<?php
/*
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/bigquery/datatransfer/v1/datatransfer.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\BigQuery\DataTransfer\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\BigQuery\DataTransfer\V1\CheckValidCredsRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\CheckValidCredsResponse;
use Google\Cloud\BigQuery\DataTransfer\V1\CreateTransferConfigRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\DataSource;
use Google\Cloud\BigQuery\DataTransfer\V1\DeleteTransferConfigRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\DeleteTransferRunRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\EnrollDataSourcesRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\GetDataSourceRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\GetTransferConfigRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\GetTransferRunRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\ListDataSourcesRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\ListDataSourcesResponse;
use Google\Cloud\BigQuery\DataTransfer\V1\ListTransferConfigsRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\ListTransferConfigsResponse;
use Google\Cloud\BigQuery\DataTransfer\V1\ListTransferLogsRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\ListTransferLogsResponse;
use Google\Cloud\BigQuery\DataTransfer\V1\ListTransferRunsRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\ListTransferRunsResponse;
use Google\Cloud\BigQuery\DataTransfer\V1\ScheduleTransferRunsRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\ScheduleTransferRunsResponse;
use Google\Cloud\BigQuery\DataTransfer\V1\StartManualTransferRunsRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\StartManualTransferRunsRequest\TimeRange;
use Google\Cloud\BigQuery\DataTransfer\V1\StartManualTransferRunsResponse;
use Google\Cloud\BigQuery\DataTransfer\V1\TransferConfig;
use Google\Cloud\BigQuery\DataTransfer\V1\TransferRun;
use Google\Cloud\BigQuery\DataTransfer\V1\UnenrollDataSourcesRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\UpdateTransferConfigRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;
use Google\Protobuf\Timestamp;

/**
 * Service Description: This API allows users to manage their data transfers into BigQuery.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $dataTransferServiceClient = new DataTransferServiceClient();
 * try {
 *     $formattedName = $dataTransferServiceClient->dataSourceName('[PROJECT]', '[DATA_SOURCE]');
 *     $response = $dataTransferServiceClient->checkValidCreds($formattedName);
 * } finally {
 *     $dataTransferServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated Please use the new service client {@see \Google\Cloud\BigQuery\DataTransfer\V1\Client\DataTransferServiceClient}.
 */
class DataTransferServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.bigquery.datatransfer.v1.DataTransferService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'bigquerydatatransfer.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'bigquerydatatransfer.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $dataSourceNameTemplate;

    private static $locationNameTemplate;

    private static $projectNameTemplate;

    private static $projectDataSourceNameTemplate;

    private static $projectLocationDataSourceNameTemplate;

    private static $projectLocationTransferConfigNameTemplate;

    private static $projectLocationTransferConfigRunNameTemplate;

    private static $projectTransferConfigNameTemplate;

    private static $projectTransferConfigRunNameTemplate;

    private static $runNameTemplate;

    private static $transferConfigNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/data_transfer_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/data_transfer_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/data_transfer_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/data_transfer_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getDataSourceNameTemplate()
    {
        if (self::$dataSourceNameTemplate == null) {
            self::$dataSourceNameTemplate = new PathTemplate('projects/{project}/dataSources/{data_source}');
        }

        return self::$dataSourceNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getProjectNameTemplate()
    {
        if (self::$projectNameTemplate == null) {
            self::$projectNameTemplate = new PathTemplate('projects/{project}');
        }

        return self::$projectNameTemplate;
    }

    private static function getProjectDataSourceNameTemplate()
    {
        if (self::$projectDataSourceNameTemplate == null) {
            self::$projectDataSourceNameTemplate = new PathTemplate('projects/{project}/dataSources/{data_source}');
        }

        return self::$projectDataSourceNameTemplate;
    }

    private static function getProjectLocationDataSourceNameTemplate()
    {
        if (self::$projectLocationDataSourceNameTemplate == null) {
            self::$projectLocationDataSourceNameTemplate = new PathTemplate('projects/{project}/locations/{location}/dataSources/{data_source}');
        }

        return self::$projectLocationDataSourceNameTemplate;
    }

    private static function getProjectLocationTransferConfigNameTemplate()
    {
        if (self::$projectLocationTransferConfigNameTemplate == null) {
            self::$projectLocationTransferConfigNameTemplate = new PathTemplate('projects/{project}/locations/{location}/transferConfigs/{transfer_config}');
        }

        return self::$projectLocationTransferConfigNameTemplate;
    }

    private static function getProjectLocationTransferConfigRunNameTemplate()
    {
        if (self::$projectLocationTransferConfigRunNameTemplate == null) {
            self::$projectLocationTransferConfigRunNameTemplate = new PathTemplate('projects/{project}/locations/{location}/transferConfigs/{transfer_config}/runs/{run}');
        }

        return self::$projectLocationTransferConfigRunNameTemplate;
    }

    private static function getProjectTransferConfigNameTemplate()
    {
        if (self::$projectTransferConfigNameTemplate == null) {
            self::$projectTransferConfigNameTemplate = new PathTemplate('projects/{project}/transferConfigs/{transfer_config}');
        }

        return self::$projectTransferConfigNameTemplate;
    }

    private static function getProjectTransferConfigRunNameTemplate()
    {
        if (self::$projectTransferConfigRunNameTemplate == null) {
            self::$projectTransferConfigRunNameTemplate = new PathTemplate('projects/{project}/transferConfigs/{transfer_config}/runs/{run}');
        }

        return self::$projectTransferConfigRunNameTemplate;
    }

    private static function getRunNameTemplate()
    {
        if (self::$runNameTemplate == null) {
            self::$runNameTemplate = new PathTemplate('projects/{project}/transferConfigs/{transfer_config}/runs/{run}');
        }

        return self::$runNameTemplate;
    }

    private static function getTransferConfigNameTemplate()
    {
        if (self::$transferConfigNameTemplate == null) {
            self::$transferConfigNameTemplate = new PathTemplate('projects/{project}/transferConfigs/{transfer_config}');
        }

        return self::$transferConfigNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'dataSource' => self::getDataSourceNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'project' => self::getProjectNameTemplate(),
                'projectDataSource' => self::getProjectDataSourceNameTemplate(),
                'projectLocationDataSource' => self::getProjectLocationDataSourceNameTemplate(),
                'projectLocationTransferConfig' => self::getProjectLocationTransferConfigNameTemplate(),
                'projectLocationTransferConfigRun' => self::getProjectLocationTransferConfigRunNameTemplate(),
                'projectTransferConfig' => self::getProjectTransferConfigNameTemplate(),
                'projectTransferConfigRun' => self::getProjectTransferConfigRunNameTemplate(),
                'run' => self::getRunNameTemplate(),
                'transferConfig' => self::getTransferConfigNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a data_source
     * resource.
     *
     * @param string $project
     * @param string $dataSource
     *
     * @return string The formatted data_source resource.
     */
    public static function dataSourceName($project, $dataSource)
    {
        return self::getDataSourceNameTemplate()->render([
            'project' => $project,
            'data_source' => $dataSource,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName($project)
    {
        return self::getProjectNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_data_source resource.
     *
     * @param string $project
     * @param string $dataSource
     *
     * @return string The formatted project_data_source resource.
     */
    public static function projectDataSourceName($project, $dataSource)
    {
        return self::getProjectDataSourceNameTemplate()->render([
            'project' => $project,
            'data_source' => $dataSource,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_data_source resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataSource
     *
     * @return string The formatted project_location_data_source resource.
     */
    public static function projectLocationDataSourceName($project, $location, $dataSource)
    {
        return self::getProjectLocationDataSourceNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'data_source' => $dataSource,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_transfer_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $transferConfig
     *
     * @return string The formatted project_location_transfer_config resource.
     */
    public static function projectLocationTransferConfigName($project, $location, $transferConfig)
    {
        return self::getProjectLocationTransferConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'transfer_config' => $transferConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_transfer_config_run resource.
     *
     * @param string $project
     * @param string $location
     * @param string $transferConfig
     * @param string $run
     *
     * @return string The formatted project_location_transfer_config_run resource.
     */
    public static function projectLocationTransferConfigRunName($project, $location, $transferConfig, $run)
    {
        return self::getProjectLocationTransferConfigRunNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'transfer_config' => $transferConfig,
            'run' => $run,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_transfer_config resource.
     *
     * @param string $project
     * @param string $transferConfig
     *
     * @return string The formatted project_transfer_config resource.
     */
    public static function projectTransferConfigName($project, $transferConfig)
    {
        return self::getProjectTransferConfigNameTemplate()->render([
            'project' => $project,
            'transfer_config' => $transferConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_transfer_config_run resource.
     *
     * @param string $project
     * @param string $transferConfig
     * @param string $run
     *
     * @return string The formatted project_transfer_config_run resource.
     */
    public static function projectTransferConfigRunName($project, $transferConfig, $run)
    {
        return self::getProjectTransferConfigRunNameTemplate()->render([
            'project' => $project,
            'transfer_config' => $transferConfig,
            'run' => $run,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a run
     * resource.
     *
     * @param string $project
     * @param string $transferConfig
     * @param string $run
     *
     * @return string The formatted run resource.
     */
    public static function runName($project, $transferConfig, $run)
    {
        return self::getRunNameTemplate()->render([
            'project' => $project,
            'transfer_config' => $transferConfig,
            'run' => $run,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * transfer_config resource.
     *
     * @param string $project
     * @param string $transferConfig
     *
     * @return string The formatted transfer_config resource.
     */
    public static function transferConfigName($project, $transferConfig)
    {
        return self::getTransferConfigNameTemplate()->render([
            'project' => $project,
            'transfer_config' => $transferConfig,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - dataSource: projects/{project}/dataSources/{data_source}
     * - location: projects/{project}/locations/{location}
     * - project: projects/{project}
     * - projectDataSource: projects/{project}/dataSources/{data_source}
     * - projectLocationDataSource: projects/{project}/locations/{location}/dataSources/{data_source}
     * - projectLocationTransferConfig: projects/{project}/locations/{location}/transferConfigs/{transfer_config}
     * - projectLocationTransferConfigRun: projects/{project}/locations/{location}/transferConfigs/{transfer_config}/runs/{run}
     * - projectTransferConfig: projects/{project}/transferConfigs/{transfer_config}
     * - projectTransferConfigRun: projects/{project}/transferConfigs/{transfer_config}/runs/{run}
     * - run: projects/{project}/transferConfigs/{transfer_config}/runs/{run}
     * - transferConfig: projects/{project}/transferConfigs/{transfer_config}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'bigquerydatatransfer.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Returns true if valid credentials exist for the given data source and
     * requesting user.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $formattedName = $dataTransferServiceClient->dataSourceName('[PROJECT]', '[DATA_SOURCE]');
     *     $response = $dataTransferServiceClient->checkValidCreds($formattedName);
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The data source in the form:
     *                             `projects/{project_id}/dataSources/{data_source_id}` or
     *                             `projects/{project_id}/locations/{location_id}/dataSources/{data_source_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\DataTransfer\V1\CheckValidCredsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function checkValidCreds($name, array $optionalArgs = [])
    {
        $request = new CheckValidCredsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CheckValidCreds', CheckValidCredsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a new data transfer configuration.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $formattedParent = $dataTransferServiceClient->projectName('[PROJECT]');
     *     $transferConfig = new TransferConfig();
     *     $response = $dataTransferServiceClient->createTransferConfig($formattedParent, $transferConfig);
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param string         $parent         Required. The BigQuery project id where the transfer configuration should
     *                                       be created. Must be in the format
     *                                       projects/{project_id}/locations/{location_id} or projects/{project_id}. If
     *                                       specified location and location of the destination bigquery dataset do not
     *                                       match - the request will fail.
     * @param TransferConfig $transferConfig Required. Data transfer configuration to create.
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type string $authorizationCode
     *           Optional OAuth2 authorization code to use with this transfer configuration.
     *           This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
     *           and new credentials are needed, as indicated by `CheckValidCreds`. In order
     *           to obtain authorization_code, make a request to the following URL:
     *           <pre class="prettyprint" suppresswarning="true">
     *           https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=authorization_code&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
     *           </pre>
     *           * The <var>client_id</var> is the OAuth client_id of the a data source as
     *           returned by ListDataSources method.
     *           * <var>data_source_scopes</var> are the scopes returned by ListDataSources
     *           method.
     *
     *           Note that this should not be set when `service_account_name` is used to
     *           create the transfer config.
     *     @type string $versionInfo
     *           Optional version info. This is required only if
     *           `transferConfig.dataSourceId` is not 'youtube_channel' and new credentials
     *           are needed, as indicated by `CheckValidCreds`. In order to obtain version
     *           info, make a request to the following URL:
     *           <pre class="prettyprint" suppresswarning="true">
     *           https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=version_info&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
     *           </pre>
     *           * The <var>client_id</var> is the OAuth client_id of the a data source as
     *           returned by ListDataSources method.
     *           * <var>data_source_scopes</var> are the scopes returned by ListDataSources
     *           method.
     *
     *           Note that this should not be set when `service_account_name` is used to
     *           create the transfer config.
     *     @type string $serviceAccountName
     *           Optional service account email. If this field is set, the transfer config
     *           will be created with this service account's credentials. It requires that
     *           the requesting user calling this API has permissions to act as this service
     *           account.
     *
     *           Note that not all data sources support service account credentials when
     *           creating a transfer config. For the latest list of data sources, read about
     *           [using service
     *           accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\DataTransfer\V1\TransferConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function createTransferConfig($parent, $transferConfig, array $optionalArgs = [])
    {
        $request = new CreateTransferConfigRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTransferConfig($transferConfig);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['authorizationCode'])) {
            $request->setAuthorizationCode($optionalArgs['authorizationCode']);
        }

        if (isset($optionalArgs['versionInfo'])) {
            $request->setVersionInfo($optionalArgs['versionInfo']);
        }

        if (isset($optionalArgs['serviceAccountName'])) {
            $request->setServiceAccountName($optionalArgs['serviceAccountName']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateTransferConfig', TransferConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a data transfer configuration, including any associated transfer
     * runs and logs.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $formattedName = $dataTransferServiceClient->transferConfigName('[PROJECT]', '[TRANSFER_CONFIG]');
     *     $dataTransferServiceClient->deleteTransferConfig($formattedName);
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The field will contain name of the resource requested, for
     *                             example: `projects/{project_id}/transferConfigs/{config_id}` or
     *                             `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTransferConfig($name, array $optionalArgs = [])
    {
        $request = new DeleteTransferConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteTransferConfig', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes the specified transfer run.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $formattedName = $dataTransferServiceClient->runName('[PROJECT]', '[TRANSFER_CONFIG]', '[RUN]');
     *     $dataTransferServiceClient->deleteTransferRun($formattedName);
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The field will contain name of the resource requested, for
     *                             example: `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}`
     *                             or
     *                             `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTransferRun($name, array $optionalArgs = [])
    {
        $request = new DeleteTransferRunRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteTransferRun', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Enroll data sources in a user project. This allows users to create transfer
     * configurations for these data sources. They will also appear in the
     * ListDataSources RPC and as such, will appear in the
     * [BigQuery UI](https://console.cloud.google.com/bigquery), and the documents
     * can be found in the public guide for
     * [BigQuery Web UI](https://cloud.google.com/bigquery/bigquery-web-ui) and
     * [Data Transfer
     * Service](https://cloud.google.com/bigquery/docs/working-with-transfers).
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $dataTransferServiceClient->enrollDataSources();
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The name of the project resource in the form: `projects/{project_id}`
     *     @type string[] $dataSourceIds
     *           Data sources that are enrolled. It is required to provide at least one
     *           data source id.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function enrollDataSources(array $optionalArgs = [])
    {
        $request = new EnrollDataSourcesRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['dataSourceIds'])) {
            $request->setDataSourceIds($optionalArgs['dataSourceIds']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('EnrollDataSources', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Retrieves a supported data source and returns its settings.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $formattedName = $dataTransferServiceClient->dataSourceName('[PROJECT]', '[DATA_SOURCE]');
     *     $response = $dataTransferServiceClient->getDataSource($formattedName);
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The field will contain name of the resource requested, for
     *                             example: `projects/{project_id}/dataSources/{data_source_id}` or
     *                             `projects/{project_id}/locations/{location_id}/dataSources/{data_source_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\DataTransfer\V1\DataSource
     *
     * @throws ApiException if the remote call fails
     */
    public function getDataSource($name, array $optionalArgs = [])
    {
        $request = new GetDataSourceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetDataSource', DataSource::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns information about a data transfer config.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $formattedName = $dataTransferServiceClient->transferConfigName('[PROJECT]', '[TRANSFER_CONFIG]');
     *     $response = $dataTransferServiceClient->getTransferConfig($formattedName);
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The field will contain name of the resource requested, for
     *                             example: `projects/{project_id}/transferConfigs/{config_id}` or
     *                             `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\DataTransfer\V1\TransferConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getTransferConfig($name, array $optionalArgs = [])
    {
        $request = new GetTransferConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetTransferConfig', TransferConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns information about the particular transfer run.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $formattedName = $dataTransferServiceClient->runName('[PROJECT]', '[TRANSFER_CONFIG]', '[RUN]');
     *     $response = $dataTransferServiceClient->getTransferRun($formattedName);
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The field will contain name of the resource requested, for
     *                             example: `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}`
     *                             or
     *                             `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\DataTransfer\V1\TransferRun
     *
     * @throws ApiException if the remote call fails
     */
    public function getTransferRun($name, array $optionalArgs = [])
    {
        $request = new GetTransferRunRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetTransferRun', TransferRun::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists supported data sources and returns their settings.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $formattedParent = $dataTransferServiceClient->projectName('[PROJECT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataTransferServiceClient->listDataSources($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataTransferServiceClient->listDataSources($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The BigQuery project id for which data sources should be
     *                             returned. Must be in the form: `projects/{project_id}` or
     *                             `projects/{project_id}/locations/{location_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDataSources($parent, array $optionalArgs = [])
    {
        $request = new ListDataSourcesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListDataSources', $optionalArgs, ListDataSourcesResponse::class, $request);
    }

    /**
     * Returns information about all transfer configs owned by a project in the
     * specified location.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $formattedParent = $dataTransferServiceClient->projectName('[PROJECT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataTransferServiceClient->listTransferConfigs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataTransferServiceClient->listTransferConfigs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The BigQuery project id for which transfer configs
     *                             should be returned: `projects/{project_id}` or
     *                             `projects/{project_id}/locations/{location_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string[] $dataSourceIds
     *           When specified, only configurations of requested data sources are returned.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTransferConfigs($parent, array $optionalArgs = [])
    {
        $request = new ListTransferConfigsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['dataSourceIds'])) {
            $request->setDataSourceIds($optionalArgs['dataSourceIds']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListTransferConfigs', $optionalArgs, ListTransferConfigsResponse::class, $request);
    }

    /**
     * Returns log messages for the transfer run.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $formattedParent = $dataTransferServiceClient->runName('[PROJECT]', '[TRANSFER_CONFIG]', '[RUN]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataTransferServiceClient->listTransferLogs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataTransferServiceClient->listTransferLogs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Transfer run name in the form:
     *                             `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}` or
     *                             `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type int[] $messageTypes
     *           Message types to return. If not populated - INFO, WARNING and ERROR
     *           messages are returned.
     *           For allowed values, use constants defined on {@see \Google\Cloud\BigQuery\DataTransfer\V1\TransferMessage\MessageSeverity}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTransferLogs($parent, array $optionalArgs = [])
    {
        $request = new ListTransferLogsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['messageTypes'])) {
            $request->setMessageTypes($optionalArgs['messageTypes']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListTransferLogs', $optionalArgs, ListTransferLogsResponse::class, $request);
    }

    /**
     * Returns information about running and completed transfer runs.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $formattedParent = $dataTransferServiceClient->transferConfigName('[PROJECT]', '[TRANSFER_CONFIG]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataTransferServiceClient->listTransferRuns($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataTransferServiceClient->listTransferRuns($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Name of transfer configuration for which transfer runs should be
     *                             retrieved. Format of transfer configuration resource name is:
     *                             `projects/{project_id}/transferConfigs/{config_id}` or
     *                             `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int[] $states
     *           When specified, only transfer runs with requested states are returned.
     *           For allowed values, use constants defined on {@see \Google\Cloud\BigQuery\DataTransfer\V1\TransferState}
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type int $runAttempt
     *           Indicates how run attempts are to be pulled.
     *           For allowed values, use constants defined on {@see \Google\Cloud\BigQuery\DataTransfer\V1\ListTransferRunsRequest\RunAttempt}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTransferRuns($parent, array $optionalArgs = [])
    {
        $request = new ListTransferRunsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['states'])) {
            $request->setStates($optionalArgs['states']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['runAttempt'])) {
            $request->setRunAttempt($optionalArgs['runAttempt']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListTransferRuns', $optionalArgs, ListTransferRunsResponse::class, $request);
    }

    /**
     * Creates transfer runs for a time range [start_time, end_time].
     * For each date - or whatever granularity the data source supports - in the
     * range, one transfer run is created.
     * Note that runs are created per UTC time in the time range.
     * DEPRECATED: use StartManualTransferRuns instead.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $formattedParent = $dataTransferServiceClient->transferConfigName('[PROJECT]', '[TRANSFER_CONFIG]');
     *     $startTime = new Timestamp();
     *     $endTime = new Timestamp();
     *     $response = $dataTransferServiceClient->scheduleTransferRuns($formattedParent, $startTime, $endTime);
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param string    $parent       Required. Transfer configuration name in the form:
     *                                `projects/{project_id}/transferConfigs/{config_id}` or
     *                                `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
     * @param Timestamp $startTime    Required. Start time of the range of transfer runs. For example,
     *                                `"2017-05-25T00:00:00+00:00"`.
     * @param Timestamp $endTime      Required. End time of the range of transfer runs. For example,
     *                                `"2017-05-30T00:00:00+00:00"`.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\DataTransfer\V1\ScheduleTransferRunsResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function scheduleTransferRuns($parent, $startTime, $endTime, array $optionalArgs = [])
    {
        $request = new ScheduleTransferRunsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setStartTime($startTime);
        $request->setEndTime($endTime);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ScheduleTransferRuns', ScheduleTransferRunsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Start manual transfer runs to be executed now with schedule_time equal to
     * current time. The transfer runs can be created for a time range where the
     * run_time is between start_time (inclusive) and end_time (exclusive), or for
     * a specific run_time.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $response = $dataTransferServiceClient->startManualTransferRuns();
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $parent
     *           Transfer configuration name in the form:
     *           `projects/{project_id}/transferConfigs/{config_id}` or
     *           `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
     *     @type TimeRange $requestedTimeRange
     *           A time_range start and end timestamp for historical data files or reports
     *           that are scheduled to be transferred by the scheduled transfer run.
     *           requested_time_range must be a past time and cannot include future time
     *           values.
     *     @type Timestamp $requestedRunTime
     *           A run_time timestamp for historical data files or reports
     *           that are scheduled to be transferred by the scheduled transfer run.
     *           requested_run_time must be a past time and cannot include future time
     *           values.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\DataTransfer\V1\StartManualTransferRunsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function startManualTransferRuns(array $optionalArgs = [])
    {
        $request = new StartManualTransferRunsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['parent'])) {
            $request->setParent($optionalArgs['parent']);
            $requestParamHeaders['parent'] = $optionalArgs['parent'];
        }

        if (isset($optionalArgs['requestedTimeRange'])) {
            $request->setRequestedTimeRange($optionalArgs['requestedTimeRange']);
        }

        if (isset($optionalArgs['requestedRunTime'])) {
            $request->setRequestedRunTime($optionalArgs['requestedRunTime']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('StartManualTransferRuns', StartManualTransferRunsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Unenroll data sources in a user project. This allows users to remove
     * transfer configurations for these data sources. They will no longer appear
     * in the ListDataSources RPC and will also no longer appear in the [BigQuery
     * UI](https://console.cloud.google.com/bigquery).
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $dataTransferServiceClient->unenrollDataSources();
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The name of the project resource in the form: `projects/{project_id}`
     *     @type string[] $dataSourceIds
     *           Data sources that are unenrolled. It is required to provide at least one
     *           data source id.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function unenrollDataSources(array $optionalArgs = [])
    {
        $request = new UnenrollDataSourcesRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['dataSourceIds'])) {
            $request->setDataSourceIds($optionalArgs['dataSourceIds']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UnenrollDataSources', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a data transfer configuration.
     * All fields must be set, even if they are not updated.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $transferConfig = new TransferConfig();
     *     $updateMask = new FieldMask();
     *     $response = $dataTransferServiceClient->updateTransferConfig($transferConfig, $updateMask);
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param TransferConfig $transferConfig Required. Data transfer configuration to create.
     * @param FieldMask      $updateMask     Required. Required list of fields to be updated in this request.
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type string $authorizationCode
     *           Optional OAuth2 authorization code to use with this transfer configuration.
     *           This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
     *           and new credentials are needed, as indicated by `CheckValidCreds`. In order
     *           to obtain authorization_code, make a request to the following URL:
     *           <pre class="prettyprint" suppresswarning="true">
     *           https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=authorization_code&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
     *           </pre>
     *           * The <var>client_id</var> is the OAuth client_id of the a data source as
     *           returned by ListDataSources method.
     *           * <var>data_source_scopes</var> are the scopes returned by ListDataSources
     *           method.
     *
     *           Note that this should not be set when `service_account_name` is used to
     *           update the transfer config.
     *     @type string $versionInfo
     *           Optional version info. This is required only if
     *           `transferConfig.dataSourceId` is not 'youtube_channel' and new credentials
     *           are needed, as indicated by `CheckValidCreds`. In order to obtain version
     *           info, make a request to the following URL:
     *           <pre class="prettyprint" suppresswarning="true">
     *           https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=version_info&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
     *           </pre>
     *           * The <var>client_id</var> is the OAuth client_id of the a data source as
     *           returned by ListDataSources method.
     *           * <var>data_source_scopes</var> are the scopes returned by ListDataSources
     *           method.
     *
     *           Note that this should not be set when `service_account_name` is used to
     *           update the transfer config.
     *     @type string $serviceAccountName
     *           Optional service account email. If this field is set, the transfer config
     *           will be created with this service account's credentials. It requires that
     *           the requesting user calling this API has permissions to act as this service
     *           account.
     *
     *           Note that not all data sources support service account credentials when
     *           creating a transfer config. For the latest list of data sources, read about
     *           [using service
     *           accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\DataTransfer\V1\TransferConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTransferConfig($transferConfig, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateTransferConfigRequest();
        $requestParamHeaders = [];
        $request->setTransferConfig($transferConfig);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['transfer_config.name'] = $transferConfig->getName();
        if (isset($optionalArgs['authorizationCode'])) {
            $request->setAuthorizationCode($optionalArgs['authorizationCode']);
        }

        if (isset($optionalArgs['versionInfo'])) {
            $request->setVersionInfo($optionalArgs['versionInfo']);
        }

        if (isset($optionalArgs['serviceAccountName'])) {
            $request->setServiceAccountName($optionalArgs['serviceAccountName']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateTransferConfig', TransferConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     $response = $dataTransferServiceClient->getLocation();
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetLocation', Location::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.cloud.location.Locations')->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $dataTransferServiceClient = new DataTransferServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataTransferServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataTransferServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataTransferServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListLocations', $optionalArgs, ListLocationsResponse::class, $request, 'google.cloud.location.Locations');
    }
}
