<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/privacy/dlp/v2/dlp.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dlp\V2\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dlp\V2\ActivateJobTriggerRequest;
use Google\Cloud\Dlp\V2\CancelDlpJobRequest;
use Google\Cloud\Dlp\V2\ColumnDataProfile;
use Google\Cloud\Dlp\V2\Connection;
use Google\Cloud\Dlp\V2\CreateConnectionRequest;
use Google\Cloud\Dlp\V2\CreateDeidentifyTemplateRequest;
use Google\Cloud\Dlp\V2\CreateDiscoveryConfigRequest;
use Google\Cloud\Dlp\V2\CreateDlpJobRequest;
use Google\Cloud\Dlp\V2\CreateInspectTemplateRequest;
use Google\Cloud\Dlp\V2\CreateJobTriggerRequest;
use Google\Cloud\Dlp\V2\CreateStoredInfoTypeRequest;
use Google\Cloud\Dlp\V2\DeidentifyContentRequest;
use Google\Cloud\Dlp\V2\DeidentifyContentResponse;
use Google\Cloud\Dlp\V2\DeidentifyTemplate;
use Google\Cloud\Dlp\V2\DeleteConnectionRequest;
use Google\Cloud\Dlp\V2\DeleteDeidentifyTemplateRequest;
use Google\Cloud\Dlp\V2\DeleteDiscoveryConfigRequest;
use Google\Cloud\Dlp\V2\DeleteDlpJobRequest;
use Google\Cloud\Dlp\V2\DeleteFileStoreDataProfileRequest;
use Google\Cloud\Dlp\V2\DeleteInspectTemplateRequest;
use Google\Cloud\Dlp\V2\DeleteJobTriggerRequest;
use Google\Cloud\Dlp\V2\DeleteStoredInfoTypeRequest;
use Google\Cloud\Dlp\V2\DeleteTableDataProfileRequest;
use Google\Cloud\Dlp\V2\DiscoveryConfig;
use Google\Cloud\Dlp\V2\DlpJob;
use Google\Cloud\Dlp\V2\FileStoreDataProfile;
use Google\Cloud\Dlp\V2\FinishDlpJobRequest;
use Google\Cloud\Dlp\V2\GetColumnDataProfileRequest;
use Google\Cloud\Dlp\V2\GetConnectionRequest;
use Google\Cloud\Dlp\V2\GetDeidentifyTemplateRequest;
use Google\Cloud\Dlp\V2\GetDiscoveryConfigRequest;
use Google\Cloud\Dlp\V2\GetDlpJobRequest;
use Google\Cloud\Dlp\V2\GetFileStoreDataProfileRequest;
use Google\Cloud\Dlp\V2\GetInspectTemplateRequest;
use Google\Cloud\Dlp\V2\GetJobTriggerRequest;
use Google\Cloud\Dlp\V2\GetProjectDataProfileRequest;
use Google\Cloud\Dlp\V2\GetStoredInfoTypeRequest;
use Google\Cloud\Dlp\V2\GetTableDataProfileRequest;
use Google\Cloud\Dlp\V2\HybridInspectDlpJobRequest;
use Google\Cloud\Dlp\V2\HybridInspectJobTriggerRequest;
use Google\Cloud\Dlp\V2\HybridInspectResponse;
use Google\Cloud\Dlp\V2\InspectContentRequest;
use Google\Cloud\Dlp\V2\InspectContentResponse;
use Google\Cloud\Dlp\V2\InspectTemplate;
use Google\Cloud\Dlp\V2\JobTrigger;
use Google\Cloud\Dlp\V2\ListColumnDataProfilesRequest;
use Google\Cloud\Dlp\V2\ListConnectionsRequest;
use Google\Cloud\Dlp\V2\ListDeidentifyTemplatesRequest;
use Google\Cloud\Dlp\V2\ListDiscoveryConfigsRequest;
use Google\Cloud\Dlp\V2\ListDlpJobsRequest;
use Google\Cloud\Dlp\V2\ListFileStoreDataProfilesRequest;
use Google\Cloud\Dlp\V2\ListInfoTypesRequest;
use Google\Cloud\Dlp\V2\ListInfoTypesResponse;
use Google\Cloud\Dlp\V2\ListInspectTemplatesRequest;
use Google\Cloud\Dlp\V2\ListJobTriggersRequest;
use Google\Cloud\Dlp\V2\ListProjectDataProfilesRequest;
use Google\Cloud\Dlp\V2\ListStoredInfoTypesRequest;
use Google\Cloud\Dlp\V2\ListTableDataProfilesRequest;
use Google\Cloud\Dlp\V2\ProjectDataProfile;
use Google\Cloud\Dlp\V2\RedactImageRequest;
use Google\Cloud\Dlp\V2\RedactImageResponse;
use Google\Cloud\Dlp\V2\ReidentifyContentRequest;
use Google\Cloud\Dlp\V2\ReidentifyContentResponse;
use Google\Cloud\Dlp\V2\SearchConnectionsRequest;
use Google\Cloud\Dlp\V2\StoredInfoType;
use Google\Cloud\Dlp\V2\TableDataProfile;
use Google\Cloud\Dlp\V2\UpdateConnectionRequest;
use Google\Cloud\Dlp\V2\UpdateDeidentifyTemplateRequest;
use Google\Cloud\Dlp\V2\UpdateDiscoveryConfigRequest;
use Google\Cloud\Dlp\V2\UpdateInspectTemplateRequest;
use Google\Cloud\Dlp\V2\UpdateJobTriggerRequest;
use Google\Cloud\Dlp\V2\UpdateStoredInfoTypeRequest;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Sensitive Data Protection provides access to a powerful sensitive data
 * inspection, classification, and de-identification platform that works
 * on text, images, and Google Cloud storage repositories.
 * To learn more about concepts and find how-to guides see
 * https://cloud.google.com/sensitive-data-protection/docs/.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<DlpJob> activateJobTriggerAsync(ActivateJobTriggerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> cancelDlpJobAsync(CancelDlpJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Connection> createConnectionAsync(CreateConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DeidentifyTemplate> createDeidentifyTemplateAsync(CreateDeidentifyTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DiscoveryConfig> createDiscoveryConfigAsync(CreateDiscoveryConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DlpJob> createDlpJobAsync(CreateDlpJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<InspectTemplate> createInspectTemplateAsync(CreateInspectTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<JobTrigger> createJobTriggerAsync(CreateJobTriggerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<StoredInfoType> createStoredInfoTypeAsync(CreateStoredInfoTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DeidentifyContentResponse> deidentifyContentAsync(DeidentifyContentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteConnectionAsync(DeleteConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteDeidentifyTemplateAsync(DeleteDeidentifyTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteDiscoveryConfigAsync(DeleteDiscoveryConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteDlpJobAsync(DeleteDlpJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteFileStoreDataProfileAsync(DeleteFileStoreDataProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteInspectTemplateAsync(DeleteInspectTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteJobTriggerAsync(DeleteJobTriggerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteStoredInfoTypeAsync(DeleteStoredInfoTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteTableDataProfileAsync(DeleteTableDataProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> finishDlpJobAsync(FinishDlpJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ColumnDataProfile> getColumnDataProfileAsync(GetColumnDataProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Connection> getConnectionAsync(GetConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DeidentifyTemplate> getDeidentifyTemplateAsync(GetDeidentifyTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DiscoveryConfig> getDiscoveryConfigAsync(GetDiscoveryConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DlpJob> getDlpJobAsync(GetDlpJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FileStoreDataProfile> getFileStoreDataProfileAsync(GetFileStoreDataProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<InspectTemplate> getInspectTemplateAsync(GetInspectTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<JobTrigger> getJobTriggerAsync(GetJobTriggerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ProjectDataProfile> getProjectDataProfileAsync(GetProjectDataProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<StoredInfoType> getStoredInfoTypeAsync(GetStoredInfoTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TableDataProfile> getTableDataProfileAsync(GetTableDataProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HybridInspectResponse> hybridInspectDlpJobAsync(HybridInspectDlpJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HybridInspectResponse> hybridInspectJobTriggerAsync(HybridInspectJobTriggerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<InspectContentResponse> inspectContentAsync(InspectContentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listColumnDataProfilesAsync(ListColumnDataProfilesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listConnectionsAsync(ListConnectionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDeidentifyTemplatesAsync(ListDeidentifyTemplatesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDiscoveryConfigsAsync(ListDiscoveryConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDlpJobsAsync(ListDlpJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listFileStoreDataProfilesAsync(ListFileStoreDataProfilesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ListInfoTypesResponse> listInfoTypesAsync(ListInfoTypesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listInspectTemplatesAsync(ListInspectTemplatesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listJobTriggersAsync(ListJobTriggersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listProjectDataProfilesAsync(ListProjectDataProfilesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listStoredInfoTypesAsync(ListStoredInfoTypesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTableDataProfilesAsync(ListTableDataProfilesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RedactImageResponse> redactImageAsync(RedactImageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ReidentifyContentResponse> reidentifyContentAsync(ReidentifyContentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> searchConnectionsAsync(SearchConnectionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Connection> updateConnectionAsync(UpdateConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DeidentifyTemplate> updateDeidentifyTemplateAsync(UpdateDeidentifyTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DiscoveryConfig> updateDiscoveryConfigAsync(UpdateDiscoveryConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<InspectTemplate> updateInspectTemplateAsync(UpdateInspectTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<JobTrigger> updateJobTriggerAsync(UpdateJobTriggerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<StoredInfoType> updateStoredInfoTypeAsync(UpdateStoredInfoTypeRequest $request, array $optionalArgs = [])
 */
final class DlpServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.privacy.dlp.v2.DlpService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'dlp.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'dlp.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/dlp_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/dlp_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/dlp_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/dlp_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * column_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $columnDataProfile
     *
     * @return string The formatted column_data_profile resource.
     */
    public static function columnDataProfileName(
        string $organization,
        string $location,
        string $columnDataProfile
    ): string {
        return self::getPathTemplate('columnDataProfile')->render([
            'organization' => $organization,
            'location' => $location,
            'column_data_profile' => $columnDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a connection
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $connection
     *
     * @return string The formatted connection resource.
     */
    public static function connectionName(string $project, string $location, string $connection): string
    {
        return self::getPathTemplate('connection')->render([
            'project' => $project,
            'location' => $location,
            'connection' => $connection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * deidentify_template resource.
     *
     * @param string $organization
     * @param string $deidentifyTemplate
     *
     * @return string The formatted deidentify_template resource.
     */
    public static function deidentifyTemplateName(string $organization, string $deidentifyTemplate): string
    {
        return self::getPathTemplate('deidentifyTemplate')->render([
            'organization' => $organization,
            'deidentify_template' => $deidentifyTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * discovery_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $discoveryConfig
     *
     * @return string The formatted discovery_config resource.
     */
    public static function discoveryConfigName(string $project, string $location, string $discoveryConfig): string
    {
        return self::getPathTemplate('discoveryConfig')->render([
            'project' => $project,
            'location' => $location,
            'discovery_config' => $discoveryConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a dlp_job
     * resource.
     *
     * @param string $project
     * @param string $dlpJob
     *
     * @return string The formatted dlp_job resource.
     */
    public static function dlpJobName(string $project, string $dlpJob): string
    {
        return self::getPathTemplate('dlpJob')->render([
            'project' => $project,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * file_store_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $fileStoreDataProfile
     *
     * @return string The formatted file_store_data_profile resource.
     */
    public static function fileStoreDataProfileName(
        string $organization,
        string $location,
        string $fileStoreDataProfile
    ): string {
        return self::getPathTemplate('fileStoreDataProfile')->render([
            'organization' => $organization,
            'location' => $location,
            'file_store_data_profile' => $fileStoreDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * inspect_template resource.
     *
     * @param string $organization
     * @param string $inspectTemplate
     *
     * @return string The formatted inspect_template resource.
     */
    public static function inspectTemplateName(string $organization, string $inspectTemplate): string
    {
        return self::getPathTemplate('inspectTemplate')->render([
            'organization' => $organization,
            'inspect_template' => $inspectTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a job_trigger
     * resource.
     *
     * @param string $project
     * @param string $jobTrigger
     *
     * @return string The formatted job_trigger resource.
     */
    public static function jobTriggerName(string $project, string $jobTrigger): string
    {
        return self::getPathTemplate('jobTrigger')->render([
            'project' => $project,
            'job_trigger' => $jobTrigger,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     */
    public static function organizationName(string $organization): string
    {
        return self::getPathTemplate('organization')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_deidentify_template resource.
     *
     * @param string $organization
     * @param string $deidentifyTemplate
     *
     * @return string The formatted organization_deidentify_template resource.
     */
    public static function organizationDeidentifyTemplateName(string $organization, string $deidentifyTemplate): string
    {
        return self::getPathTemplate('organizationDeidentifyTemplate')->render([
            'organization' => $organization,
            'deidentify_template' => $deidentifyTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_inspect_template resource.
     *
     * @param string $organization
     * @param string $inspectTemplate
     *
     * @return string The formatted organization_inspect_template resource.
     */
    public static function organizationInspectTemplateName(string $organization, string $inspectTemplate): string
    {
        return self::getPathTemplate('organizationInspectTemplate')->render([
            'organization' => $organization,
            'inspect_template' => $inspectTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted organization_location resource.
     */
    public static function organizationLocationName(string $organization, string $location): string
    {
        return self::getPathTemplate('organizationLocation')->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_column_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $columnDataProfile
     *
     * @return string The formatted organization_location_column_data_profile resource.
     */
    public static function organizationLocationColumnDataProfileName(
        string $organization,
        string $location,
        string $columnDataProfile
    ): string {
        return self::getPathTemplate('organizationLocationColumnDataProfile')->render([
            'organization' => $organization,
            'location' => $location,
            'column_data_profile' => $columnDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_connection resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $connection
     *
     * @return string The formatted organization_location_connection resource.
     */
    public static function organizationLocationConnectionName(
        string $organization,
        string $location,
        string $connection
    ): string {
        return self::getPathTemplate('organizationLocationConnection')->render([
            'organization' => $organization,
            'location' => $location,
            'connection' => $connection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_deidentify_template resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $deidentifyTemplate
     *
     * @return string The formatted organization_location_deidentify_template resource.
     */
    public static function organizationLocationDeidentifyTemplateName(
        string $organization,
        string $location,
        string $deidentifyTemplate
    ): string {
        return self::getPathTemplate('organizationLocationDeidentifyTemplate')->render([
            'organization' => $organization,
            'location' => $location,
            'deidentify_template' => $deidentifyTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_file_store_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $fileStoreDataProfile
     *
     * @return string The formatted organization_location_file_store_data_profile resource.
     */
    public static function organizationLocationFileStoreDataProfileName(
        string $organization,
        string $location,
        string $fileStoreDataProfile
    ): string {
        return self::getPathTemplate('organizationLocationFileStoreDataProfile')->render([
            'organization' => $organization,
            'location' => $location,
            'file_store_data_profile' => $fileStoreDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_inspect_template resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $inspectTemplate
     *
     * @return string The formatted organization_location_inspect_template resource.
     */
    public static function organizationLocationInspectTemplateName(
        string $organization,
        string $location,
        string $inspectTemplate
    ): string {
        return self::getPathTemplate('organizationLocationInspectTemplate')->render([
            'organization' => $organization,
            'location' => $location,
            'inspect_template' => $inspectTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_project_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $projectDataProfile
     *
     * @return string The formatted organization_location_project_data_profile resource.
     */
    public static function organizationLocationProjectDataProfileName(
        string $organization,
        string $location,
        string $projectDataProfile
    ): string {
        return self::getPathTemplate('organizationLocationProjectDataProfile')->render([
            'organization' => $organization,
            'location' => $location,
            'project_data_profile' => $projectDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_stored_info_type resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $storedInfoType
     *
     * @return string The formatted organization_location_stored_info_type resource.
     */
    public static function organizationLocationStoredInfoTypeName(
        string $organization,
        string $location,
        string $storedInfoType
    ): string {
        return self::getPathTemplate('organizationLocationStoredInfoType')->render([
            'organization' => $organization,
            'location' => $location,
            'stored_info_type' => $storedInfoType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_table_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $tableDataProfile
     *
     * @return string The formatted organization_location_table_data_profile resource.
     */
    public static function organizationLocationTableDataProfileName(
        string $organization,
        string $location,
        string $tableDataProfile
    ): string {
        return self::getPathTemplate('organizationLocationTableDataProfile')->render([
            'organization' => $organization,
            'location' => $location,
            'table_data_profile' => $tableDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_stored_info_type resource.
     *
     * @param string $organization
     * @param string $storedInfoType
     *
     * @return string The formatted organization_stored_info_type resource.
     */
    public static function organizationStoredInfoTypeName(string $organization, string $storedInfoType): string
    {
        return self::getPathTemplate('organizationStoredInfoType')->render([
            'organization' => $organization,
            'stored_info_type' => $storedInfoType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $projectDataProfile
     *
     * @return string The formatted project_data_profile resource.
     */
    public static function projectDataProfileName(
        string $organization,
        string $location,
        string $projectDataProfile
    ): string {
        return self::getPathTemplate('projectDataProfile')->render([
            'organization' => $organization,
            'location' => $location,
            'project_data_profile' => $projectDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_deidentify_template resource.
     *
     * @param string $project
     * @param string $deidentifyTemplate
     *
     * @return string The formatted project_deidentify_template resource.
     */
    public static function projectDeidentifyTemplateName(string $project, string $deidentifyTemplate): string
    {
        return self::getPathTemplate('projectDeidentifyTemplate')->render([
            'project' => $project,
            'deidentify_template' => $deidentifyTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_dlp_job resource.
     *
     * @param string $project
     * @param string $dlpJob
     *
     * @return string The formatted project_dlp_job resource.
     */
    public static function projectDlpJobName(string $project, string $dlpJob): string
    {
        return self::getPathTemplate('projectDlpJob')->render([
            'project' => $project,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_inspect_template resource.
     *
     * @param string $project
     * @param string $inspectTemplate
     *
     * @return string The formatted project_inspect_template resource.
     */
    public static function projectInspectTemplateName(string $project, string $inspectTemplate): string
    {
        return self::getPathTemplate('projectInspectTemplate')->render([
            'project' => $project,
            'inspect_template' => $inspectTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_job_trigger resource.
     *
     * @param string $project
     * @param string $jobTrigger
     *
     * @return string The formatted project_job_trigger resource.
     */
    public static function projectJobTriggerName(string $project, string $jobTrigger): string
    {
        return self::getPathTemplate('projectJobTrigger')->render([
            'project' => $project,
            'job_trigger' => $jobTrigger,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_column_data_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $columnDataProfile
     *
     * @return string The formatted project_location_column_data_profile resource.
     */
    public static function projectLocationColumnDataProfileName(
        string $project,
        string $location,
        string $columnDataProfile
    ): string {
        return self::getPathTemplate('projectLocationColumnDataProfile')->render([
            'project' => $project,
            'location' => $location,
            'column_data_profile' => $columnDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_connection resource.
     *
     * @param string $project
     * @param string $location
     * @param string $connection
     *
     * @return string The formatted project_location_connection resource.
     */
    public static function projectLocationConnectionName(string $project, string $location, string $connection): string
    {
        return self::getPathTemplate('projectLocationConnection')->render([
            'project' => $project,
            'location' => $location,
            'connection' => $connection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_deidentify_template resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deidentifyTemplate
     *
     * @return string The formatted project_location_deidentify_template resource.
     */
    public static function projectLocationDeidentifyTemplateName(
        string $project,
        string $location,
        string $deidentifyTemplate
    ): string {
        return self::getPathTemplate('projectLocationDeidentifyTemplate')->render([
            'project' => $project,
            'location' => $location,
            'deidentify_template' => $deidentifyTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_dlp_job resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dlpJob
     *
     * @return string The formatted project_location_dlp_job resource.
     */
    public static function projectLocationDlpJobName(string $project, string $location, string $dlpJob): string
    {
        return self::getPathTemplate('projectLocationDlpJob')->render([
            'project' => $project,
            'location' => $location,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_file_store_data_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $fileStoreDataProfile
     *
     * @return string The formatted project_location_file_store_data_profile resource.
     */
    public static function projectLocationFileStoreDataProfileName(
        string $project,
        string $location,
        string $fileStoreDataProfile
    ): string {
        return self::getPathTemplate('projectLocationFileStoreDataProfile')->render([
            'project' => $project,
            'location' => $location,
            'file_store_data_profile' => $fileStoreDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_inspect_template resource.
     *
     * @param string $project
     * @param string $location
     * @param string $inspectTemplate
     *
     * @return string The formatted project_location_inspect_template resource.
     */
    public static function projectLocationInspectTemplateName(
        string $project,
        string $location,
        string $inspectTemplate
    ): string {
        return self::getPathTemplate('projectLocationInspectTemplate')->render([
            'project' => $project,
            'location' => $location,
            'inspect_template' => $inspectTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_job_trigger resource.
     *
     * @param string $project
     * @param string $location
     * @param string $jobTrigger
     *
     * @return string The formatted project_location_job_trigger resource.
     */
    public static function projectLocationJobTriggerName(string $project, string $location, string $jobTrigger): string
    {
        return self::getPathTemplate('projectLocationJobTrigger')->render([
            'project' => $project,
            'location' => $location,
            'job_trigger' => $jobTrigger,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_project_data_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $projectDataProfile
     *
     * @return string The formatted project_location_project_data_profile resource.
     */
    public static function projectLocationProjectDataProfileName(
        string $project,
        string $location,
        string $projectDataProfile
    ): string {
        return self::getPathTemplate('projectLocationProjectDataProfile')->render([
            'project' => $project,
            'location' => $location,
            'project_data_profile' => $projectDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_stored_info_type resource.
     *
     * @param string $project
     * @param string $location
     * @param string $storedInfoType
     *
     * @return string The formatted project_location_stored_info_type resource.
     */
    public static function projectLocationStoredInfoTypeName(
        string $project,
        string $location,
        string $storedInfoType
    ): string {
        return self::getPathTemplate('projectLocationStoredInfoType')->render([
            'project' => $project,
            'location' => $location,
            'stored_info_type' => $storedInfoType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_table_data_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tableDataProfile
     *
     * @return string The formatted project_location_table_data_profile resource.
     */
    public static function projectLocationTableDataProfileName(
        string $project,
        string $location,
        string $tableDataProfile
    ): string {
        return self::getPathTemplate('projectLocationTableDataProfile')->render([
            'project' => $project,
            'location' => $location,
            'table_data_profile' => $tableDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_stored_info_type resource.
     *
     * @param string $project
     * @param string $storedInfoType
     *
     * @return string The formatted project_stored_info_type resource.
     */
    public static function projectStoredInfoTypeName(string $project, string $storedInfoType): string
    {
        return self::getPathTemplate('projectStoredInfoType')->render([
            'project' => $project,
            'stored_info_type' => $storedInfoType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * stored_info_type resource.
     *
     * @param string $organization
     * @param string $storedInfoType
     *
     * @return string The formatted stored_info_type resource.
     */
    public static function storedInfoTypeName(string $organization, string $storedInfoType): string
    {
        return self::getPathTemplate('storedInfoType')->render([
            'organization' => $organization,
            'stored_info_type' => $storedInfoType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * table_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $tableDataProfile
     *
     * @return string The formatted table_data_profile resource.
     */
    public static function tableDataProfileName(
        string $organization,
        string $location,
        string $tableDataProfile
    ): string {
        return self::getPathTemplate('tableDataProfile')->render([
            'organization' => $organization,
            'location' => $location,
            'table_data_profile' => $tableDataProfile,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - columnDataProfile: organizations/{organization}/locations/{location}/columnDataProfiles/{column_data_profile}
     * - connection: projects/{project}/locations/{location}/connections/{connection}
     * - deidentifyTemplate: organizations/{organization}/deidentifyTemplates/{deidentify_template}
     * - discoveryConfig: projects/{project}/locations/{location}/discoveryConfigs/{discovery_config}
     * - dlpJob: projects/{project}/dlpJobs/{dlp_job}
     * - fileStoreDataProfile: organizations/{organization}/locations/{location}/fileStoreDataProfiles/{file_store_data_profile}
     * - inspectTemplate: organizations/{organization}/inspectTemplates/{inspect_template}
     * - jobTrigger: projects/{project}/jobTriggers/{job_trigger}
     * - location: projects/{project}/locations/{location}
     * - organization: organizations/{organization}
     * - organizationDeidentifyTemplate: organizations/{organization}/deidentifyTemplates/{deidentify_template}
     * - organizationInspectTemplate: organizations/{organization}/inspectTemplates/{inspect_template}
     * - organizationLocation: organizations/{organization}/locations/{location}
     * - organizationLocationColumnDataProfile: organizations/{organization}/locations/{location}/columnDataProfiles/{column_data_profile}
     * - organizationLocationConnection: organizations/{organization}/locations/{location}/connections/{connection}
     * - organizationLocationDeidentifyTemplate: organizations/{organization}/locations/{location}/deidentifyTemplates/{deidentify_template}
     * - organizationLocationFileStoreDataProfile: organizations/{organization}/locations/{location}/fileStoreDataProfiles/{file_store_data_profile}
     * - organizationLocationInspectTemplate: organizations/{organization}/locations/{location}/inspectTemplates/{inspect_template}
     * - organizationLocationProjectDataProfile: organizations/{organization}/locations/{location}/projectDataProfiles/{project_data_profile}
     * - organizationLocationStoredInfoType: organizations/{organization}/locations/{location}/storedInfoTypes/{stored_info_type}
     * - organizationLocationTableDataProfile: organizations/{organization}/locations/{location}/tableDataProfiles/{table_data_profile}
     * - organizationStoredInfoType: organizations/{organization}/storedInfoTypes/{stored_info_type}
     * - project: projects/{project}
     * - projectDataProfile: organizations/{organization}/locations/{location}/projectDataProfiles/{project_data_profile}
     * - projectDeidentifyTemplate: projects/{project}/deidentifyTemplates/{deidentify_template}
     * - projectDlpJob: projects/{project}/dlpJobs/{dlp_job}
     * - projectInspectTemplate: projects/{project}/inspectTemplates/{inspect_template}
     * - projectJobTrigger: projects/{project}/jobTriggers/{job_trigger}
     * - projectLocationColumnDataProfile: projects/{project}/locations/{location}/columnDataProfiles/{column_data_profile}
     * - projectLocationConnection: projects/{project}/locations/{location}/connections/{connection}
     * - projectLocationDeidentifyTemplate: projects/{project}/locations/{location}/deidentifyTemplates/{deidentify_template}
     * - projectLocationDlpJob: projects/{project}/locations/{location}/dlpJobs/{dlp_job}
     * - projectLocationFileStoreDataProfile: projects/{project}/locations/{location}/fileStoreDataProfiles/{file_store_data_profile}
     * - projectLocationInspectTemplate: projects/{project}/locations/{location}/inspectTemplates/{inspect_template}
     * - projectLocationJobTrigger: projects/{project}/locations/{location}/jobTriggers/{job_trigger}
     * - projectLocationProjectDataProfile: projects/{project}/locations/{location}/projectDataProfiles/{project_data_profile}
     * - projectLocationStoredInfoType: projects/{project}/locations/{location}/storedInfoTypes/{stored_info_type}
     * - projectLocationTableDataProfile: projects/{project}/locations/{location}/tableDataProfiles/{table_data_profile}
     * - projectStoredInfoType: projects/{project}/storedInfoTypes/{stored_info_type}
     * - storedInfoType: organizations/{organization}/storedInfoTypes/{stored_info_type}
     * - tableDataProfile: organizations/{organization}/locations/{location}/tableDataProfiles/{table_data_profile}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dlp.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Activate a job trigger. Causes the immediate execute of a trigger
     * instead of waiting on the trigger event to occur.
     *
     * The async variant is {@see DlpServiceClient::activateJobTriggerAsync()} .
     *
     * @example samples/V2/DlpServiceClient/activate_job_trigger.php
     *
     * @param ActivateJobTriggerRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DlpJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function activateJobTrigger(ActivateJobTriggerRequest $request, array $callOptions = []): DlpJob
    {
        return $this->startApiCall('ActivateJobTrigger', $request, $callOptions)->wait();
    }

    /**
     * Starts asynchronous cancellation on a long-running DlpJob. The server
     * makes a best effort to cancel the DlpJob, but success is not
     * guaranteed.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
     * and
     * https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::cancelDlpJobAsync()} .
     *
     * @example samples/V2/DlpServiceClient/cancel_dlp_job.php
     *
     * @param CancelDlpJobRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function cancelDlpJob(CancelDlpJobRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('CancelDlpJob', $request, $callOptions)->wait();
    }

    /**
     * Create a Connection to an external data source.
     *
     * The async variant is {@see DlpServiceClient::createConnectionAsync()} .
     *
     * @example samples/V2/DlpServiceClient/create_connection.php
     *
     * @param CreateConnectionRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Connection
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createConnection(CreateConnectionRequest $request, array $callOptions = []): Connection
    {
        return $this->startApiCall('CreateConnection', $request, $callOptions)->wait();
    }

    /**
     * Creates a DeidentifyTemplate for reusing frequently used configuration
     * for de-identifying content, images, and storage.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::createDeidentifyTemplateAsync()} .
     *
     * @example samples/V2/DlpServiceClient/create_deidentify_template.php
     *
     * @param CreateDeidentifyTemplateRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DeidentifyTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDeidentifyTemplate(
        CreateDeidentifyTemplateRequest $request,
        array $callOptions = []
    ): DeidentifyTemplate {
        return $this->startApiCall('CreateDeidentifyTemplate', $request, $callOptions)->wait();
    }

    /**
     * Creates a config for discovery to scan and profile storage.
     *
     * The async variant is {@see DlpServiceClient::createDiscoveryConfigAsync()} .
     *
     * @example samples/V2/DlpServiceClient/create_discovery_config.php
     *
     * @param CreateDiscoveryConfigRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DiscoveryConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDiscoveryConfig(
        CreateDiscoveryConfigRequest $request,
        array $callOptions = []
    ): DiscoveryConfig {
        return $this->startApiCall('CreateDiscoveryConfig', $request, $callOptions)->wait();
    }

    /**
     * Creates a new job to inspect storage or calculate risk metrics.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
     * and
     * https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
     * to learn more.
     *
     * When no InfoTypes or CustomInfoTypes are specified in inspect jobs, the
     * system will automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     *
     * The async variant is {@see DlpServiceClient::createDlpJobAsync()} .
     *
     * @example samples/V2/DlpServiceClient/create_dlp_job.php
     *
     * @param CreateDlpJobRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DlpJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDlpJob(CreateDlpJobRequest $request, array $callOptions = []): DlpJob
    {
        return $this->startApiCall('CreateDlpJob', $request, $callOptions)->wait();
    }

    /**
     * Creates an InspectTemplate for reusing frequently used configuration
     * for inspecting content, images, and storage.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::createInspectTemplateAsync()} .
     *
     * @example samples/V2/DlpServiceClient/create_inspect_template.php
     *
     * @param CreateInspectTemplateRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InspectTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createInspectTemplate(
        CreateInspectTemplateRequest $request,
        array $callOptions = []
    ): InspectTemplate {
        return $this->startApiCall('CreateInspectTemplate', $request, $callOptions)->wait();
    }

    /**
     * Creates a job trigger to run DLP actions such as scanning storage for
     * sensitive information on a set schedule.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::createJobTriggerAsync()} .
     *
     * @example samples/V2/DlpServiceClient/create_job_trigger.php
     *
     * @param CreateJobTriggerRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return JobTrigger
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createJobTrigger(CreateJobTriggerRequest $request, array $callOptions = []): JobTrigger
    {
        return $this->startApiCall('CreateJobTrigger', $request, $callOptions)->wait();
    }

    /**
     * Creates a pre-built stored infoType to be used for inspection.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::createStoredInfoTypeAsync()} .
     *
     * @example samples/V2/DlpServiceClient/create_stored_info_type.php
     *
     * @param CreateStoredInfoTypeRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return StoredInfoType
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createStoredInfoType(CreateStoredInfoTypeRequest $request, array $callOptions = []): StoredInfoType
    {
        return $this->startApiCall('CreateStoredInfoType', $request, $callOptions)->wait();
    }

    /**
     * De-identifies potentially sensitive info from a ContentItem.
     * This method has limits on input size and output size.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/deidentify-sensitive-data
     * to learn more.
     *
     * When no InfoTypes or CustomInfoTypes are specified in this request, the
     * system will automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     *
     * The async variant is {@see DlpServiceClient::deidentifyContentAsync()} .
     *
     * @example samples/V2/DlpServiceClient/deidentify_content.php
     *
     * @param DeidentifyContentRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DeidentifyContentResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deidentifyContent(
        DeidentifyContentRequest $request,
        array $callOptions = []
    ): DeidentifyContentResponse {
        return $this->startApiCall('DeidentifyContent', $request, $callOptions)->wait();
    }

    /**
     * Delete a Connection.
     *
     * The async variant is {@see DlpServiceClient::deleteConnectionAsync()} .
     *
     * @example samples/V2/DlpServiceClient/delete_connection.php
     *
     * @param DeleteConnectionRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteConnection(DeleteConnectionRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteConnection', $request, $callOptions)->wait();
    }

    /**
     * Deletes a DeidentifyTemplate.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::deleteDeidentifyTemplateAsync()} .
     *
     * @example samples/V2/DlpServiceClient/delete_deidentify_template.php
     *
     * @param DeleteDeidentifyTemplateRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDeidentifyTemplate(DeleteDeidentifyTemplateRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteDeidentifyTemplate', $request, $callOptions)->wait();
    }

    /**
     * Deletes a discovery configuration.
     *
     * The async variant is {@see DlpServiceClient::deleteDiscoveryConfigAsync()} .
     *
     * @example samples/V2/DlpServiceClient/delete_discovery_config.php
     *
     * @param DeleteDiscoveryConfigRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDiscoveryConfig(DeleteDiscoveryConfigRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteDiscoveryConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes a long-running DlpJob. This method indicates that the client is
     * no longer interested in the DlpJob result. The job will be canceled if
     * possible.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
     * and
     * https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::deleteDlpJobAsync()} .
     *
     * @example samples/V2/DlpServiceClient/delete_dlp_job.php
     *
     * @param DeleteDlpJobRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDlpJob(DeleteDlpJobRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteDlpJob', $request, $callOptions)->wait();
    }

    /**
     * Delete a FileStoreDataProfile. Will not prevent the profile from being
     * regenerated if the resource is still included in a discovery configuration.
     *
     * The async variant is {@see DlpServiceClient::deleteFileStoreDataProfileAsync()}
     * .
     *
     * @example samples/V2/DlpServiceClient/delete_file_store_data_profile.php
     *
     * @param DeleteFileStoreDataProfileRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteFileStoreDataProfile(
        DeleteFileStoreDataProfileRequest $request,
        array $callOptions = []
    ): void {
        $this->startApiCall('DeleteFileStoreDataProfile', $request, $callOptions)->wait();
    }

    /**
     * Deletes an InspectTemplate.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::deleteInspectTemplateAsync()} .
     *
     * @example samples/V2/DlpServiceClient/delete_inspect_template.php
     *
     * @param DeleteInspectTemplateRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteInspectTemplate(DeleteInspectTemplateRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteInspectTemplate', $request, $callOptions)->wait();
    }

    /**
     * Deletes a job trigger.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::deleteJobTriggerAsync()} .
     *
     * @example samples/V2/DlpServiceClient/delete_job_trigger.php
     *
     * @param DeleteJobTriggerRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteJobTrigger(DeleteJobTriggerRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteJobTrigger', $request, $callOptions)->wait();
    }

    /**
     * Deletes a stored infoType.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::deleteStoredInfoTypeAsync()} .
     *
     * @example samples/V2/DlpServiceClient/delete_stored_info_type.php
     *
     * @param DeleteStoredInfoTypeRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteStoredInfoType(DeleteStoredInfoTypeRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteStoredInfoType', $request, $callOptions)->wait();
    }

    /**
     * Delete a TableDataProfile. Will not prevent the profile from being
     * regenerated if the table is still included in a discovery configuration.
     *
     * The async variant is {@see DlpServiceClient::deleteTableDataProfileAsync()} .
     *
     * @example samples/V2/DlpServiceClient/delete_table_data_profile.php
     *
     * @param DeleteTableDataProfileRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTableDataProfile(DeleteTableDataProfileRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteTableDataProfile', $request, $callOptions)->wait();
    }

    /**
     * Finish a running hybrid DlpJob. Triggers the finalization steps and running
     * of any enabled actions that have not yet run.
     *
     * The async variant is {@see DlpServiceClient::finishDlpJobAsync()} .
     *
     * @example samples/V2/DlpServiceClient/finish_dlp_job.php
     *
     * @param FinishDlpJobRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function finishDlpJob(FinishDlpJobRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('FinishDlpJob', $request, $callOptions)->wait();
    }

    /**
     * Gets a column data profile.
     *
     * The async variant is {@see DlpServiceClient::getColumnDataProfileAsync()} .
     *
     * @example samples/V2/DlpServiceClient/get_column_data_profile.php
     *
     * @param GetColumnDataProfileRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ColumnDataProfile
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getColumnDataProfile(
        GetColumnDataProfileRequest $request,
        array $callOptions = []
    ): ColumnDataProfile {
        return $this->startApiCall('GetColumnDataProfile', $request, $callOptions)->wait();
    }

    /**
     * Get a Connection by name.
     *
     * The async variant is {@see DlpServiceClient::getConnectionAsync()} .
     *
     * @example samples/V2/DlpServiceClient/get_connection.php
     *
     * @param GetConnectionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Connection
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getConnection(GetConnectionRequest $request, array $callOptions = []): Connection
    {
        return $this->startApiCall('GetConnection', $request, $callOptions)->wait();
    }

    /**
     * Gets a DeidentifyTemplate.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::getDeidentifyTemplateAsync()} .
     *
     * @example samples/V2/DlpServiceClient/get_deidentify_template.php
     *
     * @param GetDeidentifyTemplateRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DeidentifyTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDeidentifyTemplate(
        GetDeidentifyTemplateRequest $request,
        array $callOptions = []
    ): DeidentifyTemplate {
        return $this->startApiCall('GetDeidentifyTemplate', $request, $callOptions)->wait();
    }

    /**
     * Gets a discovery configuration.
     *
     * The async variant is {@see DlpServiceClient::getDiscoveryConfigAsync()} .
     *
     * @example samples/V2/DlpServiceClient/get_discovery_config.php
     *
     * @param GetDiscoveryConfigRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DiscoveryConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDiscoveryConfig(GetDiscoveryConfigRequest $request, array $callOptions = []): DiscoveryConfig
    {
        return $this->startApiCall('GetDiscoveryConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets the latest state of a long-running DlpJob.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
     * and
     * https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::getDlpJobAsync()} .
     *
     * @example samples/V2/DlpServiceClient/get_dlp_job.php
     *
     * @param GetDlpJobRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DlpJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDlpJob(GetDlpJobRequest $request, array $callOptions = []): DlpJob
    {
        return $this->startApiCall('GetDlpJob', $request, $callOptions)->wait();
    }

    /**
     * Gets a file store data profile.
     *
     * The async variant is {@see DlpServiceClient::getFileStoreDataProfileAsync()} .
     *
     * @example samples/V2/DlpServiceClient/get_file_store_data_profile.php
     *
     * @param GetFileStoreDataProfileRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FileStoreDataProfile
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getFileStoreDataProfile(
        GetFileStoreDataProfileRequest $request,
        array $callOptions = []
    ): FileStoreDataProfile {
        return $this->startApiCall('GetFileStoreDataProfile', $request, $callOptions)->wait();
    }

    /**
     * Gets an InspectTemplate.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::getInspectTemplateAsync()} .
     *
     * @example samples/V2/DlpServiceClient/get_inspect_template.php
     *
     * @param GetInspectTemplateRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InspectTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getInspectTemplate(GetInspectTemplateRequest $request, array $callOptions = []): InspectTemplate
    {
        return $this->startApiCall('GetInspectTemplate', $request, $callOptions)->wait();
    }

    /**
     * Gets a job trigger.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::getJobTriggerAsync()} .
     *
     * @example samples/V2/DlpServiceClient/get_job_trigger.php
     *
     * @param GetJobTriggerRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return JobTrigger
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getJobTrigger(GetJobTriggerRequest $request, array $callOptions = []): JobTrigger
    {
        return $this->startApiCall('GetJobTrigger', $request, $callOptions)->wait();
    }

    /**
     * Gets a project data profile.
     *
     * The async variant is {@see DlpServiceClient::getProjectDataProfileAsync()} .
     *
     * @example samples/V2/DlpServiceClient/get_project_data_profile.php
     *
     * @param GetProjectDataProfileRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ProjectDataProfile
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getProjectDataProfile(
        GetProjectDataProfileRequest $request,
        array $callOptions = []
    ): ProjectDataProfile {
        return $this->startApiCall('GetProjectDataProfile', $request, $callOptions)->wait();
    }

    /**
     * Gets a stored infoType.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::getStoredInfoTypeAsync()} .
     *
     * @example samples/V2/DlpServiceClient/get_stored_info_type.php
     *
     * @param GetStoredInfoTypeRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return StoredInfoType
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getStoredInfoType(GetStoredInfoTypeRequest $request, array $callOptions = []): StoredInfoType
    {
        return $this->startApiCall('GetStoredInfoType', $request, $callOptions)->wait();
    }

    /**
     * Gets a table data profile.
     *
     * The async variant is {@see DlpServiceClient::getTableDataProfileAsync()} .
     *
     * @example samples/V2/DlpServiceClient/get_table_data_profile.php
     *
     * @param GetTableDataProfileRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TableDataProfile
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTableDataProfile(GetTableDataProfileRequest $request, array $callOptions = []): TableDataProfile
    {
        return $this->startApiCall('GetTableDataProfile', $request, $callOptions)->wait();
    }

    /**
     * Inspect hybrid content and store findings to a job.
     * To review the findings, inspect the job. Inspection will occur
     * asynchronously.
     *
     * The async variant is {@see DlpServiceClient::hybridInspectDlpJobAsync()} .
     *
     * @example samples/V2/DlpServiceClient/hybrid_inspect_dlp_job.php
     *
     * @param HybridInspectDlpJobRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HybridInspectResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function hybridInspectDlpJob(
        HybridInspectDlpJobRequest $request,
        array $callOptions = []
    ): HybridInspectResponse {
        return $this->startApiCall('HybridInspectDlpJob', $request, $callOptions)->wait();
    }

    /**
     * Inspect hybrid content and store findings to a trigger. The inspection
     * will be processed asynchronously. To review the findings monitor the
     * jobs within the trigger.
     *
     * The async variant is {@see DlpServiceClient::hybridInspectJobTriggerAsync()} .
     *
     * @example samples/V2/DlpServiceClient/hybrid_inspect_job_trigger.php
     *
     * @param HybridInspectJobTriggerRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HybridInspectResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function hybridInspectJobTrigger(
        HybridInspectJobTriggerRequest $request,
        array $callOptions = []
    ): HybridInspectResponse {
        return $this->startApiCall('HybridInspectJobTrigger', $request, $callOptions)->wait();
    }

    /**
     * Finds potentially sensitive info in content.
     * This method has limits on input size, processing time, and output size.
     *
     * When no InfoTypes or CustomInfoTypes are specified in this request, the
     * system will automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     *
     * For how to guides, see
     * https://cloud.google.com/sensitive-data-protection/docs/inspecting-images
     * and
     * https://cloud.google.com/sensitive-data-protection/docs/inspecting-text,
     *
     * The async variant is {@see DlpServiceClient::inspectContentAsync()} .
     *
     * @example samples/V2/DlpServiceClient/inspect_content.php
     *
     * @param InspectContentRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InspectContentResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function inspectContent(InspectContentRequest $request, array $callOptions = []): InspectContentResponse
    {
        return $this->startApiCall('InspectContent', $request, $callOptions)->wait();
    }

    /**
     * Lists column data profiles for an organization.
     *
     * The async variant is {@see DlpServiceClient::listColumnDataProfilesAsync()} .
     *
     * @example samples/V2/DlpServiceClient/list_column_data_profiles.php
     *
     * @param ListColumnDataProfilesRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listColumnDataProfiles(
        ListColumnDataProfilesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListColumnDataProfiles', $request, $callOptions);
    }

    /**
     * Lists Connections in a parent. Use SearchConnections to see all connections
     * within an organization.
     *
     * The async variant is {@see DlpServiceClient::listConnectionsAsync()} .
     *
     * @example samples/V2/DlpServiceClient/list_connections.php
     *
     * @param ListConnectionsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listConnections(ListConnectionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListConnections', $request, $callOptions);
    }

    /**
     * Lists DeidentifyTemplates.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::listDeidentifyTemplatesAsync()} .
     *
     * @example samples/V2/DlpServiceClient/list_deidentify_templates.php
     *
     * @param ListDeidentifyTemplatesRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDeidentifyTemplates(
        ListDeidentifyTemplatesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListDeidentifyTemplates', $request, $callOptions);
    }

    /**
     * Lists discovery configurations.
     *
     * The async variant is {@see DlpServiceClient::listDiscoveryConfigsAsync()} .
     *
     * @example samples/V2/DlpServiceClient/list_discovery_configs.php
     *
     * @param ListDiscoveryConfigsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDiscoveryConfigs(
        ListDiscoveryConfigsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListDiscoveryConfigs', $request, $callOptions);
    }

    /**
     * Lists DlpJobs that match the specified filter in the request.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
     * and
     * https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::listDlpJobsAsync()} .
     *
     * @example samples/V2/DlpServiceClient/list_dlp_jobs.php
     *
     * @param ListDlpJobsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDlpJobs(ListDlpJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDlpJobs', $request, $callOptions);
    }

    /**
     * Lists file store data profiles for an organization.
     *
     * The async variant is {@see DlpServiceClient::listFileStoreDataProfilesAsync()} .
     *
     * @example samples/V2/DlpServiceClient/list_file_store_data_profiles.php
     *
     * @param ListFileStoreDataProfilesRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listFileStoreDataProfiles(
        ListFileStoreDataProfilesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListFileStoreDataProfiles', $request, $callOptions);
    }

    /**
     * Returns a list of the sensitive information types that the DLP API
     * supports. See
     * https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::listInfoTypesAsync()} .
     *
     * @example samples/V2/DlpServiceClient/list_info_types.php
     *
     * @param ListInfoTypesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListInfoTypesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listInfoTypes(ListInfoTypesRequest $request, array $callOptions = []): ListInfoTypesResponse
    {
        return $this->startApiCall('ListInfoTypes', $request, $callOptions)->wait();
    }

    /**
     * Lists InspectTemplates.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::listInspectTemplatesAsync()} .
     *
     * @example samples/V2/DlpServiceClient/list_inspect_templates.php
     *
     * @param ListInspectTemplatesRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listInspectTemplates(
        ListInspectTemplatesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListInspectTemplates', $request, $callOptions);
    }

    /**
     * Lists job triggers.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::listJobTriggersAsync()} .
     *
     * @example samples/V2/DlpServiceClient/list_job_triggers.php
     *
     * @param ListJobTriggersRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listJobTriggers(ListJobTriggersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListJobTriggers', $request, $callOptions);
    }

    /**
     * Lists project data profiles for an organization.
     *
     * The async variant is {@see DlpServiceClient::listProjectDataProfilesAsync()} .
     *
     * @example samples/V2/DlpServiceClient/list_project_data_profiles.php
     *
     * @param ListProjectDataProfilesRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listProjectDataProfiles(
        ListProjectDataProfilesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListProjectDataProfiles', $request, $callOptions);
    }

    /**
     * Lists stored infoTypes.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::listStoredInfoTypesAsync()} .
     *
     * @example samples/V2/DlpServiceClient/list_stored_info_types.php
     *
     * @param ListStoredInfoTypesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listStoredInfoTypes(ListStoredInfoTypesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListStoredInfoTypes', $request, $callOptions);
    }

    /**
     * Lists table data profiles for an organization.
     *
     * The async variant is {@see DlpServiceClient::listTableDataProfilesAsync()} .
     *
     * @example samples/V2/DlpServiceClient/list_table_data_profiles.php
     *
     * @param ListTableDataProfilesRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTableDataProfiles(
        ListTableDataProfilesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListTableDataProfiles', $request, $callOptions);
    }

    /**
     * Redacts potentially sensitive info from an image.
     * This method has limits on input size, processing time, and output size.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/redacting-sensitive-data-images
     * to learn more.
     *
     * When no InfoTypes or CustomInfoTypes are specified in this request, the
     * system will automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     *
     * The async variant is {@see DlpServiceClient::redactImageAsync()} .
     *
     * @example samples/V2/DlpServiceClient/redact_image.php
     *
     * @param RedactImageRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RedactImageResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function redactImage(RedactImageRequest $request, array $callOptions = []): RedactImageResponse
    {
        return $this->startApiCall('RedactImage', $request, $callOptions)->wait();
    }

    /**
     * Re-identifies content that has been de-identified.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/pseudonymization#re-identification_in_free_text_code_example
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::reidentifyContentAsync()} .
     *
     * @example samples/V2/DlpServiceClient/reidentify_content.php
     *
     * @param ReidentifyContentRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ReidentifyContentResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function reidentifyContent(
        ReidentifyContentRequest $request,
        array $callOptions = []
    ): ReidentifyContentResponse {
        return $this->startApiCall('ReidentifyContent', $request, $callOptions)->wait();
    }

    /**
     * Searches for Connections in a parent.
     *
     * The async variant is {@see DlpServiceClient::searchConnectionsAsync()} .
     *
     * @example samples/V2/DlpServiceClient/search_connections.php
     *
     * @param SearchConnectionsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchConnections(SearchConnectionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchConnections', $request, $callOptions);
    }

    /**
     * Update a Connection.
     *
     * The async variant is {@see DlpServiceClient::updateConnectionAsync()} .
     *
     * @example samples/V2/DlpServiceClient/update_connection.php
     *
     * @param UpdateConnectionRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Connection
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateConnection(UpdateConnectionRequest $request, array $callOptions = []): Connection
    {
        return $this->startApiCall('UpdateConnection', $request, $callOptions)->wait();
    }

    /**
     * Updates the DeidentifyTemplate.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::updateDeidentifyTemplateAsync()} .
     *
     * @example samples/V2/DlpServiceClient/update_deidentify_template.php
     *
     * @param UpdateDeidentifyTemplateRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DeidentifyTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDeidentifyTemplate(
        UpdateDeidentifyTemplateRequest $request,
        array $callOptions = []
    ): DeidentifyTemplate {
        return $this->startApiCall('UpdateDeidentifyTemplate', $request, $callOptions)->wait();
    }

    /**
     * Updates a discovery configuration.
     *
     * The async variant is {@see DlpServiceClient::updateDiscoveryConfigAsync()} .
     *
     * @example samples/V2/DlpServiceClient/update_discovery_config.php
     *
     * @param UpdateDiscoveryConfigRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DiscoveryConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDiscoveryConfig(
        UpdateDiscoveryConfigRequest $request,
        array $callOptions = []
    ): DiscoveryConfig {
        return $this->startApiCall('UpdateDiscoveryConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates the InspectTemplate.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::updateInspectTemplateAsync()} .
     *
     * @example samples/V2/DlpServiceClient/update_inspect_template.php
     *
     * @param UpdateInspectTemplateRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InspectTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateInspectTemplate(
        UpdateInspectTemplateRequest $request,
        array $callOptions = []
    ): InspectTemplate {
        return $this->startApiCall('UpdateInspectTemplate', $request, $callOptions)->wait();
    }

    /**
     * Updates a job trigger.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::updateJobTriggerAsync()} .
     *
     * @example samples/V2/DlpServiceClient/update_job_trigger.php
     *
     * @param UpdateJobTriggerRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return JobTrigger
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateJobTrigger(UpdateJobTriggerRequest $request, array $callOptions = []): JobTrigger
    {
        return $this->startApiCall('UpdateJobTrigger', $request, $callOptions)->wait();
    }

    /**
     * Updates the stored infoType by creating a new version. The existing version
     * will continue to be used until the new version is ready.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
     * to learn more.
     *
     * The async variant is {@see DlpServiceClient::updateStoredInfoTypeAsync()} .
     *
     * @example samples/V2/DlpServiceClient/update_stored_info_type.php
     *
     * @param UpdateStoredInfoTypeRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return StoredInfoType
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateStoredInfoType(UpdateStoredInfoTypeRequest $request, array $callOptions = []): StoredInfoType
    {
        return $this->startApiCall('UpdateStoredInfoType', $request, $callOptions)->wait();
    }
}
