<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1\ControlPlaneEndpointsConfig;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Describes the configuration of a DNS endpoint.
 *
 * Generated from protobuf message <code>google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig</code>
 */
class DNSEndpointConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The cluster's DNS endpoint configuration.
     * A DNS format address. This is accessible from the public internet.
     * Ex: uid.us-central1.gke.goog.
     * Always present, but the behavior may change according to the value of
     * [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
     *
     * Generated from protobuf field <code>string endpoint = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $endpoint = '';
    /**
     * Controls whether user traffic is allowed over this endpoint. Note that
     * GCP-managed services may still use the endpoint even if this is false.
     *
     * Generated from protobuf field <code>optional bool allow_external_traffic = 3;</code>
     */
    protected $allow_external_traffic = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $endpoint
     *           Output only. The cluster's DNS endpoint configuration.
     *           A DNS format address. This is accessible from the public internet.
     *           Ex: uid.us-central1.gke.goog.
     *           Always present, but the behavior may change according to the value of
     *           [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
     *     @type bool $allow_external_traffic
     *           Controls whether user traffic is allowed over this endpoint. Note that
     *           GCP-managed services may still use the endpoint even if this is false.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The cluster's DNS endpoint configuration.
     * A DNS format address. This is accessible from the public internet.
     * Ex: uid.us-central1.gke.goog.
     * Always present, but the behavior may change according to the value of
     * [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
     *
     * Generated from protobuf field <code>string endpoint = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEndpoint()
    {
        return $this->endpoint;
    }

    /**
     * Output only. The cluster's DNS endpoint configuration.
     * A DNS format address. This is accessible from the public internet.
     * Ex: uid.us-central1.gke.goog.
     * Always present, but the behavior may change according to the value of
     * [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
     *
     * Generated from protobuf field <code>string endpoint = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEndpoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->endpoint = $var;

        return $this;
    }

    /**
     * Controls whether user traffic is allowed over this endpoint. Note that
     * GCP-managed services may still use the endpoint even if this is false.
     *
     * Generated from protobuf field <code>optional bool allow_external_traffic = 3;</code>
     * @return bool
     */
    public function getAllowExternalTraffic()
    {
        return isset($this->allow_external_traffic) ? $this->allow_external_traffic : false;
    }

    public function hasAllowExternalTraffic()
    {
        return isset($this->allow_external_traffic);
    }

    public function clearAllowExternalTraffic()
    {
        unset($this->allow_external_traffic);
    }

    /**
     * Controls whether user traffic is allowed over this endpoint. Note that
     * GCP-managed services may still use the endpoint even if this is false.
     *
     * Generated from protobuf field <code>optional bool allow_external_traffic = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowExternalTraffic($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_external_traffic = $var;

        return $this;
    }

}


