<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/sql/v1/cloud_sql_resources.proto

namespace Google\Cloud\Sql\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * PSC settings for a Cloud SQL instance.
 *
 * Generated from protobuf message <code>google.cloud.sql.v1.PscConfig</code>
 */
class PscConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Whether PSC connectivity is enabled for this instance.
     *
     * Generated from protobuf field <code>optional bool psc_enabled = 1;</code>
     */
    protected $psc_enabled = null;
    /**
     * Optional. The list of consumer projects that are allow-listed for PSC
     * connections to this instance. This instance can be connected to with PSC
     * from any network in these projects.
     * Each consumer project in this list may be represented by a project number
     * (numeric) or by a project id (alphanumeric).
     *
     * Generated from protobuf field <code>repeated string allowed_consumer_projects = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $allowed_consumer_projects;
    /**
     * Optional. The list of settings for requested Private Service Connect
     * consumer endpoints that can be used to connect to this Cloud SQL instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.PscAutoConnectionConfig psc_auto_connections = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $psc_auto_connections;
    /**
     * Optional. The network attachment of the consumer network that the
     * Private Service Connect enabled Cloud SQL instance is
     * authorized to connect via PSC interface.
     * format: projects/PROJECT/regions/REGION/networkAttachments/ID
     *
     * Generated from protobuf field <code>string network_attachment_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $network_attachment_uri = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $psc_enabled
     *           Whether PSC connectivity is enabled for this instance.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $allowed_consumer_projects
     *           Optional. The list of consumer projects that are allow-listed for PSC
     *           connections to this instance. This instance can be connected to with PSC
     *           from any network in these projects.
     *           Each consumer project in this list may be represented by a project number
     *           (numeric) or by a project id (alphanumeric).
     *     @type array<\Google\Cloud\Sql\V1\PscAutoConnectionConfig>|\Google\Protobuf\Internal\RepeatedField $psc_auto_connections
     *           Optional. The list of settings for requested Private Service Connect
     *           consumer endpoints that can be used to connect to this Cloud SQL instance.
     *     @type string $network_attachment_uri
     *           Optional. The network attachment of the consumer network that the
     *           Private Service Connect enabled Cloud SQL instance is
     *           authorized to connect via PSC interface.
     *           format: projects/PROJECT/regions/REGION/networkAttachments/ID
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Sql\V1\CloudSqlResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Whether PSC connectivity is enabled for this instance.
     *
     * Generated from protobuf field <code>optional bool psc_enabled = 1;</code>
     * @return bool
     */
    public function getPscEnabled()
    {
        return isset($this->psc_enabled) ? $this->psc_enabled : false;
    }

    public function hasPscEnabled()
    {
        return isset($this->psc_enabled);
    }

    public function clearPscEnabled()
    {
        unset($this->psc_enabled);
    }

    /**
     * Whether PSC connectivity is enabled for this instance.
     *
     * Generated from protobuf field <code>optional bool psc_enabled = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setPscEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->psc_enabled = $var;

        return $this;
    }

    /**
     * Optional. The list of consumer projects that are allow-listed for PSC
     * connections to this instance. This instance can be connected to with PSC
     * from any network in these projects.
     * Each consumer project in this list may be represented by a project number
     * (numeric) or by a project id (alphanumeric).
     *
     * Generated from protobuf field <code>repeated string allowed_consumer_projects = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowedConsumerProjects()
    {
        return $this->allowed_consumer_projects;
    }

    /**
     * Optional. The list of consumer projects that are allow-listed for PSC
     * connections to this instance. This instance can be connected to with PSC
     * from any network in these projects.
     * Each consumer project in this list may be represented by a project number
     * (numeric) or by a project id (alphanumeric).
     *
     * Generated from protobuf field <code>repeated string allowed_consumer_projects = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowedConsumerProjects($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->allowed_consumer_projects = $arr;

        return $this;
    }

    /**
     * Optional. The list of settings for requested Private Service Connect
     * consumer endpoints that can be used to connect to this Cloud SQL instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.PscAutoConnectionConfig psc_auto_connections = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPscAutoConnections()
    {
        return $this->psc_auto_connections;
    }

    /**
     * Optional. The list of settings for requested Private Service Connect
     * consumer endpoints that can be used to connect to this Cloud SQL instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.PscAutoConnectionConfig psc_auto_connections = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Sql\V1\PscAutoConnectionConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPscAutoConnections($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Sql\V1\PscAutoConnectionConfig::class);
        $this->psc_auto_connections = $arr;

        return $this;
    }

    /**
     * Optional. The network attachment of the consumer network that the
     * Private Service Connect enabled Cloud SQL instance is
     * authorized to connect via PSC interface.
     * format: projects/PROJECT/regions/REGION/networkAttachments/ID
     *
     * Generated from protobuf field <code>string network_attachment_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getNetworkAttachmentUri()
    {
        return $this->network_attachment_uri;
    }

    /**
     * Optional. The network attachment of the consumer network that the
     * Private Service Connect enabled Cloud SQL instance is
     * authorized to connect via PSC interface.
     * format: projects/PROJECT/regions/REGION/networkAttachments/ID
     *
     * Generated from protobuf field <code>string network_attachment_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setNetworkAttachmentUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->network_attachment_uri = $var;

        return $this;
    }

}

