<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/location.proto

namespace Google\Cloud\Spanner\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A `Range` represents a range of keys in a database. The keys themselves
 * are encoded in "sortable string format", also known as ssformat. Consult
 * Spanner's open source client libraries for details on the encoding.
 * Each range represents a contiguous range of rows, possibly from multiple
 * tables/indexes. Each range is associated with a single paxos group (known as
 * a "group" throughout this API), a split (which names the exact range within
 * the group), and a generation that can be used to determine whether a given
 * `Range` represents a newer or older location for the key range.
 *
 * Generated from protobuf message <code>google.spanner.v1.Range</code>
 */
class Range extends \Google\Protobuf\Internal\Message
{
    /**
     * The start key of the range, inclusive. Encoded in "sortable string format"
     * (ssformat).
     *
     * Generated from protobuf field <code>bytes start_key = 1;</code>
     */
    protected $start_key = '';
    /**
     * The limit key of the range, exclusive. Encoded in "sortable string format"
     * (ssformat).
     *
     * Generated from protobuf field <code>bytes limit_key = 2;</code>
     */
    protected $limit_key = '';
    /**
     * The UID of the paxos group where this range is stored. UIDs are unique
     * within the database. References `Group.group_uid`.
     *
     * Generated from protobuf field <code>uint64 group_uid = 3;</code>
     */
    protected $group_uid = 0;
    /**
     * A group can store multiple ranges of keys. Each key range is named by an
     * ID (the split ID). Within a group, split IDs are unique. The `split_id`
     * names the exact split in `group_uid` where this range is stored.
     *
     * Generated from protobuf field <code>uint64 split_id = 4;</code>
     */
    protected $split_id = 0;
    /**
     * `generation` indicates the freshness of the range information contained
     * in this proto. Generations can be compared lexicographically; if generation
     * A is greater than generation B, then the `Range` corresponding to A is
     * newer than the `Range` corresponding to B, and should be used
     * preferentially.
     *
     * Generated from protobuf field <code>bytes generation = 5;</code>
     */
    protected $generation = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $start_key
     *           The start key of the range, inclusive. Encoded in "sortable string format"
     *           (ssformat).
     *     @type string $limit_key
     *           The limit key of the range, exclusive. Encoded in "sortable string format"
     *           (ssformat).
     *     @type int|string $group_uid
     *           The UID of the paxos group where this range is stored. UIDs are unique
     *           within the database. References `Group.group_uid`.
     *     @type int|string $split_id
     *           A group can store multiple ranges of keys. Each key range is named by an
     *           ID (the split ID). Within a group, split IDs are unique. The `split_id`
     *           names the exact split in `group_uid` where this range is stored.
     *     @type string $generation
     *           `generation` indicates the freshness of the range information contained
     *           in this proto. Generations can be compared lexicographically; if generation
     *           A is greater than generation B, then the `Range` corresponding to A is
     *           newer than the `Range` corresponding to B, and should be used
     *           preferentially.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\Location::initOnce();
        parent::__construct($data);
    }

    /**
     * The start key of the range, inclusive. Encoded in "sortable string format"
     * (ssformat).
     *
     * Generated from protobuf field <code>bytes start_key = 1;</code>
     * @return string
     */
    public function getStartKey()
    {
        return $this->start_key;
    }

    /**
     * The start key of the range, inclusive. Encoded in "sortable string format"
     * (ssformat).
     *
     * Generated from protobuf field <code>bytes start_key = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setStartKey($var)
    {
        GPBUtil::checkString($var, False);
        $this->start_key = $var;

        return $this;
    }

    /**
     * The limit key of the range, exclusive. Encoded in "sortable string format"
     * (ssformat).
     *
     * Generated from protobuf field <code>bytes limit_key = 2;</code>
     * @return string
     */
    public function getLimitKey()
    {
        return $this->limit_key;
    }

    /**
     * The limit key of the range, exclusive. Encoded in "sortable string format"
     * (ssformat).
     *
     * Generated from protobuf field <code>bytes limit_key = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setLimitKey($var)
    {
        GPBUtil::checkString($var, False);
        $this->limit_key = $var;

        return $this;
    }

    /**
     * The UID of the paxos group where this range is stored. UIDs are unique
     * within the database. References `Group.group_uid`.
     *
     * Generated from protobuf field <code>uint64 group_uid = 3;</code>
     * @return int|string
     */
    public function getGroupUid()
    {
        return $this->group_uid;
    }

    /**
     * The UID of the paxos group where this range is stored. UIDs are unique
     * within the database. References `Group.group_uid`.
     *
     * Generated from protobuf field <code>uint64 group_uid = 3;</code>
     * @param int|string $var
     * @return $this
     */
    public function setGroupUid($var)
    {
        GPBUtil::checkUint64($var);
        $this->group_uid = $var;

        return $this;
    }

    /**
     * A group can store multiple ranges of keys. Each key range is named by an
     * ID (the split ID). Within a group, split IDs are unique. The `split_id`
     * names the exact split in `group_uid` where this range is stored.
     *
     * Generated from protobuf field <code>uint64 split_id = 4;</code>
     * @return int|string
     */
    public function getSplitId()
    {
        return $this->split_id;
    }

    /**
     * A group can store multiple ranges of keys. Each key range is named by an
     * ID (the split ID). Within a group, split IDs are unique. The `split_id`
     * names the exact split in `group_uid` where this range is stored.
     *
     * Generated from protobuf field <code>uint64 split_id = 4;</code>
     * @param int|string $var
     * @return $this
     */
    public function setSplitId($var)
    {
        GPBUtil::checkUint64($var);
        $this->split_id = $var;

        return $this;
    }

    /**
     * `generation` indicates the freshness of the range information contained
     * in this proto. Generations can be compared lexicographically; if generation
     * A is greater than generation B, then the `Range` corresponding to A is
     * newer than the `Range` corresponding to B, and should be used
     * preferentially.
     *
     * Generated from protobuf field <code>bytes generation = 5;</code>
     * @return string
     */
    public function getGeneration()
    {
        return $this->generation;
    }

    /**
     * `generation` indicates the freshness of the range information contained
     * in this proto. Generations can be compared lexicographically; if generation
     * A is greater than generation B, then the `Range` corresponding to A is
     * newer than the `Range` corresponding to B, and should be used
     * preferentially.
     *
     * Generated from protobuf field <code>bytes generation = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setGeneration($var)
    {
        GPBUtil::checkString($var, False);
        $this->generation = $var;

        return $this;
    }

}

