<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/cloudsecuritycompliance/v1/audit.proto

namespace Google\Cloud\CloudSecurityCompliance\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The request message for [CreateFrameworkAudit][].
 *
 * Generated from protobuf message <code>google.cloud.cloudsecuritycompliance.v1.CreateFrameworkAuditRequest</code>
 */
class CreateFrameworkAuditRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent resource where this framework audit is created.
     * Supported formats are the following:
     * * `organizations/{organization_id}/locations/{location}`
     * * `folders/{folder_id}/locations/{location}`
     * * `projects/{project_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Optional. The ID to use for the framework audit. The ID becomes the final
     * component of the framework audit's full resource name.
     * The ID must be between 4-63 characters, and valid characters
     * are `\[a-z][0-9]-\`.
     *
     * Generated from protobuf field <code>string framework_audit_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $framework_audit_id = '';
    /**
     * Required. The framework audit to create.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.FrameworkAudit framework_audit = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $framework_audit = null;

    /**
     * @param string                                                  $parent           Required. The parent resource where this framework audit is created.
     *
     *                                                                                  Supported formats are the following:
     *
     *                                                                                  * `organizations/{organization_id}/locations/{location}`
     *                                                                                  * `folders/{folder_id}/locations/{location}`
     *                                                                                  * `projects/{project_id}/locations/{location}`
     *                                                                                  Please see {@see AuditClient::organizationLocationName()} for help formatting this field.
     * @param \Google\Cloud\CloudSecurityCompliance\V1\FrameworkAudit $frameworkAudit   Required. The framework audit to create.
     * @param string                                                  $frameworkAuditId Optional. The ID to use for the framework audit. The ID becomes the final
     *                                                                                  component of the framework audit's full resource name.
     *
     *                                                                                  The ID must be between 4-63 characters, and valid characters
     *                                                                                  are `\[a-z][0-9]-\`.
     *
     * @return \Google\Cloud\CloudSecurityCompliance\V1\CreateFrameworkAuditRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\CloudSecurityCompliance\V1\FrameworkAudit $frameworkAudit, string $frameworkAuditId): self
    {
        return (new self())
            ->setParent($parent)
            ->setFrameworkAudit($frameworkAudit)
            ->setFrameworkAuditId($frameworkAuditId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent resource where this framework audit is created.
     *           Supported formats are the following:
     *           * `organizations/{organization_id}/locations/{location}`
     *           * `folders/{folder_id}/locations/{location}`
     *           * `projects/{project_id}/locations/{location}`
     *     @type string $framework_audit_id
     *           Optional. The ID to use for the framework audit. The ID becomes the final
     *           component of the framework audit's full resource name.
     *           The ID must be between 4-63 characters, and valid characters
     *           are `\[a-z][0-9]-\`.
     *     @type \Google\Cloud\CloudSecurityCompliance\V1\FrameworkAudit $framework_audit
     *           Required. The framework audit to create.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Cloudsecuritycompliance\V1\Audit::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent resource where this framework audit is created.
     * Supported formats are the following:
     * * `organizations/{organization_id}/locations/{location}`
     * * `folders/{folder_id}/locations/{location}`
     * * `projects/{project_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent resource where this framework audit is created.
     * Supported formats are the following:
     * * `organizations/{organization_id}/locations/{location}`
     * * `folders/{folder_id}/locations/{location}`
     * * `projects/{project_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Optional. The ID to use for the framework audit. The ID becomes the final
     * component of the framework audit's full resource name.
     * The ID must be between 4-63 characters, and valid characters
     * are `\[a-z][0-9]-\`.
     *
     * Generated from protobuf field <code>string framework_audit_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getFrameworkAuditId()
    {
        return $this->framework_audit_id;
    }

    /**
     * Optional. The ID to use for the framework audit. The ID becomes the final
     * component of the framework audit's full resource name.
     * The ID must be between 4-63 characters, and valid characters
     * are `\[a-z][0-9]-\`.
     *
     * Generated from protobuf field <code>string framework_audit_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setFrameworkAuditId($var)
    {
        GPBUtil::checkString($var, True);
        $this->framework_audit_id = $var;

        return $this;
    }

    /**
     * Required. The framework audit to create.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.FrameworkAudit framework_audit = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\CloudSecurityCompliance\V1\FrameworkAudit|null
     */
    public function getFrameworkAudit()
    {
        return $this->framework_audit;
    }

    public function hasFrameworkAudit()
    {
        return isset($this->framework_audit);
    }

    public function clearFrameworkAudit()
    {
        unset($this->framework_audit);
    }

    /**
     * Required. The framework audit to create.
     *
     * Generated from protobuf field <code>.google.cloud.cloudsecuritycompliance.v1.FrameworkAudit framework_audit = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\CloudSecurityCompliance\V1\FrameworkAudit $var
     * @return $this
     */
    public function setFrameworkAudit($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudSecurityCompliance\V1\FrameworkAudit::class);
        $this->framework_audit = $var;

        return $this;
    }

}

