<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/securitycentermanagement/v1/security_center_management.proto

namespace Google\Cloud\SecurityCenterManagement\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a particular Security Command Center service. This includes
 * settings information such as top-level enablement in addition to individual
 * module settings. Service settings can be configured at the organization,
 * folder, or project level. Service settings at the organization or folder
 * level are inherited by those in descendant folders and projects.
 *
 * Generated from protobuf message <code>google.cloud.securitycentermanagement.v1.SecurityCenterService</code>
 */
class SecurityCenterService extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the service, in one of the following formats:
     * * `organizations/{organization}/locations/{location}/securityCenterServices/{service}`
     * * `folders/{folder}/locations/{location}/securityCenterServices/{service}`
     * * `projects/{project}/locations/{location}/securityCenterServices/{service}`
     * The following values are valid for `{service}`:
     * * `container-threat-detection`
     * * `event-threat-detection`
     * * `security-health-analytics`
     * * `vm-threat-detection`
     * * `web-security-scanner`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Optional. The intended enablement state for the service at its level of the
     * resource hierarchy. A `DISABLED` state will override all module enablement
     * states to `DISABLED`.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SecurityCenterService.EnablementState intended_enablement_state = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $intended_enablement_state = 0;
    /**
     * Output only. The effective enablement state for the service at its level of
     * the resource hierarchy. If the intended state is set to `INHERITED`, the
     * effective state will be inherited from the enablement state of an ancestor.
     * This state may differ from the intended enablement state due to billing
     * eligibility or onboarding status.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SecurityCenterService.EnablementState effective_enablement_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $effective_enablement_state = 0;
    /**
     * Optional. The module configurations, including the enablement state for the
     * service's modules. The absence of a module in the map implies that its
     * configuration is inherited from its parents.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.securitycentermanagement.v1.SecurityCenterService.ModuleSettings> modules = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $modules;
    /**
     * Output only. The time the service was last updated. This could be due to an
     * explicit user update or due to a side effect of another system change, such
     * as billing subscription expiry.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. Additional service-specific configuration. Not all services will
     * utilize this field.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct service_config = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $service_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of the service, in one of the following formats:
     *           * `organizations/{organization}/locations/{location}/securityCenterServices/{service}`
     *           * `folders/{folder}/locations/{location}/securityCenterServices/{service}`
     *           * `projects/{project}/locations/{location}/securityCenterServices/{service}`
     *           The following values are valid for `{service}`:
     *           * `container-threat-detection`
     *           * `event-threat-detection`
     *           * `security-health-analytics`
     *           * `vm-threat-detection`
     *           * `web-security-scanner`
     *     @type int $intended_enablement_state
     *           Optional. The intended enablement state for the service at its level of the
     *           resource hierarchy. A `DISABLED` state will override all module enablement
     *           states to `DISABLED`.
     *     @type int $effective_enablement_state
     *           Output only. The effective enablement state for the service at its level of
     *           the resource hierarchy. If the intended state is set to `INHERITED`, the
     *           effective state will be inherited from the enablement state of an ancestor.
     *           This state may differ from the intended enablement state due to billing
     *           eligibility or onboarding status.
     *     @type array|\Google\Protobuf\Internal\MapField $modules
     *           Optional. The module configurations, including the enablement state for the
     *           service's modules. The absence of a module in the map implies that its
     *           configuration is inherited from its parents.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time the service was last updated. This could be due to an
     *           explicit user update or due to a side effect of another system change, such
     *           as billing subscription expiry.
     *     @type \Google\Protobuf\Struct $service_config
     *           Optional. Additional service-specific configuration. Not all services will
     *           utilize this field.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Securitycentermanagement\V1\SecurityCenterManagement::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of the service, in one of the following formats:
     * * `organizations/{organization}/locations/{location}/securityCenterServices/{service}`
     * * `folders/{folder}/locations/{location}/securityCenterServices/{service}`
     * * `projects/{project}/locations/{location}/securityCenterServices/{service}`
     * The following values are valid for `{service}`:
     * * `container-threat-detection`
     * * `event-threat-detection`
     * * `security-health-analytics`
     * * `vm-threat-detection`
     * * `web-security-scanner`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the service, in one of the following formats:
     * * `organizations/{organization}/locations/{location}/securityCenterServices/{service}`
     * * `folders/{folder}/locations/{location}/securityCenterServices/{service}`
     * * `projects/{project}/locations/{location}/securityCenterServices/{service}`
     * The following values are valid for `{service}`:
     * * `container-threat-detection`
     * * `event-threat-detection`
     * * `security-health-analytics`
     * * `vm-threat-detection`
     * * `web-security-scanner`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. The intended enablement state for the service at its level of the
     * resource hierarchy. A `DISABLED` state will override all module enablement
     * states to `DISABLED`.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SecurityCenterService.EnablementState intended_enablement_state = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getIntendedEnablementState()
    {
        return $this->intended_enablement_state;
    }

    /**
     * Optional. The intended enablement state for the service at its level of the
     * resource hierarchy. A `DISABLED` state will override all module enablement
     * states to `DISABLED`.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SecurityCenterService.EnablementState intended_enablement_state = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setIntendedEnablementState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenterManagement\V1\SecurityCenterService\EnablementState::class);
        $this->intended_enablement_state = $var;

        return $this;
    }

    /**
     * Output only. The effective enablement state for the service at its level of
     * the resource hierarchy. If the intended state is set to `INHERITED`, the
     * effective state will be inherited from the enablement state of an ancestor.
     * This state may differ from the intended enablement state due to billing
     * eligibility or onboarding status.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SecurityCenterService.EnablementState effective_enablement_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getEffectiveEnablementState()
    {
        return $this->effective_enablement_state;
    }

    /**
     * Output only. The effective enablement state for the service at its level of
     * the resource hierarchy. If the intended state is set to `INHERITED`, the
     * effective state will be inherited from the enablement state of an ancestor.
     * This state may differ from the intended enablement state due to billing
     * eligibility or onboarding status.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SecurityCenterService.EnablementState effective_enablement_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setEffectiveEnablementState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenterManagement\V1\SecurityCenterService\EnablementState::class);
        $this->effective_enablement_state = $var;

        return $this;
    }

    /**
     * Optional. The module configurations, including the enablement state for the
     * service's modules. The absence of a module in the map implies that its
     * configuration is inherited from its parents.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.securitycentermanagement.v1.SecurityCenterService.ModuleSettings> modules = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getModules()
    {
        return $this->modules;
    }

    /**
     * Optional. The module configurations, including the enablement state for the
     * service's modules. The absence of a module in the map implies that its
     * configuration is inherited from its parents.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.securitycentermanagement.v1.SecurityCenterService.ModuleSettings> modules = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setModules($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenterManagement\V1\SecurityCenterService\ModuleSettings::class);
        $this->modules = $arr;

        return $this;
    }

    /**
     * Output only. The time the service was last updated. This could be due to an
     * explicit user update or due to a side effect of another system change, such
     * as billing subscription expiry.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time the service was last updated. This could be due to an
     * explicit user update or due to a side effect of another system change, such
     * as billing subscription expiry.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. Additional service-specific configuration. Not all services will
     * utilize this field.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct service_config = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getServiceConfig()
    {
        return $this->service_config;
    }

    public function hasServiceConfig()
    {
        return isset($this->service_config);
    }

    public function clearServiceConfig()
    {
        unset($this->service_config);
    }

    /**
     * Optional. Additional service-specific configuration. Not all services will
     * utilize this field.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct service_config = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setServiceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->service_config = $var;

        return $this;
    }

}

