<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/run/v2/build.proto

namespace Google\Cloud\Run\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for submitting a Build.
 *
 * Generated from protobuf message <code>google.cloud.run.v2.SubmitBuildRequest</code>
 */
class SubmitBuildRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The project and location to build in. Location must be a region,
     * e.g., 'us-central1' or 'global' if the global builder is to be used.
     * Format:
     * `projects/{project}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $parent = '';
    /**
     * Required. Artifact Registry URI to store the built image.
     *
     * Generated from protobuf field <code>string image_uri = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $image_uri = '';
    /**
     * Optional. The service account to use for the build. If not set, the default
     * Cloud Build service account for the project will be used.
     *
     * Generated from protobuf field <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $service_account = '';
    /**
     * Optional. Name of the Cloud Build Custom Worker Pool that should be used to
     * build the function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     *
     * Generated from protobuf field <code>string worker_pool = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $worker_pool = '';
    /**
     * Optional. Additional tags to annotate the build.
     *
     * Generated from protobuf field <code>repeated string tags = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $tags;
    /**
     * Optional. The machine type from default pool to use for the build. If left
     * blank, cloudbuild will use a sensible default. Currently only E2_HIGHCPU_8
     * is supported. If worker_pool is set, this field will be ignored.
     *
     * Generated from protobuf field <code>string machine_type = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $machine_type = '';
    /**
     * Optional. The release track of the client that initiated the build request.
     *
     * Generated from protobuf field <code>.google.api.LaunchStage release_track = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $release_track = 0;
    /**
     * Optional. The client that initiated the build request.
     *
     * Generated from protobuf field <code>string client = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $client = '';
    protected $source;
    protected $build_type;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The project and location to build in. Location must be a region,
     *           e.g., 'us-central1' or 'global' if the global builder is to be used.
     *           Format:
     *           `projects/{project}/locations/{location}`
     *     @type \Google\Cloud\Run\V2\StorageSource $storage_source
     *           Required. Source for the build.
     *     @type string $image_uri
     *           Required. Artifact Registry URI to store the built image.
     *     @type \Google\Cloud\Run\V2\SubmitBuildRequest\BuildpacksBuild $buildpack_build
     *           Build the source using Buildpacks.
     *     @type \Google\Cloud\Run\V2\SubmitBuildRequest\DockerBuild $docker_build
     *           Build the source using Docker. This means the source has a Dockerfile.
     *     @type string $service_account
     *           Optional. The service account to use for the build. If not set, the default
     *           Cloud Build service account for the project will be used.
     *     @type string $worker_pool
     *           Optional. Name of the Cloud Build Custom Worker Pool that should be used to
     *           build the function. The format of this field is
     *           `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     *           `{project}` and `{region}` are the project id and region respectively where
     *           the worker pool is defined and `{workerPool}` is the short name of the
     *           worker pool.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $tags
     *           Optional. Additional tags to annotate the build.
     *     @type string $machine_type
     *           Optional. The machine type from default pool to use for the build. If left
     *           blank, cloudbuild will use a sensible default. Currently only E2_HIGHCPU_8
     *           is supported. If worker_pool is set, this field will be ignored.
     *     @type int $release_track
     *           Optional. The release track of the client that initiated the build request.
     *     @type string $client
     *           Optional. The client that initiated the build request.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Run\V2\Build::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The project and location to build in. Location must be a region,
     * e.g., 'us-central1' or 'global' if the global builder is to be used.
     * Format:
     * `projects/{project}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The project and location to build in. Location must be a region,
     * e.g., 'us-central1' or 'global' if the global builder is to be used.
     * Format:
     * `projects/{project}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. Source for the build.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.StorageSource storage_source = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Run\V2\StorageSource|null
     */
    public function getStorageSource()
    {
        return $this->readOneof(2);
    }

    public function hasStorageSource()
    {
        return $this->hasOneof(2);
    }

    /**
     * Required. Source for the build.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.StorageSource storage_source = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Run\V2\StorageSource $var
     * @return $this
     */
    public function setStorageSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\StorageSource::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Required. Artifact Registry URI to store the built image.
     *
     * Generated from protobuf field <code>string image_uri = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getImageUri()
    {
        return $this->image_uri;
    }

    /**
     * Required. Artifact Registry URI to store the built image.
     *
     * Generated from protobuf field <code>string image_uri = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setImageUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->image_uri = $var;

        return $this;
    }

    /**
     * Build the source using Buildpacks.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.SubmitBuildRequest.BuildpacksBuild buildpack_build = 4;</code>
     * @return \Google\Cloud\Run\V2\SubmitBuildRequest\BuildpacksBuild|null
     */
    public function getBuildpackBuild()
    {
        return $this->readOneof(4);
    }

    public function hasBuildpackBuild()
    {
        return $this->hasOneof(4);
    }

    /**
     * Build the source using Buildpacks.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.SubmitBuildRequest.BuildpacksBuild buildpack_build = 4;</code>
     * @param \Google\Cloud\Run\V2\SubmitBuildRequest\BuildpacksBuild $var
     * @return $this
     */
    public function setBuildpackBuild($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\SubmitBuildRequest\BuildpacksBuild::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Build the source using Docker. This means the source has a Dockerfile.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.SubmitBuildRequest.DockerBuild docker_build = 5;</code>
     * @return \Google\Cloud\Run\V2\SubmitBuildRequest\DockerBuild|null
     */
    public function getDockerBuild()
    {
        return $this->readOneof(5);
    }

    public function hasDockerBuild()
    {
        return $this->hasOneof(5);
    }

    /**
     * Build the source using Docker. This means the source has a Dockerfile.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.SubmitBuildRequest.DockerBuild docker_build = 5;</code>
     * @param \Google\Cloud\Run\V2\SubmitBuildRequest\DockerBuild $var
     * @return $this
     */
    public function setDockerBuild($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\SubmitBuildRequest\DockerBuild::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Optional. The service account to use for the build. If not set, the default
     * Cloud Build service account for the project will be used.
     *
     * Generated from protobuf field <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * Optional. The service account to use for the build. If not set, the default
     * Cloud Build service account for the project will be used.
     *
     * Generated from protobuf field <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account = $var;

        return $this;
    }

    /**
     * Optional. Name of the Cloud Build Custom Worker Pool that should be used to
     * build the function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     *
     * Generated from protobuf field <code>string worker_pool = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getWorkerPool()
    {
        return $this->worker_pool;
    }

    /**
     * Optional. Name of the Cloud Build Custom Worker Pool that should be used to
     * build the function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     *
     * Generated from protobuf field <code>string worker_pool = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setWorkerPool($var)
    {
        GPBUtil::checkString($var, True);
        $this->worker_pool = $var;

        return $this;
    }

    /**
     * Optional. Additional tags to annotate the build.
     *
     * Generated from protobuf field <code>repeated string tags = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTags()
    {
        return $this->tags;
    }

    /**
     * Optional. Additional tags to annotate the build.
     *
     * Generated from protobuf field <code>repeated string tags = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTags($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->tags = $arr;

        return $this;
    }

    /**
     * Optional. The machine type from default pool to use for the build. If left
     * blank, cloudbuild will use a sensible default. Currently only E2_HIGHCPU_8
     * is supported. If worker_pool is set, this field will be ignored.
     *
     * Generated from protobuf field <code>string machine_type = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getMachineType()
    {
        return $this->machine_type;
    }

    /**
     * Optional. The machine type from default pool to use for the build. If left
     * blank, cloudbuild will use a sensible default. Currently only E2_HIGHCPU_8
     * is supported. If worker_pool is set, this field will be ignored.
     *
     * Generated from protobuf field <code>string machine_type = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setMachineType($var)
    {
        GPBUtil::checkString($var, True);
        $this->machine_type = $var;

        return $this;
    }

    /**
     * Optional. The release track of the client that initiated the build request.
     *
     * Generated from protobuf field <code>.google.api.LaunchStage release_track = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getReleaseTrack()
    {
        return $this->release_track;
    }

    /**
     * Optional. The release track of the client that initiated the build request.
     *
     * Generated from protobuf field <code>.google.api.LaunchStage release_track = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setReleaseTrack($var)
    {
        GPBUtil::checkEnum($var, \Google\Api\LaunchStage::class);
        $this->release_track = $var;

        return $this;
    }

    /**
     * Optional. The client that initiated the build request.
     *
     * Generated from protobuf field <code>string client = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * Optional. The client that initiated the build request.
     *
     * Generated from protobuf field <code>string client = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setClient($var)
    {
        GPBUtil::checkString($var, True);
        $this->client = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getSource()
    {
        return $this->whichOneof("source");
    }

    /**
     * @return string
     */
    public function getBuildType()
    {
        return $this->whichOneof("build_type");
    }

}

