<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/oracledatabase/v1/db_system.proto

namespace Google\Cloud\OracleDatabase\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Details of the DbSystem (BaseDB) resource.
 * https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/DbSystem/
 *
 * Generated from protobuf message <code>google.cloud.oracledatabase.v1.DbSystem</code>
 */
class DbSystem extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the DbSystem resource in the following format:
     * projects/{project}/locations/{region}/dbSystems/{db_system}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Optional. The properties of the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemProperties properties = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $properties = null;
    /**
     * Optional. The GCP Oracle zone where Oracle DbSystem is hosted.
     * Example: us-east4-b-r2.
     * If not specified, the system will pick a zone based on availability.
     *
     * Generated from protobuf field <code>string gcp_oracle_zone = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $gcp_oracle_zone = '';
    /**
     * Optional. The labels or tags associated with the DbSystem.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Optional. The name of the OdbNetwork associated with the DbSystem.
     * Format: projects/{project}/locations/{location}/odbNetworks/{odb_network}
     * It is optional but if specified, this should match the parent ODBNetwork of
     * the OdbSubnet.
     *
     * Generated from protobuf field <code>string odb_network = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $odb_network = '';
    /**
     * Required. The name of the OdbSubnet associated with the DbSystem for IP
     * allocation. Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *
     * Generated from protobuf field <code>string odb_subnet = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $odb_subnet = '';
    /**
     * Output only. The ID of the subscription entitlement associated with the
     * DbSystem
     *
     * Generated from protobuf field <code>string entitlement_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $entitlement_id = '';
    /**
     * Required. The display name for the System db. The name does not have to
     * be unique within your project.
     *
     * Generated from protobuf field <code>string display_name = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Output only. The date and time that the DbSystem was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. HTTPS link to OCI resources exposed to Customer via UI
     * Interface.
     *
     * Generated from protobuf field <code>string oci_url = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $oci_url = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of the DbSystem resource in the following format:
     *           projects/{project}/locations/{region}/dbSystems/{db_system}
     *     @type \Google\Cloud\OracleDatabase\V1\DbSystemProperties $properties
     *           Optional. The properties of the DbSystem.
     *     @type string $gcp_oracle_zone
     *           Optional. The GCP Oracle zone where Oracle DbSystem is hosted.
     *           Example: us-east4-b-r2.
     *           If not specified, the system will pick a zone based on availability.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. The labels or tags associated with the DbSystem.
     *     @type string $odb_network
     *           Optional. The name of the OdbNetwork associated with the DbSystem.
     *           Format: projects/{project}/locations/{location}/odbNetworks/{odb_network}
     *           It is optional but if specified, this should match the parent ODBNetwork of
     *           the OdbSubnet.
     *     @type string $odb_subnet
     *           Required. The name of the OdbSubnet associated with the DbSystem for IP
     *           allocation. Format:
     *           projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *     @type string $entitlement_id
     *           Output only. The ID of the subscription entitlement associated with the
     *           DbSystem
     *     @type string $display_name
     *           Required. The display name for the System db. The name does not have to
     *           be unique within your project.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The date and time that the DbSystem was created.
     *     @type string $oci_url
     *           Output only. HTTPS link to OCI resources exposed to Customer via UI
     *           Interface.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Oracledatabase\V1\DbSystem::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of the DbSystem resource in the following format:
     * projects/{project}/locations/{region}/dbSystems/{db_system}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the DbSystem resource in the following format:
     * projects/{project}/locations/{region}/dbSystems/{db_system}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. The properties of the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemProperties properties = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\OracleDatabase\V1\DbSystemProperties|null
     */
    public function getProperties()
    {
        return $this->properties;
    }

    public function hasProperties()
    {
        return isset($this->properties);
    }

    public function clearProperties()
    {
        unset($this->properties);
    }

    /**
     * Optional. The properties of the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemProperties properties = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\OracleDatabase\V1\DbSystemProperties $var
     * @return $this
     */
    public function setProperties($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OracleDatabase\V1\DbSystemProperties::class);
        $this->properties = $var;

        return $this;
    }

    /**
     * Optional. The GCP Oracle zone where Oracle DbSystem is hosted.
     * Example: us-east4-b-r2.
     * If not specified, the system will pick a zone based on availability.
     *
     * Generated from protobuf field <code>string gcp_oracle_zone = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getGcpOracleZone()
    {
        return $this->gcp_oracle_zone;
    }

    /**
     * Optional. The GCP Oracle zone where Oracle DbSystem is hosted.
     * Example: us-east4-b-r2.
     * If not specified, the system will pick a zone based on availability.
     *
     * Generated from protobuf field <code>string gcp_oracle_zone = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setGcpOracleZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->gcp_oracle_zone = $var;

        return $this;
    }

    /**
     * Optional. The labels or tags associated with the DbSystem.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. The labels or tags associated with the DbSystem.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. The name of the OdbNetwork associated with the DbSystem.
     * Format: projects/{project}/locations/{location}/odbNetworks/{odb_network}
     * It is optional but if specified, this should match the parent ODBNetwork of
     * the OdbSubnet.
     *
     * Generated from protobuf field <code>string odb_network = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getOdbNetwork()
    {
        return $this->odb_network;
    }

    /**
     * Optional. The name of the OdbNetwork associated with the DbSystem.
     * Format: projects/{project}/locations/{location}/odbNetworks/{odb_network}
     * It is optional but if specified, this should match the parent ODBNetwork of
     * the OdbSubnet.
     *
     * Generated from protobuf field <code>string odb_network = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setOdbNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->odb_network = $var;

        return $this;
    }

    /**
     * Required. The name of the OdbSubnet associated with the DbSystem for IP
     * allocation. Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *
     * Generated from protobuf field <code>string odb_subnet = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getOdbSubnet()
    {
        return $this->odb_subnet;
    }

    /**
     * Required. The name of the OdbSubnet associated with the DbSystem for IP
     * allocation. Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *
     * Generated from protobuf field <code>string odb_subnet = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setOdbSubnet($var)
    {
        GPBUtil::checkString($var, True);
        $this->odb_subnet = $var;

        return $this;
    }

    /**
     * Output only. The ID of the subscription entitlement associated with the
     * DbSystem
     *
     * Generated from protobuf field <code>string entitlement_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEntitlementId()
    {
        return $this->entitlement_id;
    }

    /**
     * Output only. The ID of the subscription entitlement associated with the
     * DbSystem
     *
     * Generated from protobuf field <code>string entitlement_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEntitlementId($var)
    {
        GPBUtil::checkString($var, True);
        $this->entitlement_id = $var;

        return $this;
    }

    /**
     * Required. The display name for the System db. The name does not have to
     * be unique within your project.
     *
     * Generated from protobuf field <code>string display_name = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The display name for the System db. The name does not have to
     * be unique within your project.
     *
     * Generated from protobuf field <code>string display_name = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Output only. The date and time that the DbSystem was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The date and time that the DbSystem was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. HTTPS link to OCI resources exposed to Customer via UI
     * Interface.
     *
     * Generated from protobuf field <code>string oci_url = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getOciUrl()
    {
        return $this->oci_url;
    }

    /**
     * Output only. HTTPS link to OCI resources exposed to Customer via UI
     * Interface.
     *
     * Generated from protobuf field <code>string oci_url = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setOciUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->oci_url = $var;

        return $this;
    }

}

