<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkconnectivity/v1/internal_range.proto

namespace Google\Cloud\NetworkConnectivity\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The internal range resource for IPAM operations within a VPC network.
 * Used to represent a private address range along with behavioral
 * characteristics of that range (its usage and peering behavior).
 * Networking resources can link to this range if they are created
 * as belonging to it.
 *
 * Generated from protobuf message <code>google.cloud.networkconnectivity.v1.InternalRange</code>
 */
class InternalRange extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of an internal range.
     * Format:
     * projects/{project}/locations/{location}/internalRanges/{internal_range}
     * See: https://google.aip.dev/122#fields-representing-resource-names
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Time when the internal range was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    protected $create_time = null;
    /**
     * Time when the internal range was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3;</code>
     */
    protected $update_time = null;
    /**
     * User-defined labels.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * Optional. A description of this resource.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. The IP range that this internal range defines.
     * NOTE: IPv6 ranges are limited to usage=EXTERNAL_TO_VPC and
     * peering=FOR_SELF.
     * NOTE: For IPv6 Ranges this field is compulsory, i.e. the address range must
     * be specified explicitly.
     *
     * Generated from protobuf field <code>string ip_cidr_range = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $ip_cidr_range = '';
    /**
     * Immutable. The URL or resource ID of the network in which to reserve the
     * internal range. The network cannot be deleted if there are any reserved
     * internal ranges referring to it. Legacy networks are not supported. For
     * example:
     *   https://www.googleapis.com/compute/v1/projects/{project}/locations/global/networks/{network}
     *   projects/{project}/locations/global/networks/{network}
     *   {network}
     *
     * Generated from protobuf field <code>string network = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $network = '';
    /**
     * Optional. The type of usage set for this InternalRange.
     *
     * Generated from protobuf field <code>.google.cloud.networkconnectivity.v1.InternalRange.Usage usage = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $usage = 0;
    /**
     * Optional. The type of peering set for this internal range.
     *
     * Generated from protobuf field <code>.google.cloud.networkconnectivity.v1.InternalRange.Peering peering = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $peering = 0;
    /**
     * Optional. An alternate to ip_cidr_range. Can be set when trying to create
     * an IPv4 reservation that automatically finds a free range of the given
     * size. If both ip_cidr_range and prefix_length are set, there is an error if
     * the range sizes do not match. Can also be used during updates to change the
     * range size.
     * NOTE: For IPv6 this field only works if ip_cidr_range is set as well, and
     * both fields must match. In other words, with IPv6 this field only works as
     * a redundant parameter.
     *
     * Generated from protobuf field <code>int32 prefix_length = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $prefix_length = 0;
    /**
     * Optional. Can be set to narrow down or pick a different address space while
     * searching for a free range. If not set, defaults to the "10.0.0.0/8"
     * address space. This can be used to search in other rfc-1918 address
     * spaces like "172.16.0.0/12" and "192.168.0.0/16" or non-rfc-1918
     * address spaces used in the VPC.
     *
     * Generated from protobuf field <code>repeated string target_cidr_range = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $target_cidr_range;
    /**
     * Output only. The list of resources that refer to this internal range.
     * Resources that use the internal range for their range allocation
     * are referred to as users of the range. Other resources mark themselves
     * as users while doing so by creating a reference to this internal range.
     * Having a user, based on this reference, prevents deletion of the
     * internal range referred to. Can be empty.
     *
     * Generated from protobuf field <code>repeated string users = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $users;
    /**
     * Optional. Types of resources that are allowed to overlap with the current
     * internal range.
     *
     * Generated from protobuf field <code>repeated .google.cloud.networkconnectivity.v1.InternalRange.Overlap overlaps = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $overlaps;
    /**
     * Optional. Must be present if usage is set to FOR_MIGRATION.
     *
     * Generated from protobuf field <code>.google.cloud.networkconnectivity.v1.InternalRange.Migration migration = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $migration = null;
    /**
     * Optional. Immutable ranges cannot have their fields modified, except for
     * labels and description.
     *
     * Generated from protobuf field <code>bool immutable = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $immutable = false;
    /**
     * Optional. Range auto-allocation options, may be set only when
     * auto-allocation is selected by not setting ip_cidr_range (and setting
     * prefix_length).
     *
     * Generated from protobuf field <code>.google.cloud.networkconnectivity.v1.InternalRange.AllocationOptions allocation_options = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $allocation_options = null;
    /**
     * Optional. ExcludeCidrRanges flag. Specifies a set of CIDR blocks that
     * allows exclusion of particular CIDR ranges from the auto-allocation
     * process, without having to reserve these blocks
     *
     * Generated from protobuf field <code>repeated string exclude_cidr_ranges = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $exclude_cidr_ranges;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of an internal range.
     *           Format:
     *           projects/{project}/locations/{location}/internalRanges/{internal_range}
     *           See: https://google.aip.dev/122#fields-representing-resource-names
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Time when the internal range was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Time when the internal range was updated.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           User-defined labels.
     *     @type string $description
     *           Optional. A description of this resource.
     *     @type string $ip_cidr_range
     *           Optional. The IP range that this internal range defines.
     *           NOTE: IPv6 ranges are limited to usage=EXTERNAL_TO_VPC and
     *           peering=FOR_SELF.
     *           NOTE: For IPv6 Ranges this field is compulsory, i.e. the address range must
     *           be specified explicitly.
     *     @type string $network
     *           Immutable. The URL or resource ID of the network in which to reserve the
     *           internal range. The network cannot be deleted if there are any reserved
     *           internal ranges referring to it. Legacy networks are not supported. For
     *           example:
     *             https://www.googleapis.com/compute/v1/projects/{project}/locations/global/networks/{network}
     *             projects/{project}/locations/global/networks/{network}
     *             {network}
     *     @type int $usage
     *           Optional. The type of usage set for this InternalRange.
     *     @type int $peering
     *           Optional. The type of peering set for this internal range.
     *     @type int $prefix_length
     *           Optional. An alternate to ip_cidr_range. Can be set when trying to create
     *           an IPv4 reservation that automatically finds a free range of the given
     *           size. If both ip_cidr_range and prefix_length are set, there is an error if
     *           the range sizes do not match. Can also be used during updates to change the
     *           range size.
     *           NOTE: For IPv6 this field only works if ip_cidr_range is set as well, and
     *           both fields must match. In other words, with IPv6 this field only works as
     *           a redundant parameter.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $target_cidr_range
     *           Optional. Can be set to narrow down or pick a different address space while
     *           searching for a free range. If not set, defaults to the "10.0.0.0/8"
     *           address space. This can be used to search in other rfc-1918 address
     *           spaces like "172.16.0.0/12" and "192.168.0.0/16" or non-rfc-1918
     *           address spaces used in the VPC.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $users
     *           Output only. The list of resources that refer to this internal range.
     *           Resources that use the internal range for their range allocation
     *           are referred to as users of the range. Other resources mark themselves
     *           as users while doing so by creating a reference to this internal range.
     *           Having a user, based on this reference, prevents deletion of the
     *           internal range referred to. Can be empty.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $overlaps
     *           Optional. Types of resources that are allowed to overlap with the current
     *           internal range.
     *     @type \Google\Cloud\NetworkConnectivity\V1\InternalRange\Migration $migration
     *           Optional. Must be present if usage is set to FOR_MIGRATION.
     *     @type bool $immutable
     *           Optional. Immutable ranges cannot have their fields modified, except for
     *           labels and description.
     *     @type \Google\Cloud\NetworkConnectivity\V1\InternalRange\AllocationOptions $allocation_options
     *           Optional. Range auto-allocation options, may be set only when
     *           auto-allocation is selected by not setting ip_cidr_range (and setting
     *           prefix_length).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $exclude_cidr_ranges
     *           Optional. ExcludeCidrRanges flag. Specifies a set of CIDR blocks that
     *           allows exclusion of particular CIDR ranges from the auto-allocation
     *           process, without having to reserve these blocks
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkconnectivity\V1\InternalRange::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of an internal range.
     * Format:
     * projects/{project}/locations/{location}/internalRanges/{internal_range}
     * See: https://google.aip.dev/122#fields-representing-resource-names
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of an internal range.
     * Format:
     * projects/{project}/locations/{location}/internalRanges/{internal_range}
     * See: https://google.aip.dev/122#fields-representing-resource-names
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Time when the internal range was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Time when the internal range was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Time when the internal range was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Time when the internal range was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * User-defined labels.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * User-defined labels.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. A description of this resource.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. A description of this resource.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. The IP range that this internal range defines.
     * NOTE: IPv6 ranges are limited to usage=EXTERNAL_TO_VPC and
     * peering=FOR_SELF.
     * NOTE: For IPv6 Ranges this field is compulsory, i.e. the address range must
     * be specified explicitly.
     *
     * Generated from protobuf field <code>string ip_cidr_range = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getIpCidrRange()
    {
        return $this->ip_cidr_range;
    }

    /**
     * Optional. The IP range that this internal range defines.
     * NOTE: IPv6 ranges are limited to usage=EXTERNAL_TO_VPC and
     * peering=FOR_SELF.
     * NOTE: For IPv6 Ranges this field is compulsory, i.e. the address range must
     * be specified explicitly.
     *
     * Generated from protobuf field <code>string ip_cidr_range = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setIpCidrRange($var)
    {
        GPBUtil::checkString($var, True);
        $this->ip_cidr_range = $var;

        return $this;
    }

    /**
     * Immutable. The URL or resource ID of the network in which to reserve the
     * internal range. The network cannot be deleted if there are any reserved
     * internal ranges referring to it. Legacy networks are not supported. For
     * example:
     *   https://www.googleapis.com/compute/v1/projects/{project}/locations/global/networks/{network}
     *   projects/{project}/locations/global/networks/{network}
     *   {network}
     *
     * Generated from protobuf field <code>string network = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * Immutable. The URL or resource ID of the network in which to reserve the
     * internal range. The network cannot be deleted if there are any reserved
     * internal ranges referring to it. Legacy networks are not supported. For
     * example:
     *   https://www.googleapis.com/compute/v1/projects/{project}/locations/global/networks/{network}
     *   projects/{project}/locations/global/networks/{network}
     *   {network}
     *
     * Generated from protobuf field <code>string network = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * Optional. The type of usage set for this InternalRange.
     *
     * Generated from protobuf field <code>.google.cloud.networkconnectivity.v1.InternalRange.Usage usage = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getUsage()
    {
        return $this->usage;
    }

    /**
     * Optional. The type of usage set for this InternalRange.
     *
     * Generated from protobuf field <code>.google.cloud.networkconnectivity.v1.InternalRange.Usage usage = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setUsage($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkConnectivity\V1\InternalRange\Usage::class);
        $this->usage = $var;

        return $this;
    }

    /**
     * Optional. The type of peering set for this internal range.
     *
     * Generated from protobuf field <code>.google.cloud.networkconnectivity.v1.InternalRange.Peering peering = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPeering()
    {
        return $this->peering;
    }

    /**
     * Optional. The type of peering set for this internal range.
     *
     * Generated from protobuf field <code>.google.cloud.networkconnectivity.v1.InternalRange.Peering peering = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPeering($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkConnectivity\V1\InternalRange\Peering::class);
        $this->peering = $var;

        return $this;
    }

    /**
     * Optional. An alternate to ip_cidr_range. Can be set when trying to create
     * an IPv4 reservation that automatically finds a free range of the given
     * size. If both ip_cidr_range and prefix_length are set, there is an error if
     * the range sizes do not match. Can also be used during updates to change the
     * range size.
     * NOTE: For IPv6 this field only works if ip_cidr_range is set as well, and
     * both fields must match. In other words, with IPv6 this field only works as
     * a redundant parameter.
     *
     * Generated from protobuf field <code>int32 prefix_length = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPrefixLength()
    {
        return $this->prefix_length;
    }

    /**
     * Optional. An alternate to ip_cidr_range. Can be set when trying to create
     * an IPv4 reservation that automatically finds a free range of the given
     * size. If both ip_cidr_range and prefix_length are set, there is an error if
     * the range sizes do not match. Can also be used during updates to change the
     * range size.
     * NOTE: For IPv6 this field only works if ip_cidr_range is set as well, and
     * both fields must match. In other words, with IPv6 this field only works as
     * a redundant parameter.
     *
     * Generated from protobuf field <code>int32 prefix_length = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPrefixLength($var)
    {
        GPBUtil::checkInt32($var);
        $this->prefix_length = $var;

        return $this;
    }

    /**
     * Optional. Can be set to narrow down or pick a different address space while
     * searching for a free range. If not set, defaults to the "10.0.0.0/8"
     * address space. This can be used to search in other rfc-1918 address
     * spaces like "172.16.0.0/12" and "192.168.0.0/16" or non-rfc-1918
     * address spaces used in the VPC.
     *
     * Generated from protobuf field <code>repeated string target_cidr_range = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTargetCidrRange()
    {
        return $this->target_cidr_range;
    }

    /**
     * Optional. Can be set to narrow down or pick a different address space while
     * searching for a free range. If not set, defaults to the "10.0.0.0/8"
     * address space. This can be used to search in other rfc-1918 address
     * spaces like "172.16.0.0/12" and "192.168.0.0/16" or non-rfc-1918
     * address spaces used in the VPC.
     *
     * Generated from protobuf field <code>repeated string target_cidr_range = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTargetCidrRange($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->target_cidr_range = $arr;

        return $this;
    }

    /**
     * Output only. The list of resources that refer to this internal range.
     * Resources that use the internal range for their range allocation
     * are referred to as users of the range. Other resources mark themselves
     * as users while doing so by creating a reference to this internal range.
     * Having a user, based on this reference, prevents deletion of the
     * internal range referred to. Can be empty.
     *
     * Generated from protobuf field <code>repeated string users = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getUsers()
    {
        return $this->users;
    }

    /**
     * Output only. The list of resources that refer to this internal range.
     * Resources that use the internal range for their range allocation
     * are referred to as users of the range. Other resources mark themselves
     * as users while doing so by creating a reference to this internal range.
     * Having a user, based on this reference, prevents deletion of the
     * internal range referred to. Can be empty.
     *
     * Generated from protobuf field <code>repeated string users = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setUsers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->users = $arr;

        return $this;
    }

    /**
     * Optional. Types of resources that are allowed to overlap with the current
     * internal range.
     *
     * Generated from protobuf field <code>repeated .google.cloud.networkconnectivity.v1.InternalRange.Overlap overlaps = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getOverlaps()
    {
        return $this->overlaps;
    }

    /**
     * Optional. Types of resources that are allowed to overlap with the current
     * internal range.
     *
     * Generated from protobuf field <code>repeated .google.cloud.networkconnectivity.v1.InternalRange.Overlap overlaps = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setOverlaps($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\NetworkConnectivity\V1\InternalRange\Overlap::class);
        $this->overlaps = $arr;

        return $this;
    }

    /**
     * Optional. Must be present if usage is set to FOR_MIGRATION.
     *
     * Generated from protobuf field <code>.google.cloud.networkconnectivity.v1.InternalRange.Migration migration = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\NetworkConnectivity\V1\InternalRange\Migration|null
     */
    public function getMigration()
    {
        return $this->migration;
    }

    public function hasMigration()
    {
        return isset($this->migration);
    }

    public function clearMigration()
    {
        unset($this->migration);
    }

    /**
     * Optional. Must be present if usage is set to FOR_MIGRATION.
     *
     * Generated from protobuf field <code>.google.cloud.networkconnectivity.v1.InternalRange.Migration migration = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\NetworkConnectivity\V1\InternalRange\Migration $var
     * @return $this
     */
    public function setMigration($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\NetworkConnectivity\V1\InternalRange\Migration::class);
        $this->migration = $var;

        return $this;
    }

    /**
     * Optional. Immutable ranges cannot have their fields modified, except for
     * labels and description.
     *
     * Generated from protobuf field <code>bool immutable = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getImmutable()
    {
        return $this->immutable;
    }

    /**
     * Optional. Immutable ranges cannot have their fields modified, except for
     * labels and description.
     *
     * Generated from protobuf field <code>bool immutable = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setImmutable($var)
    {
        GPBUtil::checkBool($var);
        $this->immutable = $var;

        return $this;
    }

    /**
     * Optional. Range auto-allocation options, may be set only when
     * auto-allocation is selected by not setting ip_cidr_range (and setting
     * prefix_length).
     *
     * Generated from protobuf field <code>.google.cloud.networkconnectivity.v1.InternalRange.AllocationOptions allocation_options = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\NetworkConnectivity\V1\InternalRange\AllocationOptions|null
     */
    public function getAllocationOptions()
    {
        return $this->allocation_options;
    }

    public function hasAllocationOptions()
    {
        return isset($this->allocation_options);
    }

    public function clearAllocationOptions()
    {
        unset($this->allocation_options);
    }

    /**
     * Optional. Range auto-allocation options, may be set only when
     * auto-allocation is selected by not setting ip_cidr_range (and setting
     * prefix_length).
     *
     * Generated from protobuf field <code>.google.cloud.networkconnectivity.v1.InternalRange.AllocationOptions allocation_options = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\NetworkConnectivity\V1\InternalRange\AllocationOptions $var
     * @return $this
     */
    public function setAllocationOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\NetworkConnectivity\V1\InternalRange\AllocationOptions::class);
        $this->allocation_options = $var;

        return $this;
    }

    /**
     * Optional. ExcludeCidrRanges flag. Specifies a set of CIDR blocks that
     * allows exclusion of particular CIDR ranges from the auto-allocation
     * process, without having to reserve these blocks
     *
     * Generated from protobuf field <code>repeated string exclude_cidr_ranges = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExcludeCidrRanges()
    {
        return $this->exclude_cidr_ranges;
    }

    /**
     * Optional. ExcludeCidrRanges flag. Specifies a set of CIDR blocks that
     * allows exclusion of particular CIDR ranges from the auto-allocation
     * process, without having to reserve these blocks
     *
     * Generated from protobuf field <code>repeated string exclude_cidr_ranges = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExcludeCidrRanges($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->exclude_cidr_ranges = $arr;

        return $this;
    }

}

