<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/maps/routeoptimization/v1/route_optimization_service.proto

namespace Google\Maps\RouteOptimization\V1\Vehicle\LoadLimit;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Cost of moving one unit of load during a `Transition`.
 * For a given load, the cost is the sum of two parts:
 * - min(load, `load_threshold`) * `cost_per_unit_below_threshold`
 * - max(0, load - `load_threshold`) * `cost_per_unit_above_threshold`
 * With this cost, solutions prefer to deliver high demands first,
 * or equivalently pickup high demands last.
 * For example, if a vehicle has
 *     load_limit {
 *       key: "weight"
 *       value {
 *         cost_per_kilometer {
 *           load_threshold: 15
 *           cost_per_unit_below_threshold: 2.0
 *           cost_per_unit_above_threshold: 10.0
 *         }
 *       }
 *     }
 * and its route is start,pickup,pickup,delivery,delivery,end with
 * transitions:
 *     transition { vehicle_load['weight'] { amount: 0 }
 *                  travel_distance_meters: 1000.0 }
 *     transition { vehicle_load['weight'] { amount: 10 }
 *                  travel_distance_meters: 1000.0 }
 *     transition { vehicle_load['weight'] { amount: 20 }
 *                  travel_distance_meters: 1000.0 }
 *     transition { vehicle_load['weight'] { amount: 10 }
 *                  travel_distance_meters: 1000.0 }
 *     transition { vehicle_load['weight'] { amount: 0 }
 *                  travel_distance_meters: 1000.0 }
 * then the cost incurred by this `LoadCost` is
 * (cost_below * load_below * kilometers + cost_above * load_above * kms)
 * - transition 0: 0.0
 * - transition 1: 2.0 * 10 * 1.0 + 10.0 * 0 * 1.0 = 20.0
 * - transition 2: 2.0 * 15 * 1.0 + 10.0 * (20 - 15) * 1.0 = 80.0
 * - transition 3: 2.0 * 10 * 1.0 + 10.0 * 0 * 1.0 = 20.0
 * - transition 4: 0.0
 * So the `LoadCost` over the route is 120.0.
 * However, if the route is start,pickup,delivery,pickup,delivery,end
 * with transitions:
 *     transition { vehicle_load['weight'] { amount: 0 }
 *                  travel_distance_meters: 1000.0 }
 *     transition { vehicle_load['weight'] { amount: 10 }
 *                  travel_distance_meters: 1000.0 }
 *     transition { vehicle_load['weight'] { amount: 0 }
 *                  travel_distance_meters: 1000.0 }
 *     transition { vehicle_load['weight'] { amount: 10 }
 *                  travel_distance_meters: 1000.0 }
 *     transition { vehicle_load['weight'] { amount: 0 }
 *                  travel_distance_meters: 1000.0 }
 * then the cost incurred by this `LoadCost` is
 * - transition 0: 0.0
 * - transition 1: 2.0 * 10 * 1.0 + 10.0 * 0 * 1.0 = 20.0
 * - transition 2: 0.0
 * - transition 3: 2.0 * 10 * 1.0 + 10.0 * 0 * 1.0 = 20.0
 * - transition 4: 0.0
 * Here the `LoadCost` over the route is 40.0.
 * `LoadCost` makes solutions with heavy-loaded transitions more expensive.
 * Experimental: See
 * https://developers.google.com/maps/tt/route-optimization/experimental/load-cost/make-request
 * for more details.
 *
 * Generated from protobuf message <code>google.maps.routeoptimization.v1.Vehicle.LoadLimit.LoadCost</code>
 */
class LoadCost extends \Google\Protobuf\Internal\Message
{
    /**
     * Amount of load above which the cost of moving a unit of load changes
     * from cost_per_unit_below_threshold to cost_per_unit_above_threshold.
     * Must be >= 0.
     *
     * Generated from protobuf field <code>optional int64 load_threshold = 1;</code>
     */
    protected $load_threshold = null;
    /**
     * Cost of moving a unit of load, for each unit between 0 and threshold.
     * Must be a finite value, and >= 0.
     *
     * Generated from protobuf field <code>optional double cost_per_unit_below_threshold = 2;</code>
     */
    protected $cost_per_unit_below_threshold = null;
    /**
     * Cost of moving a unit of load, for each unit above threshold.
     * In the special case threshold = 0, this is a fixed cost per unit.
     * Must be a finite value, and >= 0.
     *
     * Generated from protobuf field <code>optional double cost_per_unit_above_threshold = 3;</code>
     */
    protected $cost_per_unit_above_threshold = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $load_threshold
     *           Amount of load above which the cost of moving a unit of load changes
     *           from cost_per_unit_below_threshold to cost_per_unit_above_threshold.
     *           Must be >= 0.
     *     @type float $cost_per_unit_below_threshold
     *           Cost of moving a unit of load, for each unit between 0 and threshold.
     *           Must be a finite value, and >= 0.
     *     @type float $cost_per_unit_above_threshold
     *           Cost of moving a unit of load, for each unit above threshold.
     *           In the special case threshold = 0, this is a fixed cost per unit.
     *           Must be a finite value, and >= 0.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Maps\Routeoptimization\V1\RouteOptimizationService::initOnce();
        parent::__construct($data);
    }

    /**
     * Amount of load above which the cost of moving a unit of load changes
     * from cost_per_unit_below_threshold to cost_per_unit_above_threshold.
     * Must be >= 0.
     *
     * Generated from protobuf field <code>optional int64 load_threshold = 1;</code>
     * @return int|string
     */
    public function getLoadThreshold()
    {
        return isset($this->load_threshold) ? $this->load_threshold : 0;
    }

    public function hasLoadThreshold()
    {
        return isset($this->load_threshold);
    }

    public function clearLoadThreshold()
    {
        unset($this->load_threshold);
    }

    /**
     * Amount of load above which the cost of moving a unit of load changes
     * from cost_per_unit_below_threshold to cost_per_unit_above_threshold.
     * Must be >= 0.
     *
     * Generated from protobuf field <code>optional int64 load_threshold = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setLoadThreshold($var)
    {
        GPBUtil::checkInt64($var);
        $this->load_threshold = $var;

        return $this;
    }

    /**
     * Cost of moving a unit of load, for each unit between 0 and threshold.
     * Must be a finite value, and >= 0.
     *
     * Generated from protobuf field <code>optional double cost_per_unit_below_threshold = 2;</code>
     * @return float
     */
    public function getCostPerUnitBelowThreshold()
    {
        return isset($this->cost_per_unit_below_threshold) ? $this->cost_per_unit_below_threshold : 0.0;
    }

    public function hasCostPerUnitBelowThreshold()
    {
        return isset($this->cost_per_unit_below_threshold);
    }

    public function clearCostPerUnitBelowThreshold()
    {
        unset($this->cost_per_unit_below_threshold);
    }

    /**
     * Cost of moving a unit of load, for each unit between 0 and threshold.
     * Must be a finite value, and >= 0.
     *
     * Generated from protobuf field <code>optional double cost_per_unit_below_threshold = 2;</code>
     * @param float $var
     * @return $this
     */
    public function setCostPerUnitBelowThreshold($var)
    {
        GPBUtil::checkDouble($var);
        $this->cost_per_unit_below_threshold = $var;

        return $this;
    }

    /**
     * Cost of moving a unit of load, for each unit above threshold.
     * In the special case threshold = 0, this is a fixed cost per unit.
     * Must be a finite value, and >= 0.
     *
     * Generated from protobuf field <code>optional double cost_per_unit_above_threshold = 3;</code>
     * @return float
     */
    public function getCostPerUnitAboveThreshold()
    {
        return isset($this->cost_per_unit_above_threshold) ? $this->cost_per_unit_above_threshold : 0.0;
    }

    public function hasCostPerUnitAboveThreshold()
    {
        return isset($this->cost_per_unit_above_threshold);
    }

    public function clearCostPerUnitAboveThreshold()
    {
        unset($this->cost_per_unit_above_threshold);
    }

    /**
     * Cost of moving a unit of load, for each unit above threshold.
     * In the special case threshold = 0, this is a fixed cost per unit.
     * Must be a finite value, and >= 0.
     *
     * Generated from protobuf field <code>optional double cost_per_unit_above_threshold = 3;</code>
     * @param float $var
     * @return $this
     */
    public function setCostPerUnitAboveThreshold($var)
    {
        GPBUtil::checkDouble($var);
        $this->cost_per_unit_above_threshold = $var;

        return $this;
    }

}


