<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/kms/v1/ekm_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Kms\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Kms\V1\CreateEkmConnectionRequest;
use Google\Cloud\Kms\V1\EkmConfig;
use Google\Cloud\Kms\V1\EkmConnection;
use Google\Cloud\Kms\V1\GetEkmConfigRequest;
use Google\Cloud\Kms\V1\GetEkmConnectionRequest;
use Google\Cloud\Kms\V1\ListEkmConnectionsRequest;
use Google\Cloud\Kms\V1\UpdateEkmConfigRequest;
use Google\Cloud\Kms\V1\UpdateEkmConnectionRequest;
use Google\Cloud\Kms\V1\VerifyConnectivityRequest;
use Google\Cloud\Kms\V1\VerifyConnectivityResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Google Cloud Key Management EKM Service
 *
 * Manages external cryptographic keys and operations using those keys.
 * Implements a REST model with the following objects:
 * * [EkmConnection][google.cloud.kms.v1.EkmConnection]
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<EkmConnection> createEkmConnectionAsync(CreateEkmConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EkmConfig> getEkmConfigAsync(GetEkmConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EkmConnection> getEkmConnectionAsync(GetEkmConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEkmConnectionsAsync(ListEkmConnectionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EkmConfig> updateEkmConfigAsync(UpdateEkmConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EkmConnection> updateEkmConnectionAsync(UpdateEkmConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<VerifyConnectivityResponse> verifyConnectivityAsync(VerifyConnectivityRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class EkmServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.kms.v1.EkmService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'cloudkms.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'cloudkms.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/cloudkms',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/ekm_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/ekm_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/ekm_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/ekm_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a ekm_config
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted ekm_config resource.
     */
    public static function ekmConfigName(string $project, string $location): string
    {
        return self::getPathTemplate('ekmConfig')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * ekm_connection resource.
     *
     * @param string $project
     * @param string $location
     * @param string $ekmConnection
     *
     * @return string The formatted ekm_connection resource.
     */
    public static function ekmConnectionName(string $project, string $location, string $ekmConnection): string
    {
        return self::getPathTemplate('ekmConnection')->render([
            'project' => $project,
            'location' => $location,
            'ekm_connection' => $ekmConnection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a service
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $namespace
     * @param string $service
     *
     * @return string The formatted service resource.
     */
    public static function serviceName(string $project, string $location, string $namespace, string $service): string
    {
        return self::getPathTemplate('service')->render([
            'project' => $project,
            'location' => $location,
            'namespace' => $namespace,
            'service' => $service,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - ekmConfig: projects/{project}/locations/{location}/ekmConfig
     * - ekmConnection: projects/{project}/locations/{location}/ekmConnections/{ekm_connection}
     * - location: projects/{project}/locations/{location}
     * - service: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'cloudkms.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Kms\V1\EkmServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new EkmServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new [EkmConnection][google.cloud.kms.v1.EkmConnection] in a given
     * Project and Location.
     *
     * The async variant is {@see EkmServiceClient::createEkmConnectionAsync()} .
     *
     * @example samples/V1/EkmServiceClient/create_ekm_connection.php
     *
     * @param CreateEkmConnectionRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EkmConnection
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEkmConnection(CreateEkmConnectionRequest $request, array $callOptions = []): EkmConnection
    {
        return $this->startApiCall('CreateEkmConnection', $request, $callOptions)->wait();
    }

    /**
     * Returns the [EkmConfig][google.cloud.kms.v1.EkmConfig] singleton resource
     * for a given project and location.
     *
     * The async variant is {@see EkmServiceClient::getEkmConfigAsync()} .
     *
     * @example samples/V1/EkmServiceClient/get_ekm_config.php
     *
     * @param GetEkmConfigRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EkmConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEkmConfig(GetEkmConfigRequest $request, array $callOptions = []): EkmConfig
    {
        return $this->startApiCall('GetEkmConfig', $request, $callOptions)->wait();
    }

    /**
     * Returns metadata for a given
     * [EkmConnection][google.cloud.kms.v1.EkmConnection].
     *
     * The async variant is {@see EkmServiceClient::getEkmConnectionAsync()} .
     *
     * @example samples/V1/EkmServiceClient/get_ekm_connection.php
     *
     * @param GetEkmConnectionRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EkmConnection
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEkmConnection(GetEkmConnectionRequest $request, array $callOptions = []): EkmConnection
    {
        return $this->startApiCall('GetEkmConnection', $request, $callOptions)->wait();
    }

    /**
     * Lists [EkmConnections][google.cloud.kms.v1.EkmConnection].
     *
     * The async variant is {@see EkmServiceClient::listEkmConnectionsAsync()} .
     *
     * @example samples/V1/EkmServiceClient/list_ekm_connections.php
     *
     * @param ListEkmConnectionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEkmConnections(ListEkmConnectionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEkmConnections', $request, $callOptions);
    }

    /**
     * Updates the [EkmConfig][google.cloud.kms.v1.EkmConfig] singleton resource
     * for a given project and location.
     *
     * The async variant is {@see EkmServiceClient::updateEkmConfigAsync()} .
     *
     * @example samples/V1/EkmServiceClient/update_ekm_config.php
     *
     * @param UpdateEkmConfigRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EkmConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateEkmConfig(UpdateEkmConfigRequest $request, array $callOptions = []): EkmConfig
    {
        return $this->startApiCall('UpdateEkmConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates an [EkmConnection][google.cloud.kms.v1.EkmConnection]'s metadata.
     *
     * The async variant is {@see EkmServiceClient::updateEkmConnectionAsync()} .
     *
     * @example samples/V1/EkmServiceClient/update_ekm_connection.php
     *
     * @param UpdateEkmConnectionRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EkmConnection
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateEkmConnection(UpdateEkmConnectionRequest $request, array $callOptions = []): EkmConnection
    {
        return $this->startApiCall('UpdateEkmConnection', $request, $callOptions)->wait();
    }

    /**
     * Verifies that Cloud KMS can successfully connect to the external key
     * manager specified by an [EkmConnection][google.cloud.kms.v1.EkmConnection].
     * If there is an error connecting to the EKM, this method returns a
     * FAILED_PRECONDITION status containing structured information as described
     * at https://cloud.google.com/kms/docs/reference/ekm_errors.
     *
     * The async variant is {@see EkmServiceClient::verifyConnectivityAsync()} .
     *
     * @example samples/V1/EkmServiceClient/verify_connectivity.php
     *
     * @param VerifyConnectivityRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return VerifyConnectivityResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function verifyConnectivity(
        VerifyConnectivityRequest $request,
        array $callOptions = []
    ): VerifyConnectivityResponse {
        return $this->startApiCall('VerifyConnectivity', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see EkmServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/EkmServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see EkmServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/EkmServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see EkmServiceClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/EkmServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see EkmServiceClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/EkmServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see EkmServiceClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/EkmServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
