<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/kms/v1/resources.proto

namespace Google\Cloud\Kms\V1;

use UnexpectedValueException;

/**
 * Describes the reason for a data access. Please refer to
 * https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
 * for the detailed semantic meaning of justification reason codes.
 *
 * Protobuf type <code>google.cloud.kms.v1.AccessReason</code>
 */
class AccessReason
{
    /**
     * Unspecified access reason.
     *
     * Generated from protobuf enum <code>REASON_UNSPECIFIED = 0;</code>
     */
    const REASON_UNSPECIFIED = 0;
    /**
     * Customer-initiated support.
     *
     * Generated from protobuf enum <code>CUSTOMER_INITIATED_SUPPORT = 1;</code>
     */
    const CUSTOMER_INITIATED_SUPPORT = 1;
    /**
     * Google-initiated access for system management and troubleshooting.
     *
     * Generated from protobuf enum <code>GOOGLE_INITIATED_SERVICE = 2;</code>
     */
    const GOOGLE_INITIATED_SERVICE = 2;
    /**
     * Google-initiated access in response to a legal request or legal process.
     *
     * Generated from protobuf enum <code>THIRD_PARTY_DATA_REQUEST = 3;</code>
     */
    const THIRD_PARTY_DATA_REQUEST = 3;
    /**
     * Google-initiated access for security, fraud, abuse, or compliance purposes.
     *
     * Generated from protobuf enum <code>GOOGLE_INITIATED_REVIEW = 4;</code>
     */
    const GOOGLE_INITIATED_REVIEW = 4;
    /**
     * Customer uses their account to perform any access to their own data which
     * their IAM policy authorizes.
     *
     * Generated from protobuf enum <code>CUSTOMER_INITIATED_ACCESS = 5;</code>
     */
    const CUSTOMER_INITIATED_ACCESS = 5;
    /**
     * Google systems access customer data to help optimize the structure of the
     * data or quality for future uses by the customer.
     *
     * Generated from protobuf enum <code>GOOGLE_INITIATED_SYSTEM_OPERATION = 6;</code>
     */
    const GOOGLE_INITIATED_SYSTEM_OPERATION = 6;
    /**
     * No reason is expected for this key request.
     *
     * Generated from protobuf enum <code>REASON_NOT_EXPECTED = 7;</code>
     */
    const REASON_NOT_EXPECTED = 7;
    /**
     * Deprecated: This code is no longer generated by Google Cloud. The
     * GOOGLE_RESPONSE_TO_PRODUCTION_ALERT justification codes available in both
     * Key Access Justifications and Access Transparency logs provide
     * customer-visible signals of emergency access in more precise contexts.
     * Customer uses their account to perform any access to their own data which
     * their IAM policy authorizes, and one of the following is true:
     * * A Google administrator has reset the root-access account associated with
     *   the user's organization within the past 7 days.
     * * A Google-initiated emergency access operation has interacted with a
     *   resource in the same project or folder as the currently accessed resource
     *   within the past 7 days.
     *
     * Generated from protobuf enum <code>MODIFIED_CUSTOMER_INITIATED_ACCESS = 8 [deprecated = true];</code>
     */
    const MODIFIED_CUSTOMER_INITIATED_ACCESS = 8;
    /**
     * Deprecated: This code is no longer generated by Google Cloud. The
     * GOOGLE_RESPONSE_TO_PRODUCTION_ALERT justification codes available in both
     * Key Access Justifications and Access Transparency logs provide
     * customer-visible signals of emergency access in more precise contexts.
     * Google systems access customer data to help optimize the structure of the
     * data or quality for future uses by the customer, and one of the following
     * is true:
     * * A Google administrator has reset the root-access account associated with
     *   the user's organization within the past 7 days.
     * * A Google-initiated emergency access operation has interacted with a
     *   resource in the same project or folder as the currently accessed resource
     *   within the past 7 days.
     *
     * Generated from protobuf enum <code>MODIFIED_GOOGLE_INITIATED_SYSTEM_OPERATION = 9 [deprecated = true];</code>
     */
    const MODIFIED_GOOGLE_INITIATED_SYSTEM_OPERATION = 9;
    /**
     * Google-initiated access to maintain system reliability.
     *
     * Generated from protobuf enum <code>GOOGLE_RESPONSE_TO_PRODUCTION_ALERT = 10;</code>
     */
    const GOOGLE_RESPONSE_TO_PRODUCTION_ALERT = 10;
    /**
     * One of the following operations is being executed while simultaneously
     * encountering an internal technical issue which prevented a more precise
     * justification code from being generated:
     * * Your account has been used to perform any access to your own data which
     *   your IAM policy authorizes.
     * * An automated Google system operates on encrypted customer data which your
     *   IAM policy authorizes.
     * * Customer-initiated Google support access.
     * * Google-initiated support access to protect system reliability.
     *
     * Generated from protobuf enum <code>CUSTOMER_AUTHORIZED_WORKFLOW_SERVICING = 11;</code>
     */
    const CUSTOMER_AUTHORIZED_WORKFLOW_SERVICING = 11;

    private static $valueToName = [
        self::REASON_UNSPECIFIED => 'REASON_UNSPECIFIED',
        self::CUSTOMER_INITIATED_SUPPORT => 'CUSTOMER_INITIATED_SUPPORT',
        self::GOOGLE_INITIATED_SERVICE => 'GOOGLE_INITIATED_SERVICE',
        self::THIRD_PARTY_DATA_REQUEST => 'THIRD_PARTY_DATA_REQUEST',
        self::GOOGLE_INITIATED_REVIEW => 'GOOGLE_INITIATED_REVIEW',
        self::CUSTOMER_INITIATED_ACCESS => 'CUSTOMER_INITIATED_ACCESS',
        self::GOOGLE_INITIATED_SYSTEM_OPERATION => 'GOOGLE_INITIATED_SYSTEM_OPERATION',
        self::REASON_NOT_EXPECTED => 'REASON_NOT_EXPECTED',
        self::MODIFIED_CUSTOMER_INITIATED_ACCESS => 'MODIFIED_CUSTOMER_INITIATED_ACCESS',
        self::MODIFIED_GOOGLE_INITIATED_SYSTEM_OPERATION => 'MODIFIED_GOOGLE_INITIATED_SYSTEM_OPERATION',
        self::GOOGLE_RESPONSE_TO_PRODUCTION_ALERT => 'GOOGLE_RESPONSE_TO_PRODUCTION_ALERT',
        self::CUSTOMER_AUTHORIZED_WORKFLOW_SERVICING => 'CUSTOMER_AUTHORIZED_WORKFLOW_SERVICING',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}

