<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/eventarc/v1/trigger.proto

namespace Google\Cloud\Eventarc\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A representation of the trigger resource.
 *
 * Generated from protobuf message <code>google.cloud.eventarc.v1.Trigger</code>
 */
class Trigger extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the trigger. Must be unique within the
     * location of the project and must be in
     * `projects/{project}/locations/{location}/triggers/{trigger}` format.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $name = '';
    /**
     * Output only. Server-assigned unique identifier for the trigger. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uid = '';
    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The last-modified time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Required. Unordered list. The list of filters that applies to event
     * attributes. Only events that match all the provided filters are sent to the
     * destination.
     *
     * Generated from protobuf field <code>repeated .google.cloud.eventarc.v1.EventFilter event_filters = 8 [(.google.api.field_behavior) = UNORDERED_LIST, (.google.api.field_behavior) = REQUIRED];</code>
     */
    private $event_filters;
    /**
     * Optional. The IAM service account email associated with the trigger. The
     * service account represents the identity of the trigger.
     * The `iam.serviceAccounts.actAs` permission must be granted on the service
     * account to allow a principal to impersonate the service account. For more
     * information, see the
     * [Roles and permissions](/eventarc/docs/all-roles-permissions) page specific
     * to the trigger destination.
     *
     * Generated from protobuf field <code>string service_account = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $service_account = '';
    /**
     * Required. Destination specifies where the events should be sent to.
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Destination destination = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $destination = null;
    /**
     * Optional. To deliver messages, Eventarc might use other Google Cloud
     * products as a transport intermediary. This field contains a reference to
     * that transport intermediary. This information can be used for debugging
     * purposes.
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Transport transport = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $transport = null;
    /**
     * Optional. User labels attached to the triggers that can be used to group
     * resources.
     *
     * Generated from protobuf field <code>map<string, string> labels = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Optional. The name of the channel associated with the trigger in
     * `projects/{project}/locations/{location}/channels/{channel}` format.
     * You must provide a channel to receive events from Eventarc SaaS partners.
     *
     * Generated from protobuf field <code>string channel = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $channel = '';
    /**
     * Output only. The reason(s) why a trigger is in FAILED state.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.eventarc.v1.StateCondition> conditions = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $conditions;
    /**
     * Optional. EventDataContentType specifies the type of payload in MIME
     * format that is expected from the CloudEvent data field. This is set to
     * `application/json` if the value is not defined.
     *
     * Generated from protobuf field <code>string event_data_content_type = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $event_data_content_type = '';
    /**
     * Output only. Whether or not this Trigger satisfies the requirements of
     * physical zone separation
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzs = false;
    /**
     * Optional. The retry policy to use in the Trigger.
     * If unset, event delivery will be retried for up to 24 hours by default:
     * https://cloud.google.com/eventarc/docs/retry-events
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Trigger.RetryPolicy retry_policy = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $retry_policy = null;
    /**
     * Output only. This checksum is computed by the server based on the value of
     * other fields, and might be sent only on create requests to ensure that the
     * client has an up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $etag = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. The resource name of the trigger. Must be unique within the
     *           location of the project and must be in
     *           `projects/{project}/locations/{location}/triggers/{trigger}` format.
     *     @type string $uid
     *           Output only. Server-assigned unique identifier for the trigger. The value
     *           is a UUID4 string and guaranteed to remain unchanged until the resource is
     *           deleted.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation time.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The last-modified time.
     *     @type array<\Google\Cloud\Eventarc\V1\EventFilter>|\Google\Protobuf\Internal\RepeatedField $event_filters
     *           Required. Unordered list. The list of filters that applies to event
     *           attributes. Only events that match all the provided filters are sent to the
     *           destination.
     *     @type string $service_account
     *           Optional. The IAM service account email associated with the trigger. The
     *           service account represents the identity of the trigger.
     *           The `iam.serviceAccounts.actAs` permission must be granted on the service
     *           account to allow a principal to impersonate the service account. For more
     *           information, see the
     *           [Roles and permissions](/eventarc/docs/all-roles-permissions) page specific
     *           to the trigger destination.
     *     @type \Google\Cloud\Eventarc\V1\Destination $destination
     *           Required. Destination specifies where the events should be sent to.
     *     @type \Google\Cloud\Eventarc\V1\Transport $transport
     *           Optional. To deliver messages, Eventarc might use other Google Cloud
     *           products as a transport intermediary. This field contains a reference to
     *           that transport intermediary. This information can be used for debugging
     *           purposes.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. User labels attached to the triggers that can be used to group
     *           resources.
     *     @type string $channel
     *           Optional. The name of the channel associated with the trigger in
     *           `projects/{project}/locations/{location}/channels/{channel}` format.
     *           You must provide a channel to receive events from Eventarc SaaS partners.
     *     @type array|\Google\Protobuf\Internal\MapField $conditions
     *           Output only. The reason(s) why a trigger is in FAILED state.
     *     @type string $event_data_content_type
     *           Optional. EventDataContentType specifies the type of payload in MIME
     *           format that is expected from the CloudEvent data field. This is set to
     *           `application/json` if the value is not defined.
     *     @type bool $satisfies_pzs
     *           Output only. Whether or not this Trigger satisfies the requirements of
     *           physical zone separation
     *     @type \Google\Cloud\Eventarc\V1\Trigger\RetryPolicy $retry_policy
     *           Optional. The retry policy to use in the Trigger.
     *           If unset, event delivery will be retried for up to 24 hours by default:
     *           https://cloud.google.com/eventarc/docs/retry-events
     *     @type string $etag
     *           Output only. This checksum is computed by the server based on the value of
     *           other fields, and might be sent only on create requests to ensure that the
     *           client has an up-to-date value before proceeding.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Eventarc\V1\Trigger::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the trigger. Must be unique within the
     * location of the project and must be in
     * `projects/{project}/locations/{location}/triggers/{trigger}` format.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The resource name of the trigger. Must be unique within the
     * location of the project and must be in
     * `projects/{project}/locations/{location}/triggers/{trigger}` format.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Server-assigned unique identifier for the trigger. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. Server-assigned unique identifier for the trigger. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The last-modified time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The last-modified time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Required. Unordered list. The list of filters that applies to event
     * attributes. Only events that match all the provided filters are sent to the
     * destination.
     *
     * Generated from protobuf field <code>repeated .google.cloud.eventarc.v1.EventFilter event_filters = 8 [(.google.api.field_behavior) = UNORDERED_LIST, (.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEventFilters()
    {
        return $this->event_filters;
    }

    /**
     * Required. Unordered list. The list of filters that applies to event
     * attributes. Only events that match all the provided filters are sent to the
     * destination.
     *
     * Generated from protobuf field <code>repeated .google.cloud.eventarc.v1.EventFilter event_filters = 8 [(.google.api.field_behavior) = UNORDERED_LIST, (.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\Eventarc\V1\EventFilter>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEventFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Eventarc\V1\EventFilter::class);
        $this->event_filters = $arr;

        return $this;
    }

    /**
     * Optional. The IAM service account email associated with the trigger. The
     * service account represents the identity of the trigger.
     * The `iam.serviceAccounts.actAs` permission must be granted on the service
     * account to allow a principal to impersonate the service account. For more
     * information, see the
     * [Roles and permissions](/eventarc/docs/all-roles-permissions) page specific
     * to the trigger destination.
     *
     * Generated from protobuf field <code>string service_account = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * Optional. The IAM service account email associated with the trigger. The
     * service account represents the identity of the trigger.
     * The `iam.serviceAccounts.actAs` permission must be granted on the service
     * account to allow a principal to impersonate the service account. For more
     * information, see the
     * [Roles and permissions](/eventarc/docs/all-roles-permissions) page specific
     * to the trigger destination.
     *
     * Generated from protobuf field <code>string service_account = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account = $var;

        return $this;
    }

    /**
     * Required. Destination specifies where the events should be sent to.
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Destination destination = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Eventarc\V1\Destination|null
     */
    public function getDestination()
    {
        return $this->destination;
    }

    public function hasDestination()
    {
        return isset($this->destination);
    }

    public function clearDestination()
    {
        unset($this->destination);
    }

    /**
     * Required. Destination specifies where the events should be sent to.
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Destination destination = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Eventarc\V1\Destination $var
     * @return $this
     */
    public function setDestination($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Eventarc\V1\Destination::class);
        $this->destination = $var;

        return $this;
    }

    /**
     * Optional. To deliver messages, Eventarc might use other Google Cloud
     * products as a transport intermediary. This field contains a reference to
     * that transport intermediary. This information can be used for debugging
     * purposes.
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Transport transport = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Eventarc\V1\Transport|null
     */
    public function getTransport()
    {
        return $this->transport;
    }

    public function hasTransport()
    {
        return isset($this->transport);
    }

    public function clearTransport()
    {
        unset($this->transport);
    }

    /**
     * Optional. To deliver messages, Eventarc might use other Google Cloud
     * products as a transport intermediary. This field contains a reference to
     * that transport intermediary. This information can be used for debugging
     * purposes.
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Transport transport = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Eventarc\V1\Transport $var
     * @return $this
     */
    public function setTransport($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Eventarc\V1\Transport::class);
        $this->transport = $var;

        return $this;
    }

    /**
     * Optional. User labels attached to the triggers that can be used to group
     * resources.
     *
     * Generated from protobuf field <code>map<string, string> labels = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. User labels attached to the triggers that can be used to group
     * resources.
     *
     * Generated from protobuf field <code>map<string, string> labels = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. The name of the channel associated with the trigger in
     * `projects/{project}/locations/{location}/channels/{channel}` format.
     * You must provide a channel to receive events from Eventarc SaaS partners.
     *
     * Generated from protobuf field <code>string channel = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getChannel()
    {
        return $this->channel;
    }

    /**
     * Optional. The name of the channel associated with the trigger in
     * `projects/{project}/locations/{location}/channels/{channel}` format.
     * You must provide a channel to receive events from Eventarc SaaS partners.
     *
     * Generated from protobuf field <code>string channel = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setChannel($var)
    {
        GPBUtil::checkString($var, True);
        $this->channel = $var;

        return $this;
    }

    /**
     * Output only. The reason(s) why a trigger is in FAILED state.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.eventarc.v1.StateCondition> conditions = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getConditions()
    {
        return $this->conditions;
    }

    /**
     * Output only. The reason(s) why a trigger is in FAILED state.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.eventarc.v1.StateCondition> conditions = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setConditions($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Eventarc\V1\StateCondition::class);
        $this->conditions = $arr;

        return $this;
    }

    /**
     * Optional. EventDataContentType specifies the type of payload in MIME
     * format that is expected from the CloudEvent data field. This is set to
     * `application/json` if the value is not defined.
     *
     * Generated from protobuf field <code>string event_data_content_type = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEventDataContentType()
    {
        return $this->event_data_content_type;
    }

    /**
     * Optional. EventDataContentType specifies the type of payload in MIME
     * format that is expected from the CloudEvent data field. This is set to
     * `application/json` if the value is not defined.
     *
     * Generated from protobuf field <code>string event_data_content_type = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEventDataContentType($var)
    {
        GPBUtil::checkString($var, True);
        $this->event_data_content_type = $var;

        return $this;
    }

    /**
     * Output only. Whether or not this Trigger satisfies the requirements of
     * physical zone separation
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return $this->satisfies_pzs;
    }

    /**
     * Output only. Whether or not this Trigger satisfies the requirements of
     * physical zone separation
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Optional. The retry policy to use in the Trigger.
     * If unset, event delivery will be retried for up to 24 hours by default:
     * https://cloud.google.com/eventarc/docs/retry-events
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Trigger.RetryPolicy retry_policy = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Eventarc\V1\Trigger\RetryPolicy|null
     */
    public function getRetryPolicy()
    {
        return $this->retry_policy;
    }

    public function hasRetryPolicy()
    {
        return isset($this->retry_policy);
    }

    public function clearRetryPolicy()
    {
        unset($this->retry_policy);
    }

    /**
     * Optional. The retry policy to use in the Trigger.
     * If unset, event delivery will be retried for up to 24 hours by default:
     * https://cloud.google.com/eventarc/docs/retry-events
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Trigger.RetryPolicy retry_policy = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Eventarc\V1\Trigger\RetryPolicy $var
     * @return $this
     */
    public function setRetryPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Eventarc\V1\Trigger\RetryPolicy::class);
        $this->retry_policy = $var;

        return $this;
    }

    /**
     * Output only. This checksum is computed by the server based on the value of
     * other fields, and might be sent only on create requests to ensure that the
     * client has an up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Output only. This checksum is computed by the server based on the value of
     * other fields, and might be sent only on create requests to ensure that the
     * client has an up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

}

