<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/discoveryengine/v1/data_store_service.proto

namespace Google\Cloud\DiscoveryEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request for
 * [DataStoreService.CreateDataStore][google.cloud.discoveryengine.v1.DataStoreService.CreateDataStore]
 * method.
 *
 * Generated from protobuf message <code>google.cloud.discoveryengine.v1.CreateDataStoreRequest</code>
 */
class CreateDataStoreRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
     * create.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.DataStore data_store = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $data_store = null;
    /**
     * Required. The ID to use for the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore], which will become
     * the final component of the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]'s resource name.
     * This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string data_store_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $data_store_id = '';
    /**
     * A boolean flag indicating whether user want to directly create an advanced
     * data store for site search.
     * If the data store is not configured as site
     * search (GENERIC vertical and PUBLIC_WEBSITE content_config), this flag will
     * be ignored.
     *
     * Generated from protobuf field <code>bool create_advanced_site_search = 4;</code>
     */
    protected $create_advanced_site_search = false;
    /**
     * A boolean flag indicating whether to skip the default schema creation for
     * the data store. Only enable this flag if you are certain that the default
     * schema is incompatible with your use case.
     * If set to true, you must manually create a schema for the data store before
     * any documents can be ingested.
     * This flag cannot be specified if `data_store.starting_schema` is specified.
     *
     * Generated from protobuf field <code>bool skip_default_schema_creation = 7;</code>
     */
    protected $skip_default_schema_creation = false;
    protected $cmek_options;

    /**
     * @param string                                     $parent      Required. The parent resource name, such as
     *                                                                `projects/{project}/locations/{location}/collections/{collection}`. Please see
     *                                                                {@see DataStoreServiceClient::collectionName()} for help formatting this field.
     * @param \Google\Cloud\DiscoveryEngine\V1\DataStore $dataStore   Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
     *                                                                create.
     * @param string                                     $dataStoreId Required. The ID to use for the
     *                                                                [DataStore][google.cloud.discoveryengine.v1.DataStore], which will become
     *                                                                the final component of the
     *                                                                [DataStore][google.cloud.discoveryengine.v1.DataStore]'s resource name.
     *
     *                                                                This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     *                                                                standard with a length limit of 63 characters. Otherwise, an
     *                                                                INVALID_ARGUMENT error is returned.
     *
     * @return \Google\Cloud\DiscoveryEngine\V1\CreateDataStoreRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\DiscoveryEngine\V1\DataStore $dataStore, string $dataStoreId): self
    {
        return (new self())
            ->setParent($parent)
            ->setDataStore($dataStore)
            ->setDataStoreId($dataStoreId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $cmek_config_name
     *           Resource name of the CmekConfig to use for protecting this DataStore.
     *     @type bool $disable_cmek
     *           DataStore without CMEK protections. If a default CmekConfig is set for
     *           the project, setting this field will override the default CmekConfig as
     *           well.
     *     @type string $parent
     *           Required. The parent resource name, such as
     *           `projects/{project}/locations/{location}/collections/{collection}`.
     *     @type \Google\Cloud\DiscoveryEngine\V1\DataStore $data_store
     *           Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
     *           create.
     *     @type string $data_store_id
     *           Required. The ID to use for the
     *           [DataStore][google.cloud.discoveryengine.v1.DataStore], which will become
     *           the final component of the
     *           [DataStore][google.cloud.discoveryengine.v1.DataStore]'s resource name.
     *           This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     *           standard with a length limit of 63 characters. Otherwise, an
     *           INVALID_ARGUMENT error is returned.
     *     @type bool $create_advanced_site_search
     *           A boolean flag indicating whether user want to directly create an advanced
     *           data store for site search.
     *           If the data store is not configured as site
     *           search (GENERIC vertical and PUBLIC_WEBSITE content_config), this flag will
     *           be ignored.
     *     @type bool $skip_default_schema_creation
     *           A boolean flag indicating whether to skip the default schema creation for
     *           the data store. Only enable this flag if you are certain that the default
     *           schema is incompatible with your use case.
     *           If set to true, you must manually create a schema for the data store before
     *           any documents can be ingested.
     *           This flag cannot be specified if `data_store.starting_schema` is specified.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Discoveryengine\V1\DataStoreService::initOnce();
        parent::__construct($data);
    }

    /**
     * Resource name of the CmekConfig to use for protecting this DataStore.
     *
     * Generated from protobuf field <code>string cmek_config_name = 5 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getCmekConfigName()
    {
        return $this->readOneof(5);
    }

    public function hasCmekConfigName()
    {
        return $this->hasOneof(5);
    }

    /**
     * Resource name of the CmekConfig to use for protecting this DataStore.
     *
     * Generated from protobuf field <code>string cmek_config_name = 5 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setCmekConfigName($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * DataStore without CMEK protections. If a default CmekConfig is set for
     * the project, setting this field will override the default CmekConfig as
     * well.
     *
     * Generated from protobuf field <code>bool disable_cmek = 6;</code>
     * @return bool
     */
    public function getDisableCmek()
    {
        return $this->readOneof(6);
    }

    public function hasDisableCmek()
    {
        return $this->hasOneof(6);
    }

    /**
     * DataStore without CMEK protections. If a default CmekConfig is set for
     * the project, setting this field will override the default CmekConfig as
     * well.
     *
     * Generated from protobuf field <code>bool disable_cmek = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisableCmek($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Required. The parent resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
     * create.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.DataStore data_store = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\DataStore|null
     */
    public function getDataStore()
    {
        return $this->data_store;
    }

    public function hasDataStore()
    {
        return isset($this->data_store);
    }

    public function clearDataStore()
    {
        unset($this->data_store);
    }

    /**
     * Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
     * create.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.DataStore data_store = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\DataStore $var
     * @return $this
     */
    public function setDataStore($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\DataStore::class);
        $this->data_store = $var;

        return $this;
    }

    /**
     * Required. The ID to use for the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore], which will become
     * the final component of the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]'s resource name.
     * This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string data_store_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDataStoreId()
    {
        return $this->data_store_id;
    }

    /**
     * Required. The ID to use for the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore], which will become
     * the final component of the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]'s resource name.
     * This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string data_store_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDataStoreId($var)
    {
        GPBUtil::checkString($var, True);
        $this->data_store_id = $var;

        return $this;
    }

    /**
     * A boolean flag indicating whether user want to directly create an advanced
     * data store for site search.
     * If the data store is not configured as site
     * search (GENERIC vertical and PUBLIC_WEBSITE content_config), this flag will
     * be ignored.
     *
     * Generated from protobuf field <code>bool create_advanced_site_search = 4;</code>
     * @return bool
     */
    public function getCreateAdvancedSiteSearch()
    {
        return $this->create_advanced_site_search;
    }

    /**
     * A boolean flag indicating whether user want to directly create an advanced
     * data store for site search.
     * If the data store is not configured as site
     * search (GENERIC vertical and PUBLIC_WEBSITE content_config), this flag will
     * be ignored.
     *
     * Generated from protobuf field <code>bool create_advanced_site_search = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setCreateAdvancedSiteSearch($var)
    {
        GPBUtil::checkBool($var);
        $this->create_advanced_site_search = $var;

        return $this;
    }

    /**
     * A boolean flag indicating whether to skip the default schema creation for
     * the data store. Only enable this flag if you are certain that the default
     * schema is incompatible with your use case.
     * If set to true, you must manually create a schema for the data store before
     * any documents can be ingested.
     * This flag cannot be specified if `data_store.starting_schema` is specified.
     *
     * Generated from protobuf field <code>bool skip_default_schema_creation = 7;</code>
     * @return bool
     */
    public function getSkipDefaultSchemaCreation()
    {
        return $this->skip_default_schema_creation;
    }

    /**
     * A boolean flag indicating whether to skip the default schema creation for
     * the data store. Only enable this flag if you are certain that the default
     * schema is incompatible with your use case.
     * If set to true, you must manually create a schema for the data store before
     * any documents can be ingested.
     * This flag cannot be specified if `data_store.starting_schema` is specified.
     *
     * Generated from protobuf field <code>bool skip_default_schema_creation = 7;</code>
     * @param bool $var
     * @return $this
     */
    public function setSkipDefaultSchemaCreation($var)
    {
        GPBUtil::checkBool($var);
        $this->skip_default_schema_creation = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getCmekOptions()
    {
        return $this->whichOneof("cmek_options");
    }

}

