<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/response_message.proto

namespace Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\MixedAudio;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents one segment of audio.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.ResponseMessage.MixedAudio.Segment</code>
 */
class Segment extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Whether the playback of this segment can be interrupted by
     * the end user's speech and the client should then start the next
     * Dialogflow request.
     *
     * Generated from protobuf field <code>bool allow_playback_interruption = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $allow_playback_interruption = false;
    protected $content;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $audio
     *           Raw audio synthesized from the Dialogflow agent's response using
     *           the output config specified in the request.
     *     @type string $uri
     *           Client-specific URI that points to an audio clip accessible to the
     *           client. Dialogflow does not impose any validation on it.
     *     @type bool $allow_playback_interruption
     *           Output only. Whether the playback of this segment can be interrupted by
     *           the end user's speech and the client should then start the next
     *           Dialogflow request.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\ResponseMessage::initOnce();
        parent::__construct($data);
    }

    /**
     * Raw audio synthesized from the Dialogflow agent's response using
     * the output config specified in the request.
     *
     * Generated from protobuf field <code>bytes audio = 1;</code>
     * @return string
     */
    public function getAudio()
    {
        return $this->readOneof(1);
    }

    public function hasAudio()
    {
        return $this->hasOneof(1);
    }

    /**
     * Raw audio synthesized from the Dialogflow agent's response using
     * the output config specified in the request.
     *
     * Generated from protobuf field <code>bytes audio = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setAudio($var)
    {
        GPBUtil::checkString($var, False);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Client-specific URI that points to an audio clip accessible to the
     * client. Dialogflow does not impose any validation on it.
     *
     * Generated from protobuf field <code>string uri = 2;</code>
     * @return string
     */
    public function getUri()
    {
        return $this->readOneof(2);
    }

    public function hasUri()
    {
        return $this->hasOneof(2);
    }

    /**
     * Client-specific URI that points to an audio clip accessible to the
     * client. Dialogflow does not impose any validation on it.
     *
     * Generated from protobuf field <code>string uri = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Output only. Whether the playback of this segment can be interrupted by
     * the end user's speech and the client should then start the next
     * Dialogflow request.
     *
     * Generated from protobuf field <code>bool allow_playback_interruption = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getAllowPlaybackInterruption()
    {
        return $this->allow_playback_interruption;
    }

    /**
     * Output only. Whether the playback of this segment can be interrupted by
     * the end user's speech and the client should then start the next
     * Dialogflow request.
     *
     * Generated from protobuf field <code>bool allow_playback_interruption = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowPlaybackInterruption($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_playback_interruption = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getContent()
    {
        return $this->whichOneof("content");
    }

}


