<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for the Lustre CSI driver.
 *
 * Generated from protobuf message <code>google.container.v1.LustreCsiDriverConfig</code>
 */
class LustreCsiDriverConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Whether the Lustre CSI driver is enabled for this cluster.
     *
     * Generated from protobuf field <code>bool enabled = 1;</code>
     */
    protected $enabled = false;
    /**
     * If set to true, the Lustre CSI driver will install Lustre kernel modules
     * using port 6988.
     * This serves as a workaround for a port conflict with the
     * gke-metadata-server. This field is required ONLY under the following
     * conditions:
     * 1. The GKE node version is older than 1.33.2-gke.4655000.
     * 2. You're connecting to a Lustre instance that has the
     * 'gke-support-enabled' flag.
     * Deprecated: This flag is no longer required as of GKE node version
     * 1.33.2-gke.4655000, unless you are connecting to a Lustre instance
     * that has the `gke-support-enabled` flag.
     *
     * Generated from protobuf field <code>bool enable_legacy_lustre_port = 3 [deprecated = true];</code>
     * @deprecated
     */
    protected $enable_legacy_lustre_port = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $enabled
     *           Whether the Lustre CSI driver is enabled for this cluster.
     *     @type bool $enable_legacy_lustre_port
     *           If set to true, the Lustre CSI driver will install Lustre kernel modules
     *           using port 6988.
     *           This serves as a workaround for a port conflict with the
     *           gke-metadata-server. This field is required ONLY under the following
     *           conditions:
     *           1. The GKE node version is older than 1.33.2-gke.4655000.
     *           2. You're connecting to a Lustre instance that has the
     *           'gke-support-enabled' flag.
     *           Deprecated: This flag is no longer required as of GKE node version
     *           1.33.2-gke.4655000, unless you are connecting to a Lustre instance
     *           that has the `gke-support-enabled` flag.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * Whether the Lustre CSI driver is enabled for this cluster.
     *
     * Generated from protobuf field <code>bool enabled = 1;</code>
     * @return bool
     */
    public function getEnabled()
    {
        return $this->enabled;
    }

    /**
     * Whether the Lustre CSI driver is enabled for this cluster.
     *
     * Generated from protobuf field <code>bool enabled = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->enabled = $var;

        return $this;
    }

    /**
     * If set to true, the Lustre CSI driver will install Lustre kernel modules
     * using port 6988.
     * This serves as a workaround for a port conflict with the
     * gke-metadata-server. This field is required ONLY under the following
     * conditions:
     * 1. The GKE node version is older than 1.33.2-gke.4655000.
     * 2. You're connecting to a Lustre instance that has the
     * 'gke-support-enabled' flag.
     * Deprecated: This flag is no longer required as of GKE node version
     * 1.33.2-gke.4655000, unless you are connecting to a Lustre instance
     * that has the `gke-support-enabled` flag.
     *
     * Generated from protobuf field <code>bool enable_legacy_lustre_port = 3 [deprecated = true];</code>
     * @return bool
     * @deprecated
     */
    public function getEnableLegacyLustrePort()
    {
        if ($this->enable_legacy_lustre_port !== false) {
            @trigger_error('enable_legacy_lustre_port is deprecated.', E_USER_DEPRECATED);
        }
        return $this->enable_legacy_lustre_port;
    }

    /**
     * If set to true, the Lustre CSI driver will install Lustre kernel modules
     * using port 6988.
     * This serves as a workaround for a port conflict with the
     * gke-metadata-server. This field is required ONLY under the following
     * conditions:
     * 1. The GKE node version is older than 1.33.2-gke.4655000.
     * 2. You're connecting to a Lustre instance that has the
     * 'gke-support-enabled' flag.
     * Deprecated: This flag is no longer required as of GKE node version
     * 1.33.2-gke.4655000, unless you are connecting to a Lustre instance
     * that has the `gke-support-enabled` flag.
     *
     * Generated from protobuf field <code>bool enable_legacy_lustre_port = 3 [deprecated = true];</code>
     * @param bool $var
     * @return $this
     * @deprecated
     */
    public function setEnableLegacyLustrePort($var)
    {
        @trigger_error('enable_legacy_lustre_port is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkBool($var);
        $this->enable_legacy_lustre_port = $var;

        return $this;
    }

}

