<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/channel/v1/products.proto

namespace Google\Cloud\Channel\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a product's purchasable Stock Keeping Unit (SKU).
 * SKUs represent the different variations of the product. For example, Google
 * Workspace Business Standard and Google Workspace Business Plus are Google
 * Workspace product SKUs.
 *
 * Generated from protobuf message <code>google.cloud.channel.v1.Sku</code>
 */
class Sku extends \Google\Protobuf\Internal\Message
{
    /**
     * Resource Name of the SKU.
     * Format: products/{product_id}/skus/{sku_id}
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Marketing information for the SKU.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.MarketingInfo marketing_info = 2;</code>
     */
    protected $marketing_info = null;
    /**
     * Product the SKU is associated with.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.Product product = 3;</code>
     */
    protected $product = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Resource Name of the SKU.
     *           Format: products/{product_id}/skus/{sku_id}
     *     @type \Google\Cloud\Channel\V1\MarketingInfo $marketing_info
     *           Marketing information for the SKU.
     *     @type \Google\Cloud\Channel\V1\Product $product
     *           Product the SKU is associated with.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Channel\V1\Products::initOnce();
        parent::__construct($data);
    }

    /**
     * Resource Name of the SKU.
     * Format: products/{product_id}/skus/{sku_id}
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Resource Name of the SKU.
     * Format: products/{product_id}/skus/{sku_id}
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Marketing information for the SKU.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.MarketingInfo marketing_info = 2;</code>
     * @return \Google\Cloud\Channel\V1\MarketingInfo|null
     */
    public function getMarketingInfo()
    {
        return $this->marketing_info;
    }

    public function hasMarketingInfo()
    {
        return isset($this->marketing_info);
    }

    public function clearMarketingInfo()
    {
        unset($this->marketing_info);
    }

    /**
     * Marketing information for the SKU.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.MarketingInfo marketing_info = 2;</code>
     * @param \Google\Cloud\Channel\V1\MarketingInfo $var
     * @return $this
     */
    public function setMarketingInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Channel\V1\MarketingInfo::class);
        $this->marketing_info = $var;

        return $this;
    }

    /**
     * Product the SKU is associated with.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.Product product = 3;</code>
     * @return \Google\Cloud\Channel\V1\Product|null
     */
    public function getProduct()
    {
        return $this->product;
    }

    public function hasProduct()
    {
        return isset($this->product);
    }

    public function clearProduct()
    {
        unset($this->product);
    }

    /**
     * Product the SKU is associated with.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.Product product = 3;</code>
     * @param \Google\Cloud\Channel\V1\Product $var
     * @return $this
     */
    public function setProduct($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Channel\V1\Product::class);
        $this->product = $var;

        return $this;
    }

}

