<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/asset/v1/assets.proto

namespace Google\Cloud\Asset\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A result of Resource Search, containing information of a cloud resource.
 *
 * Generated from protobuf message <code>google.cloud.asset.v1.ResourceSearchResult</code>
 */
class ResourceSearchResult extends \Google\Protobuf\Internal\Message
{
    /**
     * The full resource name of this resource. Example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     * See [Cloud Asset Inventory Resource Name
     * Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
     * for more information.
     * To search against the `name`:
     * * Use a field query. Example: `name:instance1`
     * * Use a free text query. Example: `instance1`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * The type of this resource. Example: `compute.googleapis.com/Disk`.
     * To search against the `asset_type`:
     * * Specify the `asset_type` field in your search request.
     *
     * Generated from protobuf field <code>string asset_type = 2;</code>
     */
    protected $asset_type = '';
    /**
     * The project that this resource belongs to, in the form of
     * projects/{PROJECT_NUMBER}. This field is available when the resource
     * belongs to a project.
     * To search against `project`:
     * * Use a field query. Example: `project:12345`
     * * Use a free text query. Example: `12345`
     * * Specify the `scope` field as this project in your search request.
     *
     * Generated from protobuf field <code>string project = 3;</code>
     */
    protected $project = '';
    /**
     * The folder(s) that this resource belongs to, in the form of
     * folders/{FOLDER_NUMBER}. This field is available when the resource
     * belongs to one or more folders.
     * To search against `folders`:
     * * Use a field query. Example: `folders:(123 OR 456)`
     * * Use a free text query. Example: `123`
     * * Specify the `scope` field as this folder in your search request.
     *
     * Generated from protobuf field <code>repeated string folders = 17;</code>
     */
    private $folders;
    /**
     * The organization that this resource belongs to, in the form of
     * organizations/{ORGANIZATION_NUMBER}. This field is available when the
     * resource belongs to an organization.
     * To search against `organization`:
     * * Use a field query. Example: `organization:123`
     * * Use a free text query. Example: `123`
     * * Specify the `scope` field as this organization in your search request.
     *
     * Generated from protobuf field <code>string organization = 18;</code>
     */
    protected $organization = '';
    /**
     * The display name of this resource. This field is available only when the
     * resource's Protobuf contains it.
     * To search against the `display_name`:
     * * Use a field query. Example: `displayName:"My Instance"`
     * * Use a free text query. Example: `"My Instance"`
     *
     * Generated from protobuf field <code>string display_name = 4;</code>
     */
    protected $display_name = '';
    /**
     * One or more paragraphs of text description of this resource. Maximum length
     * could be up to 1M bytes. This field is available only when the resource's
     * Protobuf contains it.
     * To search against the `description`:
     * * Use a field query. Example: `description:"important instance"`
     * * Use a free text query. Example: `"important instance"`
     *
     * Generated from protobuf field <code>string description = 5;</code>
     */
    protected $description = '';
    /**
     * Location can be `global`, regional like `us-east1`, or zonal like
     * `us-west1-b`. This field is available only when the resource's Protobuf
     * contains it.
     * To search against the `location`:
     * * Use a field query. Example: `location:us-west*`
     * * Use a free text query. Example: `us-west*`
     *
     * Generated from protobuf field <code>string location = 6;</code>
     */
    protected $location = '';
    /**
     * User labels associated with this resource. See [Labelling and grouping
     * Google Cloud
     * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information. This field is available only when the resource's
     * Protobuf contains it.
     * To search against the `labels`:
     * * Use a field query:
     *     - query on any label's key or value. Example: `labels:prod`
     *     - query by a given label. Example: `labels.env:prod`
     *     - query by a given label's existence. Example: `labels.env:*`
     * * Use a free text query. Example: `prod`
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     */
    private $labels;
    /**
     * Network tags associated with this resource. Like labels, network tags are a
     * type of annotations used to group Google Cloud resources. See [Labelling
     * Google Cloud
     * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information. This field is available only when the resource's
     * Protobuf contains it.
     * To search against the `network_tags`:
     * * Use a field query. Example: `networkTags:internal`
     * * Use a free text query. Example: `internal`
     *
     * Generated from protobuf field <code>repeated string network_tags = 8;</code>
     */
    private $network_tags;
    /**
     * The Cloud KMS
     * [CryptoKey](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys)
     * name or
     * [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions)
     * name.
     * This field only presents for the purpose of backward compatibility.
     * Use the `kms_keys` field to retrieve Cloud KMS key information. This field
     * is available only when the resource's Protobuf contains it and will only be
     * populated for [these resource
     * types](https://cloud.google.com/asset-inventory/docs/legacy-field-names#resource_types_with_the_to_be_deprecated_kmskey_field)
     * for backward compatible purposes.
     * To search against the `kms_key`:
     * * Use a field query. Example: `kmsKey:key`
     * * Use a free text query. Example: `key`
     *
     * Generated from protobuf field <code>string kms_key = 10 [deprecated = true];</code>
     * @deprecated
     */
    protected $kms_key = '';
    /**
     * The Cloud KMS
     * [CryptoKey](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys)
     * names or
     * [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions)
     * names. This field is available only when the resource's Protobuf contains
     * it.
     * To search against the `kms_keys`:
     * * Use a field query. Example: `kmsKeys:key`
     * * Use a free text query. Example: `key`
     *
     * Generated from protobuf field <code>repeated string kms_keys = 28;</code>
     */
    private $kms_keys;
    /**
     * The create timestamp of this resource, at which the resource was created.
     * The granularity is in seconds. Timestamp.nanos will always be 0. This field
     * is available only when the resource's Protobuf contains it.
     * To search against `create_time`:
     * * Use a field query.
     *     - value in seconds since unix epoch. Example: `createTime > 1609459200`
     *     - value in date string. Example: `createTime > 2021-01-01`
     *     - value in date-time string (must be quoted). Example: `createTime >
     *     "2021-01-01T00:00:00"`
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    protected $create_time = null;
    /**
     * The last update timestamp of this resource, at which the resource was last
     * modified or deleted. The granularity is in seconds. Timestamp.nanos will
     * always be 0. This field is available only when the resource's Protobuf
     * contains it.
     * To search against `update_time`:
     * * Use a field query.
     *     - value in seconds since unix epoch. Example: `updateTime < 1609459200`
     *     - value in date string. Example: `updateTime < 2021-01-01`
     *     - value in date-time string (must be quoted). Example: `updateTime <
     *     "2021-01-01T00:00:00"`
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 12;</code>
     */
    protected $update_time = null;
    /**
     * The state of this resource. Different resources types have different state
     * definitions that are mapped from various fields of different resource
     * types. This field is available only when the resource's Protobuf contains
     * it.
     * Example:
     * If the resource is an instance provided by Compute Engine,
     * its state will include PROVISIONING, STAGING, RUNNING, STOPPING,
     * SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. See `status` definition
     * in [API
     * Reference](https://cloud.google.com/compute/docs/reference/rest/v1/instances).
     * If the resource is a project provided by Resource Manager, its state
     * will include LIFECYCLE_STATE_UNSPECIFIED, ACTIVE, DELETE_REQUESTED and
     * DELETE_IN_PROGRESS. See `lifecycleState` definition in [API
     * Reference](https://cloud.google.com/resource-manager/reference/rest/v1/projects).
     * To search against the `state`:
     * * Use a field query. Example: `state:RUNNING`
     * * Use a free text query. Example: `RUNNING`
     *
     * Generated from protobuf field <code>string state = 13;</code>
     */
    protected $state = '';
    /**
     * The additional searchable attributes of this resource. The attributes may
     * vary from one resource type to another. Examples: `projectId` for Project,
     * `dnsName` for DNS ManagedZone. This field contains a subset of the resource
     * metadata fields that are returned by the List or Get APIs provided by the
     * corresponding Google Cloud service (e.g., Compute Engine). see [API
     * references and supported searchable
     * attributes](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
     * to see which fields are included.
     * You can search values of these fields through free text search. However,
     * you should not consume the field programically as the field names and
     * values may change as the Google Cloud service updates to a new incompatible
     * API version.
     * To search against the `additional_attributes`:
     * * Use a free text query to match the attributes values. Example: to search
     *   `additional_attributes = { dnsName: "foobar" }`, you can issue a query
     *   `foobar`.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct additional_attributes = 9;</code>
     */
    protected $additional_attributes = null;
    /**
     * The full resource name of this resource's parent, if it has one.
     * To search against the `parent_full_resource_name`:
     * * Use a field query. Example:
     * `parentFullResourceName:"project-name"`
     * * Use a free text query. Example:
     * `project-name`
     *
     * Generated from protobuf field <code>string parent_full_resource_name = 19;</code>
     */
    protected $parent_full_resource_name = '';
    /**
     * Versioned resource representations of this resource. This is repeated
     * because there could be multiple versions of resource representations during
     * version migration.
     * This `versioned_resources` field is not searchable. Some attributes of the
     * resource representations are exposed in `additional_attributes` field, so
     * as to allow users to search on them.
     *
     * Generated from protobuf field <code>repeated .google.cloud.asset.v1.VersionedResource versioned_resources = 16;</code>
     */
    private $versioned_resources;
    /**
     * Attached resources of this resource. For example, an OSConfig
     * Inventory is an attached resource of a Compute Instance. This field is
     * repeated because a resource could have multiple attached resources.
     * This `attached_resources` field is not searchable. Some attributes
     * of the attached resources are exposed in `additional_attributes` field, so
     * as to allow users to search on them.
     *
     * Generated from protobuf field <code>repeated .google.cloud.asset.v1.AttachedResource attached_resources = 20;</code>
     */
    private $attached_resources;
    /**
     * A map of related resources of this resource, keyed by the
     * relationship type. A relationship type is in the format of
     * {SourceType}_{ACTION}_{DestType}. Example: `DISK_TO_INSTANCE`,
     * `DISK_TO_NETWORK`, `INSTANCE_TO_INSTANCEGROUP`.
     * See [supported relationship
     * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#supported_relationship_types).
     *
     * Generated from protobuf field <code>map<string, .google.cloud.asset.v1.RelatedResources> relationships = 21;</code>
     */
    private $relationships;
    /**
     * This field is only present for the purpose of backward compatibility.
     * Use the `tags` field instead.
     * TagKey namespaced names, in the format of {ORG_ID}/{TAG_KEY_SHORT_NAME}.
     * To search against the `tagKeys`:
     * * Use a field query. Example:
     *     - `tagKeys:"123456789/env*"`
     *     - `tagKeys="123456789/env"`
     *     - `tagKeys:"env"`
     * * Use a free text query. Example:
     *     - `env`
     *
     * Generated from protobuf field <code>repeated string tag_keys = 23 [deprecated = true];</code>
     * @deprecated
     */
    private $tag_keys;
    /**
     * This field is only present for the purpose of backward compatibility.
     * Use the `tags` field instead.
     * TagValue namespaced names, in the format of
     * {ORG_ID}/{TAG_KEY_SHORT_NAME}/{TAG_VALUE_SHORT_NAME}.
     * To search against the `tagValues`:
     * * Use a field query. Example:
     *     - `tagValues:"env"`
     *     - `tagValues:"env/prod"`
     *     - `tagValues:"123456789/env/prod*"`
     *     - `tagValues="123456789/env/prod"`
     * * Use a free text query. Example:
     *     - `prod`
     *
     * Generated from protobuf field <code>repeated string tag_values = 25 [deprecated = true];</code>
     * @deprecated
     */
    private $tag_values;
    /**
     * This field is only present for the purpose of backward compatibility.
     * Use the `tags` field instead.
     * TagValue IDs, in the format of tagValues/{TAG_VALUE_ID}.
     * To search against the `tagValueIds`:
     * * Use a field query. Example:
     *     - `tagValueIds="tagValues/456"`
     * * Use a free text query. Example:
     *     - `456`
     *
     * Generated from protobuf field <code>repeated string tag_value_ids = 26 [deprecated = true];</code>
     * @deprecated
     */
    private $tag_value_ids;
    /**
     * The tags directly attached to this resource.
     * To search against the `tags`:
     * * Use a field query. Example:
     *     - `tagKeys:"123456789/env*"`
     *     - `tagKeys="123456789/env"`
     *     - `tagKeys:"env"`
     *     - `tagKeyIds="tagKeys/123"`
     *     - `tagValues:"env"`
     *     - `tagValues:"env/prod"`
     *     - `tagValues:"123456789/env/prod*"`
     *     - `tagValues="123456789/env/prod"`
     *     - `tagValueIds="tagValues/456"`
     * * Use a free text query. Example:
     *     - `env/prod`
     *
     * Generated from protobuf field <code>repeated .google.cloud.asset.v1.Tag tags = 29;</code>
     */
    private $tags;
    /**
     * The effective tags on this resource. All of the tags that are both attached
     * to and inherited by a resource are collectively called the effective
     * tags. For more information, see [tag
     * inheritance](https://cloud.google.com/resource-manager/docs/tags/tags-overview#inheritance).
     * To search against the `effective_tags`:
     * * Use a field query. Example:
     *     - `effectiveTagKeys:"123456789/env*"`
     *     - `effectiveTagKeys="123456789/env"`
     *     - `effectiveTagKeys:"env"`
     *     - `effectiveTagKeyIds="tagKeys/123"`
     *     - `effectiveTagValues:"env"`
     *     - `effectiveTagValues:"env/prod"`
     *     - `effectiveTagValues:"123456789/env/prod*"`
     *     - `effectiveTagValues="123456789/env/prod"`
     *     - `effectiveTagValueIds="tagValues/456"`
     *
     * Generated from protobuf field <code>repeated .google.cloud.asset.v1.EffectiveTagDetails effective_tags = 30;</code>
     */
    private $effective_tags;
    /**
     * Enrichments of the asset. Currently supported enrichment types with
     * SearchAllResources API:
     * * RESOURCE_OWNERS
     * The corresponding read masks in order to get the enrichment:
     * * enrichments.resource_owners
     * The corresponding required permissions:
     * * cloudasset.assets.searchEnrichmentResourceOwners
     * Example query to get resource owner enrichment:
     * ```
     *   scope: "projects/my-project"
     *   query: "name: my-project"
     *   assetTypes: "cloudresourcemanager.googleapis.com/Project"
     *   readMask: {
     *      paths: "asset_type"
     *      paths: "name"
     *      paths: "enrichments.resource_owners"
     *   }
     * ```
     *
     * Generated from protobuf field <code>repeated .google.cloud.asset.v1.AssetEnrichment enrichments = 31;</code>
     */
    private $enrichments;
    /**
     * The type of this resource's immediate parent, if there is one.
     * To search against the `parent_asset_type`:
     * * Use a field query. Example:
     * `parentAssetType:"cloudresourcemanager.googleapis.com/Project"`
     * * Use a free text query. Example:
     * `cloudresourcemanager.googleapis.com/Project`
     *
     * Generated from protobuf field <code>string parent_asset_type = 103;</code>
     */
    protected $parent_asset_type = '';
    /**
     * The actual content of Security Command Center security marks associated
     * with the asset.
     * To search against SCC SecurityMarks field:
     *   * Use a field query:
     *     - query by a given key value pair. Example: `sccSecurityMarks.foo=bar`
     *     - query by a given key's existence. Example: `sccSecurityMarks.foo:*`
     *
     * Generated from protobuf field <code>map<string, string> scc_security_marks = 32;</code>
     */
    private $scc_security_marks;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The full resource name of this resource. Example:
     *           `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     *           See [Cloud Asset Inventory Resource Name
     *           Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
     *           for more information.
     *           To search against the `name`:
     *           * Use a field query. Example: `name:instance1`
     *           * Use a free text query. Example: `instance1`
     *     @type string $asset_type
     *           The type of this resource. Example: `compute.googleapis.com/Disk`.
     *           To search against the `asset_type`:
     *           * Specify the `asset_type` field in your search request.
     *     @type string $project
     *           The project that this resource belongs to, in the form of
     *           projects/{PROJECT_NUMBER}. This field is available when the resource
     *           belongs to a project.
     *           To search against `project`:
     *           * Use a field query. Example: `project:12345`
     *           * Use a free text query. Example: `12345`
     *           * Specify the `scope` field as this project in your search request.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $folders
     *           The folder(s) that this resource belongs to, in the form of
     *           folders/{FOLDER_NUMBER}. This field is available when the resource
     *           belongs to one or more folders.
     *           To search against `folders`:
     *           * Use a field query. Example: `folders:(123 OR 456)`
     *           * Use a free text query. Example: `123`
     *           * Specify the `scope` field as this folder in your search request.
     *     @type string $organization
     *           The organization that this resource belongs to, in the form of
     *           organizations/{ORGANIZATION_NUMBER}. This field is available when the
     *           resource belongs to an organization.
     *           To search against `organization`:
     *           * Use a field query. Example: `organization:123`
     *           * Use a free text query. Example: `123`
     *           * Specify the `scope` field as this organization in your search request.
     *     @type string $display_name
     *           The display name of this resource. This field is available only when the
     *           resource's Protobuf contains it.
     *           To search against the `display_name`:
     *           * Use a field query. Example: `displayName:"My Instance"`
     *           * Use a free text query. Example: `"My Instance"`
     *     @type string $description
     *           One or more paragraphs of text description of this resource. Maximum length
     *           could be up to 1M bytes. This field is available only when the resource's
     *           Protobuf contains it.
     *           To search against the `description`:
     *           * Use a field query. Example: `description:"important instance"`
     *           * Use a free text query. Example: `"important instance"`
     *     @type string $location
     *           Location can be `global`, regional like `us-east1`, or zonal like
     *           `us-west1-b`. This field is available only when the resource's Protobuf
     *           contains it.
     *           To search against the `location`:
     *           * Use a field query. Example: `location:us-west*`
     *           * Use a free text query. Example: `us-west*`
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           User labels associated with this resource. See [Labelling and grouping
     *           Google Cloud
     *           resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     *           for more information. This field is available only when the resource's
     *           Protobuf contains it.
     *           To search against the `labels`:
     *           * Use a field query:
     *               - query on any label's key or value. Example: `labels:prod`
     *               - query by a given label. Example: `labels.env:prod`
     *               - query by a given label's existence. Example: `labels.env:*`
     *           * Use a free text query. Example: `prod`
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $network_tags
     *           Network tags associated with this resource. Like labels, network tags are a
     *           type of annotations used to group Google Cloud resources. See [Labelling
     *           Google Cloud
     *           resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     *           for more information. This field is available only when the resource's
     *           Protobuf contains it.
     *           To search against the `network_tags`:
     *           * Use a field query. Example: `networkTags:internal`
     *           * Use a free text query. Example: `internal`
     *     @type string $kms_key
     *           The Cloud KMS
     *           [CryptoKey](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys)
     *           name or
     *           [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions)
     *           name.
     *           This field only presents for the purpose of backward compatibility.
     *           Use the `kms_keys` field to retrieve Cloud KMS key information. This field
     *           is available only when the resource's Protobuf contains it and will only be
     *           populated for [these resource
     *           types](https://cloud.google.com/asset-inventory/docs/legacy-field-names#resource_types_with_the_to_be_deprecated_kmskey_field)
     *           for backward compatible purposes.
     *           To search against the `kms_key`:
     *           * Use a field query. Example: `kmsKey:key`
     *           * Use a free text query. Example: `key`
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $kms_keys
     *           The Cloud KMS
     *           [CryptoKey](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys)
     *           names or
     *           [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions)
     *           names. This field is available only when the resource's Protobuf contains
     *           it.
     *           To search against the `kms_keys`:
     *           * Use a field query. Example: `kmsKeys:key`
     *           * Use a free text query. Example: `key`
     *     @type \Google\Protobuf\Timestamp $create_time
     *           The create timestamp of this resource, at which the resource was created.
     *           The granularity is in seconds. Timestamp.nanos will always be 0. This field
     *           is available only when the resource's Protobuf contains it.
     *           To search against `create_time`:
     *           * Use a field query.
     *               - value in seconds since unix epoch. Example: `createTime > 1609459200`
     *               - value in date string. Example: `createTime > 2021-01-01`
     *               - value in date-time string (must be quoted). Example: `createTime >
     *               "2021-01-01T00:00:00"`
     *     @type \Google\Protobuf\Timestamp $update_time
     *           The last update timestamp of this resource, at which the resource was last
     *           modified or deleted. The granularity is in seconds. Timestamp.nanos will
     *           always be 0. This field is available only when the resource's Protobuf
     *           contains it.
     *           To search against `update_time`:
     *           * Use a field query.
     *               - value in seconds since unix epoch. Example: `updateTime < 1609459200`
     *               - value in date string. Example: `updateTime < 2021-01-01`
     *               - value in date-time string (must be quoted). Example: `updateTime <
     *               "2021-01-01T00:00:00"`
     *     @type string $state
     *           The state of this resource. Different resources types have different state
     *           definitions that are mapped from various fields of different resource
     *           types. This field is available only when the resource's Protobuf contains
     *           it.
     *           Example:
     *           If the resource is an instance provided by Compute Engine,
     *           its state will include PROVISIONING, STAGING, RUNNING, STOPPING,
     *           SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. See `status` definition
     *           in [API
     *           Reference](https://cloud.google.com/compute/docs/reference/rest/v1/instances).
     *           If the resource is a project provided by Resource Manager, its state
     *           will include LIFECYCLE_STATE_UNSPECIFIED, ACTIVE, DELETE_REQUESTED and
     *           DELETE_IN_PROGRESS. See `lifecycleState` definition in [API
     *           Reference](https://cloud.google.com/resource-manager/reference/rest/v1/projects).
     *           To search against the `state`:
     *           * Use a field query. Example: `state:RUNNING`
     *           * Use a free text query. Example: `RUNNING`
     *     @type \Google\Protobuf\Struct $additional_attributes
     *           The additional searchable attributes of this resource. The attributes may
     *           vary from one resource type to another. Examples: `projectId` for Project,
     *           `dnsName` for DNS ManagedZone. This field contains a subset of the resource
     *           metadata fields that are returned by the List or Get APIs provided by the
     *           corresponding Google Cloud service (e.g., Compute Engine). see [API
     *           references and supported searchable
     *           attributes](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
     *           to see which fields are included.
     *           You can search values of these fields through free text search. However,
     *           you should not consume the field programically as the field names and
     *           values may change as the Google Cloud service updates to a new incompatible
     *           API version.
     *           To search against the `additional_attributes`:
     *           * Use a free text query to match the attributes values. Example: to search
     *             `additional_attributes = { dnsName: "foobar" }`, you can issue a query
     *             `foobar`.
     *     @type string $parent_full_resource_name
     *           The full resource name of this resource's parent, if it has one.
     *           To search against the `parent_full_resource_name`:
     *           * Use a field query. Example:
     *           `parentFullResourceName:"project-name"`
     *           * Use a free text query. Example:
     *           `project-name`
     *     @type array<\Google\Cloud\Asset\V1\VersionedResource>|\Google\Protobuf\Internal\RepeatedField $versioned_resources
     *           Versioned resource representations of this resource. This is repeated
     *           because there could be multiple versions of resource representations during
     *           version migration.
     *           This `versioned_resources` field is not searchable. Some attributes of the
     *           resource representations are exposed in `additional_attributes` field, so
     *           as to allow users to search on them.
     *     @type array<\Google\Cloud\Asset\V1\AttachedResource>|\Google\Protobuf\Internal\RepeatedField $attached_resources
     *           Attached resources of this resource. For example, an OSConfig
     *           Inventory is an attached resource of a Compute Instance. This field is
     *           repeated because a resource could have multiple attached resources.
     *           This `attached_resources` field is not searchable. Some attributes
     *           of the attached resources are exposed in `additional_attributes` field, so
     *           as to allow users to search on them.
     *     @type array|\Google\Protobuf\Internal\MapField $relationships
     *           A map of related resources of this resource, keyed by the
     *           relationship type. A relationship type is in the format of
     *           {SourceType}_{ACTION}_{DestType}. Example: `DISK_TO_INSTANCE`,
     *           `DISK_TO_NETWORK`, `INSTANCE_TO_INSTANCEGROUP`.
     *           See [supported relationship
     *           types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#supported_relationship_types).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $tag_keys
     *           This field is only present for the purpose of backward compatibility.
     *           Use the `tags` field instead.
     *           TagKey namespaced names, in the format of {ORG_ID}/{TAG_KEY_SHORT_NAME}.
     *           To search against the `tagKeys`:
     *           * Use a field query. Example:
     *               - `tagKeys:"123456789/env*"`
     *               - `tagKeys="123456789/env"`
     *               - `tagKeys:"env"`
     *           * Use a free text query. Example:
     *               - `env`
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $tag_values
     *           This field is only present for the purpose of backward compatibility.
     *           Use the `tags` field instead.
     *           TagValue namespaced names, in the format of
     *           {ORG_ID}/{TAG_KEY_SHORT_NAME}/{TAG_VALUE_SHORT_NAME}.
     *           To search against the `tagValues`:
     *           * Use a field query. Example:
     *               - `tagValues:"env"`
     *               - `tagValues:"env/prod"`
     *               - `tagValues:"123456789/env/prod*"`
     *               - `tagValues="123456789/env/prod"`
     *           * Use a free text query. Example:
     *               - `prod`
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $tag_value_ids
     *           This field is only present for the purpose of backward compatibility.
     *           Use the `tags` field instead.
     *           TagValue IDs, in the format of tagValues/{TAG_VALUE_ID}.
     *           To search against the `tagValueIds`:
     *           * Use a field query. Example:
     *               - `tagValueIds="tagValues/456"`
     *           * Use a free text query. Example:
     *               - `456`
     *     @type array<\Google\Cloud\Asset\V1\Tag>|\Google\Protobuf\Internal\RepeatedField $tags
     *           The tags directly attached to this resource.
     *           To search against the `tags`:
     *           * Use a field query. Example:
     *               - `tagKeys:"123456789/env*"`
     *               - `tagKeys="123456789/env"`
     *               - `tagKeys:"env"`
     *               - `tagKeyIds="tagKeys/123"`
     *               - `tagValues:"env"`
     *               - `tagValues:"env/prod"`
     *               - `tagValues:"123456789/env/prod*"`
     *               - `tagValues="123456789/env/prod"`
     *               - `tagValueIds="tagValues/456"`
     *           * Use a free text query. Example:
     *               - `env/prod`
     *     @type array<\Google\Cloud\Asset\V1\EffectiveTagDetails>|\Google\Protobuf\Internal\RepeatedField $effective_tags
     *           The effective tags on this resource. All of the tags that are both attached
     *           to and inherited by a resource are collectively called the effective
     *           tags. For more information, see [tag
     *           inheritance](https://cloud.google.com/resource-manager/docs/tags/tags-overview#inheritance).
     *           To search against the `effective_tags`:
     *           * Use a field query. Example:
     *               - `effectiveTagKeys:"123456789/env*"`
     *               - `effectiveTagKeys="123456789/env"`
     *               - `effectiveTagKeys:"env"`
     *               - `effectiveTagKeyIds="tagKeys/123"`
     *               - `effectiveTagValues:"env"`
     *               - `effectiveTagValues:"env/prod"`
     *               - `effectiveTagValues:"123456789/env/prod*"`
     *               - `effectiveTagValues="123456789/env/prod"`
     *               - `effectiveTagValueIds="tagValues/456"`
     *     @type array<\Google\Cloud\Asset\V1\AssetEnrichment>|\Google\Protobuf\Internal\RepeatedField $enrichments
     *           Enrichments of the asset. Currently supported enrichment types with
     *           SearchAllResources API:
     *           * RESOURCE_OWNERS
     *           The corresponding read masks in order to get the enrichment:
     *           * enrichments.resource_owners
     *           The corresponding required permissions:
     *           * cloudasset.assets.searchEnrichmentResourceOwners
     *           Example query to get resource owner enrichment:
     *           ```
     *             scope: "projects/my-project"
     *             query: "name: my-project"
     *             assetTypes: "cloudresourcemanager.googleapis.com/Project"
     *             readMask: {
     *                paths: "asset_type"
     *                paths: "name"
     *                paths: "enrichments.resource_owners"
     *             }
     *           ```
     *     @type string $parent_asset_type
     *           The type of this resource's immediate parent, if there is one.
     *           To search against the `parent_asset_type`:
     *           * Use a field query. Example:
     *           `parentAssetType:"cloudresourcemanager.googleapis.com/Project"`
     *           * Use a free text query. Example:
     *           `cloudresourcemanager.googleapis.com/Project`
     *     @type array|\Google\Protobuf\Internal\MapField $scc_security_marks
     *           The actual content of Security Command Center security marks associated
     *           with the asset.
     *           To search against SCC SecurityMarks field:
     *             * Use a field query:
     *               - query by a given key value pair. Example: `sccSecurityMarks.foo=bar`
     *               - query by a given key's existence. Example: `sccSecurityMarks.foo:*`
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Asset\V1\Assets::initOnce();
        parent::__construct($data);
    }

    /**
     * The full resource name of this resource. Example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     * See [Cloud Asset Inventory Resource Name
     * Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
     * for more information.
     * To search against the `name`:
     * * Use a field query. Example: `name:instance1`
     * * Use a free text query. Example: `instance1`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The full resource name of this resource. Example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     * See [Cloud Asset Inventory Resource Name
     * Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
     * for more information.
     * To search against the `name`:
     * * Use a field query. Example: `name:instance1`
     * * Use a free text query. Example: `instance1`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The type of this resource. Example: `compute.googleapis.com/Disk`.
     * To search against the `asset_type`:
     * * Specify the `asset_type` field in your search request.
     *
     * Generated from protobuf field <code>string asset_type = 2;</code>
     * @return string
     */
    public function getAssetType()
    {
        return $this->asset_type;
    }

    /**
     * The type of this resource. Example: `compute.googleapis.com/Disk`.
     * To search against the `asset_type`:
     * * Specify the `asset_type` field in your search request.
     *
     * Generated from protobuf field <code>string asset_type = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setAssetType($var)
    {
        GPBUtil::checkString($var, True);
        $this->asset_type = $var;

        return $this;
    }

    /**
     * The project that this resource belongs to, in the form of
     * projects/{PROJECT_NUMBER}. This field is available when the resource
     * belongs to a project.
     * To search against `project`:
     * * Use a field query. Example: `project:12345`
     * * Use a free text query. Example: `12345`
     * * Specify the `scope` field as this project in your search request.
     *
     * Generated from protobuf field <code>string project = 3;</code>
     * @return string
     */
    public function getProject()
    {
        return $this->project;
    }

    /**
     * The project that this resource belongs to, in the form of
     * projects/{PROJECT_NUMBER}. This field is available when the resource
     * belongs to a project.
     * To search against `project`:
     * * Use a field query. Example: `project:12345`
     * * Use a free text query. Example: `12345`
     * * Specify the `scope` field as this project in your search request.
     *
     * Generated from protobuf field <code>string project = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->project = $var;

        return $this;
    }

    /**
     * The folder(s) that this resource belongs to, in the form of
     * folders/{FOLDER_NUMBER}. This field is available when the resource
     * belongs to one or more folders.
     * To search against `folders`:
     * * Use a field query. Example: `folders:(123 OR 456)`
     * * Use a free text query. Example: `123`
     * * Specify the `scope` field as this folder in your search request.
     *
     * Generated from protobuf field <code>repeated string folders = 17;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFolders()
    {
        return $this->folders;
    }

    /**
     * The folder(s) that this resource belongs to, in the form of
     * folders/{FOLDER_NUMBER}. This field is available when the resource
     * belongs to one or more folders.
     * To search against `folders`:
     * * Use a field query. Example: `folders:(123 OR 456)`
     * * Use a free text query. Example: `123`
     * * Specify the `scope` field as this folder in your search request.
     *
     * Generated from protobuf field <code>repeated string folders = 17;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFolders($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->folders = $arr;

        return $this;
    }

    /**
     * The organization that this resource belongs to, in the form of
     * organizations/{ORGANIZATION_NUMBER}. This field is available when the
     * resource belongs to an organization.
     * To search against `organization`:
     * * Use a field query. Example: `organization:123`
     * * Use a free text query. Example: `123`
     * * Specify the `scope` field as this organization in your search request.
     *
     * Generated from protobuf field <code>string organization = 18;</code>
     * @return string
     */
    public function getOrganization()
    {
        return $this->organization;
    }

    /**
     * The organization that this resource belongs to, in the form of
     * organizations/{ORGANIZATION_NUMBER}. This field is available when the
     * resource belongs to an organization.
     * To search against `organization`:
     * * Use a field query. Example: `organization:123`
     * * Use a free text query. Example: `123`
     * * Specify the `scope` field as this organization in your search request.
     *
     * Generated from protobuf field <code>string organization = 18;</code>
     * @param string $var
     * @return $this
     */
    public function setOrganization($var)
    {
        GPBUtil::checkString($var, True);
        $this->organization = $var;

        return $this;
    }

    /**
     * The display name of this resource. This field is available only when the
     * resource's Protobuf contains it.
     * To search against the `display_name`:
     * * Use a field query. Example: `displayName:"My Instance"`
     * * Use a free text query. Example: `"My Instance"`
     *
     * Generated from protobuf field <code>string display_name = 4;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * The display name of this resource. This field is available only when the
     * resource's Protobuf contains it.
     * To search against the `display_name`:
     * * Use a field query. Example: `displayName:"My Instance"`
     * * Use a free text query. Example: `"My Instance"`
     *
     * Generated from protobuf field <code>string display_name = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * One or more paragraphs of text description of this resource. Maximum length
     * could be up to 1M bytes. This field is available only when the resource's
     * Protobuf contains it.
     * To search against the `description`:
     * * Use a field query. Example: `description:"important instance"`
     * * Use a free text query. Example: `"important instance"`
     *
     * Generated from protobuf field <code>string description = 5;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * One or more paragraphs of text description of this resource. Maximum length
     * could be up to 1M bytes. This field is available only when the resource's
     * Protobuf contains it.
     * To search against the `description`:
     * * Use a field query. Example: `description:"important instance"`
     * * Use a free text query. Example: `"important instance"`
     *
     * Generated from protobuf field <code>string description = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Location can be `global`, regional like `us-east1`, or zonal like
     * `us-west1-b`. This field is available only when the resource's Protobuf
     * contains it.
     * To search against the `location`:
     * * Use a field query. Example: `location:us-west*`
     * * Use a free text query. Example: `us-west*`
     *
     * Generated from protobuf field <code>string location = 6;</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * Location can be `global`, regional like `us-east1`, or zonal like
     * `us-west1-b`. This field is available only when the resource's Protobuf
     * contains it.
     * To search against the `location`:
     * * Use a field query. Example: `location:us-west*`
     * * Use a free text query. Example: `us-west*`
     *
     * Generated from protobuf field <code>string location = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * User labels associated with this resource. See [Labelling and grouping
     * Google Cloud
     * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information. This field is available only when the resource's
     * Protobuf contains it.
     * To search against the `labels`:
     * * Use a field query:
     *     - query on any label's key or value. Example: `labels:prod`
     *     - query by a given label. Example: `labels.env:prod`
     *     - query by a given label's existence. Example: `labels.env:*`
     * * Use a free text query. Example: `prod`
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * User labels associated with this resource. See [Labelling and grouping
     * Google Cloud
     * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information. This field is available only when the resource's
     * Protobuf contains it.
     * To search against the `labels`:
     * * Use a field query:
     *     - query on any label's key or value. Example: `labels:prod`
     *     - query by a given label. Example: `labels.env:prod`
     *     - query by a given label's existence. Example: `labels.env:*`
     * * Use a free text query. Example: `prod`
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Network tags associated with this resource. Like labels, network tags are a
     * type of annotations used to group Google Cloud resources. See [Labelling
     * Google Cloud
     * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information. This field is available only when the resource's
     * Protobuf contains it.
     * To search against the `network_tags`:
     * * Use a field query. Example: `networkTags:internal`
     * * Use a free text query. Example: `internal`
     *
     * Generated from protobuf field <code>repeated string network_tags = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getNetworkTags()
    {
        return $this->network_tags;
    }

    /**
     * Network tags associated with this resource. Like labels, network tags are a
     * type of annotations used to group Google Cloud resources. See [Labelling
     * Google Cloud
     * resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
     * for more information. This field is available only when the resource's
     * Protobuf contains it.
     * To search against the `network_tags`:
     * * Use a field query. Example: `networkTags:internal`
     * * Use a free text query. Example: `internal`
     *
     * Generated from protobuf field <code>repeated string network_tags = 8;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setNetworkTags($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->network_tags = $arr;

        return $this;
    }

    /**
     * The Cloud KMS
     * [CryptoKey](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys)
     * name or
     * [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions)
     * name.
     * This field only presents for the purpose of backward compatibility.
     * Use the `kms_keys` field to retrieve Cloud KMS key information. This field
     * is available only when the resource's Protobuf contains it and will only be
     * populated for [these resource
     * types](https://cloud.google.com/asset-inventory/docs/legacy-field-names#resource_types_with_the_to_be_deprecated_kmskey_field)
     * for backward compatible purposes.
     * To search against the `kms_key`:
     * * Use a field query. Example: `kmsKey:key`
     * * Use a free text query. Example: `key`
     *
     * Generated from protobuf field <code>string kms_key = 10 [deprecated = true];</code>
     * @return string
     * @deprecated
     */
    public function getKmsKey()
    {
        if ($this->kms_key !== '') {
            @trigger_error('kms_key is deprecated.', E_USER_DEPRECATED);
        }
        return $this->kms_key;
    }

    /**
     * The Cloud KMS
     * [CryptoKey](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys)
     * name or
     * [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions)
     * name.
     * This field only presents for the purpose of backward compatibility.
     * Use the `kms_keys` field to retrieve Cloud KMS key information. This field
     * is available only when the resource's Protobuf contains it and will only be
     * populated for [these resource
     * types](https://cloud.google.com/asset-inventory/docs/legacy-field-names#resource_types_with_the_to_be_deprecated_kmskey_field)
     * for backward compatible purposes.
     * To search against the `kms_key`:
     * * Use a field query. Example: `kmsKey:key`
     * * Use a free text query. Example: `key`
     *
     * Generated from protobuf field <code>string kms_key = 10 [deprecated = true];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setKmsKey($var)
    {
        @trigger_error('kms_key is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->kms_key = $var;

        return $this;
    }

    /**
     * The Cloud KMS
     * [CryptoKey](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys)
     * names or
     * [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions)
     * names. This field is available only when the resource's Protobuf contains
     * it.
     * To search against the `kms_keys`:
     * * Use a field query. Example: `kmsKeys:key`
     * * Use a free text query. Example: `key`
     *
     * Generated from protobuf field <code>repeated string kms_keys = 28;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getKmsKeys()
    {
        return $this->kms_keys;
    }

    /**
     * The Cloud KMS
     * [CryptoKey](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys)
     * names or
     * [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions)
     * names. This field is available only when the resource's Protobuf contains
     * it.
     * To search against the `kms_keys`:
     * * Use a field query. Example: `kmsKeys:key`
     * * Use a free text query. Example: `key`
     *
     * Generated from protobuf field <code>repeated string kms_keys = 28;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setKmsKeys($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->kms_keys = $arr;

        return $this;
    }

    /**
     * The create timestamp of this resource, at which the resource was created.
     * The granularity is in seconds. Timestamp.nanos will always be 0. This field
     * is available only when the resource's Protobuf contains it.
     * To search against `create_time`:
     * * Use a field query.
     *     - value in seconds since unix epoch. Example: `createTime > 1609459200`
     *     - value in date string. Example: `createTime > 2021-01-01`
     *     - value in date-time string (must be quoted). Example: `createTime >
     *     "2021-01-01T00:00:00"`
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 11;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * The create timestamp of this resource, at which the resource was created.
     * The granularity is in seconds. Timestamp.nanos will always be 0. This field
     * is available only when the resource's Protobuf contains it.
     * To search against `create_time`:
     * * Use a field query.
     *     - value in seconds since unix epoch. Example: `createTime > 1609459200`
     *     - value in date string. Example: `createTime > 2021-01-01`
     *     - value in date-time string (must be quoted). Example: `createTime >
     *     "2021-01-01T00:00:00"`
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 11;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * The last update timestamp of this resource, at which the resource was last
     * modified or deleted. The granularity is in seconds. Timestamp.nanos will
     * always be 0. This field is available only when the resource's Protobuf
     * contains it.
     * To search against `update_time`:
     * * Use a field query.
     *     - value in seconds since unix epoch. Example: `updateTime < 1609459200`
     *     - value in date string. Example: `updateTime < 2021-01-01`
     *     - value in date-time string (must be quoted). Example: `updateTime <
     *     "2021-01-01T00:00:00"`
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 12;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * The last update timestamp of this resource, at which the resource was last
     * modified or deleted. The granularity is in seconds. Timestamp.nanos will
     * always be 0. This field is available only when the resource's Protobuf
     * contains it.
     * To search against `update_time`:
     * * Use a field query.
     *     - value in seconds since unix epoch. Example: `updateTime < 1609459200`
     *     - value in date string. Example: `updateTime < 2021-01-01`
     *     - value in date-time string (must be quoted). Example: `updateTime <
     *     "2021-01-01T00:00:00"`
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 12;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * The state of this resource. Different resources types have different state
     * definitions that are mapped from various fields of different resource
     * types. This field is available only when the resource's Protobuf contains
     * it.
     * Example:
     * If the resource is an instance provided by Compute Engine,
     * its state will include PROVISIONING, STAGING, RUNNING, STOPPING,
     * SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. See `status` definition
     * in [API
     * Reference](https://cloud.google.com/compute/docs/reference/rest/v1/instances).
     * If the resource is a project provided by Resource Manager, its state
     * will include LIFECYCLE_STATE_UNSPECIFIED, ACTIVE, DELETE_REQUESTED and
     * DELETE_IN_PROGRESS. See `lifecycleState` definition in [API
     * Reference](https://cloud.google.com/resource-manager/reference/rest/v1/projects).
     * To search against the `state`:
     * * Use a field query. Example: `state:RUNNING`
     * * Use a free text query. Example: `RUNNING`
     *
     * Generated from protobuf field <code>string state = 13;</code>
     * @return string
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * The state of this resource. Different resources types have different state
     * definitions that are mapped from various fields of different resource
     * types. This field is available only when the resource's Protobuf contains
     * it.
     * Example:
     * If the resource is an instance provided by Compute Engine,
     * its state will include PROVISIONING, STAGING, RUNNING, STOPPING,
     * SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. See `status` definition
     * in [API
     * Reference](https://cloud.google.com/compute/docs/reference/rest/v1/instances).
     * If the resource is a project provided by Resource Manager, its state
     * will include LIFECYCLE_STATE_UNSPECIFIED, ACTIVE, DELETE_REQUESTED and
     * DELETE_IN_PROGRESS. See `lifecycleState` definition in [API
     * Reference](https://cloud.google.com/resource-manager/reference/rest/v1/projects).
     * To search against the `state`:
     * * Use a field query. Example: `state:RUNNING`
     * * Use a free text query. Example: `RUNNING`
     *
     * Generated from protobuf field <code>string state = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkString($var, True);
        $this->state = $var;

        return $this;
    }

    /**
     * The additional searchable attributes of this resource. The attributes may
     * vary from one resource type to another. Examples: `projectId` for Project,
     * `dnsName` for DNS ManagedZone. This field contains a subset of the resource
     * metadata fields that are returned by the List or Get APIs provided by the
     * corresponding Google Cloud service (e.g., Compute Engine). see [API
     * references and supported searchable
     * attributes](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
     * to see which fields are included.
     * You can search values of these fields through free text search. However,
     * you should not consume the field programically as the field names and
     * values may change as the Google Cloud service updates to a new incompatible
     * API version.
     * To search against the `additional_attributes`:
     * * Use a free text query to match the attributes values. Example: to search
     *   `additional_attributes = { dnsName: "foobar" }`, you can issue a query
     *   `foobar`.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct additional_attributes = 9;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getAdditionalAttributes()
    {
        return $this->additional_attributes;
    }

    public function hasAdditionalAttributes()
    {
        return isset($this->additional_attributes);
    }

    public function clearAdditionalAttributes()
    {
        unset($this->additional_attributes);
    }

    /**
     * The additional searchable attributes of this resource. The attributes may
     * vary from one resource type to another. Examples: `projectId` for Project,
     * `dnsName` for DNS ManagedZone. This field contains a subset of the resource
     * metadata fields that are returned by the List or Get APIs provided by the
     * corresponding Google Cloud service (e.g., Compute Engine). see [API
     * references and supported searchable
     * attributes](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
     * to see which fields are included.
     * You can search values of these fields through free text search. However,
     * you should not consume the field programically as the field names and
     * values may change as the Google Cloud service updates to a new incompatible
     * API version.
     * To search against the `additional_attributes`:
     * * Use a free text query to match the attributes values. Example: to search
     *   `additional_attributes = { dnsName: "foobar" }`, you can issue a query
     *   `foobar`.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct additional_attributes = 9;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setAdditionalAttributes($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->additional_attributes = $var;

        return $this;
    }

    /**
     * The full resource name of this resource's parent, if it has one.
     * To search against the `parent_full_resource_name`:
     * * Use a field query. Example:
     * `parentFullResourceName:"project-name"`
     * * Use a free text query. Example:
     * `project-name`
     *
     * Generated from protobuf field <code>string parent_full_resource_name = 19;</code>
     * @return string
     */
    public function getParentFullResourceName()
    {
        return $this->parent_full_resource_name;
    }

    /**
     * The full resource name of this resource's parent, if it has one.
     * To search against the `parent_full_resource_name`:
     * * Use a field query. Example:
     * `parentFullResourceName:"project-name"`
     * * Use a free text query. Example:
     * `project-name`
     *
     * Generated from protobuf field <code>string parent_full_resource_name = 19;</code>
     * @param string $var
     * @return $this
     */
    public function setParentFullResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent_full_resource_name = $var;

        return $this;
    }

    /**
     * Versioned resource representations of this resource. This is repeated
     * because there could be multiple versions of resource representations during
     * version migration.
     * This `versioned_resources` field is not searchable. Some attributes of the
     * resource representations are exposed in `additional_attributes` field, so
     * as to allow users to search on them.
     *
     * Generated from protobuf field <code>repeated .google.cloud.asset.v1.VersionedResource versioned_resources = 16;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getVersionedResources()
    {
        return $this->versioned_resources;
    }

    /**
     * Versioned resource representations of this resource. This is repeated
     * because there could be multiple versions of resource representations during
     * version migration.
     * This `versioned_resources` field is not searchable. Some attributes of the
     * resource representations are exposed in `additional_attributes` field, so
     * as to allow users to search on them.
     *
     * Generated from protobuf field <code>repeated .google.cloud.asset.v1.VersionedResource versioned_resources = 16;</code>
     * @param array<\Google\Cloud\Asset\V1\VersionedResource>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setVersionedResources($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Asset\V1\VersionedResource::class);
        $this->versioned_resources = $arr;

        return $this;
    }

    /**
     * Attached resources of this resource. For example, an OSConfig
     * Inventory is an attached resource of a Compute Instance. This field is
     * repeated because a resource could have multiple attached resources.
     * This `attached_resources` field is not searchable. Some attributes
     * of the attached resources are exposed in `additional_attributes` field, so
     * as to allow users to search on them.
     *
     * Generated from protobuf field <code>repeated .google.cloud.asset.v1.AttachedResource attached_resources = 20;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAttachedResources()
    {
        return $this->attached_resources;
    }

    /**
     * Attached resources of this resource. For example, an OSConfig
     * Inventory is an attached resource of a Compute Instance. This field is
     * repeated because a resource could have multiple attached resources.
     * This `attached_resources` field is not searchable. Some attributes
     * of the attached resources are exposed in `additional_attributes` field, so
     * as to allow users to search on them.
     *
     * Generated from protobuf field <code>repeated .google.cloud.asset.v1.AttachedResource attached_resources = 20;</code>
     * @param array<\Google\Cloud\Asset\V1\AttachedResource>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAttachedResources($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Asset\V1\AttachedResource::class);
        $this->attached_resources = $arr;

        return $this;
    }

    /**
     * A map of related resources of this resource, keyed by the
     * relationship type. A relationship type is in the format of
     * {SourceType}_{ACTION}_{DestType}. Example: `DISK_TO_INSTANCE`,
     * `DISK_TO_NETWORK`, `INSTANCE_TO_INSTANCEGROUP`.
     * See [supported relationship
     * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#supported_relationship_types).
     *
     * Generated from protobuf field <code>map<string, .google.cloud.asset.v1.RelatedResources> relationships = 21;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getRelationships()
    {
        return $this->relationships;
    }

    /**
     * A map of related resources of this resource, keyed by the
     * relationship type. A relationship type is in the format of
     * {SourceType}_{ACTION}_{DestType}. Example: `DISK_TO_INSTANCE`,
     * `DISK_TO_NETWORK`, `INSTANCE_TO_INSTANCEGROUP`.
     * See [supported relationship
     * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#supported_relationship_types).
     *
     * Generated from protobuf field <code>map<string, .google.cloud.asset.v1.RelatedResources> relationships = 21;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setRelationships($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Asset\V1\RelatedResources::class);
        $this->relationships = $arr;

        return $this;
    }

    /**
     * This field is only present for the purpose of backward compatibility.
     * Use the `tags` field instead.
     * TagKey namespaced names, in the format of {ORG_ID}/{TAG_KEY_SHORT_NAME}.
     * To search against the `tagKeys`:
     * * Use a field query. Example:
     *     - `tagKeys:"123456789/env*"`
     *     - `tagKeys="123456789/env"`
     *     - `tagKeys:"env"`
     * * Use a free text query. Example:
     *     - `env`
     *
     * Generated from protobuf field <code>repeated string tag_keys = 23 [deprecated = true];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     * @deprecated
     */
    public function getTagKeys()
    {
        if ($this->tag_keys->count() !== 0) {
            @trigger_error('tag_keys is deprecated.', E_USER_DEPRECATED);
        }
        return $this->tag_keys;
    }

    /**
     * This field is only present for the purpose of backward compatibility.
     * Use the `tags` field instead.
     * TagKey namespaced names, in the format of {ORG_ID}/{TAG_KEY_SHORT_NAME}.
     * To search against the `tagKeys`:
     * * Use a field query. Example:
     *     - `tagKeys:"123456789/env*"`
     *     - `tagKeys="123456789/env"`
     *     - `tagKeys:"env"`
     * * Use a free text query. Example:
     *     - `env`
     *
     * Generated from protobuf field <code>repeated string tag_keys = 23 [deprecated = true];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     * @deprecated
     */
    public function setTagKeys($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        if (count($arr) !== 0) {
            @trigger_error('tag_keys is deprecated.', E_USER_DEPRECATED);
        }
        $this->tag_keys = $arr;

        return $this;
    }

    /**
     * This field is only present for the purpose of backward compatibility.
     * Use the `tags` field instead.
     * TagValue namespaced names, in the format of
     * {ORG_ID}/{TAG_KEY_SHORT_NAME}/{TAG_VALUE_SHORT_NAME}.
     * To search against the `tagValues`:
     * * Use a field query. Example:
     *     - `tagValues:"env"`
     *     - `tagValues:"env/prod"`
     *     - `tagValues:"123456789/env/prod*"`
     *     - `tagValues="123456789/env/prod"`
     * * Use a free text query. Example:
     *     - `prod`
     *
     * Generated from protobuf field <code>repeated string tag_values = 25 [deprecated = true];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     * @deprecated
     */
    public function getTagValues()
    {
        if ($this->tag_values->count() !== 0) {
            @trigger_error('tag_values is deprecated.', E_USER_DEPRECATED);
        }
        return $this->tag_values;
    }

    /**
     * This field is only present for the purpose of backward compatibility.
     * Use the `tags` field instead.
     * TagValue namespaced names, in the format of
     * {ORG_ID}/{TAG_KEY_SHORT_NAME}/{TAG_VALUE_SHORT_NAME}.
     * To search against the `tagValues`:
     * * Use a field query. Example:
     *     - `tagValues:"env"`
     *     - `tagValues:"env/prod"`
     *     - `tagValues:"123456789/env/prod*"`
     *     - `tagValues="123456789/env/prod"`
     * * Use a free text query. Example:
     *     - `prod`
     *
     * Generated from protobuf field <code>repeated string tag_values = 25 [deprecated = true];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     * @deprecated
     */
    public function setTagValues($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        if (count($arr) !== 0) {
            @trigger_error('tag_values is deprecated.', E_USER_DEPRECATED);
        }
        $this->tag_values = $arr;

        return $this;
    }

    /**
     * This field is only present for the purpose of backward compatibility.
     * Use the `tags` field instead.
     * TagValue IDs, in the format of tagValues/{TAG_VALUE_ID}.
     * To search against the `tagValueIds`:
     * * Use a field query. Example:
     *     - `tagValueIds="tagValues/456"`
     * * Use a free text query. Example:
     *     - `456`
     *
     * Generated from protobuf field <code>repeated string tag_value_ids = 26 [deprecated = true];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     * @deprecated
     */
    public function getTagValueIds()
    {
        if ($this->tag_value_ids->count() !== 0) {
            @trigger_error('tag_value_ids is deprecated.', E_USER_DEPRECATED);
        }
        return $this->tag_value_ids;
    }

    /**
     * This field is only present for the purpose of backward compatibility.
     * Use the `tags` field instead.
     * TagValue IDs, in the format of tagValues/{TAG_VALUE_ID}.
     * To search against the `tagValueIds`:
     * * Use a field query. Example:
     *     - `tagValueIds="tagValues/456"`
     * * Use a free text query. Example:
     *     - `456`
     *
     * Generated from protobuf field <code>repeated string tag_value_ids = 26 [deprecated = true];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     * @deprecated
     */
    public function setTagValueIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        if (count($arr) !== 0) {
            @trigger_error('tag_value_ids is deprecated.', E_USER_DEPRECATED);
        }
        $this->tag_value_ids = $arr;

        return $this;
    }

    /**
     * The tags directly attached to this resource.
     * To search against the `tags`:
     * * Use a field query. Example:
     *     - `tagKeys:"123456789/env*"`
     *     - `tagKeys="123456789/env"`
     *     - `tagKeys:"env"`
     *     - `tagKeyIds="tagKeys/123"`
     *     - `tagValues:"env"`
     *     - `tagValues:"env/prod"`
     *     - `tagValues:"123456789/env/prod*"`
     *     - `tagValues="123456789/env/prod"`
     *     - `tagValueIds="tagValues/456"`
     * * Use a free text query. Example:
     *     - `env/prod`
     *
     * Generated from protobuf field <code>repeated .google.cloud.asset.v1.Tag tags = 29;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTags()
    {
        return $this->tags;
    }

    /**
     * The tags directly attached to this resource.
     * To search against the `tags`:
     * * Use a field query. Example:
     *     - `tagKeys:"123456789/env*"`
     *     - `tagKeys="123456789/env"`
     *     - `tagKeys:"env"`
     *     - `tagKeyIds="tagKeys/123"`
     *     - `tagValues:"env"`
     *     - `tagValues:"env/prod"`
     *     - `tagValues:"123456789/env/prod*"`
     *     - `tagValues="123456789/env/prod"`
     *     - `tagValueIds="tagValues/456"`
     * * Use a free text query. Example:
     *     - `env/prod`
     *
     * Generated from protobuf field <code>repeated .google.cloud.asset.v1.Tag tags = 29;</code>
     * @param array<\Google\Cloud\Asset\V1\Tag>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTags($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Asset\V1\Tag::class);
        $this->tags = $arr;

        return $this;
    }

    /**
     * The effective tags on this resource. All of the tags that are both attached
     * to and inherited by a resource are collectively called the effective
     * tags. For more information, see [tag
     * inheritance](https://cloud.google.com/resource-manager/docs/tags/tags-overview#inheritance).
     * To search against the `effective_tags`:
     * * Use a field query. Example:
     *     - `effectiveTagKeys:"123456789/env*"`
     *     - `effectiveTagKeys="123456789/env"`
     *     - `effectiveTagKeys:"env"`
     *     - `effectiveTagKeyIds="tagKeys/123"`
     *     - `effectiveTagValues:"env"`
     *     - `effectiveTagValues:"env/prod"`
     *     - `effectiveTagValues:"123456789/env/prod*"`
     *     - `effectiveTagValues="123456789/env/prod"`
     *     - `effectiveTagValueIds="tagValues/456"`
     *
     * Generated from protobuf field <code>repeated .google.cloud.asset.v1.EffectiveTagDetails effective_tags = 30;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEffectiveTags()
    {
        return $this->effective_tags;
    }

    /**
     * The effective tags on this resource. All of the tags that are both attached
     * to and inherited by a resource are collectively called the effective
     * tags. For more information, see [tag
     * inheritance](https://cloud.google.com/resource-manager/docs/tags/tags-overview#inheritance).
     * To search against the `effective_tags`:
     * * Use a field query. Example:
     *     - `effectiveTagKeys:"123456789/env*"`
     *     - `effectiveTagKeys="123456789/env"`
     *     - `effectiveTagKeys:"env"`
     *     - `effectiveTagKeyIds="tagKeys/123"`
     *     - `effectiveTagValues:"env"`
     *     - `effectiveTagValues:"env/prod"`
     *     - `effectiveTagValues:"123456789/env/prod*"`
     *     - `effectiveTagValues="123456789/env/prod"`
     *     - `effectiveTagValueIds="tagValues/456"`
     *
     * Generated from protobuf field <code>repeated .google.cloud.asset.v1.EffectiveTagDetails effective_tags = 30;</code>
     * @param array<\Google\Cloud\Asset\V1\EffectiveTagDetails>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEffectiveTags($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Asset\V1\EffectiveTagDetails::class);
        $this->effective_tags = $arr;

        return $this;
    }

    /**
     * Enrichments of the asset. Currently supported enrichment types with
     * SearchAllResources API:
     * * RESOURCE_OWNERS
     * The corresponding read masks in order to get the enrichment:
     * * enrichments.resource_owners
     * The corresponding required permissions:
     * * cloudasset.assets.searchEnrichmentResourceOwners
     * Example query to get resource owner enrichment:
     * ```
     *   scope: "projects/my-project"
     *   query: "name: my-project"
     *   assetTypes: "cloudresourcemanager.googleapis.com/Project"
     *   readMask: {
     *      paths: "asset_type"
     *      paths: "name"
     *      paths: "enrichments.resource_owners"
     *   }
     * ```
     *
     * Generated from protobuf field <code>repeated .google.cloud.asset.v1.AssetEnrichment enrichments = 31;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEnrichments()
    {
        return $this->enrichments;
    }

    /**
     * Enrichments of the asset. Currently supported enrichment types with
     * SearchAllResources API:
     * * RESOURCE_OWNERS
     * The corresponding read masks in order to get the enrichment:
     * * enrichments.resource_owners
     * The corresponding required permissions:
     * * cloudasset.assets.searchEnrichmentResourceOwners
     * Example query to get resource owner enrichment:
     * ```
     *   scope: "projects/my-project"
     *   query: "name: my-project"
     *   assetTypes: "cloudresourcemanager.googleapis.com/Project"
     *   readMask: {
     *      paths: "asset_type"
     *      paths: "name"
     *      paths: "enrichments.resource_owners"
     *   }
     * ```
     *
     * Generated from protobuf field <code>repeated .google.cloud.asset.v1.AssetEnrichment enrichments = 31;</code>
     * @param array<\Google\Cloud\Asset\V1\AssetEnrichment>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEnrichments($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Asset\V1\AssetEnrichment::class);
        $this->enrichments = $arr;

        return $this;
    }

    /**
     * The type of this resource's immediate parent, if there is one.
     * To search against the `parent_asset_type`:
     * * Use a field query. Example:
     * `parentAssetType:"cloudresourcemanager.googleapis.com/Project"`
     * * Use a free text query. Example:
     * `cloudresourcemanager.googleapis.com/Project`
     *
     * Generated from protobuf field <code>string parent_asset_type = 103;</code>
     * @return string
     */
    public function getParentAssetType()
    {
        return $this->parent_asset_type;
    }

    /**
     * The type of this resource's immediate parent, if there is one.
     * To search against the `parent_asset_type`:
     * * Use a field query. Example:
     * `parentAssetType:"cloudresourcemanager.googleapis.com/Project"`
     * * Use a free text query. Example:
     * `cloudresourcemanager.googleapis.com/Project`
     *
     * Generated from protobuf field <code>string parent_asset_type = 103;</code>
     * @param string $var
     * @return $this
     */
    public function setParentAssetType($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent_asset_type = $var;

        return $this;
    }

    /**
     * The actual content of Security Command Center security marks associated
     * with the asset.
     * To search against SCC SecurityMarks field:
     *   * Use a field query:
     *     - query by a given key value pair. Example: `sccSecurityMarks.foo=bar`
     *     - query by a given key's existence. Example: `sccSecurityMarks.foo:*`
     *
     * Generated from protobuf field <code>map<string, string> scc_security_marks = 32;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getSccSecurityMarks()
    {
        return $this->scc_security_marks;
    }

    /**
     * The actual content of Security Command Center security marks associated
     * with the asset.
     * To search against SCC SecurityMarks field:
     *   * Use a field query:
     *     - query by a given key value pair. Example: `sccSecurityMarks.foo=bar`
     *     - query by a given key's existence. Example: `sccSecurityMarks.foo:*`
     *
     * Generated from protobuf field <code>map<string, string> scc_security_marks = 32;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setSccSecurityMarks($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->scc_security_marks = $arr;

        return $this;
    }

}

