<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/chat/v1/user.proto

namespace Google\Apps\Chat\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A user in Google Chat.
 * When returned as an output from a request, if your Chat app [authenticates as
 * a
 * user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
 * the output for a `User` resource only populates the user's `name` and `type`.
 *
 * Generated from protobuf message <code>google.chat.v1.User</code>
 */
class User extends \Google\Protobuf\Internal\Message
{
    /**
     * Resource name for a Google Chat [user][google.chat.v1.User].
     * Format: `users/{user}`. `users/app` can be used as an alias for the calling
     * app [bot][google.chat.v1.User.Type.BOT] user.
     * For [human users][google.chat.v1.User.Type.HUMAN], `{user}` is the same
     * user identifier as:
     * - the `id` for the
     * [Person](https://developers.google.com/people/api/rest/v1/people) in the
     * People API. For example, `users/123456789` in Chat API represents the same
     * person as the `123456789` Person profile ID in People API.
     * - the `id` for a
     * [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
     * in the Admin SDK Directory API.
     * - the user's email address can be used as an alias for `{user}` in API
     * requests. For example, if the People API Person profile ID for
     * `user&#64;example.com` is `123456789`, you can use `users/user&#64;example.com` as
     * an alias to reference `users/123456789`. Only the canonical resource name
     * (for example `users/123456789`) will be returned from the API.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Output only. The user's display name.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $display_name = '';
    /**
     * Unique identifier of the user's Google Workspace domain.
     *
     * Generated from protobuf field <code>string domain_id = 6;</code>
     */
    protected $domain_id = '';
    /**
     * User type.
     *
     * Generated from protobuf field <code>.google.chat.v1.User.Type type = 5;</code>
     */
    protected $type = 0;
    /**
     * Output only. When `true`, the user is deleted or their profile is not
     * visible.
     *
     * Generated from protobuf field <code>bool is_anonymous = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $is_anonymous = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Resource name for a Google Chat [user][google.chat.v1.User].
     *           Format: `users/{user}`. `users/app` can be used as an alias for the calling
     *           app [bot][google.chat.v1.User.Type.BOT] user.
     *           For [human users][google.chat.v1.User.Type.HUMAN], `{user}` is the same
     *           user identifier as:
     *           - the `id` for the
     *           [Person](https://developers.google.com/people/api/rest/v1/people) in the
     *           People API. For example, `users/123456789` in Chat API represents the same
     *           person as the `123456789` Person profile ID in People API.
     *           - the `id` for a
     *           [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
     *           in the Admin SDK Directory API.
     *           - the user's email address can be used as an alias for `{user}` in API
     *           requests. For example, if the People API Person profile ID for
     *           `user&#64;example.com` is `123456789`, you can use `users/user&#64;example.com` as
     *           an alias to reference `users/123456789`. Only the canonical resource name
     *           (for example `users/123456789`) will be returned from the API.
     *     @type string $display_name
     *           Output only. The user's display name.
     *     @type string $domain_id
     *           Unique identifier of the user's Google Workspace domain.
     *     @type int $type
     *           User type.
     *     @type bool $is_anonymous
     *           Output only. When `true`, the user is deleted or their profile is not
     *           visible.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Chat\V1\User::initOnce();
        parent::__construct($data);
    }

    /**
     * Resource name for a Google Chat [user][google.chat.v1.User].
     * Format: `users/{user}`. `users/app` can be used as an alias for the calling
     * app [bot][google.chat.v1.User.Type.BOT] user.
     * For [human users][google.chat.v1.User.Type.HUMAN], `{user}` is the same
     * user identifier as:
     * - the `id` for the
     * [Person](https://developers.google.com/people/api/rest/v1/people) in the
     * People API. For example, `users/123456789` in Chat API represents the same
     * person as the `123456789` Person profile ID in People API.
     * - the `id` for a
     * [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
     * in the Admin SDK Directory API.
     * - the user's email address can be used as an alias for `{user}` in API
     * requests. For example, if the People API Person profile ID for
     * `user&#64;example.com` is `123456789`, you can use `users/user&#64;example.com` as
     * an alias to reference `users/123456789`. Only the canonical resource name
     * (for example `users/123456789`) will be returned from the API.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Resource name for a Google Chat [user][google.chat.v1.User].
     * Format: `users/{user}`. `users/app` can be used as an alias for the calling
     * app [bot][google.chat.v1.User.Type.BOT] user.
     * For [human users][google.chat.v1.User.Type.HUMAN], `{user}` is the same
     * user identifier as:
     * - the `id` for the
     * [Person](https://developers.google.com/people/api/rest/v1/people) in the
     * People API. For example, `users/123456789` in Chat API represents the same
     * person as the `123456789` Person profile ID in People API.
     * - the `id` for a
     * [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
     * in the Admin SDK Directory API.
     * - the user's email address can be used as an alias for `{user}` in API
     * requests. For example, if the People API Person profile ID for
     * `user&#64;example.com` is `123456789`, you can use `users/user&#64;example.com` as
     * an alias to reference `users/123456789`. Only the canonical resource name
     * (for example `users/123456789`) will be returned from the API.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The user's display name.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Output only. The user's display name.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Unique identifier of the user's Google Workspace domain.
     *
     * Generated from protobuf field <code>string domain_id = 6;</code>
     * @return string
     */
    public function getDomainId()
    {
        return $this->domain_id;
    }

    /**
     * Unique identifier of the user's Google Workspace domain.
     *
     * Generated from protobuf field <code>string domain_id = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setDomainId($var)
    {
        GPBUtil::checkString($var, True);
        $this->domain_id = $var;

        return $this;
    }

    /**
     * User type.
     *
     * Generated from protobuf field <code>.google.chat.v1.User.Type type = 5;</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * User type.
     *
     * Generated from protobuf field <code>.google.chat.v1.User.Type type = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Chat\V1\User\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Output only. When `true`, the user is deleted or their profile is not
     * visible.
     *
     * Generated from protobuf field <code>bool is_anonymous = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getIsAnonymous()
    {
        return $this->is_anonymous;
    }

    /**
     * Output only. When `true`, the user is deleted or their profile is not
     * visible.
     *
     * Generated from protobuf field <code>bool is_anonymous = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setIsAnonymous($var)
    {
        GPBUtil::checkBool($var);
        $this->is_anonymous = $var;

        return $this;
    }

}

