<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/admanager/v1/creative_template_messages.proto

namespace Google\Ads\AdManager\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a variable defined in a creative template.
 *
 * Generated from protobuf message <code>google.ads.admanager.v1.CreativeTemplateVariable</code>
 */
class CreativeTemplateVariable extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Label that is displayed to users when creating from the creative
     * template. This has a maximum length of 127 characters.
     *
     * Generated from protobuf field <code>optional string label = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $label = null;
    /**
     * Output only. Unique name used to identify the variable. This attribute is
     * assigned by Google when a creative template variable is created.
     *
     * Generated from protobuf field <code>optional string unique_display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $unique_display_name = null;
    /**
     * Required. A descriptive help text that is displayed to users along with the
     * label. This attribute has a maximum length of 255 characters.
     *
     * Generated from protobuf field <code>optional string description = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $description = null;
    /**
     * Optional. `True` if this variable is required to be filled in by users when
     * creating a creative from the creative template.
     *
     * Generated from protobuf field <code>optional bool required = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $required = null;
    protected $SubType;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Ads\AdManager\V1\CreativeTemplateVariable\AssetCreativeTemplateVariable $asset_variable
     *           Optional. Represents a file asset variable defined in a creative
     *           template.
     *     @type \Google\Ads\AdManager\V1\CreativeTemplateVariable\ListStringCreativeTemplateVariable $list_string_variable
     *           Optional. Represents a list variable defined in a creative template.
     *     @type \Google\Ads\AdManager\V1\CreativeTemplateVariable\LongCreativeTemplateVariable $long_variable
     *           Optional. Represents a long variable defined in a creative template.
     *     @type \Google\Ads\AdManager\V1\CreativeTemplateVariable\StringCreativeTemplateVariable $string_variable
     *           Optional. Represents a string variable defined in a creative template.
     *     @type \Google\Ads\AdManager\V1\CreativeTemplateVariable\UrlCreativeTemplateVariable $url_variable
     *           Optional. Represents a url variable defined in a creative template.
     *     @type string $label
     *           Required. Label that is displayed to users when creating from the creative
     *           template. This has a maximum length of 127 characters.
     *     @type string $unique_display_name
     *           Output only. Unique name used to identify the variable. This attribute is
     *           assigned by Google when a creative template variable is created.
     *     @type string $description
     *           Required. A descriptive help text that is displayed to users along with the
     *           label. This attribute has a maximum length of 255 characters.
     *     @type bool $required
     *           Optional. `True` if this variable is required to be filled in by users when
     *           creating a creative from the creative template.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\Admanager\V1\CreativeTemplateMessages::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Represents a file asset variable defined in a creative
     * template.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.CreativeTemplateVariable.AssetCreativeTemplateVariable asset_variable = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\AdManager\V1\CreativeTemplateVariable\AssetCreativeTemplateVariable|null
     */
    public function getAssetVariable()
    {
        return $this->readOneof(5);
    }

    public function hasAssetVariable()
    {
        return $this->hasOneof(5);
    }

    /**
     * Optional. Represents a file asset variable defined in a creative
     * template.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.CreativeTemplateVariable.AssetCreativeTemplateVariable asset_variable = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\AdManager\V1\CreativeTemplateVariable\AssetCreativeTemplateVariable $var
     * @return $this
     */
    public function setAssetVariable($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\AdManager\V1\CreativeTemplateVariable\AssetCreativeTemplateVariable::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Optional. Represents a list variable defined in a creative template.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.CreativeTemplateVariable.ListStringCreativeTemplateVariable list_string_variable = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\AdManager\V1\CreativeTemplateVariable\ListStringCreativeTemplateVariable|null
     */
    public function getListStringVariable()
    {
        return $this->readOneof(7);
    }

    public function hasListStringVariable()
    {
        return $this->hasOneof(7);
    }

    /**
     * Optional. Represents a list variable defined in a creative template.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.CreativeTemplateVariable.ListStringCreativeTemplateVariable list_string_variable = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\AdManager\V1\CreativeTemplateVariable\ListStringCreativeTemplateVariable $var
     * @return $this
     */
    public function setListStringVariable($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\AdManager\V1\CreativeTemplateVariable\ListStringCreativeTemplateVariable::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Optional. Represents a long variable defined in a creative template.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.CreativeTemplateVariable.LongCreativeTemplateVariable long_variable = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\AdManager\V1\CreativeTemplateVariable\LongCreativeTemplateVariable|null
     */
    public function getLongVariable()
    {
        return $this->readOneof(8);
    }

    public function hasLongVariable()
    {
        return $this->hasOneof(8);
    }

    /**
     * Optional. Represents a long variable defined in a creative template.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.CreativeTemplateVariable.LongCreativeTemplateVariable long_variable = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\AdManager\V1\CreativeTemplateVariable\LongCreativeTemplateVariable $var
     * @return $this
     */
    public function setLongVariable($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\AdManager\V1\CreativeTemplateVariable\LongCreativeTemplateVariable::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * Optional. Represents a string variable defined in a creative template.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.CreativeTemplateVariable.StringCreativeTemplateVariable string_variable = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\AdManager\V1\CreativeTemplateVariable\StringCreativeTemplateVariable|null
     */
    public function getStringVariable()
    {
        return $this->readOneof(9);
    }

    public function hasStringVariable()
    {
        return $this->hasOneof(9);
    }

    /**
     * Optional. Represents a string variable defined in a creative template.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.CreativeTemplateVariable.StringCreativeTemplateVariable string_variable = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\AdManager\V1\CreativeTemplateVariable\StringCreativeTemplateVariable $var
     * @return $this
     */
    public function setStringVariable($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\AdManager\V1\CreativeTemplateVariable\StringCreativeTemplateVariable::class);
        $this->writeOneof(9, $var);

        return $this;
    }

    /**
     * Optional. Represents a url variable defined in a creative template.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.CreativeTemplateVariable.UrlCreativeTemplateVariable url_variable = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\AdManager\V1\CreativeTemplateVariable\UrlCreativeTemplateVariable|null
     */
    public function getUrlVariable()
    {
        return $this->readOneof(10);
    }

    public function hasUrlVariable()
    {
        return $this->hasOneof(10);
    }

    /**
     * Optional. Represents a url variable defined in a creative template.
     *
     * Generated from protobuf field <code>.google.ads.admanager.v1.CreativeTemplateVariable.UrlCreativeTemplateVariable url_variable = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\AdManager\V1\CreativeTemplateVariable\UrlCreativeTemplateVariable $var
     * @return $this
     */
    public function setUrlVariable($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\AdManager\V1\CreativeTemplateVariable\UrlCreativeTemplateVariable::class);
        $this->writeOneof(10, $var);

        return $this;
    }

    /**
     * Required. Label that is displayed to users when creating from the creative
     * template. This has a maximum length of 127 characters.
     *
     * Generated from protobuf field <code>optional string label = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getLabel()
    {
        return isset($this->label) ? $this->label : '';
    }

    public function hasLabel()
    {
        return isset($this->label);
    }

    public function clearLabel()
    {
        unset($this->label);
    }

    /**
     * Required. Label that is displayed to users when creating from the creative
     * template. This has a maximum length of 127 characters.
     *
     * Generated from protobuf field <code>optional string label = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->label = $var;

        return $this;
    }

    /**
     * Output only. Unique name used to identify the variable. This attribute is
     * assigned by Google when a creative template variable is created.
     *
     * Generated from protobuf field <code>optional string unique_display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUniqueDisplayName()
    {
        return isset($this->unique_display_name) ? $this->unique_display_name : '';
    }

    public function hasUniqueDisplayName()
    {
        return isset($this->unique_display_name);
    }

    public function clearUniqueDisplayName()
    {
        unset($this->unique_display_name);
    }

    /**
     * Output only. Unique name used to identify the variable. This attribute is
     * assigned by Google when a creative template variable is created.
     *
     * Generated from protobuf field <code>optional string unique_display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUniqueDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->unique_display_name = $var;

        return $this;
    }

    /**
     * Required. A descriptive help text that is displayed to users along with the
     * label. This attribute has a maximum length of 255 characters.
     *
     * Generated from protobuf field <code>optional string description = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * Required. A descriptive help text that is displayed to users along with the
     * label. This attribute has a maximum length of 255 characters.
     *
     * Generated from protobuf field <code>optional string description = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. `True` if this variable is required to be filled in by users when
     * creating a creative from the creative template.
     *
     * Generated from protobuf field <code>optional bool required = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getRequired()
    {
        return isset($this->required) ? $this->required : false;
    }

    public function hasRequired()
    {
        return isset($this->required);
    }

    public function clearRequired()
    {
        unset($this->required);
    }

    /**
     * Optional. `True` if this variable is required to be filled in by users when
     * creating a creative from the creative template.
     *
     * Generated from protobuf field <code>optional bool required = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setRequired($var)
    {
        GPBUtil::checkBool($var);
        $this->required = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getSubType()
    {
        return $this->whichOneof("SubType");
    }

}

