<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/deployment.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a deployment in an environment. A deployment happens when a flow
 * version configured to be active in the environment. You can configure running
 * pre-deployment steps, e.g. running validation test cases, experiment
 * auto-rollout, etc.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.Deployment</code>
 */
class Deployment extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the deployment.
     * Format:
     * projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/environments/<EnvironmentID>/deployments/<DeploymentID>.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * The name of the flow version for this deployment.
     * Format:
     * projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>/versions/<VerionID>.
     *
     * Generated from protobuf field <code>string flow_version = 2 [(.google.api.resource_reference) = {</code>
     */
    protected $flow_version = '';
    /**
     * The current state of the deployment.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Deployment.State state = 3;</code>
     */
    protected $state = 0;
    /**
     * Result of the deployment.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Deployment.Result result = 4;</code>
     */
    protected $result = null;
    /**
     * Start time of this deployment.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 5;</code>
     */
    protected $start_time = null;
    /**
     * End time of this deployment.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    protected $end_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The name of the deployment.
     *           Format:
     *           projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/environments/<EnvironmentID>/deployments/<DeploymentID>.
     *     @type string $flow_version
     *           The name of the flow version for this deployment.
     *           Format:
     *           projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>/versions/<VerionID>.
     *     @type int $state
     *           The current state of the deployment.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\Deployment\Result $result
     *           Result of the deployment.
     *     @type \Google\Protobuf\Timestamp $start_time
     *           Start time of this deployment.
     *     @type \Google\Protobuf\Timestamp $end_time
     *           End time of this deployment.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\Deployment::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of the deployment.
     * Format:
     * projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/environments/<EnvironmentID>/deployments/<DeploymentID>.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name of the deployment.
     * Format:
     * projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/environments/<EnvironmentID>/deployments/<DeploymentID>.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The name of the flow version for this deployment.
     * Format:
     * projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>/versions/<VerionID>.
     *
     * Generated from protobuf field <code>string flow_version = 2 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getFlowVersion()
    {
        return $this->flow_version;
    }

    /**
     * The name of the flow version for this deployment.
     * Format:
     * projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>/versions/<VerionID>.
     *
     * Generated from protobuf field <code>string flow_version = 2 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setFlowVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->flow_version = $var;

        return $this;
    }

    /**
     * The current state of the deployment.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Deployment.State state = 3;</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * The current state of the deployment.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Deployment.State state = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\Cx\V3\Deployment\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Result of the deployment.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Deployment.Result result = 4;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\Deployment\Result|null
     */
    public function getResult()
    {
        return $this->result;
    }

    public function hasResult()
    {
        return isset($this->result);
    }

    public function clearResult()
    {
        unset($this->result);
    }

    /**
     * Result of the deployment.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Deployment.Result result = 4;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\Deployment\Result $var
     * @return $this
     */
    public function setResult($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\Deployment\Result::class);
        $this->result = $var;

        return $this;
    }

    /**
     * Start time of this deployment.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 5;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    public function hasStartTime()
    {
        return isset($this->start_time);
    }

    public function clearStartTime()
    {
        unset($this->start_time);
    }

    /**
     * Start time of this deployment.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->start_time = $var;

        return $this;
    }

    /**
     * End time of this deployment.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 6;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEndTime()
    {
        return $this->end_time;
    }

    public function hasEndTime()
    {
        return isset($this->end_time);
    }

    public function clearEndTime()
    {
        unset($this->end_time);
    }

    /**
     * End time of this deployment.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 6;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->end_time = $var;

        return $this;
    }

}

