<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/security/privateca/v1/resources.proto

namespace Google\Cloud\Security\PrivateCA\V1\X509Parameters;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Describes values that are relevant in a CA certificate.
 *
 * Generated from protobuf message <code>google.cloud.security.privateca.v1.X509Parameters.CaOptions</code>
 */
class CaOptions extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Refers to the "CA" X.509 extension, which is a boolean value. When this
     * value is missing, the extension will be omitted from the CA certificate.
     *
     * Generated from protobuf field <code>optional bool is_ca = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $is_ca = null;
    /**
     * Optional. Refers to the path length restriction X.509 extension. For a CA
     * certificate, this value describes the depth of subordinate CA
     * certificates that are allowed.
     * If this value is less than 0, the request will fail.
     * If this value is missing, the max path length will be omitted from the
     * CA certificate.
     *
     * Generated from protobuf field <code>optional int32 max_issuer_path_length = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $max_issuer_path_length = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $is_ca
     *           Optional. Refers to the "CA" X.509 extension, which is a boolean value. When this
     *           value is missing, the extension will be omitted from the CA certificate.
     *     @type int $max_issuer_path_length
     *           Optional. Refers to the path length restriction X.509 extension. For a CA
     *           certificate, this value describes the depth of subordinate CA
     *           certificates that are allowed.
     *           If this value is less than 0, the request will fail.
     *           If this value is missing, the max path length will be omitted from the
     *           CA certificate.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Security\Privateca\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Refers to the "CA" X.509 extension, which is a boolean value. When this
     * value is missing, the extension will be omitted from the CA certificate.
     *
     * Generated from protobuf field <code>optional bool is_ca = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getIsCa()
    {
        return isset($this->is_ca) ? $this->is_ca : false;
    }

    public function hasIsCa()
    {
        return isset($this->is_ca);
    }

    public function clearIsCa()
    {
        unset($this->is_ca);
    }

    /**
     * Optional. Refers to the "CA" X.509 extension, which is a boolean value. When this
     * value is missing, the extension will be omitted from the CA certificate.
     *
     * Generated from protobuf field <code>optional bool is_ca = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setIsCa($var)
    {
        GPBUtil::checkBool($var);
        $this->is_ca = $var;

        return $this;
    }

    /**
     * Optional. Refers to the path length restriction X.509 extension. For a CA
     * certificate, this value describes the depth of subordinate CA
     * certificates that are allowed.
     * If this value is less than 0, the request will fail.
     * If this value is missing, the max path length will be omitted from the
     * CA certificate.
     *
     * Generated from protobuf field <code>optional int32 max_issuer_path_length = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getMaxIssuerPathLength()
    {
        return isset($this->max_issuer_path_length) ? $this->max_issuer_path_length : 0;
    }

    public function hasMaxIssuerPathLength()
    {
        return isset($this->max_issuer_path_length);
    }

    public function clearMaxIssuerPathLength()
    {
        unset($this->max_issuer_path_length);
    }

    /**
     * Optional. Refers to the path length restriction X.509 extension. For a CA
     * certificate, this value describes the depth of subordinate CA
     * certificates that are allowed.
     * If this value is less than 0, the request will fail.
     * If this value is missing, the max path length will be omitted from the
     * CA certificate.
     *
     * Generated from protobuf field <code>optional int32 max_issuer_path_length = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setMaxIssuerPathLength($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_issuer_path_length = $var;

        return $this;
    }

}


