<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/product_service.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for [SetInventory][] method.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.SetInventoryRequest</code>
 */
class SetInventoryRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The inventory information to update. The allowable fields to
     * update are:
     * * [Product.price_info][google.cloud.retail.v2.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2.Product.fulfillment_info]
     * The updated inventory fields must be specified in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2.SetInventoryRequest.set_mask].
     * If [SetInventoryRequest.inventory.name][] is empty or invalid, an
     * INVALID_ARGUMENT error is returned.
     * If the caller does not have permission to update the
     * [Product][google.cloud.retail.v2.Product] named in
     * [Product.name][google.cloud.retail.v2.Product.name], regardless of whether
     * or not it exists, a PERMISSION_DENIED error is returned.
     * If the [Product][google.cloud.retail.v2.Product] to update does not have
     * existing inventory information, the provided inventory information will be
     * inserted.
     * If the [Product][google.cloud.retail.v2.Product] to update has existing
     * inventory information, the provided inventory information will be merged
     * while respecting the last update time for each inventory field, using the
     * provided or default value for
     * [SetInventoryRequest.set_time][google.cloud.retail.v2.SetInventoryRequest.set_time].
     * The caller can replace place IDs for a subset of fulfillment types in the
     * following ways:
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types and corresponding place IDs
     * to update in [SetInventoryRequest.inventory.fulfillment_info][]
     * The caller can clear all place IDs from a subset of fulfillment types in
     * the following ways:
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types to clear in
     * [SetInventoryRequest.inventory.fulfillment_info][]
     * * Checks that only the desired fulfillment info types have empty
     * [SetInventoryRequest.inventory.fulfillment_info.place_ids][]
     * The last update time is recorded for the following inventory fields:
     * * [Product.price_info][google.cloud.retail.v2.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2.Product.fulfillment_info]
     * If a full overwrite of inventory information while ignoring timestamps is
     * needed, [UpdateProduct][] should be invoked instead.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.Product inventory = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $inventory = null;
    /**
     * Indicates which inventory fields in the provided
     * [Product][google.cloud.retail.v2.Product] to update.
     * At least one field must be provided.
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask set_mask = 2;</code>
     */
    private $set_mask = null;
    /**
     * The time when the request is issued, used to prevent
     * out-of-order updates on inventory fields with the last update time
     * recorded. If not provided, the internal system time will be used.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp set_time = 3;</code>
     */
    private $set_time = null;
    /**
     * If set to true, and the [Product][google.cloud.retail.v2.Product] with name
     * [Product.name][google.cloud.retail.v2.Product.name] is not found, the
     * inventory update will still be processed and retained for at most 1 day
     * until the [Product][google.cloud.retail.v2.Product] is created. If set to
     * false, a NOT_FOUND error is returned if the
     * [Product][google.cloud.retail.v2.Product] is not found.
     *
     * Generated from protobuf field <code>bool allow_missing = 4;</code>
     */
    private $allow_missing = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Retail\V2\Product $inventory
     *           Required. The inventory information to update. The allowable fields to
     *           update are:
     *           * [Product.price_info][google.cloud.retail.v2.Product.price_info]
     *           * [Product.availability][google.cloud.retail.v2.Product.availability]
     *           * [Product.available_quantity][google.cloud.retail.v2.Product.available_quantity]
     *           * [Product.fulfillment_info][google.cloud.retail.v2.Product.fulfillment_info]
     *           The updated inventory fields must be specified in
     *           [SetInventoryRequest.set_mask][google.cloud.retail.v2.SetInventoryRequest.set_mask].
     *           If [SetInventoryRequest.inventory.name][] is empty or invalid, an
     *           INVALID_ARGUMENT error is returned.
     *           If the caller does not have permission to update the
     *           [Product][google.cloud.retail.v2.Product] named in
     *           [Product.name][google.cloud.retail.v2.Product.name], regardless of whether
     *           or not it exists, a PERMISSION_DENIED error is returned.
     *           If the [Product][google.cloud.retail.v2.Product] to update does not have
     *           existing inventory information, the provided inventory information will be
     *           inserted.
     *           If the [Product][google.cloud.retail.v2.Product] to update has existing
     *           inventory information, the provided inventory information will be merged
     *           while respecting the last update time for each inventory field, using the
     *           provided or default value for
     *           [SetInventoryRequest.set_time][google.cloud.retail.v2.SetInventoryRequest.set_time].
     *           The caller can replace place IDs for a subset of fulfillment types in the
     *           following ways:
     *           * Adds "fulfillment_info" in
     *           [SetInventoryRequest.set_mask][google.cloud.retail.v2.SetInventoryRequest.set_mask]
     *           * Specifies only the desired fulfillment types and corresponding place IDs
     *           to update in [SetInventoryRequest.inventory.fulfillment_info][]
     *           The caller can clear all place IDs from a subset of fulfillment types in
     *           the following ways:
     *           * Adds "fulfillment_info" in
     *           [SetInventoryRequest.set_mask][google.cloud.retail.v2.SetInventoryRequest.set_mask]
     *           * Specifies only the desired fulfillment types to clear in
     *           [SetInventoryRequest.inventory.fulfillment_info][]
     *           * Checks that only the desired fulfillment info types have empty
     *           [SetInventoryRequest.inventory.fulfillment_info.place_ids][]
     *           The last update time is recorded for the following inventory fields:
     *           * [Product.price_info][google.cloud.retail.v2.Product.price_info]
     *           * [Product.availability][google.cloud.retail.v2.Product.availability]
     *           * [Product.available_quantity][google.cloud.retail.v2.Product.available_quantity]
     *           * [Product.fulfillment_info][google.cloud.retail.v2.Product.fulfillment_info]
     *           If a full overwrite of inventory information while ignoring timestamps is
     *           needed, [UpdateProduct][] should be invoked instead.
     *     @type \Google\Protobuf\FieldMask $set_mask
     *           Indicates which inventory fields in the provided
     *           [Product][google.cloud.retail.v2.Product] to update.
     *           At least one field must be provided.
     *           If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     *           is returned and the entire update will be ignored.
     *     @type \Google\Protobuf\Timestamp $set_time
     *           The time when the request is issued, used to prevent
     *           out-of-order updates on inventory fields with the last update time
     *           recorded. If not provided, the internal system time will be used.
     *     @type bool $allow_missing
     *           If set to true, and the [Product][google.cloud.retail.v2.Product] with name
     *           [Product.name][google.cloud.retail.v2.Product.name] is not found, the
     *           inventory update will still be processed and retained for at most 1 day
     *           until the [Product][google.cloud.retail.v2.Product] is created. If set to
     *           false, a NOT_FOUND error is returned if the
     *           [Product][google.cloud.retail.v2.Product] is not found.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\ProductService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The inventory information to update. The allowable fields to
     * update are:
     * * [Product.price_info][google.cloud.retail.v2.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2.Product.fulfillment_info]
     * The updated inventory fields must be specified in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2.SetInventoryRequest.set_mask].
     * If [SetInventoryRequest.inventory.name][] is empty or invalid, an
     * INVALID_ARGUMENT error is returned.
     * If the caller does not have permission to update the
     * [Product][google.cloud.retail.v2.Product] named in
     * [Product.name][google.cloud.retail.v2.Product.name], regardless of whether
     * or not it exists, a PERMISSION_DENIED error is returned.
     * If the [Product][google.cloud.retail.v2.Product] to update does not have
     * existing inventory information, the provided inventory information will be
     * inserted.
     * If the [Product][google.cloud.retail.v2.Product] to update has existing
     * inventory information, the provided inventory information will be merged
     * while respecting the last update time for each inventory field, using the
     * provided or default value for
     * [SetInventoryRequest.set_time][google.cloud.retail.v2.SetInventoryRequest.set_time].
     * The caller can replace place IDs for a subset of fulfillment types in the
     * following ways:
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types and corresponding place IDs
     * to update in [SetInventoryRequest.inventory.fulfillment_info][]
     * The caller can clear all place IDs from a subset of fulfillment types in
     * the following ways:
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types to clear in
     * [SetInventoryRequest.inventory.fulfillment_info][]
     * * Checks that only the desired fulfillment info types have empty
     * [SetInventoryRequest.inventory.fulfillment_info.place_ids][]
     * The last update time is recorded for the following inventory fields:
     * * [Product.price_info][google.cloud.retail.v2.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2.Product.fulfillment_info]
     * If a full overwrite of inventory information while ignoring timestamps is
     * needed, [UpdateProduct][] should be invoked instead.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.Product inventory = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Retail\V2\Product|null
     */
    public function getInventory()
    {
        return $this->inventory;
    }

    public function hasInventory()
    {
        return isset($this->inventory);
    }

    public function clearInventory()
    {
        unset($this->inventory);
    }

    /**
     * Required. The inventory information to update. The allowable fields to
     * update are:
     * * [Product.price_info][google.cloud.retail.v2.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2.Product.fulfillment_info]
     * The updated inventory fields must be specified in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2.SetInventoryRequest.set_mask].
     * If [SetInventoryRequest.inventory.name][] is empty or invalid, an
     * INVALID_ARGUMENT error is returned.
     * If the caller does not have permission to update the
     * [Product][google.cloud.retail.v2.Product] named in
     * [Product.name][google.cloud.retail.v2.Product.name], regardless of whether
     * or not it exists, a PERMISSION_DENIED error is returned.
     * If the [Product][google.cloud.retail.v2.Product] to update does not have
     * existing inventory information, the provided inventory information will be
     * inserted.
     * If the [Product][google.cloud.retail.v2.Product] to update has existing
     * inventory information, the provided inventory information will be merged
     * while respecting the last update time for each inventory field, using the
     * provided or default value for
     * [SetInventoryRequest.set_time][google.cloud.retail.v2.SetInventoryRequest.set_time].
     * The caller can replace place IDs for a subset of fulfillment types in the
     * following ways:
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types and corresponding place IDs
     * to update in [SetInventoryRequest.inventory.fulfillment_info][]
     * The caller can clear all place IDs from a subset of fulfillment types in
     * the following ways:
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types to clear in
     * [SetInventoryRequest.inventory.fulfillment_info][]
     * * Checks that only the desired fulfillment info types have empty
     * [SetInventoryRequest.inventory.fulfillment_info.place_ids][]
     * The last update time is recorded for the following inventory fields:
     * * [Product.price_info][google.cloud.retail.v2.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2.Product.fulfillment_info]
     * If a full overwrite of inventory information while ignoring timestamps is
     * needed, [UpdateProduct][] should be invoked instead.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.Product inventory = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Retail\V2\Product $var
     * @return $this
     */
    public function setInventory($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\Product::class);
        $this->inventory = $var;

        return $this;
    }

    /**
     * Indicates which inventory fields in the provided
     * [Product][google.cloud.retail.v2.Product] to update.
     * At least one field must be provided.
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask set_mask = 2;</code>
     * @return \Google\Protobuf\FieldMask|null
     */
    public function getSetMask()
    {
        return $this->set_mask;
    }

    public function hasSetMask()
    {
        return isset($this->set_mask);
    }

    public function clearSetMask()
    {
        unset($this->set_mask);
    }

    /**
     * Indicates which inventory fields in the provided
     * [Product][google.cloud.retail.v2.Product] to update.
     * At least one field must be provided.
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask set_mask = 2;</code>
     * @param \Google\Protobuf\FieldMask $var
     * @return $this
     */
    public function setSetMask($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\FieldMask::class);
        $this->set_mask = $var;

        return $this;
    }

    /**
     * The time when the request is issued, used to prevent
     * out-of-order updates on inventory fields with the last update time
     * recorded. If not provided, the internal system time will be used.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp set_time = 3;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getSetTime()
    {
        return $this->set_time;
    }

    public function hasSetTime()
    {
        return isset($this->set_time);
    }

    public function clearSetTime()
    {
        unset($this->set_time);
    }

    /**
     * The time when the request is issued, used to prevent
     * out-of-order updates on inventory fields with the last update time
     * recorded. If not provided, the internal system time will be used.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp set_time = 3;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setSetTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->set_time = $var;

        return $this;
    }

    /**
     * If set to true, and the [Product][google.cloud.retail.v2.Product] with name
     * [Product.name][google.cloud.retail.v2.Product.name] is not found, the
     * inventory update will still be processed and retained for at most 1 day
     * until the [Product][google.cloud.retail.v2.Product] is created. If set to
     * false, a NOT_FOUND error is returned if the
     * [Product][google.cloud.retail.v2.Product] is not found.
     *
     * Generated from protobuf field <code>bool allow_missing = 4;</code>
     * @return bool
     */
    public function getAllowMissing()
    {
        return $this->allow_missing;
    }

    /**
     * If set to true, and the [Product][google.cloud.retail.v2.Product] with name
     * [Product.name][google.cloud.retail.v2.Product.name] is not found, the
     * inventory update will still be processed and retained for at most 1 day
     * until the [Product][google.cloud.retail.v2.Product] is created. If set to
     * false, a NOT_FOUND error is returned if the
     * [Product][google.cloud.retail.v2.Product] is not found.
     *
     * Generated from protobuf field <code>bool allow_missing = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowMissing($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_missing = $var;

        return $this;
    }

}

