<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/datatransfer/v1/transfer.proto

namespace Google\Cloud\BigQuery\DataTransfer\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a data transfer configuration. A transfer configuration
 * contains all metadata needed to perform a data transfer. For example,
 * `destination_dataset_id` specifies where data should be stored.
 * When a new transfer configuration is created, the specified
 * `destination_dataset_id` is created when needed and shared with the
 * appropriate data source service account.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.datatransfer.v1.TransferConfig</code>
 */
class TransferConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the transfer config.
     * Transfer config names have the form
     * `projects/{project_id}/transferConfigs/{config_id}`.
     * Where `config_id` is usually a uuid, even though it is not
     * guaranteed or required. The name is ignored when creating a transfer
     * config.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * The BigQuery target dataset id.
     *
     * Generated from protobuf field <code>string destination_dataset_id = 2;</code>
     */
    private $destination_dataset_id = '';
    /**
     * User specified display name for the data transfer.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     */
    private $display_name = '';
    /**
     * Data source id. Cannot be changed once data transfer is created.
     *
     * Generated from protobuf field <code>string data_source_id = 5;</code>
     */
    private $data_source_id = '';
    /**
     * Data transfer specific parameters.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct params = 9;</code>
     */
    private $params = null;
    /**
     * Data transfer schedule.
     * If the data source does not support a custom schedule, this should be
     * empty. If it is empty, the default value for the data source will be
     * used.
     * The specified times are in UTC.
     * Examples of valid format:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     * See more explanation about the format here:
     * https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
     * NOTE: the granularity should be at least 8 hours, or less frequent.
     *
     * Generated from protobuf field <code>string schedule = 7;</code>
     */
    private $schedule = '';
    /**
     * The number of days to look back to automatically refresh the data.
     * For example, if `data_refresh_window_days = 10`, then every day
     * BigQuery reingests data for [today-10, today-1], rather than ingesting data
     * for just [today-1].
     * Only valid if the data source supports the feature. Set the value to  0
     * to use the default value.
     *
     * Generated from protobuf field <code>int32 data_refresh_window_days = 12;</code>
     */
    private $data_refresh_window_days = 0;
    /**
     * Is this config disabled. When set to true, no runs are scheduled
     * for a given transfer.
     *
     * Generated from protobuf field <code>bool disabled = 13;</code>
     */
    private $disabled = false;
    /**
     * Output only. Data transfer modification time. Ignored by server on input.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    private $update_time = null;
    /**
     * Output only. Next time when data transfer will run.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp next_run_time = 8;</code>
     */
    private $next_run_time = null;
    /**
     * Output only. State of the most recently updated transfer run.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.TransferState state = 10;</code>
     */
    private $state = 0;
    /**
     * Output only. Unique ID of the user on whose behalf transfer is done.
     * Applicable only to data sources that do not support service accounts.
     * When set to 0, the data source service account credentials are used.
     * May be negative. Note, that this identifier is not stable.
     * It may change over time even for the same user.
     *
     * Generated from protobuf field <code>int64 user_id = 11;</code>
     */
    private $user_id = 0;
    /**
     * Output only. Region in which BigQuery dataset is located.
     *
     * Generated from protobuf field <code>string dataset_region = 14;</code>
     */
    private $dataset_region = '';

    public function __construct() {
        \GPBMetadata\Google\Cloud\Bigquery\Datatransfer\V1\Transfer::initOnce();
        parent::__construct();
    }

    /**
     * The resource name of the transfer config.
     * Transfer config names have the form
     * `projects/{project_id}/transferConfigs/{config_id}`.
     * Where `config_id` is usually a uuid, even though it is not
     * guaranteed or required. The name is ignored when creating a transfer
     * config.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the transfer config.
     * Transfer config names have the form
     * `projects/{project_id}/transferConfigs/{config_id}`.
     * Where `config_id` is usually a uuid, even though it is not
     * guaranteed or required. The name is ignored when creating a transfer
     * config.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The BigQuery target dataset id.
     *
     * Generated from protobuf field <code>string destination_dataset_id = 2;</code>
     * @return string
     */
    public function getDestinationDatasetId()
    {
        return $this->destination_dataset_id;
    }

    /**
     * The BigQuery target dataset id.
     *
     * Generated from protobuf field <code>string destination_dataset_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDestinationDatasetId($var)
    {
        GPBUtil::checkString($var, True);
        $this->destination_dataset_id = $var;

        return $this;
    }

    /**
     * User specified display name for the data transfer.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * User specified display name for the data transfer.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Data source id. Cannot be changed once data transfer is created.
     *
     * Generated from protobuf field <code>string data_source_id = 5;</code>
     * @return string
     */
    public function getDataSourceId()
    {
        return $this->data_source_id;
    }

    /**
     * Data source id. Cannot be changed once data transfer is created.
     *
     * Generated from protobuf field <code>string data_source_id = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDataSourceId($var)
    {
        GPBUtil::checkString($var, True);
        $this->data_source_id = $var;

        return $this;
    }

    /**
     * Data transfer specific parameters.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct params = 9;</code>
     * @return \Google\Protobuf\Struct
     */
    public function getParams()
    {
        return $this->params;
    }

    /**
     * Data transfer specific parameters.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct params = 9;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setParams($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->params = $var;

        return $this;
    }

    /**
     * Data transfer schedule.
     * If the data source does not support a custom schedule, this should be
     * empty. If it is empty, the default value for the data source will be
     * used.
     * The specified times are in UTC.
     * Examples of valid format:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     * See more explanation about the format here:
     * https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
     * NOTE: the granularity should be at least 8 hours, or less frequent.
     *
     * Generated from protobuf field <code>string schedule = 7;</code>
     * @return string
     */
    public function getSchedule()
    {
        return $this->schedule;
    }

    /**
     * Data transfer schedule.
     * If the data source does not support a custom schedule, this should be
     * empty. If it is empty, the default value for the data source will be
     * used.
     * The specified times are in UTC.
     * Examples of valid format:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     * See more explanation about the format here:
     * https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
     * NOTE: the granularity should be at least 8 hours, or less frequent.
     *
     * Generated from protobuf field <code>string schedule = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setSchedule($var)
    {
        GPBUtil::checkString($var, True);
        $this->schedule = $var;

        return $this;
    }

    /**
     * The number of days to look back to automatically refresh the data.
     * For example, if `data_refresh_window_days = 10`, then every day
     * BigQuery reingests data for [today-10, today-1], rather than ingesting data
     * for just [today-1].
     * Only valid if the data source supports the feature. Set the value to  0
     * to use the default value.
     *
     * Generated from protobuf field <code>int32 data_refresh_window_days = 12;</code>
     * @return int
     */
    public function getDataRefreshWindowDays()
    {
        return $this->data_refresh_window_days;
    }

    /**
     * The number of days to look back to automatically refresh the data.
     * For example, if `data_refresh_window_days = 10`, then every day
     * BigQuery reingests data for [today-10, today-1], rather than ingesting data
     * for just [today-1].
     * Only valid if the data source supports the feature. Set the value to  0
     * to use the default value.
     *
     * Generated from protobuf field <code>int32 data_refresh_window_days = 12;</code>
     * @param int $var
     * @return $this
     */
    public function setDataRefreshWindowDays($var)
    {
        GPBUtil::checkInt32($var);
        $this->data_refresh_window_days = $var;

        return $this;
    }

    /**
     * Is this config disabled. When set to true, no runs are scheduled
     * for a given transfer.
     *
     * Generated from protobuf field <code>bool disabled = 13;</code>
     * @return bool
     */
    public function getDisabled()
    {
        return $this->disabled;
    }

    /**
     * Is this config disabled. When set to true, no runs are scheduled
     * for a given transfer.
     *
     * Generated from protobuf field <code>bool disabled = 13;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisabled($var)
    {
        GPBUtil::checkBool($var);
        $this->disabled = $var;

        return $this;
    }

    /**
     * Output only. Data transfer modification time. Ignored by server on input.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    /**
     * Output only. Data transfer modification time. Ignored by server on input.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. Next time when data transfer will run.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp next_run_time = 8;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getNextRunTime()
    {
        return $this->next_run_time;
    }

    /**
     * Output only. Next time when data transfer will run.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp next_run_time = 8;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setNextRunTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->next_run_time = $var;

        return $this;
    }

    /**
     * Output only. State of the most recently updated transfer run.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.TransferState state = 10;</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. State of the most recently updated transfer run.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.TransferState state = 10;</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BigQuery\DataTransfer\V1\TransferState::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Unique ID of the user on whose behalf transfer is done.
     * Applicable only to data sources that do not support service accounts.
     * When set to 0, the data source service account credentials are used.
     * May be negative. Note, that this identifier is not stable.
     * It may change over time even for the same user.
     *
     * Generated from protobuf field <code>int64 user_id = 11;</code>
     * @return int|string
     */
    public function getUserId()
    {
        return $this->user_id;
    }

    /**
     * Output only. Unique ID of the user on whose behalf transfer is done.
     * Applicable only to data sources that do not support service accounts.
     * When set to 0, the data source service account credentials are used.
     * May be negative. Note, that this identifier is not stable.
     * It may change over time even for the same user.
     *
     * Generated from protobuf field <code>int64 user_id = 11;</code>
     * @param int|string $var
     * @return $this
     */
    public function setUserId($var)
    {
        GPBUtil::checkInt64($var);
        $this->user_id = $var;

        return $this;
    }

    /**
     * Output only. Region in which BigQuery dataset is located.
     *
     * Generated from protobuf field <code>string dataset_region = 14;</code>
     * @return string
     */
    public function getDatasetRegion()
    {
        return $this->dataset_region;
    }

    /**
     * Output only. Region in which BigQuery dataset is located.
     *
     * Generated from protobuf field <code>string dataset_region = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setDatasetRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->dataset_region = $var;

        return $this;
    }

}

