<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/gkebackup/v1/gkebackup.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\GkeBackup\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\GkeBackup\V1\Backup;
use Google\Cloud\GkeBackup\V1\BackupPlan;
use Google\Cloud\GkeBackup\V1\CreateBackupPlanRequest;
use Google\Cloud\GkeBackup\V1\CreateBackupRequest;
use Google\Cloud\GkeBackup\V1\CreateRestorePlanRequest;
use Google\Cloud\GkeBackup\V1\CreateRestoreRequest;
use Google\Cloud\GkeBackup\V1\DeleteBackupPlanRequest;
use Google\Cloud\GkeBackup\V1\DeleteBackupRequest;
use Google\Cloud\GkeBackup\V1\DeleteRestorePlanRequest;
use Google\Cloud\GkeBackup\V1\DeleteRestoreRequest;
use Google\Cloud\GkeBackup\V1\GetBackupPlanRequest;
use Google\Cloud\GkeBackup\V1\GetBackupRequest;
use Google\Cloud\GkeBackup\V1\GetRestorePlanRequest;
use Google\Cloud\GkeBackup\V1\GetRestoreRequest;
use Google\Cloud\GkeBackup\V1\GetVolumeBackupRequest;
use Google\Cloud\GkeBackup\V1\GetVolumeRestoreRequest;
use Google\Cloud\GkeBackup\V1\ListBackupPlansRequest;
use Google\Cloud\GkeBackup\V1\ListBackupPlansResponse;
use Google\Cloud\GkeBackup\V1\ListBackupsRequest;
use Google\Cloud\GkeBackup\V1\ListBackupsResponse;
use Google\Cloud\GkeBackup\V1\ListRestorePlansRequest;
use Google\Cloud\GkeBackup\V1\ListRestorePlansResponse;
use Google\Cloud\GkeBackup\V1\ListRestoresRequest;
use Google\Cloud\GkeBackup\V1\ListRestoresResponse;
use Google\Cloud\GkeBackup\V1\ListVolumeBackupsRequest;
use Google\Cloud\GkeBackup\V1\ListVolumeBackupsResponse;
use Google\Cloud\GkeBackup\V1\ListVolumeRestoresRequest;
use Google\Cloud\GkeBackup\V1\ListVolumeRestoresResponse;
use Google\Cloud\GkeBackup\V1\Restore;
use Google\Cloud\GkeBackup\V1\RestorePlan;
use Google\Cloud\GkeBackup\V1\UpdateBackupPlanRequest;
use Google\Cloud\GkeBackup\V1\UpdateBackupRequest;
use Google\Cloud\GkeBackup\V1\UpdateRestorePlanRequest;
use Google\Cloud\GkeBackup\V1\UpdateRestoreRequest;
use Google\Cloud\GkeBackup\V1\VolumeBackup;
use Google\Cloud\GkeBackup\V1\VolumeRestore;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: BackupForGKE allows Kubernetes administrators to configure, execute, and
 * manage backup and restore operations for their GKE clusters.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $backupForGKEClient = new BackupForGKEClient();
 * try {
 *     $formattedParent = $backupForGKEClient->backupPlanName('[PROJECT]', '[LOCATION]', '[BACKUP_PLAN]');
 *     $operationResponse = $backupForGKEClient->createBackup($formattedParent);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $backupForGKEClient->createBackup($formattedParent);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $backupForGKEClient->resumeOperation($operationName, 'createBackup');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $backupForGKEClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class BackupForGKEGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.gkebackup.v1.BackupForGKE';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'gkebackup.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $backupNameTemplate;

    private static $backupPlanNameTemplate;

    private static $clusterNameTemplate;

    private static $cryptoKeyNameTemplate;

    private static $locationNameTemplate;

    private static $restoreNameTemplate;

    private static $restorePlanNameTemplate;

    private static $volumeBackupNameTemplate;

    private static $volumeRestoreNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/backup_for_gke_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/backup_for_gke_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/backup_for_gke_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/backup_for_gke_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getBackupNameTemplate()
    {
        if (self::$backupNameTemplate == null) {
            self::$backupNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/backupPlans/{backup_plan}/backups/{backup}'
            );
        }

        return self::$backupNameTemplate;
    }

    private static function getBackupPlanNameTemplate()
    {
        if (self::$backupPlanNameTemplate == null) {
            self::$backupPlanNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/backupPlans/{backup_plan}'
            );
        }

        return self::$backupPlanNameTemplate;
    }

    private static function getClusterNameTemplate()
    {
        if (self::$clusterNameTemplate == null) {
            self::$clusterNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/clusters/{cluster}'
            );
        }

        return self::$clusterNameTemplate;
    }

    private static function getCryptoKeyNameTemplate()
    {
        if (self::$cryptoKeyNameTemplate == null) {
            self::$cryptoKeyNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}'
            );
        }

        return self::$cryptoKeyNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getRestoreNameTemplate()
    {
        if (self::$restoreNameTemplate == null) {
            self::$restoreNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/restorePlans/{restore_plan}/restores/{restore}'
            );
        }

        return self::$restoreNameTemplate;
    }

    private static function getRestorePlanNameTemplate()
    {
        if (self::$restorePlanNameTemplate == null) {
            self::$restorePlanNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/restorePlans/{restore_plan}'
            );
        }

        return self::$restorePlanNameTemplate;
    }

    private static function getVolumeBackupNameTemplate()
    {
        if (self::$volumeBackupNameTemplate == null) {
            self::$volumeBackupNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/backupPlans/{backup_plan}/backups/{backup}/volumeBackups/{volume_backup}'
            );
        }

        return self::$volumeBackupNameTemplate;
    }

    private static function getVolumeRestoreNameTemplate()
    {
        if (self::$volumeRestoreNameTemplate == null) {
            self::$volumeRestoreNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/restorePlans/{restore_plan}/restores/{restore}/volumeRestores/{volume_restore}'
            );
        }

        return self::$volumeRestoreNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'backup' => self::getBackupNameTemplate(),
                'backupPlan' => self::getBackupPlanNameTemplate(),
                'cluster' => self::getClusterNameTemplate(),
                'cryptoKey' => self::getCryptoKeyNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'restore' => self::getRestoreNameTemplate(),
                'restorePlan' => self::getRestorePlanNameTemplate(),
                'volumeBackup' => self::getVolumeBackupNameTemplate(),
                'volumeRestore' => self::getVolumeRestoreNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backupPlan
     * @param string $backup
     *
     * @return string The formatted backup resource.
     */
    public static function backupName($project, $location, $backupPlan, $backup)
    {
        return self::getBackupNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'backup_plan' => $backupPlan,
            'backup' => $backup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup_plan
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backupPlan
     *
     * @return string The formatted backup_plan resource.
     */
    public static function backupPlanName($project, $location, $backupPlan)
    {
        return self::getBackupPlanNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'backup_plan' => $backupPlan,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cluster
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     *
     * @return string The formatted cluster resource.
     */
    public static function clusterName($project, $location, $cluster)
    {
        return self::getClusterNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a crypto_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     *
     * @return string The formatted crypto_key resource.
     */
    public static function cryptoKeyName(
        $project,
        $location,
        $keyRing,
        $cryptoKey
    ) {
        return self::getCryptoKeyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a restore
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $restorePlan
     * @param string $restore
     *
     * @return string The formatted restore resource.
     */
    public static function restoreName(
        $project,
        $location,
        $restorePlan,
        $restore
    ) {
        return self::getRestoreNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'restore_plan' => $restorePlan,
            'restore' => $restore,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a restore_plan
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $restorePlan
     *
     * @return string The formatted restore_plan resource.
     */
    public static function restorePlanName($project, $location, $restorePlan)
    {
        return self::getRestorePlanNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'restore_plan' => $restorePlan,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * volume_backup resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backupPlan
     * @param string $backup
     * @param string $volumeBackup
     *
     * @return string The formatted volume_backup resource.
     */
    public static function volumeBackupName(
        $project,
        $location,
        $backupPlan,
        $backup,
        $volumeBackup
    ) {
        return self::getVolumeBackupNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'backup_plan' => $backupPlan,
            'backup' => $backup,
            'volume_backup' => $volumeBackup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * volume_restore resource.
     *
     * @param string $project
     * @param string $location
     * @param string $restorePlan
     * @param string $restore
     * @param string $volumeRestore
     *
     * @return string The formatted volume_restore resource.
     */
    public static function volumeRestoreName(
        $project,
        $location,
        $restorePlan,
        $restore,
        $volumeRestore
    ) {
        return self::getVolumeRestoreNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'restore_plan' => $restorePlan,
            'restore' => $restore,
            'volume_restore' => $volumeRestore,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - backup: projects/{project}/locations/{location}/backupPlans/{backup_plan}/backups/{backup}
     * - backupPlan: projects/{project}/locations/{location}/backupPlans/{backup_plan}
     * - cluster: projects/{project}/locations/{location}/clusters/{cluster}
     * - cryptoKey: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}
     * - location: projects/{project}/locations/{location}
     * - restore: projects/{project}/locations/{location}/restorePlans/{restore_plan}/restores/{restore}
     * - restorePlan: projects/{project}/locations/{location}/restorePlans/{restore_plan}
     * - volumeBackup: projects/{project}/locations/{location}/backupPlans/{backup_plan}/backups/{backup}/volumeBackups/{volume_backup}
     * - volumeRestore: projects/{project}/locations/{location}/restorePlans/{restore_plan}/restores/{restore}/volumeRestores/{volume_restore}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'gkebackup.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a Backup for the given BackupPlan.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedParent = $backupForGKEClient->backupPlanName('[PROJECT]', '[LOCATION]', '[BACKUP_PLAN]');
     *     $operationResponse = $backupForGKEClient->createBackup($formattedParent);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $backupForGKEClient->createBackup($formattedParent);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $backupForGKEClient->resumeOperation($operationName, 'createBackup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The BackupPlan within which to create the Backup.
     *                             Format: projects/&#42;/locations/&#42;/backupPlans/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type Backup $backup
     *           The Backup resource to create.
     *     @type string $backupId
     *           The client-provided short name for the Backup resource.
     *           This name must:
     *
     *           - be between 1 and 63 characters long (inclusive)
     *           - consist of only lower-case ASCII letters, numbers, and dashes
     *           - start with a lower-case letter
     *           - end with a lower-case letter or number
     *           - be unique within the set of Backups in this BackupPlan
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createBackup($parent, array $optionalArgs = [])
    {
        $request = new CreateBackupRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['backup'])) {
            $request->setBackup($optionalArgs['backup']);
        }

        if (isset($optionalArgs['backupId'])) {
            $request->setBackupId($optionalArgs['backupId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateBackup',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new BackupPlan in a given location.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedParent = $backupForGKEClient->locationName('[PROJECT]', '[LOCATION]');
     *     $backupPlan = new BackupPlan();
     *     $backupPlanId = 'backup_plan_id';
     *     $operationResponse = $backupForGKEClient->createBackupPlan($formattedParent, $backupPlan, $backupPlanId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $backupForGKEClient->createBackupPlan($formattedParent, $backupPlan, $backupPlanId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $backupForGKEClient->resumeOperation($operationName, 'createBackupPlan');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The location within which to create the BackupPlan.
     *                                 Format: projects/&#42;/locations/*
     * @param BackupPlan $backupPlan   Required. The BackupPlan resource object to create.
     * @param string     $backupPlanId Required. The client-provided short name for the BackupPlan resource.
     *                                 This name must:
     *
     *                                 - be between 1 and 63 characters long (inclusive)
     *                                 - consist of only lower-case ASCII letters, numbers, and dashes
     *                                 - start with a lower-case letter
     *                                 - end with a lower-case letter or number
     *                                 - be unique within the set of BackupPlans in this location
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createBackupPlan(
        $parent,
        $backupPlan,
        $backupPlanId,
        array $optionalArgs = []
    ) {
        $request = new CreateBackupPlanRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setBackupPlan($backupPlan);
        $request->setBackupPlanId($backupPlanId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateBackupPlan',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new Restore for the given RestorePlan.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedParent = $backupForGKEClient->restorePlanName('[PROJECT]', '[LOCATION]', '[RESTORE_PLAN]');
     *     $restore = new Restore();
     *     $restoreId = 'restore_id';
     *     $operationResponse = $backupForGKEClient->createRestore($formattedParent, $restore, $restoreId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $backupForGKEClient->createRestore($formattedParent, $restore, $restoreId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $backupForGKEClient->resumeOperation($operationName, 'createRestore');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The RestorePlan within which to create the Restore.
     *                              Format: projects/&#42;/locations/&#42;/restorePlans/*
     * @param Restore $restore      Required. The restore resource to create.
     * @param string  $restoreId    Required. The client-provided short name for the Restore resource.
     *                              This name must:
     *
     *                              - be between 1 and 63 characters long (inclusive)
     *                              - consist of only lower-case ASCII letters, numbers, and dashes
     *                              - start with a lower-case letter
     *                              - end with a lower-case letter or number
     *                              - be unique within the set of Restores in this RestorePlan.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createRestore(
        $parent,
        $restore,
        $restoreId,
        array $optionalArgs = []
    ) {
        $request = new CreateRestoreRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRestore($restore);
        $request->setRestoreId($restoreId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateRestore',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new RestorePlan in a given location.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedParent = $backupForGKEClient->locationName('[PROJECT]', '[LOCATION]');
     *     $restorePlan = new RestorePlan();
     *     $restorePlanId = 'restore_plan_id';
     *     $operationResponse = $backupForGKEClient->createRestorePlan($formattedParent, $restorePlan, $restorePlanId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $backupForGKEClient->createRestorePlan($formattedParent, $restorePlan, $restorePlanId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $backupForGKEClient->resumeOperation($operationName, 'createRestorePlan');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string      $parent        Required. The location within which to create the RestorePlan.
     *                                   Format: projects/&#42;/locations/*
     * @param RestorePlan $restorePlan   Required. The RestorePlan resource object to create.
     * @param string      $restorePlanId Required. The client-provided short name for the RestorePlan resource.
     *                                   This name must:
     *
     *                                   - be between 1 and 63 characters long (inclusive)
     *                                   - consist of only lower-case ASCII letters, numbers, and dashes
     *                                   - start with a lower-case letter
     *                                   - end with a lower-case letter or number
     *                                   - be unique within the set of RestorePlans in this location
     * @param array       $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createRestorePlan(
        $parent,
        $restorePlan,
        $restorePlanId,
        array $optionalArgs = []
    ) {
        $request = new CreateRestorePlanRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRestorePlan($restorePlan);
        $request->setRestorePlanId($restorePlanId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateRestorePlan',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes an existing Backup.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedName = $backupForGKEClient->backupName('[PROJECT]', '[LOCATION]', '[BACKUP_PLAN]', '[BACKUP]');
     *     $operationResponse = $backupForGKEClient->deleteBackup($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $backupForGKEClient->deleteBackup($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $backupForGKEClient->resumeOperation($operationName, 'deleteBackup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the Backup resource.
     *                             Format: projects/&#42;/locations/&#42;/backupPlans/&#42;/backups/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           If provided, this value must match the current value of the
     *           target Backup's [etag][google.cloud.gkebackup.v1.Backup.etag] field or the request is
     *           rejected.
     *     @type bool $force
     *           If set to true, any VolumeBackups below this Backup will also be deleted.
     *           Otherwise, the request will only succeed if the Backup has no
     *           VolumeBackups.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteBackup($name, array $optionalArgs = [])
    {
        $request = new DeleteBackupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteBackup',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes an existing BackupPlan.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedName = $backupForGKEClient->backupPlanName('[PROJECT]', '[LOCATION]', '[BACKUP_PLAN]');
     *     $operationResponse = $backupForGKEClient->deleteBackupPlan($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $backupForGKEClient->deleteBackupPlan($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $backupForGKEClient->resumeOperation($operationName, 'deleteBackupPlan');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Fully qualified BackupPlan name.
     *                             Format: projects/&#42;/locations/&#42;/backupPlans/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           If provided, this value must match the current value of the
     *           target BackupPlan's [etag][google.cloud.gkebackup.v1.BackupPlan.etag] field or the request is
     *           rejected.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteBackupPlan($name, array $optionalArgs = [])
    {
        $request = new DeleteBackupPlanRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteBackupPlan',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes an existing Restore.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedName = $backupForGKEClient->restoreName('[PROJECT]', '[LOCATION]', '[RESTORE_PLAN]', '[RESTORE]');
     *     $operationResponse = $backupForGKEClient->deleteRestore($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $backupForGKEClient->deleteRestore($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $backupForGKEClient->resumeOperation($operationName, 'deleteRestore');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Full name of the Restore
     *                             Format: projects/&#42;/locations/&#42;/restorePlans/&#42;/restores/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           If provided, this value must match the current value of the
     *           target Restore's [etag][google.cloud.gkebackup.v1.Restore.etag] field or the request is
     *           rejected.
     *     @type bool $force
     *           If set to true, any VolumeRestores below this restore will also be deleted.
     *           Otherwise, the request will only succeed if the restore has no
     *           VolumeRestores.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteRestore($name, array $optionalArgs = [])
    {
        $request = new DeleteRestoreRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteRestore',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes an existing RestorePlan.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedName = $backupForGKEClient->restorePlanName('[PROJECT]', '[LOCATION]', '[RESTORE_PLAN]');
     *     $operationResponse = $backupForGKEClient->deleteRestorePlan($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $backupForGKEClient->deleteRestorePlan($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $backupForGKEClient->resumeOperation($operationName, 'deleteRestorePlan');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Fully qualified RestorePlan name.
     *                             Format: projects/&#42;/locations/&#42;/restorePlans/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           If provided, this value must match the current value of the
     *           target RestorePlan's [etag][google.cloud.gkebackup.v1.RestorePlan.etag] field or the request is
     *           rejected.
     *     @type bool $force
     *           If set to true, any Restores below this RestorePlan will also be deleted.
     *           Otherwise, the request will only succeed if the RestorePlan has no
     *           Restores.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteRestorePlan($name, array $optionalArgs = [])
    {
        $request = new DeleteRestorePlanRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteRestorePlan',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Retrieve the details of a single Backup.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedName = $backupForGKEClient->backupName('[PROJECT]', '[LOCATION]', '[BACKUP_PLAN]', '[BACKUP]');
     *     $response = $backupForGKEClient->getBackup($formattedName);
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Full name of the Backup resource.
     *                             Format: projects/&#42;/locations/&#42;/backupPlans/&#42;/backups/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeBackup\V1\Backup
     *
     * @throws ApiException if the remote call fails
     */
    public function getBackup($name, array $optionalArgs = [])
    {
        $request = new GetBackupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetBackup',
            Backup::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieve the details of a single BackupPlan.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedName = $backupForGKEClient->backupPlanName('[PROJECT]', '[LOCATION]', '[BACKUP_PLAN]');
     *     $response = $backupForGKEClient->getBackupPlan($formattedName);
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Fully qualified BackupPlan name.
     *                             Format: projects/&#42;/locations/&#42;/backupPlans/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeBackup\V1\BackupPlan
     *
     * @throws ApiException if the remote call fails
     */
    public function getBackupPlan($name, array $optionalArgs = [])
    {
        $request = new GetBackupPlanRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetBackupPlan',
            BackupPlan::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves the details of a single Restore.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedName = $backupForGKEClient->restoreName('[PROJECT]', '[LOCATION]', '[RESTORE_PLAN]', '[RESTORE]');
     *     $response = $backupForGKEClient->getRestore($formattedName);
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the restore resource.
     *                             Format: projects/&#42;/locations/&#42;/restorePlans/&#42;/restores/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeBackup\V1\Restore
     *
     * @throws ApiException if the remote call fails
     */
    public function getRestore($name, array $optionalArgs = [])
    {
        $request = new GetRestoreRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetRestore',
            Restore::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieve the details of a single RestorePlan.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedName = $backupForGKEClient->restorePlanName('[PROJECT]', '[LOCATION]', '[RESTORE_PLAN]');
     *     $response = $backupForGKEClient->getRestorePlan($formattedName);
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Fully qualified RestorePlan name.
     *                             Format: projects/&#42;/locations/&#42;/restorePlans/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeBackup\V1\RestorePlan
     *
     * @throws ApiException if the remote call fails
     */
    public function getRestorePlan($name, array $optionalArgs = [])
    {
        $request = new GetRestorePlanRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetRestorePlan',
            RestorePlan::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieve the details of a single VolumeBackup.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedName = $backupForGKEClient->volumeBackupName('[PROJECT]', '[LOCATION]', '[BACKUP_PLAN]', '[BACKUP]', '[VOLUME_BACKUP]');
     *     $response = $backupForGKEClient->getVolumeBackup($formattedName);
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Full name of the VolumeBackup resource.
     *                             Format: projects/&#42;/locations/&#42;/backupPlans/&#42;/backups/&#42;/volumeBackups/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeBackup\V1\VolumeBackup
     *
     * @throws ApiException if the remote call fails
     */
    public function getVolumeBackup($name, array $optionalArgs = [])
    {
        $request = new GetVolumeBackupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetVolumeBackup',
            VolumeBackup::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieve the details of a single VolumeRestore.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedName = $backupForGKEClient->volumeRestoreName('[PROJECT]', '[LOCATION]', '[RESTORE_PLAN]', '[RESTORE]', '[VOLUME_RESTORE]');
     *     $response = $backupForGKEClient->getVolumeRestore($formattedName);
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Full name of the VolumeRestore resource.
     *                             Format: projects/&#42;/locations/&#42;/restorePlans/&#42;/restores/&#42;/volumeRestores/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeBackup\V1\VolumeRestore
     *
     * @throws ApiException if the remote call fails
     */
    public function getVolumeRestore($name, array $optionalArgs = [])
    {
        $request = new GetVolumeRestoreRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetVolumeRestore',
            VolumeRestore::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists BackupPlans in a given location.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedParent = $backupForGKEClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $backupForGKEClient->listBackupPlans($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $backupForGKEClient->listBackupPlans($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The location that contains the BackupPlans to list.
     *                             Format: projects/&#42;/locations/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Field match expression used to filter the results.
     *     @type string $orderBy
     *           Field by which to sort the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listBackupPlans($parent, array $optionalArgs = [])
    {
        $request = new ListBackupPlansRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListBackupPlans',
            $optionalArgs,
            ListBackupPlansResponse::class,
            $request
        );
    }

    /**
     * Lists the Backups for a given BackupPlan.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedParent = $backupForGKEClient->backupPlanName('[PROJECT]', '[LOCATION]', '[BACKUP_PLAN]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $backupForGKEClient->listBackups($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $backupForGKEClient->listBackups($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The BackupPlan that contains the Backups to list.
     *                             Format: projects/&#42;/locations/&#42;/backupPlans/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Field match expression used to filter the results.
     *     @type string $orderBy
     *           Field by which to sort the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listBackups($parent, array $optionalArgs = [])
    {
        $request = new ListBackupsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListBackups',
            $optionalArgs,
            ListBackupsResponse::class,
            $request
        );
    }

    /**
     * Lists RestorePlans in a given location.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedParent = $backupForGKEClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $backupForGKEClient->listRestorePlans($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $backupForGKEClient->listRestorePlans($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The location that contains the RestorePlans to list.
     *                             Format: projects/&#42;/locations/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Field match expression used to filter the results.
     *     @type string $orderBy
     *           Field by which to sort the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listRestorePlans($parent, array $optionalArgs = [])
    {
        $request = new ListRestorePlansRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListRestorePlans',
            $optionalArgs,
            ListRestorePlansResponse::class,
            $request
        );
    }

    /**
     * Lists the Restores for a given RestorePlan.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedParent = $backupForGKEClient->restorePlanName('[PROJECT]', '[LOCATION]', '[RESTORE_PLAN]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $backupForGKEClient->listRestores($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $backupForGKEClient->listRestores($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The RestorePlan that contains the Restores to list.
     *                             Format: projects/&#42;/locations/&#42;/restorePlans/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Field match expression used to filter the results.
     *     @type string $orderBy
     *           Field by which to sort the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listRestores($parent, array $optionalArgs = [])
    {
        $request = new ListRestoresRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListRestores',
            $optionalArgs,
            ListRestoresResponse::class,
            $request
        );
    }

    /**
     * Lists the VolumeBackups for a given Backup.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedParent = $backupForGKEClient->backupName('[PROJECT]', '[LOCATION]', '[BACKUP_PLAN]', '[BACKUP]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $backupForGKEClient->listVolumeBackups($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $backupForGKEClient->listVolumeBackups($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The Backup that contains the VolumeBackups to list.
     *                             Format: projects/&#42;/locations/&#42;/backupPlans/&#42;/backups/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Field match expression used to filter the results.
     *     @type string $orderBy
     *           Field by which to sort the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listVolumeBackups($parent, array $optionalArgs = [])
    {
        $request = new ListVolumeBackupsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListVolumeBackups',
            $optionalArgs,
            ListVolumeBackupsResponse::class,
            $request
        );
    }

    /**
     * Lists the VolumeRestores for a given Restore.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $formattedParent = $backupForGKEClient->restoreName('[PROJECT]', '[LOCATION]', '[RESTORE_PLAN]', '[RESTORE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $backupForGKEClient->listVolumeRestores($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $backupForGKEClient->listVolumeRestores($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The Restore that contains the VolumeRestores to list.
     *                             Format: projects/&#42;/locations/&#42;/restorePlans/&#42;/restores/*
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Field match expression used to filter the results.
     *     @type string $orderBy
     *           Field by which to sort the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listVolumeRestores($parent, array $optionalArgs = [])
    {
        $request = new ListVolumeRestoresRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListVolumeRestores',
            $optionalArgs,
            ListVolumeRestoresResponse::class,
            $request
        );
    }

    /**
     * Update a Backup.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $backup = new Backup();
     *     $operationResponse = $backupForGKEClient->updateBackup($backup);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $backupForGKEClient->updateBackup($backup);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $backupForGKEClient->resumeOperation($operationName, 'updateBackup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param Backup $backup       Required. A new version of the Backup resource that contains updated fields.
     *                             This may be sparsely populated if an `update_mask` is provided.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           This is used to specify the fields to be overwritten in the
     *           Backup targeted for update. The values for each of these
     *           updated fields will be taken from the `backup_plan` provided
     *           with this request. Field names are relative to the root of the resource.
     *           If no `update_mask` is provided, all fields in `backup` will be
     *           written to the target Backup resource.
     *           Note that OUTPUT_ONLY and IMMUTABLE fields in `backup` are ignored
     *           and are not used to update the target Backup.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateBackup($backup, array $optionalArgs = [])
    {
        $request = new UpdateBackupRequest();
        $requestParamHeaders = [];
        $request->setBackup($backup);
        $requestParamHeaders['backup.name'] = $backup->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateBackup',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Update a BackupPlan.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $backupPlan = new BackupPlan();
     *     $operationResponse = $backupForGKEClient->updateBackupPlan($backupPlan);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $backupForGKEClient->updateBackupPlan($backupPlan);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $backupForGKEClient->resumeOperation($operationName, 'updateBackupPlan');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param BackupPlan $backupPlan   Required. A new version of the BackupPlan resource that contains updated fields.
     *                                 This may be sparsely populated if an `update_mask` is provided.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           This is used to specify the fields to be overwritten in the
     *           BackupPlan targeted for update. The values for each of these
     *           updated fields will be taken from the `backup_plan` provided
     *           with this request. Field names are relative to the root of the resource
     *           (e.g., `description`, `backup_config.include_volume_data`, etc.)
     *           If no `update_mask` is provided, all fields in `backup_plan` will be
     *           written to the target BackupPlan resource.
     *           Note that OUTPUT_ONLY and IMMUTABLE fields in `backup_plan` are ignored
     *           and are not used to update the target BackupPlan.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateBackupPlan($backupPlan, array $optionalArgs = [])
    {
        $request = new UpdateBackupPlanRequest();
        $requestParamHeaders = [];
        $request->setBackupPlan($backupPlan);
        $requestParamHeaders['backup_plan.name'] = $backupPlan->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateBackupPlan',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Update a Restore.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $restore = new Restore();
     *     $operationResponse = $backupForGKEClient->updateRestore($restore);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $backupForGKEClient->updateRestore($restore);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $backupForGKEClient->resumeOperation($operationName, 'updateRestore');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param Restore $restore      Required. A new version of the Restore resource that contains updated fields.
     *                              This may be sparsely populated if an `update_mask` is provided.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           This is used to specify the fields to be overwritten in the
     *           Restore targeted for update. The values for each of these
     *           updated fields will be taken from the `restore` provided
     *           with this request. Field names are relative to the root of the resource.
     *           If no `update_mask` is provided, all fields in `restore` will be
     *           written to the target Restore resource.
     *           Note that OUTPUT_ONLY and IMMUTABLE fields in `restore` are ignored
     *           and are not used to update the target Restore.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateRestore($restore, array $optionalArgs = [])
    {
        $request = new UpdateRestoreRequest();
        $requestParamHeaders = [];
        $request->setRestore($restore);
        $requestParamHeaders['restore.name'] = $restore->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateRestore',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Update a RestorePlan.
     *
     * Sample code:
     * ```
     * $backupForGKEClient = new BackupForGKEClient();
     * try {
     *     $restorePlan = new RestorePlan();
     *     $operationResponse = $backupForGKEClient->updateRestorePlan($restorePlan);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $backupForGKEClient->updateRestorePlan($restorePlan);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $backupForGKEClient->resumeOperation($operationName, 'updateRestorePlan');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $backupForGKEClient->close();
     * }
     * ```
     *
     * @param RestorePlan $restorePlan  Required. A new version of the RestorePlan resource that contains updated fields.
     *                                  This may be sparsely populated if an `update_mask` is provided.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           This is used to specify the fields to be overwritten in the
     *           RestorePlan targeted for update. The values for each of these
     *           updated fields will be taken from the `restore_plan` provided
     *           with this request. Field names are relative to the root of the resource.
     *           If no `update_mask` is provided, all fields in `restore_plan` will be
     *           written to the target RestorePlan resource.
     *           Note that OUTPUT_ONLY and IMMUTABLE fields in `restore_plan` are ignored
     *           and are not used to update the target RestorePlan.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateRestorePlan($restorePlan, array $optionalArgs = [])
    {
        $request = new UpdateRestorePlanRequest();
        $requestParamHeaders = [];
        $request->setRestorePlan($restorePlan);
        $requestParamHeaders['restore_plan.name'] = $restorePlan->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateRestorePlan',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }
}
