<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/datacatalog/v1/policytagmanager.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\DataCatalog\V1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\DataCatalog\V1\CreatePolicyTagRequest;
use Google\Cloud\DataCatalog\V1\CreateTaxonomyRequest;
use Google\Cloud\DataCatalog\V1\DeletePolicyTagRequest;
use Google\Cloud\DataCatalog\V1\DeleteTaxonomyRequest;
use Google\Cloud\DataCatalog\V1\GetPolicyTagRequest;
use Google\Cloud\DataCatalog\V1\GetTaxonomyRequest;
use Google\Cloud\DataCatalog\V1\ListPolicyTagsRequest;
use Google\Cloud\DataCatalog\V1\ListTaxonomiesRequest;
use Google\Cloud\DataCatalog\V1\PolicyTag;
use Google\Cloud\DataCatalog\V1\Taxonomy;
use Google\Cloud\DataCatalog\V1\UpdatePolicyTagRequest;
use Google\Cloud\DataCatalog\V1\UpdateTaxonomyRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Policy Tag Manager API service allows you to manage your policy tags and
 * taxonomies.
 *
 * Policy tags are used to tag BigQuery columns and apply additional access
 * control policies. A taxonomy is a hierarchical grouping of policy tags that
 * classify data along a common axis.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes.
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface createPolicyTagAsync(CreatePolicyTagRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createTaxonomyAsync(CreateTaxonomyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deletePolicyTagAsync(DeletePolicyTagRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteTaxonomyAsync(DeleteTaxonomyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getPolicyTagAsync(GetPolicyTagRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getTaxonomyAsync(GetTaxonomyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPolicyTagsAsync(ListPolicyTagsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listTaxonomiesAsync(ListTaxonomiesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updatePolicyTagAsync(UpdatePolicyTagRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateTaxonomyAsync(UpdateTaxonomyRequest $request, array $optionalArgs = [])
 */
abstract class PolicyTagManagerBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.datacatalog.v1.PolicyTagManager';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'datacatalog.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/policy_tag_manager_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/policy_tag_manager_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/policy_tag_manager_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/policy_tag_manager_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a policy_tag
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $taxonomy
     * @param string $policyTag
     *
     * @return string The formatted policy_tag resource.
     */
    public static function policyTagName(string $project, string $location, string $taxonomy, string $policyTag): string
    {
        return self::getPathTemplate('policyTag')->render([
            'project' => $project,
            'location' => $location,
            'taxonomy' => $taxonomy,
            'policy_tag' => $policyTag,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a taxonomy
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $taxonomy
     *
     * @return string The formatted taxonomy resource.
     */
    public static function taxonomyName(string $project, string $location, string $taxonomy): string
    {
        return self::getPathTemplate('taxonomy')->render([
            'project' => $project,
            'location' => $location,
            'taxonomy' => $taxonomy,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - location: projects/{project}/locations/{location}
     * - policyTag: projects/{project}/locations/{location}/taxonomies/{taxonomy}/policyTags/{policy_tag}
     * - taxonomy: projects/{project}/locations/{location}/taxonomies/{taxonomy}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'datacatalog.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a policy tag in a taxonomy.
     *
     * The async variant is {@see self::createPolicyTagAsync()} .
     *
     * @param CreatePolicyTagRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PolicyTag
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPolicyTag(CreatePolicyTagRequest $request, array $callOptions = []): PolicyTag
    {
        return $this->startApiCall('CreatePolicyTag', $request, $callOptions)->wait();
    }

    /**
     * Creates a taxonomy in a specified project.
     *
     * The taxonomy is initially empty, that is, it doesn't contain policy tags.
     *
     * The async variant is {@see self::createTaxonomyAsync()} .
     *
     * @param CreateTaxonomyRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Taxonomy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTaxonomy(CreateTaxonomyRequest $request, array $callOptions = []): Taxonomy
    {
        return $this->startApiCall('CreateTaxonomy', $request, $callOptions)->wait();
    }

    /**
     * Deletes a policy tag together with the following:
     *
     * * All of its descendant policy tags, if any
     * * Policies associated with the policy tag and its descendants
     * * References from BigQuery table schema of the policy tag and its
     * descendants
     *
     * The async variant is {@see self::deletePolicyTagAsync()} .
     *
     * @param DeletePolicyTagRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePolicyTag(DeletePolicyTagRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeletePolicyTag', $request, $callOptions)->wait();
    }

    /**
     * Deletes a taxonomy, including all policy tags in this
     * taxonomy, their associated policies, and the policy tags references from
     * BigQuery columns.
     *
     * The async variant is {@see self::deleteTaxonomyAsync()} .
     *
     * @param DeleteTaxonomyRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTaxonomy(DeleteTaxonomyRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteTaxonomy', $request, $callOptions)->wait();
    }

    /**
     * Gets the IAM policy for a policy tag or a taxonomy.
     *
     * The async variant is {@see self::getIamPolicyAsync()} .
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets a policy tag.
     *
     * The async variant is {@see self::getPolicyTagAsync()} .
     *
     * @param GetPolicyTagRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PolicyTag
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPolicyTag(GetPolicyTagRequest $request, array $callOptions = []): PolicyTag
    {
        return $this->startApiCall('GetPolicyTag', $request, $callOptions)->wait();
    }

    /**
     * Gets a taxonomy.
     *
     * The async variant is {@see self::getTaxonomyAsync()} .
     *
     * @param GetTaxonomyRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Taxonomy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTaxonomy(GetTaxonomyRequest $request, array $callOptions = []): Taxonomy
    {
        return $this->startApiCall('GetTaxonomy', $request, $callOptions)->wait();
    }

    /**
     * Lists all policy tags in a taxonomy.
     *
     * The async variant is {@see self::listPolicyTagsAsync()} .
     *
     * @param ListPolicyTagsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPolicyTags(ListPolicyTagsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPolicyTags', $request, $callOptions);
    }

    /**
     * Lists all taxonomies in a project in a particular location that you
     * have a permission to view.
     *
     * The async variant is {@see self::listTaxonomiesAsync()} .
     *
     * @param ListTaxonomiesRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTaxonomies(ListTaxonomiesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTaxonomies', $request, $callOptions);
    }

    /**
     * Sets the IAM policy for a policy tag or a taxonomy.
     *
     * The async variant is {@see self::setIamPolicyAsync()} .
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns your permissions on a specified policy tag or
     * taxonomy.
     *
     * The async variant is {@see self::testIamPermissionsAsync()} .
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Updates a policy tag, including its display
     * name, description, and parent policy tag.
     *
     * The async variant is {@see self::updatePolicyTagAsync()} .
     *
     * @param UpdatePolicyTagRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PolicyTag
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updatePolicyTag(UpdatePolicyTagRequest $request, array $callOptions = []): PolicyTag
    {
        return $this->startApiCall('UpdatePolicyTag', $request, $callOptions)->wait();
    }

    /**
     * Updates a taxonomy, including its display name,
     * description, and activated policy types.
     *
     * The async variant is {@see self::updateTaxonomyAsync()} .
     *
     * @param UpdateTaxonomyRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Taxonomy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTaxonomy(UpdateTaxonomyRequest $request, array $callOptions = []): Taxonomy
    {
        return $this->startApiCall('UpdateTaxonomy', $request, $callOptions)->wait();
    }
}
