<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/container/v1/cluster_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Container\V1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Container\V1\CancelOperationRequest;
use Google\Cloud\Container\V1\Cluster;
use Google\Cloud\Container\V1\CompleteIPRotationRequest;
use Google\Cloud\Container\V1\CompleteNodePoolUpgradeRequest;
use Google\Cloud\Container\V1\CreateClusterRequest;
use Google\Cloud\Container\V1\CreateNodePoolRequest;
use Google\Cloud\Container\V1\DeleteClusterRequest;
use Google\Cloud\Container\V1\DeleteNodePoolRequest;
use Google\Cloud\Container\V1\GetClusterRequest;
use Google\Cloud\Container\V1\GetJSONWebKeysRequest;
use Google\Cloud\Container\V1\GetJSONWebKeysResponse;
use Google\Cloud\Container\V1\GetNodePoolRequest;
use Google\Cloud\Container\V1\GetOperationRequest;
use Google\Cloud\Container\V1\GetServerConfigRequest;
use Google\Cloud\Container\V1\ListClustersRequest;
use Google\Cloud\Container\V1\ListClustersResponse;
use Google\Cloud\Container\V1\ListNodePoolsRequest;
use Google\Cloud\Container\V1\ListNodePoolsResponse;
use Google\Cloud\Container\V1\ListOperationsRequest;
use Google\Cloud\Container\V1\ListOperationsResponse;
use Google\Cloud\Container\V1\ListUsableSubnetworksRequest;
use Google\Cloud\Container\V1\NodePool;
use Google\Cloud\Container\V1\Operation;
use Google\Cloud\Container\V1\RollbackNodePoolUpgradeRequest;
use Google\Cloud\Container\V1\ServerConfig;
use Google\Cloud\Container\V1\SetAddonsConfigRequest;
use Google\Cloud\Container\V1\SetLabelsRequest;
use Google\Cloud\Container\V1\SetLegacyAbacRequest;
use Google\Cloud\Container\V1\SetLocationsRequest;
use Google\Cloud\Container\V1\SetLoggingServiceRequest;
use Google\Cloud\Container\V1\SetMaintenancePolicyRequest;
use Google\Cloud\Container\V1\SetMasterAuthRequest;
use Google\Cloud\Container\V1\SetMonitoringServiceRequest;
use Google\Cloud\Container\V1\SetNetworkPolicyRequest;
use Google\Cloud\Container\V1\SetNodePoolAutoscalingRequest;
use Google\Cloud\Container\V1\SetNodePoolManagementRequest;
use Google\Cloud\Container\V1\SetNodePoolSizeRequest;
use Google\Cloud\Container\V1\StartIPRotationRequest;
use Google\Cloud\Container\V1\UpdateClusterRequest;
use Google\Cloud\Container\V1\UpdateMasterRequest;
use Google\Cloud\Container\V1\UpdateNodePoolRequest;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Google Kubernetes Engine Cluster Manager v1
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes.
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface cancelOperationAsync(CancelOperationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface completeIPRotationAsync(CompleteIPRotationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface completeNodePoolUpgradeAsync(CompleteNodePoolUpgradeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createClusterAsync(CreateClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createNodePoolAsync(CreateNodePoolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteClusterAsync(DeleteClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteNodePoolAsync(DeleteNodePoolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getClusterAsync(GetClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getJSONWebKeysAsync(GetJSONWebKeysRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getNodePoolAsync(GetNodePoolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getOperationAsync(GetOperationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getServerConfigAsync(GetServerConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listClustersAsync(ListClustersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listNodePoolsAsync(ListNodePoolsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listOperationsAsync(ListOperationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listUsableSubnetworksAsync(ListUsableSubnetworksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface rollbackNodePoolUpgradeAsync(RollbackNodePoolUpgradeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setAddonsConfigAsync(SetAddonsConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setLabelsAsync(SetLabelsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setLegacyAbacAsync(SetLegacyAbacRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setLocationsAsync(SetLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setLoggingServiceAsync(SetLoggingServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setMaintenancePolicyAsync(SetMaintenancePolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setMasterAuthAsync(SetMasterAuthRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setMonitoringServiceAsync(SetMonitoringServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setNetworkPolicyAsync(SetNetworkPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setNodePoolAutoscalingAsync(SetNodePoolAutoscalingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setNodePoolManagementAsync(SetNodePoolManagementRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setNodePoolSizeAsync(SetNodePoolSizeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface startIPRotationAsync(StartIPRotationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateClusterAsync(UpdateClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateMasterAsync(UpdateMasterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateNodePoolAsync(UpdateNodePoolRequest $request, array $optionalArgs = [])
 */
abstract class ClusterManagerBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.container.v1.ClusterManager';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'container.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/cluster_manager_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/cluster_manager_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/cluster_manager_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/cluster_manager_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a topic
     * resource.
     *
     * @param string $project
     * @param string $topic
     *
     * @return string The formatted topic resource.
     */
    public static function topicName(string $project, string $topic): string
    {
        return self::getPathTemplate('topic')->render([
            'project' => $project,
            'topic' => $topic,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - topic: projects/{project}/topics/{topic}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'container.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Cancels the specified operation.
     *
     * The async variant is {@see self::cancelOperationAsync()} .
     *
     * @param CancelOperationRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function cancelOperation(CancelOperationRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('CancelOperation', $request, $callOptions)->wait();
    }

    /**
     * Completes master IP rotation.
     *
     * The async variant is {@see self::completeIPRotationAsync()} .
     *
     * @param CompleteIPRotationRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function completeIPRotation(CompleteIPRotationRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('CompleteIPRotation', $request, $callOptions)->wait();
    }

    /**
     * CompleteNodePoolUpgrade will signal an on-going node pool upgrade to
     * complete.
     *
     * The async variant is {@see self::completeNodePoolUpgradeAsync()} .
     *
     * @param CompleteNodePoolUpgradeRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function completeNodePoolUpgrade(CompleteNodePoolUpgradeRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('CompleteNodePoolUpgrade', $request, $callOptions)->wait();
    }

    /**
     * Creates a cluster, consisting of the specified number and type of Google
     * Compute Engine instances.
     *
     * By default, the cluster is created in the project's
     * [default
     * network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks).
     *
     * One firewall is added for the cluster. After cluster creation,
     * the Kubelet creates routes for each node to allow the containers
     * on that node to communicate with all other instances in the
     * cluster.
     *
     * Finally, an entry is added to the project's global metadata indicating
     * which CIDR range the cluster is using.
     *
     * The async variant is {@see self::createClusterAsync()} .
     *
     * @param CreateClusterRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCluster(CreateClusterRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('CreateCluster', $request, $callOptions)->wait();
    }

    /**
     * Creates a node pool for a cluster.
     *
     * The async variant is {@see self::createNodePoolAsync()} .
     *
     * @param CreateNodePoolRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createNodePool(CreateNodePoolRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('CreateNodePool', $request, $callOptions)->wait();
    }

    /**
     * Deletes the cluster, including the Kubernetes endpoint and all worker
     * nodes.
     *
     * Firewalls and routes that were configured during cluster creation
     * are also deleted.
     *
     * Other Google Compute Engine resources that might be in use by the cluster,
     * such as load balancer resources, are not deleted if they weren't present
     * when the cluster was initially created.
     *
     * The async variant is {@see self::deleteClusterAsync()} .
     *
     * @param DeleteClusterRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCluster(DeleteClusterRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('DeleteCluster', $request, $callOptions)->wait();
    }

    /**
     * Deletes a node pool from a cluster.
     *
     * The async variant is {@see self::deleteNodePoolAsync()} .
     *
     * @param DeleteNodePoolRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteNodePool(DeleteNodePoolRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('DeleteNodePool', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of a specific cluster.
     *
     * The async variant is {@see self::getClusterAsync()} .
     *
     * @param GetClusterRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Cluster
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCluster(GetClusterRequest $request, array $callOptions = []): Cluster
    {
        return $this->startApiCall('GetCluster', $request, $callOptions)->wait();
    }

    /**
     * Gets the public component of the cluster signing keys in
     * JSON Web Key format.
     * This API is not yet intended for general use, and is not available for all
     * clusters.
     *
     * The async variant is {@see self::getJSONWebKeysAsync()} .
     *
     * @param GetJSONWebKeysRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GetJSONWebKeysResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getJSONWebKeys(GetJSONWebKeysRequest $request, array $callOptions = []): GetJSONWebKeysResponse
    {
        return $this->startApiCall('GetJSONWebKeys', $request, $callOptions)->wait();
    }

    /**
     * Retrieves the requested node pool.
     *
     * The async variant is {@see self::getNodePoolAsync()} .
     *
     * @param GetNodePoolRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NodePool
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNodePool(GetNodePoolRequest $request, array $callOptions = []): NodePool
    {
        return $this->startApiCall('GetNodePool', $request, $callOptions)->wait();
    }

    /**
     * Gets the specified operation.
     *
     * The async variant is {@see self::getOperationAsync()} .
     *
     * @param GetOperationRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getOperation(GetOperationRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('GetOperation', $request, $callOptions)->wait();
    }

    /**
     * Returns configuration info about the Google Kubernetes Engine service.
     *
     * The async variant is {@see self::getServerConfigAsync()} .
     *
     * @param GetServerConfigRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ServerConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getServerConfig(GetServerConfigRequest $request, array $callOptions = []): ServerConfig
    {
        return $this->startApiCall('GetServerConfig', $request, $callOptions)->wait();
    }

    /**
     * Lists all clusters owned by a project in either the specified zone or all
     * zones.
     *
     * The async variant is {@see self::listClustersAsync()} .
     *
     * @param ListClustersRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListClustersResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listClusters(ListClustersRequest $request, array $callOptions = []): ListClustersResponse
    {
        return $this->startApiCall('ListClusters', $request, $callOptions)->wait();
    }

    /**
     * Lists the node pools for a cluster.
     *
     * The async variant is {@see self::listNodePoolsAsync()} .
     *
     * @param ListNodePoolsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListNodePoolsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNodePools(ListNodePoolsRequest $request, array $callOptions = []): ListNodePoolsResponse
    {
        return $this->startApiCall('ListNodePools', $request, $callOptions)->wait();
    }

    /**
     * Lists all operations in a project in a specific zone or all zones.
     *
     * The async variant is {@see self::listOperationsAsync()} .
     *
     * @param ListOperationsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListOperationsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listOperations(ListOperationsRequest $request, array $callOptions = []): ListOperationsResponse
    {
        return $this->startApiCall('ListOperations', $request, $callOptions)->wait();
    }

    /**
     * Lists subnetworks that are usable for creating clusters in a project.
     *
     * The async variant is {@see self::listUsableSubnetworksAsync()} .
     *
     * @param ListUsableSubnetworksRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listUsableSubnetworks(ListUsableSubnetworksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListUsableSubnetworks', $request, $callOptions);
    }

    /**
     * Rolls back a previously Aborted or Failed NodePool upgrade.
     * This makes no changes if the last upgrade successfully completed.
     *
     * The async variant is {@see self::rollbackNodePoolUpgradeAsync()} .
     *
     * @param RollbackNodePoolUpgradeRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function rollbackNodePoolUpgrade(RollbackNodePoolUpgradeRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('RollbackNodePoolUpgrade', $request, $callOptions)->wait();
    }

    /**
     * Sets the addons for a specific cluster.
     *
     * The async variant is {@see self::setAddonsConfigAsync()} .
     *
     * @param SetAddonsConfigRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setAddonsConfig(SetAddonsConfigRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('SetAddonsConfig', $request, $callOptions)->wait();
    }

    /**
     * Sets labels on a cluster.
     *
     * The async variant is {@see self::setLabelsAsync()} .
     *
     * @param SetLabelsRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setLabels(SetLabelsRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('SetLabels', $request, $callOptions)->wait();
    }

    /**
     * Enables or disables the ABAC authorization mechanism on a cluster.
     *
     * The async variant is {@see self::setLegacyAbacAsync()} .
     *
     * @param SetLegacyAbacRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setLegacyAbac(SetLegacyAbacRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('SetLegacyAbac', $request, $callOptions)->wait();
    }

    /**
     * Sets the locations for a specific cluster.
     * Deprecated. Use
     * [projects.locations.clusters.update](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters/update)
     * instead.
     *
     * The async variant is {@see self::setLocationsAsync()} .
     *
     * @param SetLocationsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function setLocations(SetLocationsRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('SetLocations', $request, $callOptions)->wait();
    }

    /**
     * Sets the logging service for a specific cluster.
     *
     * The async variant is {@see self::setLoggingServiceAsync()} .
     *
     * @param SetLoggingServiceRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setLoggingService(SetLoggingServiceRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('SetLoggingService', $request, $callOptions)->wait();
    }

    /**
     * Sets the maintenance policy for a cluster.
     *
     * The async variant is {@see self::setMaintenancePolicyAsync()} .
     *
     * @param SetMaintenancePolicyRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setMaintenancePolicy(SetMaintenancePolicyRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('SetMaintenancePolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets master auth materials. Currently supports changing the admin password
     * or a specific cluster, either via password generation or explicitly setting
     * the password.
     *
     * The async variant is {@see self::setMasterAuthAsync()} .
     *
     * @param SetMasterAuthRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setMasterAuth(SetMasterAuthRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('SetMasterAuth', $request, $callOptions)->wait();
    }

    /**
     * Sets the monitoring service for a specific cluster.
     *
     * The async variant is {@see self::setMonitoringServiceAsync()} .
     *
     * @param SetMonitoringServiceRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setMonitoringService(SetMonitoringServiceRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('SetMonitoringService', $request, $callOptions)->wait();
    }

    /**
     * Enables or disables Network Policy for a cluster.
     *
     * The async variant is {@see self::setNetworkPolicyAsync()} .
     *
     * @param SetNetworkPolicyRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setNetworkPolicy(SetNetworkPolicyRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('SetNetworkPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the autoscaling settings for the specified node pool.
     *
     * The async variant is {@see self::setNodePoolAutoscalingAsync()} .
     *
     * @param SetNodePoolAutoscalingRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setNodePoolAutoscaling(SetNodePoolAutoscalingRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('SetNodePoolAutoscaling', $request, $callOptions)->wait();
    }

    /**
     * Sets the NodeManagement options for a node pool.
     *
     * The async variant is {@see self::setNodePoolManagementAsync()} .
     *
     * @param SetNodePoolManagementRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setNodePoolManagement(SetNodePoolManagementRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('SetNodePoolManagement', $request, $callOptions)->wait();
    }

    /**
     * Sets the size for a specific node pool. The new size will be used for all
     * replicas, including future replicas created by modifying
     * [NodePool.locations][google.container.v1.NodePool.locations].
     *
     * The async variant is {@see self::setNodePoolSizeAsync()} .
     *
     * @param SetNodePoolSizeRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setNodePoolSize(SetNodePoolSizeRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('SetNodePoolSize', $request, $callOptions)->wait();
    }

    /**
     * Starts master IP rotation.
     *
     * The async variant is {@see self::startIPRotationAsync()} .
     *
     * @param StartIPRotationRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function startIPRotation(StartIPRotationRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('StartIPRotation', $request, $callOptions)->wait();
    }

    /**
     * Updates the settings of a specific cluster.
     *
     * The async variant is {@see self::updateClusterAsync()} .
     *
     * @param UpdateClusterRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCluster(UpdateClusterRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('UpdateCluster', $request, $callOptions)->wait();
    }

    /**
     * Updates the master for a specific cluster.
     *
     * The async variant is {@see self::updateMasterAsync()} .
     *
     * @param UpdateMasterRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateMaster(UpdateMasterRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('UpdateMaster', $request, $callOptions)->wait();
    }

    /**
     * Updates the version and/or image type for the specified node pool.
     *
     * The async variant is {@see self::updateNodePoolAsync()} .
     *
     * @param UpdateNodePoolRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateNodePool(UpdateNodePoolRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('UpdateNodePool', $request, $callOptions)->wait();
    }
}
