<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/sql/v1/cloud_sql_instances.proto

namespace Google\Cloud\Sql\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The context to perform a point-in-time recovery of an instance managed by
 * Backup and Disaster Recovery (DR) Service.
 *
 * Generated from protobuf message <code>google.cloud.sql.v1.PointInTimeRestoreContext</code>
 */
class PointInTimeRestoreContext extends \Google\Protobuf\Internal\Message
{
    /**
     * The Backup and Disaster Recovery (DR) Service Datasource URI.
     * Format:
     * projects/{project}/locations/{region}/backupVaults/{backupvault}/dataSources/{datasource}.
     *
     * Generated from protobuf field <code>optional string datasource = 1;</code>
     */
    protected $datasource = null;
    /**
     * Required. The date and time to which you want to restore the instance.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp point_in_time = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $point_in_time = null;
    /**
     * Target instance name.
     *
     * Generated from protobuf field <code>optional string target_instance = 3;</code>
     */
    protected $target_instance = null;
    /**
     * Optional. The resource link for the VPC network from which the Cloud SQL
     * instance is accessible for private IP. For example,
     * `/projects/myProject/global/networks/default`.
     *
     * Generated from protobuf field <code>optional string private_network = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $private_network = null;
    /**
     * Optional. The name of the allocated IP range for the internal IP Cloud SQL
     * instance. For example: "google-managed-services-default". If you set this,
     * then Cloud SQL creates the IP address for the cloned instance in the
     * allocated range. This range must comply with [RFC
     * 1035](https://tools.ietf.org/html/rfc1035) standards. Specifically, the
     * name must be 1-63 characters long and match the regular expression
     * [a-z]([-a-z0-9]*[a-z0-9])?. Reserved for future use.
     *
     * Generated from protobuf field <code>optional string allocated_ip_range = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $allocated_ip_range = null;
    /**
     * Optional. Point-in-time recovery of an instance to the specified zone. If
     * no zone is specified, then clone to the same primary zone as the source
     * instance.
     *
     * Generated from protobuf field <code>optional string preferred_zone = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $preferred_zone = null;
    /**
     * Optional. Point-in-time recovery of a regional instance in the specified
     * zones. If not specified, clone to the same secondary zone as the source
     * instance. This value cannot be the same as the preferred_zone field.
     *
     * Generated from protobuf field <code>optional string preferred_secondary_zone = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $preferred_secondary_zone = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $datasource
     *           The Backup and Disaster Recovery (DR) Service Datasource URI.
     *           Format:
     *           projects/{project}/locations/{region}/backupVaults/{backupvault}/dataSources/{datasource}.
     *     @type \Google\Protobuf\Timestamp $point_in_time
     *           Required. The date and time to which you want to restore the instance.
     *     @type string $target_instance
     *           Target instance name.
     *     @type string $private_network
     *           Optional. The resource link for the VPC network from which the Cloud SQL
     *           instance is accessible for private IP. For example,
     *           `/projects/myProject/global/networks/default`.
     *     @type string $allocated_ip_range
     *           Optional. The name of the allocated IP range for the internal IP Cloud SQL
     *           instance. For example: "google-managed-services-default". If you set this,
     *           then Cloud SQL creates the IP address for the cloned instance in the
     *           allocated range. This range must comply with [RFC
     *           1035](https://tools.ietf.org/html/rfc1035) standards. Specifically, the
     *           name must be 1-63 characters long and match the regular expression
     *           [a-z]([-a-z0-9]*[a-z0-9])?. Reserved for future use.
     *     @type string $preferred_zone
     *           Optional. Point-in-time recovery of an instance to the specified zone. If
     *           no zone is specified, then clone to the same primary zone as the source
     *           instance.
     *     @type string $preferred_secondary_zone
     *           Optional. Point-in-time recovery of a regional instance in the specified
     *           zones. If not specified, clone to the same secondary zone as the source
     *           instance. This value cannot be the same as the preferred_zone field.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Sql\V1\CloudSqlInstances::initOnce();
        parent::__construct($data);
    }

    /**
     * The Backup and Disaster Recovery (DR) Service Datasource URI.
     * Format:
     * projects/{project}/locations/{region}/backupVaults/{backupvault}/dataSources/{datasource}.
     *
     * Generated from protobuf field <code>optional string datasource = 1;</code>
     * @return string
     */
    public function getDatasource()
    {
        return isset($this->datasource) ? $this->datasource : '';
    }

    public function hasDatasource()
    {
        return isset($this->datasource);
    }

    public function clearDatasource()
    {
        unset($this->datasource);
    }

    /**
     * The Backup and Disaster Recovery (DR) Service Datasource URI.
     * Format:
     * projects/{project}/locations/{region}/backupVaults/{backupvault}/dataSources/{datasource}.
     *
     * Generated from protobuf field <code>optional string datasource = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setDatasource($var)
    {
        GPBUtil::checkString($var, True);
        $this->datasource = $var;

        return $this;
    }

    /**
     * Required. The date and time to which you want to restore the instance.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp point_in_time = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getPointInTime()
    {
        return $this->point_in_time;
    }

    public function hasPointInTime()
    {
        return isset($this->point_in_time);
    }

    public function clearPointInTime()
    {
        unset($this->point_in_time);
    }

    /**
     * Required. The date and time to which you want to restore the instance.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp point_in_time = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setPointInTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->point_in_time = $var;

        return $this;
    }

    /**
     * Target instance name.
     *
     * Generated from protobuf field <code>optional string target_instance = 3;</code>
     * @return string
     */
    public function getTargetInstance()
    {
        return isset($this->target_instance) ? $this->target_instance : '';
    }

    public function hasTargetInstance()
    {
        return isset($this->target_instance);
    }

    public function clearTargetInstance()
    {
        unset($this->target_instance);
    }

    /**
     * Target instance name.
     *
     * Generated from protobuf field <code>optional string target_instance = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setTargetInstance($var)
    {
        GPBUtil::checkString($var, True);
        $this->target_instance = $var;

        return $this;
    }

    /**
     * Optional. The resource link for the VPC network from which the Cloud SQL
     * instance is accessible for private IP. For example,
     * `/projects/myProject/global/networks/default`.
     *
     * Generated from protobuf field <code>optional string private_network = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPrivateNetwork()
    {
        return isset($this->private_network) ? $this->private_network : '';
    }

    public function hasPrivateNetwork()
    {
        return isset($this->private_network);
    }

    public function clearPrivateNetwork()
    {
        unset($this->private_network);
    }

    /**
     * Optional. The resource link for the VPC network from which the Cloud SQL
     * instance is accessible for private IP. For example,
     * `/projects/myProject/global/networks/default`.
     *
     * Generated from protobuf field <code>optional string private_network = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPrivateNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->private_network = $var;

        return $this;
    }

    /**
     * Optional. The name of the allocated IP range for the internal IP Cloud SQL
     * instance. For example: "google-managed-services-default". If you set this,
     * then Cloud SQL creates the IP address for the cloned instance in the
     * allocated range. This range must comply with [RFC
     * 1035](https://tools.ietf.org/html/rfc1035) standards. Specifically, the
     * name must be 1-63 characters long and match the regular expression
     * [a-z]([-a-z0-9]*[a-z0-9])?. Reserved for future use.
     *
     * Generated from protobuf field <code>optional string allocated_ip_range = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAllocatedIpRange()
    {
        return isset($this->allocated_ip_range) ? $this->allocated_ip_range : '';
    }

    public function hasAllocatedIpRange()
    {
        return isset($this->allocated_ip_range);
    }

    public function clearAllocatedIpRange()
    {
        unset($this->allocated_ip_range);
    }

    /**
     * Optional. The name of the allocated IP range for the internal IP Cloud SQL
     * instance. For example: "google-managed-services-default". If you set this,
     * then Cloud SQL creates the IP address for the cloned instance in the
     * allocated range. This range must comply with [RFC
     * 1035](https://tools.ietf.org/html/rfc1035) standards. Specifically, the
     * name must be 1-63 characters long and match the regular expression
     * [a-z]([-a-z0-9]*[a-z0-9])?. Reserved for future use.
     *
     * Generated from protobuf field <code>optional string allocated_ip_range = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAllocatedIpRange($var)
    {
        GPBUtil::checkString($var, True);
        $this->allocated_ip_range = $var;

        return $this;
    }

    /**
     * Optional. Point-in-time recovery of an instance to the specified zone. If
     * no zone is specified, then clone to the same primary zone as the source
     * instance.
     *
     * Generated from protobuf field <code>optional string preferred_zone = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPreferredZone()
    {
        return isset($this->preferred_zone) ? $this->preferred_zone : '';
    }

    public function hasPreferredZone()
    {
        return isset($this->preferred_zone);
    }

    public function clearPreferredZone()
    {
        unset($this->preferred_zone);
    }

    /**
     * Optional. Point-in-time recovery of an instance to the specified zone. If
     * no zone is specified, then clone to the same primary zone as the source
     * instance.
     *
     * Generated from protobuf field <code>optional string preferred_zone = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPreferredZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->preferred_zone = $var;

        return $this;
    }

    /**
     * Optional. Point-in-time recovery of a regional instance in the specified
     * zones. If not specified, clone to the same secondary zone as the source
     * instance. This value cannot be the same as the preferred_zone field.
     *
     * Generated from protobuf field <code>optional string preferred_secondary_zone = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPreferredSecondaryZone()
    {
        return isset($this->preferred_secondary_zone) ? $this->preferred_secondary_zone : '';
    }

    public function hasPreferredSecondaryZone()
    {
        return isset($this->preferred_secondary_zone);
    }

    public function clearPreferredSecondaryZone()
    {
        unset($this->preferred_secondary_zone);
    }

    /**
     * Optional. Point-in-time recovery of a regional instance in the specified
     * zones. If not specified, clone to the same secondary zone as the source
     * instance. This value cannot be the same as the preferred_zone field.
     *
     * Generated from protobuf field <code>optional string preferred_secondary_zone = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPreferredSecondaryZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->preferred_secondary_zone = $var;

        return $this;
    }

}

