<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/sql/v1/cloud_sql_instances.proto

namespace Google\Cloud\Sql\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The request payload used to execute SQL statements.
 *
 * Generated from protobuf message <code>google.cloud.sql.v1.ExecuteSqlPayload</code>
 */
class ExecuteSqlPayload extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. The name of an existing database user to connect to the database.
     * When `auto_iam_authn` is set to true, this field is ignored and the API
     * caller's IAM user is used.
     *
     * Generated from protobuf field <code>string user = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $user = '';
    /**
     * Required. SQL statements to run on the database. It can be a single
     * statement or a sequence of statements separated by semicolons.
     *
     * Generated from protobuf field <code>string sql_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $sql_statement = '';
    /**
     * Optional. Name of the database on which the statement will be executed.
     *
     * Generated from protobuf field <code>string database = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $database = '';
    /**
     * Optional. The maximum number of rows returned per SQL statement.
     *
     * Generated from protobuf field <code>int64 row_limit = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $row_limit = 0;
    /**
     * Optional. Controls how the API should respond when the SQL execution result
     * is incomplete due to the size limit or another error. The default mode is
     * to throw an error.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.ExecuteSqlPayload.PartialResultMode partial_result_mode = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $partial_result_mode = 0;
    /**
     * Optional. Specifies the name of the application that is making the request.
     * This field is used for telemetry. Only alphanumeric characters, dashes, and
     * underscores are allowed. The maximum length is 32 characters.
     *
     * Generated from protobuf field <code>string application = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $application = '';
    protected $user_password;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $user
     *           Optional. The name of an existing database user to connect to the database.
     *           When `auto_iam_authn` is set to true, this field is ignored and the API
     *           caller's IAM user is used.
     *     @type string $sql_statement
     *           Required. SQL statements to run on the database. It can be a single
     *           statement or a sequence of statements separated by semicolons.
     *     @type string $database
     *           Optional. Name of the database on which the statement will be executed.
     *     @type bool $auto_iam_authn
     *           Optional. When set to true, the API caller identity associated with the
     *           request is used for database authentication. The API caller must be an
     *           IAM user in the database.
     *     @type int|string $row_limit
     *           Optional. The maximum number of rows returned per SQL statement.
     *     @type int $partial_result_mode
     *           Optional. Controls how the API should respond when the SQL execution result
     *           is incomplete due to the size limit or another error. The default mode is
     *           to throw an error.
     *     @type string $application
     *           Optional. Specifies the name of the application that is making the request.
     *           This field is used for telemetry. Only alphanumeric characters, dashes, and
     *           underscores are allowed. The maximum length is 32 characters.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Sql\V1\CloudSqlInstances::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. The name of an existing database user to connect to the database.
     * When `auto_iam_authn` is set to true, this field is ignored and the API
     * caller's IAM user is used.
     *
     * Generated from protobuf field <code>string user = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Optional. The name of an existing database user to connect to the database.
     * When `auto_iam_authn` is set to true, this field is ignored and the API
     * caller's IAM user is used.
     *
     * Generated from protobuf field <code>string user = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setUser($var)
    {
        GPBUtil::checkString($var, True);
        $this->user = $var;

        return $this;
    }

    /**
     * Required. SQL statements to run on the database. It can be a single
     * statement or a sequence of statements separated by semicolons.
     *
     * Generated from protobuf field <code>string sql_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getSqlStatement()
    {
        return $this->sql_statement;
    }

    /**
     * Required. SQL statements to run on the database. It can be a single
     * statement or a sequence of statements separated by semicolons.
     *
     * Generated from protobuf field <code>string sql_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setSqlStatement($var)
    {
        GPBUtil::checkString($var, True);
        $this->sql_statement = $var;

        return $this;
    }

    /**
     * Optional. Name of the database on which the statement will be executed.
     *
     * Generated from protobuf field <code>string database = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDatabase()
    {
        return $this->database;
    }

    /**
     * Optional. Name of the database on which the statement will be executed.
     *
     * Generated from protobuf field <code>string database = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDatabase($var)
    {
        GPBUtil::checkString($var, True);
        $this->database = $var;

        return $this;
    }

    /**
     * Optional. When set to true, the API caller identity associated with the
     * request is used for database authentication. The API caller must be an
     * IAM user in the database.
     *
     * Generated from protobuf field <code>bool auto_iam_authn = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getAutoIamAuthn()
    {
        return $this->readOneof(11);
    }

    public function hasAutoIamAuthn()
    {
        return $this->hasOneof(11);
    }

    /**
     * Optional. When set to true, the API caller identity associated with the
     * request is used for database authentication. The API caller must be an
     * IAM user in the database.
     *
     * Generated from protobuf field <code>bool auto_iam_authn = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setAutoIamAuthn($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * Optional. The maximum number of rows returned per SQL statement.
     *
     * Generated from protobuf field <code>int64 row_limit = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getRowLimit()
    {
        return $this->row_limit;
    }

    /**
     * Optional. The maximum number of rows returned per SQL statement.
     *
     * Generated from protobuf field <code>int64 row_limit = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setRowLimit($var)
    {
        GPBUtil::checkInt64($var);
        $this->row_limit = $var;

        return $this;
    }

    /**
     * Optional. Controls how the API should respond when the SQL execution result
     * is incomplete due to the size limit or another error. The default mode is
     * to throw an error.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.ExecuteSqlPayload.PartialResultMode partial_result_mode = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPartialResultMode()
    {
        return $this->partial_result_mode;
    }

    /**
     * Optional. Controls how the API should respond when the SQL execution result
     * is incomplete due to the size limit or another error. The default mode is
     * to throw an error.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.ExecuteSqlPayload.PartialResultMode partial_result_mode = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPartialResultMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\ExecuteSqlPayload\PartialResultMode::class);
        $this->partial_result_mode = $var;

        return $this;
    }

    /**
     * Optional. Specifies the name of the application that is making the request.
     * This field is used for telemetry. Only alphanumeric characters, dashes, and
     * underscores are allowed. The maximum length is 32 characters.
     *
     * Generated from protobuf field <code>string application = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getApplication()
    {
        return $this->application;
    }

    /**
     * Optional. Specifies the name of the application that is making the request.
     * This field is used for telemetry. Only alphanumeric characters, dashes, and
     * underscores are allowed. The maximum length is 32 characters.
     *
     * Generated from protobuf field <code>string application = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setApplication($var)
    {
        GPBUtil::checkString($var, True);
        $this->application = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserPassword()
    {
        return $this->whichOneof("user_password");
    }

}

