<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/securitycenter/v2/securitycenter_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\SecurityCenter\V2\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\SecurityCenter\V2\BatchCreateResourceValueConfigsRequest;
use Google\Cloud\SecurityCenter\V2\BatchCreateResourceValueConfigsResponse;
use Google\Cloud\SecurityCenter\V2\BigQueryExport;
use Google\Cloud\SecurityCenter\V2\BulkMuteFindingsRequest;
use Google\Cloud\SecurityCenter\V2\BulkMuteFindingsResponse;
use Google\Cloud\SecurityCenter\V2\CreateBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V2\CreateFindingRequest;
use Google\Cloud\SecurityCenter\V2\CreateMuteConfigRequest;
use Google\Cloud\SecurityCenter\V2\CreateNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V2\CreateSourceRequest;
use Google\Cloud\SecurityCenter\V2\DeleteBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V2\DeleteMuteConfigRequest;
use Google\Cloud\SecurityCenter\V2\DeleteNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V2\DeleteResourceValueConfigRequest;
use Google\Cloud\SecurityCenter\V2\ExternalSystem;
use Google\Cloud\SecurityCenter\V2\Finding;
use Google\Cloud\SecurityCenter\V2\GetBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V2\GetMuteConfigRequest;
use Google\Cloud\SecurityCenter\V2\GetNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V2\GetResourceValueConfigRequest;
use Google\Cloud\SecurityCenter\V2\GetSimulationRequest;
use Google\Cloud\SecurityCenter\V2\GetSourceRequest;
use Google\Cloud\SecurityCenter\V2\GetValuedResourceRequest;
use Google\Cloud\SecurityCenter\V2\GroupFindingsRequest;
use Google\Cloud\SecurityCenter\V2\ListAttackPathsRequest;
use Google\Cloud\SecurityCenter\V2\ListBigQueryExportsRequest;
use Google\Cloud\SecurityCenter\V2\ListFindingsRequest;
use Google\Cloud\SecurityCenter\V2\ListMuteConfigsRequest;
use Google\Cloud\SecurityCenter\V2\ListNotificationConfigsRequest;
use Google\Cloud\SecurityCenter\V2\ListResourceValueConfigsRequest;
use Google\Cloud\SecurityCenter\V2\ListSourcesRequest;
use Google\Cloud\SecurityCenter\V2\ListValuedResourcesRequest;
use Google\Cloud\SecurityCenter\V2\MuteConfig;
use Google\Cloud\SecurityCenter\V2\NotificationConfig;
use Google\Cloud\SecurityCenter\V2\ResourceValueConfig;
use Google\Cloud\SecurityCenter\V2\SecurityMarks;
use Google\Cloud\SecurityCenter\V2\SetFindingStateRequest;
use Google\Cloud\SecurityCenter\V2\SetMuteRequest;
use Google\Cloud\SecurityCenter\V2\Simulation;
use Google\Cloud\SecurityCenter\V2\Source;
use Google\Cloud\SecurityCenter\V2\UpdateBigQueryExportRequest;
use Google\Cloud\SecurityCenter\V2\UpdateExternalSystemRequest;
use Google\Cloud\SecurityCenter\V2\UpdateFindingRequest;
use Google\Cloud\SecurityCenter\V2\UpdateMuteConfigRequest;
use Google\Cloud\SecurityCenter\V2\UpdateNotificationConfigRequest;
use Google\Cloud\SecurityCenter\V2\UpdateResourceValueConfigRequest;
use Google\Cloud\SecurityCenter\V2\UpdateSecurityMarksRequest;
use Google\Cloud\SecurityCenter\V2\UpdateSourceRequest;
use Google\Cloud\SecurityCenter\V2\ValuedResource;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: V2 APIs for Security Center service.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<BatchCreateResourceValueConfigsResponse> batchCreateResourceValueConfigsAsync(BatchCreateResourceValueConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> bulkMuteFindingsAsync(BulkMuteFindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BigQueryExport> createBigQueryExportAsync(CreateBigQueryExportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Finding> createFindingAsync(CreateFindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MuteConfig> createMuteConfigAsync(CreateMuteConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<NotificationConfig> createNotificationConfigAsync(CreateNotificationConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Source> createSourceAsync(CreateSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteBigQueryExportAsync(DeleteBigQueryExportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteMuteConfigAsync(DeleteMuteConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteNotificationConfigAsync(DeleteNotificationConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteResourceValueConfigAsync(DeleteResourceValueConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BigQueryExport> getBigQueryExportAsync(GetBigQueryExportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MuteConfig> getMuteConfigAsync(GetMuteConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<NotificationConfig> getNotificationConfigAsync(GetNotificationConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ResourceValueConfig> getResourceValueConfigAsync(GetResourceValueConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Simulation> getSimulationAsync(GetSimulationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Source> getSourceAsync(GetSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ValuedResource> getValuedResourceAsync(GetValuedResourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> groupFindingsAsync(GroupFindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAttackPathsAsync(ListAttackPathsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listBigQueryExportsAsync(ListBigQueryExportsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listFindingsAsync(ListFindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listMuteConfigsAsync(ListMuteConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listNotificationConfigsAsync(ListNotificationConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listResourceValueConfigsAsync(ListResourceValueConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSourcesAsync(ListSourcesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listValuedResourcesAsync(ListValuedResourcesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Finding> setFindingStateAsync(SetFindingStateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Finding> setMuteAsync(SetMuteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BigQueryExport> updateBigQueryExportAsync(UpdateBigQueryExportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ExternalSystem> updateExternalSystemAsync(UpdateExternalSystemRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Finding> updateFindingAsync(UpdateFindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MuteConfig> updateMuteConfigAsync(UpdateMuteConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<NotificationConfig> updateNotificationConfigAsync(UpdateNotificationConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ResourceValueConfig> updateResourceValueConfigAsync(UpdateResourceValueConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SecurityMarks> updateSecurityMarksAsync(UpdateSecurityMarksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Source> updateSourceAsync(UpdateSourceRequest $request, array $optionalArgs = [])
 */
final class SecurityCenterClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.securitycenter.v2.SecurityCenter';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'securitycenter.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'securitycenter.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/security_center_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/security_center_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/security_center_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/security_center_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * big_query_export resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $export
     *
     * @return string The formatted big_query_export resource.
     */
    public static function bigQueryExportName(string $organization, string $location, string $export): string
    {
        return self::getPathTemplate('bigQueryExport')->render([
            'organization' => $organization,
            'location' => $location,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a dlp_job
     * resource.
     *
     * @param string $project
     * @param string $dlpJob
     *
     * @return string The formatted dlp_job resource.
     */
    public static function dlpJobName(string $project, string $dlpJob): string
    {
        return self::getPathTemplate('dlpJob')->render([
            'project' => $project,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * external_system resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted external_system resource.
     */
    public static function externalSystemName(
        string $organization,
        string $source,
        string $finding,
        string $externalsystem
    ): string {
        return self::getPathTemplate('externalSystem')->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a finding
     * resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted finding resource.
     */
    public static function findingName(string $organization, string $source, string $finding): string
    {
        return self::getPathTemplate('finding')->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder
     * resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder resource.
     */
    public static function folderName(string $folder): string
    {
        return self::getPathTemplate('folder')->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_asset_securityMarks resource.
     *
     * @param string $folder
     * @param string $asset
     *
     * @return string The formatted folder_asset_securityMarks resource.
     */
    public static function folderAssetSecurityMarksName(string $folder, string $asset): string
    {
        return self::getPathTemplate('folderAssetSecurityMarks')->render([
            'folder' => $folder,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_constraint_name resource.
     *
     * @param string $folder
     * @param string $constraintName
     *
     * @return string The formatted folder_constraint_name resource.
     */
    public static function folderConstraintNameName(string $folder, string $constraintName): string
    {
        return self::getPathTemplate('folderConstraintName')->render([
            'folder' => $folder,
            'constraint_name' => $constraintName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location resource.
     *
     * @param string $folder
     * @param string $location
     *
     * @return string The formatted folder_location resource.
     */
    public static function folderLocationName(string $folder, string $location): string
    {
        return self::getPathTemplate('folderLocation')->render([
            'folder' => $folder,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_export resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $export
     *
     * @return string The formatted folder_location_export resource.
     */
    public static function folderLocationExportName(string $folder, string $location, string $export): string
    {
        return self::getPathTemplate('folderLocationExport')->render([
            'folder' => $folder,
            'location' => $location,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_mute_config resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $muteConfig
     *
     * @return string The formatted folder_location_mute_config resource.
     */
    public static function folderLocationMuteConfigName(string $folder, string $location, string $muteConfig): string
    {
        return self::getPathTemplate('folderLocationMuteConfig')->render([
            'folder' => $folder,
            'location' => $location,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_notification_config resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $notificationConfig
     *
     * @return string The formatted folder_location_notification_config resource.
     */
    public static function folderLocationNotificationConfigName(
        string $folder,
        string $location,
        string $notificationConfig
    ): string {
        return self::getPathTemplate('folderLocationNotificationConfig')->render([
            'folder' => $folder,
            'location' => $location,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_mute_config resource.
     *
     * @param string $folder
     * @param string $muteConfig
     *
     * @return string The formatted folder_mute_config resource.
     */
    public static function folderMuteConfigName(string $folder, string $muteConfig): string
    {
        return self::getPathTemplate('folderMuteConfig')->render([
            'folder' => $folder,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source resource.
     *
     * @param string $folder
     * @param string $source
     *
     * @return string The formatted folder_source resource.
     */
    public static function folderSourceName(string $folder, string $source): string
    {
        return self::getPathTemplate('folderSource')->render([
            'folder' => $folder,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source_finding resource.
     *
     * @param string $folder
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted folder_source_finding resource.
     */
    public static function folderSourceFindingName(string $folder, string $source, string $finding): string
    {
        return self::getPathTemplate('folderSourceFinding')->render([
            'folder' => $folder,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source_finding_externalsystem resource.
     *
     * @param string $folder
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted folder_source_finding_externalsystem resource.
     */
    public static function folderSourceFindingExternalsystemName(
        string $folder,
        string $source,
        string $finding,
        string $externalsystem
    ): string {
        return self::getPathTemplate('folderSourceFindingExternalsystem')->render([
            'folder' => $folder,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source_finding_securityMarks resource.
     *
     * @param string $folder
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted folder_source_finding_securityMarks resource.
     */
    public static function folderSourceFindingSecurityMarksName(string $folder, string $source, string $finding): string
    {
        return self::getPathTemplate('folderSourceFindingSecurityMarks')->render([
            'folder' => $folder,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source_location_finding resource.
     *
     * @param string $folder
     * @param string $source
     * @param string $location
     * @param string $finding
     *
     * @return string The formatted folder_source_location_finding resource.
     */
    public static function folderSourceLocationFindingName(
        string $folder,
        string $source,
        string $location,
        string $finding
    ): string {
        return self::getPathTemplate('folderSourceLocationFinding')->render([
            'folder' => $folder,
            'source' => $source,
            'location' => $location,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source_location_finding_externalsystem resource.
     *
     * @param string $folder
     * @param string $source
     * @param string $location
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted folder_source_location_finding_externalsystem resource.
     */
    public static function folderSourceLocationFindingExternalsystemName(
        string $folder,
        string $source,
        string $location,
        string $finding,
        string $externalsystem
    ): string {
        return self::getPathTemplate('folderSourceLocationFindingExternalsystem')->render([
            'folder' => $folder,
            'source' => $source,
            'location' => $location,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_source_location_finding_securityMarks resource.
     *
     * @param string $folder
     * @param string $source
     * @param string $location
     * @param string $finding
     *
     * @return string The formatted folder_source_location_finding_securityMarks resource.
     */
    public static function folderSourceLocationFindingSecurityMarksName(
        string $folder,
        string $source,
        string $location,
        string $finding
    ): string {
        return self::getPathTemplate('folderSourceLocationFindingSecurityMarks')->render([
            'folder' => $folder,
            'source' => $source,
            'location' => $location,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a mute_config
     * resource.
     *
     * @param string $organization
     * @param string $muteConfig
     *
     * @return string The formatted mute_config resource.
     */
    public static function muteConfigName(string $organization, string $muteConfig): string
    {
        return self::getPathTemplate('muteConfig')->render([
            'organization' => $organization,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * notification_config resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $notificationConfig
     *
     * @return string The formatted notification_config resource.
     */
    public static function notificationConfigName(
        string $organization,
        string $location,
        string $notificationConfig
    ): string {
        return self::getPathTemplate('notificationConfig')->render([
            'organization' => $organization,
            'location' => $location,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     */
    public static function organizationName(string $organization): string
    {
        return self::getPathTemplate('organization')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_asset_securityMarks resource.
     *
     * @param string $organization
     * @param string $asset
     *
     * @return string The formatted organization_asset_securityMarks resource.
     */
    public static function organizationAssetSecurityMarksName(string $organization, string $asset): string
    {
        return self::getPathTemplate('organizationAssetSecurityMarks')->render([
            'organization' => $organization,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_constraint_name resource.
     *
     * @param string $organization
     * @param string $constraintName
     *
     * @return string The formatted organization_constraint_name resource.
     */
    public static function organizationConstraintNameName(string $organization, string $constraintName): string
    {
        return self::getPathTemplate('organizationConstraintName')->render([
            'organization' => $organization,
            'constraint_name' => $constraintName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted organization_location resource.
     */
    public static function organizationLocationName(string $organization, string $location): string
    {
        return self::getPathTemplate('organizationLocation')->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_export resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $export
     *
     * @return string The formatted organization_location_export resource.
     */
    public static function organizationLocationExportName(
        string $organization,
        string $location,
        string $export
    ): string {
        return self::getPathTemplate('organizationLocationExport')->render([
            'organization' => $organization,
            'location' => $location,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_mute_config resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $muteConfig
     *
     * @return string The formatted organization_location_mute_config resource.
     */
    public static function organizationLocationMuteConfigName(
        string $organization,
        string $location,
        string $muteConfig
    ): string {
        return self::getPathTemplate('organizationLocationMuteConfig')->render([
            'organization' => $organization,
            'location' => $location,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_notification_config resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $notificationConfig
     *
     * @return string The formatted organization_location_notification_config resource.
     */
    public static function organizationLocationNotificationConfigName(
        string $organization,
        string $location,
        string $notificationConfig
    ): string {
        return self::getPathTemplate('organizationLocationNotificationConfig')->render([
            'organization' => $organization,
            'location' => $location,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_resource_value_config resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $resourceValueConfig
     *
     * @return string The formatted organization_location_resource_value_config resource.
     */
    public static function organizationLocationResourceValueConfigName(
        string $organization,
        string $location,
        string $resourceValueConfig
    ): string {
        return self::getPathTemplate('organizationLocationResourceValueConfig')->render([
            'organization' => $organization,
            'location' => $location,
            'resource_value_config' => $resourceValueConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_simluation resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $simluation
     *
     * @return string The formatted organization_location_simluation resource.
     */
    public static function organizationLocationSimluationName(
        string $organization,
        string $location,
        string $simluation
    ): string {
        return self::getPathTemplate('organizationLocationSimluation')->render([
            'organization' => $organization,
            'location' => $location,
            'simluation' => $simluation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_simluation_valued_resource resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $simluation
     * @param string $valuedResource
     *
     * @return string The formatted organization_location_simluation_valued_resource resource.
     */
    public static function organizationLocationSimluationValuedResourceName(
        string $organization,
        string $location,
        string $simluation,
        string $valuedResource
    ): string {
        return self::getPathTemplate('organizationLocationSimluationValuedResource')->render([
            'organization' => $organization,
            'location' => $location,
            'simluation' => $simluation,
            'valued_resource' => $valuedResource,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_mute_config resource.
     *
     * @param string $organization
     * @param string $muteConfig
     *
     * @return string The formatted organization_mute_config resource.
     */
    public static function organizationMuteConfigName(string $organization, string $muteConfig): string
    {
        return self::getPathTemplate('organizationMuteConfig')->render([
            'organization' => $organization,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_resource_value_config resource.
     *
     * @param string $organization
     * @param string $resourceValueConfig
     *
     * @return string The formatted organization_resource_value_config resource.
     */
    public static function organizationResourceValueConfigName(
        string $organization,
        string $resourceValueConfig
    ): string {
        return self::getPathTemplate('organizationResourceValueConfig')->render([
            'organization' => $organization,
            'resource_value_config' => $resourceValueConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_simulation resource.
     *
     * @param string $organization
     * @param string $simulation
     *
     * @return string The formatted organization_simulation resource.
     */
    public static function organizationSimulationName(string $organization, string $simulation): string
    {
        return self::getPathTemplate('organizationSimulation')->render([
            'organization' => $organization,
            'simulation' => $simulation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_simulation_valued_resource resource.
     *
     * @param string $organization
     * @param string $simulation
     * @param string $valuedResource
     *
     * @return string The formatted organization_simulation_valued_resource resource.
     */
    public static function organizationSimulationValuedResourceName(
        string $organization,
        string $simulation,
        string $valuedResource
    ): string {
        return self::getPathTemplate('organizationSimulationValuedResource')->render([
            'organization' => $organization,
            'simulation' => $simulation,
            'valued_resource' => $valuedResource,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source resource.
     *
     * @param string $organization
     * @param string $source
     *
     * @return string The formatted organization_source resource.
     */
    public static function organizationSourceName(string $organization, string $source): string
    {
        return self::getPathTemplate('organizationSource')->render([
            'organization' => $organization,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source_finding resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted organization_source_finding resource.
     */
    public static function organizationSourceFindingName(string $organization, string $source, string $finding): string
    {
        return self::getPathTemplate('organizationSourceFinding')->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source_finding_externalsystem resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted organization_source_finding_externalsystem resource.
     */
    public static function organizationSourceFindingExternalsystemName(
        string $organization,
        string $source,
        string $finding,
        string $externalsystem
    ): string {
        return self::getPathTemplate('organizationSourceFindingExternalsystem')->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source_finding_securityMarks resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted organization_source_finding_securityMarks resource.
     */
    public static function organizationSourceFindingSecurityMarksName(
        string $organization,
        string $source,
        string $finding
    ): string {
        return self::getPathTemplate('organizationSourceFindingSecurityMarks')->render([
            'organization' => $organization,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source_location_finding resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $location
     * @param string $finding
     *
     * @return string The formatted organization_source_location_finding resource.
     */
    public static function organizationSourceLocationFindingName(
        string $organization,
        string $source,
        string $location,
        string $finding
    ): string {
        return self::getPathTemplate('organizationSourceLocationFinding')->render([
            'organization' => $organization,
            'source' => $source,
            'location' => $location,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source_location_finding_externalsystem resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $location
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted organization_source_location_finding_externalsystem resource.
     */
    public static function organizationSourceLocationFindingExternalsystemName(
        string $organization,
        string $source,
        string $location,
        string $finding,
        string $externalsystem
    ): string {
        return self::getPathTemplate('organizationSourceLocationFindingExternalsystem')->render([
            'organization' => $organization,
            'source' => $source,
            'location' => $location,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_source_location_finding_securityMarks resource.
     *
     * @param string $organization
     * @param string $source
     * @param string $location
     * @param string $finding
     *
     * @return string The formatted organization_source_location_finding_securityMarks resource.
     */
    public static function organizationSourceLocationFindingSecurityMarksName(
        string $organization,
        string $source,
        string $location,
        string $finding
    ): string {
        return self::getPathTemplate('organizationSourceLocationFindingSecurityMarks')->render([
            'organization' => $organization,
            'source' => $source,
            'location' => $location,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_valued_resource resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $simulation
     * @param string $valuedResource
     *
     * @return string The formatted organization_valued_resource resource.
     */
    public static function organizationValuedResourceName(
        string $organization,
        string $location,
        string $simulation,
        string $valuedResource
    ): string {
        return self::getPathTemplate('organizationValuedResource')->render([
            'organization' => $organization,
            'location' => $location,
            'simulation' => $simulation,
            'valued_resource' => $valuedResource,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a policy
     * resource.
     *
     * @param string $organization
     * @param string $constraintName
     *
     * @return string The formatted policy resource.
     */
    public static function policyName(string $organization, string $constraintName): string
    {
        return self::getPathTemplate('policy')->render([
            'organization' => $organization,
            'constraint_name' => $constraintName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_asset_securityMarks resource.
     *
     * @param string $project
     * @param string $asset
     *
     * @return string The formatted project_asset_securityMarks resource.
     */
    public static function projectAssetSecurityMarksName(string $project, string $asset): string
    {
        return self::getPathTemplate('projectAssetSecurityMarks')->render([
            'project' => $project,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_constraint_name resource.
     *
     * @param string $project
     * @param string $constraintName
     *
     * @return string The formatted project_constraint_name resource.
     */
    public static function projectConstraintNameName(string $project, string $constraintName): string
    {
        return self::getPathTemplate('projectConstraintName')->render([
            'project' => $project,
            'constraint_name' => $constraintName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_dlp_job resource.
     *
     * @param string $project
     * @param string $dlpJob
     *
     * @return string The formatted project_dlp_job resource.
     */
    public static function projectDlpJobName(string $project, string $dlpJob): string
    {
        return self::getPathTemplate('projectDlpJob')->render([
            'project' => $project,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_dlp_job resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dlpJob
     *
     * @return string The formatted project_location_dlp_job resource.
     */
    public static function projectLocationDlpJobName(string $project, string $location, string $dlpJob): string
    {
        return self::getPathTemplate('projectLocationDlpJob')->render([
            'project' => $project,
            'location' => $location,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_export resource.
     *
     * @param string $project
     * @param string $location
     * @param string $export
     *
     * @return string The formatted project_location_export resource.
     */
    public static function projectLocationExportName(string $project, string $location, string $export): string
    {
        return self::getPathTemplate('projectLocationExport')->render([
            'project' => $project,
            'location' => $location,
            'export' => $export,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_mute_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $muteConfig
     *
     * @return string The formatted project_location_mute_config resource.
     */
    public static function projectLocationMuteConfigName(string $project, string $location, string $muteConfig): string
    {
        return self::getPathTemplate('projectLocationMuteConfig')->render([
            'project' => $project,
            'location' => $location,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_notification_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $notificationConfig
     *
     * @return string The formatted project_location_notification_config resource.
     */
    public static function projectLocationNotificationConfigName(
        string $project,
        string $location,
        string $notificationConfig
    ): string {
        return self::getPathTemplate('projectLocationNotificationConfig')->render([
            'project' => $project,
            'location' => $location,
            'notification_config' => $notificationConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_table_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tableProfile
     *
     * @return string The formatted project_location_table_profile resource.
     */
    public static function projectLocationTableProfileName(
        string $project,
        string $location,
        string $tableProfile
    ): string {
        return self::getPathTemplate('projectLocationTableProfile')->render([
            'project' => $project,
            'location' => $location,
            'table_profile' => $tableProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_mute_config resource.
     *
     * @param string $project
     * @param string $muteConfig
     *
     * @return string The formatted project_mute_config resource.
     */
    public static function projectMuteConfigName(string $project, string $muteConfig): string
    {
        return self::getPathTemplate('projectMuteConfig')->render([
            'project' => $project,
            'mute_config' => $muteConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source resource.
     *
     * @param string $project
     * @param string $source
     *
     * @return string The formatted project_source resource.
     */
    public static function projectSourceName(string $project, string $source): string
    {
        return self::getPathTemplate('projectSource')->render([
            'project' => $project,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source_finding resource.
     *
     * @param string $project
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted project_source_finding resource.
     */
    public static function projectSourceFindingName(string $project, string $source, string $finding): string
    {
        return self::getPathTemplate('projectSourceFinding')->render([
            'project' => $project,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source_finding_externalsystem resource.
     *
     * @param string $project
     * @param string $source
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted project_source_finding_externalsystem resource.
     */
    public static function projectSourceFindingExternalsystemName(
        string $project,
        string $source,
        string $finding,
        string $externalsystem
    ): string {
        return self::getPathTemplate('projectSourceFindingExternalsystem')->render([
            'project' => $project,
            'source' => $source,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source_finding_securityMarks resource.
     *
     * @param string $project
     * @param string $source
     * @param string $finding
     *
     * @return string The formatted project_source_finding_securityMarks resource.
     */
    public static function projectSourceFindingSecurityMarksName(
        string $project,
        string $source,
        string $finding
    ): string {
        return self::getPathTemplate('projectSourceFindingSecurityMarks')->render([
            'project' => $project,
            'source' => $source,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source_location_finding resource.
     *
     * @param string $project
     * @param string $source
     * @param string $location
     * @param string $finding
     *
     * @return string The formatted project_source_location_finding resource.
     */
    public static function projectSourceLocationFindingName(
        string $project,
        string $source,
        string $location,
        string $finding
    ): string {
        return self::getPathTemplate('projectSourceLocationFinding')->render([
            'project' => $project,
            'source' => $source,
            'location' => $location,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source_location_finding_externalsystem resource.
     *
     * @param string $project
     * @param string $source
     * @param string $location
     * @param string $finding
     * @param string $externalsystem
     *
     * @return string The formatted project_source_location_finding_externalsystem resource.
     */
    public static function projectSourceLocationFindingExternalsystemName(
        string $project,
        string $source,
        string $location,
        string $finding,
        string $externalsystem
    ): string {
        return self::getPathTemplate('projectSourceLocationFindingExternalsystem')->render([
            'project' => $project,
            'source' => $source,
            'location' => $location,
            'finding' => $finding,
            'externalsystem' => $externalsystem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_source_location_finding_securityMarks resource.
     *
     * @param string $project
     * @param string $source
     * @param string $location
     * @param string $finding
     *
     * @return string The formatted project_source_location_finding_securityMarks resource.
     */
    public static function projectSourceLocationFindingSecurityMarksName(
        string $project,
        string $source,
        string $location,
        string $finding
    ): string {
        return self::getPathTemplate('projectSourceLocationFindingSecurityMarks')->render([
            'project' => $project,
            'source' => $source,
            'location' => $location,
            'finding' => $finding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_table_profile resource.
     *
     * @param string $project
     * @param string $tableProfile
     *
     * @return string The formatted project_table_profile resource.
     */
    public static function projectTableProfileName(string $project, string $tableProfile): string
    {
        return self::getPathTemplate('projectTableProfile')->render([
            'project' => $project,
            'table_profile' => $tableProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * resource_value_config resource.
     *
     * @param string $organization
     * @param string $resourceValueConfig
     *
     * @return string The formatted resource_value_config resource.
     */
    public static function resourceValueConfigName(string $organization, string $resourceValueConfig): string
    {
        return self::getPathTemplate('resourceValueConfig')->render([
            'organization' => $organization,
            'resource_value_config' => $resourceValueConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * security_marks resource.
     *
     * @param string $organization
     * @param string $asset
     *
     * @return string The formatted security_marks resource.
     */
    public static function securityMarksName(string $organization, string $asset): string
    {
        return self::getPathTemplate('securityMarks')->render([
            'organization' => $organization,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a simulation
     * resource.
     *
     * @param string $organization
     * @param string $simulation
     *
     * @return string The formatted simulation resource.
     */
    public static function simulationName(string $organization, string $simulation): string
    {
        return self::getPathTemplate('simulation')->render([
            'organization' => $organization,
            'simulation' => $simulation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a source
     * resource.
     *
     * @param string $organization
     * @param string $source
     *
     * @return string The formatted source resource.
     */
    public static function sourceName(string $organization, string $source): string
    {
        return self::getPathTemplate('source')->render([
            'organization' => $organization,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * table_data_profile resource.
     *
     * @param string $project
     * @param string $tableProfile
     *
     * @return string The formatted table_data_profile resource.
     */
    public static function tableDataProfileName(string $project, string $tableProfile): string
    {
        return self::getPathTemplate('tableDataProfile')->render([
            'project' => $project,
            'table_profile' => $tableProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a topic
     * resource.
     *
     * @param string $project
     * @param string $topic
     *
     * @return string The formatted topic resource.
     */
    public static function topicName(string $project, string $topic): string
    {
        return self::getPathTemplate('topic')->render([
            'project' => $project,
            'topic' => $topic,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * valued_resource resource.
     *
     * @param string $organization
     * @param string $simulation
     * @param string $valuedResource
     *
     * @return string The formatted valued_resource resource.
     */
    public static function valuedResourceName(string $organization, string $simulation, string $valuedResource): string
    {
        return self::getPathTemplate('valuedResource')->render([
            'organization' => $organization,
            'simulation' => $simulation,
            'valued_resource' => $valuedResource,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - bigQueryExport: organizations/{organization}/locations/{location}/bigQueryExports/{export}
     * - dlpJob: projects/{project}/dlpJobs/{dlp_job}
     * - externalSystem: organizations/{organization}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - finding: organizations/{organization}/sources/{source}/findings/{finding}
     * - folder: folders/{folder}
     * - folderAssetSecurityMarks: folders/{folder}/assets/{asset}/securityMarks
     * - folderConstraintName: folders/{folder}/policies/{constraint_name}
     * - folderLocation: folders/{folder}/locations/{location}
     * - folderLocationExport: folders/{folder}/locations/{location}/bigQueryExports/{export}
     * - folderLocationMuteConfig: folders/{folder}/locations/{location}/muteConfigs/{mute_config}
     * - folderLocationNotificationConfig: folders/{folder}/locations/{location}/notificationConfigs/{notification_config}
     * - folderMuteConfig: folders/{folder}/muteConfigs/{mute_config}
     * - folderSource: folders/{folder}/sources/{source}
     * - folderSourceFinding: folders/{folder}/sources/{source}/findings/{finding}
     * - folderSourceFindingExternalsystem: folders/{folder}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - folderSourceFindingSecurityMarks: folders/{folder}/sources/{source}/findings/{finding}/securityMarks
     * - folderSourceLocationFinding: folders/{folder}/sources/{source}/locations/{location}/findings/{finding}
     * - folderSourceLocationFindingExternalsystem: folders/{folder}/sources/{source}/locations/{location}/findings/{finding}/externalSystems/{externalsystem}
     * - folderSourceLocationFindingSecurityMarks: folders/{folder}/sources/{source}/locations/{location}/findings/{finding}/securityMarks
     * - location: projects/{project}/locations/{location}
     * - muteConfig: organizations/{organization}/muteConfigs/{mute_config}
     * - notificationConfig: organizations/{organization}/locations/{location}/notificationConfigs/{notification_config}
     * - organization: organizations/{organization}
     * - organizationAssetSecurityMarks: organizations/{organization}/assets/{asset}/securityMarks
     * - organizationConstraintName: organizations/{organization}/policies/{constraint_name}
     * - organizationLocation: organizations/{organization}/locations/{location}
     * - organizationLocationExport: organizations/{organization}/locations/{location}/bigQueryExports/{export}
     * - organizationLocationMuteConfig: organizations/{organization}/locations/{location}/muteConfigs/{mute_config}
     * - organizationLocationNotificationConfig: organizations/{organization}/locations/{location}/notificationConfigs/{notification_config}
     * - organizationLocationResourceValueConfig: organizations/{organization}/locations/{location}/resourceValueConfigs/{resource_value_config}
     * - organizationLocationSimluation: organizations/{organization}/locations/{location}/simulations/{simluation}
     * - organizationLocationSimluationValuedResource: organizations/{organization}/locations/{location}/simulations/{simluation}/valuedResources/{valued_resource}
     * - organizationMuteConfig: organizations/{organization}/muteConfigs/{mute_config}
     * - organizationResourceValueConfig: organizations/{organization}/resourceValueConfigs/{resource_value_config}
     * - organizationSimulation: organizations/{organization}/simulations/{simulation}
     * - organizationSimulationValuedResource: organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}
     * - organizationSource: organizations/{organization}/sources/{source}
     * - organizationSourceFinding: organizations/{organization}/sources/{source}/findings/{finding}
     * - organizationSourceFindingExternalsystem: organizations/{organization}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - organizationSourceFindingSecurityMarks: organizations/{organization}/sources/{source}/findings/{finding}/securityMarks
     * - organizationSourceLocationFinding: organizations/{organization}/sources/{source}/locations/{location}/findings/{finding}
     * - organizationSourceLocationFindingExternalsystem: organizations/{organization}/sources/{source}/locations/{location}/findings/{finding}/externalSystems/{externalsystem}
     * - organizationSourceLocationFindingSecurityMarks: organizations/{organization}/sources/{source}/locations/{location}/findings/{finding}/securityMarks
     * - organizationValuedResource: organizations/{organization}/locations/{location}/simulations/{simulation}/valuedResources/{valued_resource}
     * - policy: organizations/{organization}/policies/{constraint_name}
     * - project: projects/{project}
     * - projectAssetSecurityMarks: projects/{project}/assets/{asset}/securityMarks
     * - projectConstraintName: projects/{project}/policies/{constraint_name}
     * - projectDlpJob: projects/{project}/dlpJobs/{dlp_job}
     * - projectLocationDlpJob: projects/{project}/locations/{location}/dlpJobs/{dlp_job}
     * - projectLocationExport: projects/{project}/locations/{location}/bigQueryExports/{export}
     * - projectLocationMuteConfig: projects/{project}/locations/{location}/muteConfigs/{mute_config}
     * - projectLocationNotificationConfig: projects/{project}/locations/{location}/notificationConfigs/{notification_config}
     * - projectLocationTableProfile: projects/{project}/locations/{location}/tableProfiles/{table_profile}
     * - projectMuteConfig: projects/{project}/muteConfigs/{mute_config}
     * - projectSource: projects/{project}/sources/{source}
     * - projectSourceFinding: projects/{project}/sources/{source}/findings/{finding}
     * - projectSourceFindingExternalsystem: projects/{project}/sources/{source}/findings/{finding}/externalSystems/{externalsystem}
     * - projectSourceFindingSecurityMarks: projects/{project}/sources/{source}/findings/{finding}/securityMarks
     * - projectSourceLocationFinding: projects/{project}/sources/{source}/locations/{location}/findings/{finding}
     * - projectSourceLocationFindingExternalsystem: projects/{project}/sources/{source}/locations/{location}/findings/{finding}/externalSystems/{externalsystem}
     * - projectSourceLocationFindingSecurityMarks: projects/{project}/sources/{source}/locations/{location}/findings/{finding}/securityMarks
     * - projectTableProfile: projects/{project}/tableProfiles/{table_profile}
     * - resourceValueConfig: organizations/{organization}/resourceValueConfigs/{resource_value_config}
     * - securityMarks: organizations/{organization}/assets/{asset}/securityMarks
     * - simulation: organizations/{organization}/simulations/{simulation}
     * - source: organizations/{organization}/sources/{source}
     * - tableDataProfile: projects/{project}/tableProfiles/{table_profile}
     * - topic: projects/{project}/topics/{topic}
     * - valuedResource: organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'securitycenter.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\SecurityCenter\V2\SecurityCenterClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new SecurityCenterClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a ResourceValueConfig for an organization. Maps user's tags to
     * difference resource values for use by the attack path simulation.
     *
     * The async variant is
     * {@see SecurityCenterClient::batchCreateResourceValueConfigsAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/batch_create_resource_value_configs.php
     *
     * @param BatchCreateResourceValueConfigsRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchCreateResourceValueConfigsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchCreateResourceValueConfigs(
        BatchCreateResourceValueConfigsRequest $request,
        array $callOptions = []
    ): BatchCreateResourceValueConfigsResponse {
        return $this->startApiCall('BatchCreateResourceValueConfigs', $request, $callOptions)->wait();
    }

    /**
     * Kicks off an LRO to bulk mute findings for a parent based on a filter. If
     * no location is specified, findings are muted in global. The parent
     * can be either an organization, folder, or project. The findings matched by
     * the filter will be muted after the LRO is done.
     *
     * The async variant is {@see SecurityCenterClient::bulkMuteFindingsAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/bulk_mute_findings.php
     *
     * @param BulkMuteFindingsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<BulkMuteFindingsResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function bulkMuteFindings(BulkMuteFindingsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('BulkMuteFindings', $request, $callOptions)->wait();
    }

    /**
     * Creates a BigQuery export.
     *
     * The async variant is {@see SecurityCenterClient::createBigQueryExportAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/create_big_query_export.php
     *
     * @param CreateBigQueryExportRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BigQueryExport
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBigQueryExport(CreateBigQueryExportRequest $request, array $callOptions = []): BigQueryExport
    {
        return $this->startApiCall('CreateBigQueryExport', $request, $callOptions)->wait();
    }

    /**
     * Creates a finding in a location. The corresponding source must exist for
     * finding creation to succeed.
     *
     * The async variant is {@see SecurityCenterClient::createFindingAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/create_finding.php
     *
     * @param CreateFindingRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Finding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createFinding(CreateFindingRequest $request, array $callOptions = []): Finding
    {
        return $this->startApiCall('CreateFinding', $request, $callOptions)->wait();
    }

    /**
     * Creates a mute config.
     *
     * The async variant is {@see SecurityCenterClient::createMuteConfigAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/create_mute_config.php
     *
     * @param CreateMuteConfigRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MuteConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createMuteConfig(CreateMuteConfigRequest $request, array $callOptions = []): MuteConfig
    {
        return $this->startApiCall('CreateMuteConfig', $request, $callOptions)->wait();
    }

    /**
     * Creates a notification config.
     *
     * The async variant is
     * {@see SecurityCenterClient::createNotificationConfigAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/create_notification_config.php
     *
     * @param CreateNotificationConfigRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NotificationConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createNotificationConfig(
        CreateNotificationConfigRequest $request,
        array $callOptions = []
    ): NotificationConfig {
        return $this->startApiCall('CreateNotificationConfig', $request, $callOptions)->wait();
    }

    /**
     * Creates a source.
     *
     * The async variant is {@see SecurityCenterClient::createSourceAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/create_source.php
     *
     * @param CreateSourceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Source
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSource(CreateSourceRequest $request, array $callOptions = []): Source
    {
        return $this->startApiCall('CreateSource', $request, $callOptions)->wait();
    }

    /**
     * Deletes an existing BigQuery export.
     *
     * The async variant is {@see SecurityCenterClient::deleteBigQueryExportAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/delete_big_query_export.php
     *
     * @param DeleteBigQueryExportRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBigQueryExport(DeleteBigQueryExportRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteBigQueryExport', $request, $callOptions)->wait();
    }

    /**
     * Deletes an existing mute config. If no location is specified, default is
     * global.
     *
     * The async variant is {@see SecurityCenterClient::deleteMuteConfigAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/delete_mute_config.php
     *
     * @param DeleteMuteConfigRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteMuteConfig(DeleteMuteConfigRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteMuteConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes a notification config.
     *
     * The async variant is
     * {@see SecurityCenterClient::deleteNotificationConfigAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/delete_notification_config.php
     *
     * @param DeleteNotificationConfigRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteNotificationConfig(DeleteNotificationConfigRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteNotificationConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes a ResourceValueConfig.
     *
     * The async variant is
     * {@see SecurityCenterClient::deleteResourceValueConfigAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/delete_resource_value_config.php
     *
     * @param DeleteResourceValueConfigRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteResourceValueConfig(DeleteResourceValueConfigRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteResourceValueConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets a BigQuery export.
     *
     * The async variant is {@see SecurityCenterClient::getBigQueryExportAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/get_big_query_export.php
     *
     * @param GetBigQueryExportRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BigQueryExport
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBigQueryExport(GetBigQueryExportRequest $request, array $callOptions = []): BigQueryExport
    {
        return $this->startApiCall('GetBigQueryExport', $request, $callOptions)->wait();
    }

    /**
     * Gets the access control policy on the specified Source.
     *
     * The async variant is {@see SecurityCenterClient::getIamPolicyAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets a mute config. If no location is specified, default is
     * global.
     *
     * The async variant is {@see SecurityCenterClient::getMuteConfigAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/get_mute_config.php
     *
     * @param GetMuteConfigRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MuteConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMuteConfig(GetMuteConfigRequest $request, array $callOptions = []): MuteConfig
    {
        return $this->startApiCall('GetMuteConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets a notification config.
     *
     * The async variant is {@see SecurityCenterClient::getNotificationConfigAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/get_notification_config.php
     *
     * @param GetNotificationConfigRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NotificationConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNotificationConfig(
        GetNotificationConfigRequest $request,
        array $callOptions = []
    ): NotificationConfig {
        return $this->startApiCall('GetNotificationConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets a ResourceValueConfig.
     *
     * The async variant is {@see SecurityCenterClient::getResourceValueConfigAsync()}
     * .
     *
     * @example samples/V2/SecurityCenterClient/get_resource_value_config.php
     *
     * @param GetResourceValueConfigRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ResourceValueConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getResourceValueConfig(
        GetResourceValueConfigRequest $request,
        array $callOptions = []
    ): ResourceValueConfig {
        return $this->startApiCall('GetResourceValueConfig', $request, $callOptions)->wait();
    }

    /**
     * Get the simulation by name or the latest simulation for the given
     * organization.
     *
     * The async variant is {@see SecurityCenterClient::getSimulationAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/get_simulation.php
     *
     * @param GetSimulationRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Simulation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSimulation(GetSimulationRequest $request, array $callOptions = []): Simulation
    {
        return $this->startApiCall('GetSimulation', $request, $callOptions)->wait();
    }

    /**
     * Gets a source.
     *
     * The async variant is {@see SecurityCenterClient::getSourceAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/get_source.php
     *
     * @param GetSourceRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Source
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSource(GetSourceRequest $request, array $callOptions = []): Source
    {
        return $this->startApiCall('GetSource', $request, $callOptions)->wait();
    }

    /**
     * Get the valued resource by name
     *
     * The async variant is {@see SecurityCenterClient::getValuedResourceAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/get_valued_resource.php
     *
     * @param GetValuedResourceRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ValuedResource
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getValuedResource(GetValuedResourceRequest $request, array $callOptions = []): ValuedResource
    {
        return $this->startApiCall('GetValuedResource', $request, $callOptions)->wait();
    }

    /**
     * Filters an organization or source's findings and groups them by their
     * specified properties in a location. If no location is specified, findings
     * are assumed to be in global
     *
     * To group across all sources provide a `-` as the source id.
     * The following list shows some examples:
     *
     * + `/v2/organizations/{organization_id}/sources/-/findings`
     * +
     * `/v2/organizations/{organization_id}/sources/-/locations/{location_id}/findings`
     * + `/v2/folders/{folder_id}/sources/-/findings`
     * + `/v2/folders/{folder_id}/sources/-/locations/{location_id}/findings`
     * + `/v2/projects/{project_id}/sources/-/findings`
     * + `/v2/projects/{project_id}/sources/-/locations/{location_id}/findings`
     *
     * The async variant is {@see SecurityCenterClient::groupFindingsAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/group_findings.php
     *
     * @param GroupFindingsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function groupFindings(GroupFindingsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('GroupFindings', $request, $callOptions);
    }

    /**
     * Lists the attack paths for a set of simulation results or valued resources
     * and filter.
     *
     * The async variant is {@see SecurityCenterClient::listAttackPathsAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/list_attack_paths.php
     *
     * @param ListAttackPathsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAttackPaths(ListAttackPathsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAttackPaths', $request, $callOptions);
    }

    /**
     * Lists BigQuery exports. Note that when requesting BigQuery exports at a
     * given level all exports under that level are also returned e.g. if
     * requesting BigQuery exports under a folder, then all BigQuery exports
     * immediately under the folder plus the ones created under the projects
     * within the folder are returned.
     *
     * The async variant is {@see SecurityCenterClient::listBigQueryExportsAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/list_big_query_exports.php
     *
     * @param ListBigQueryExportsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBigQueryExports(ListBigQueryExportsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBigQueryExports', $request, $callOptions);
    }

    /**
     * Lists an organization or source's findings.
     *
     * To list across all sources for a given location provide a `-` as the source
     * id. If no location is specified, finding are assumed to be in global.
     * The following list shows some examples:
     *
     * + `/v2/organizations/{organization_id}/sources/-/findings`
     * +
     * `/v2/organizations/{organization_id}/sources/-/locations/{location_id}/findings`
     *
     * The async variant is {@see SecurityCenterClient::listFindingsAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/list_findings.php
     *
     * @param ListFindingsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listFindings(ListFindingsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListFindings', $request, $callOptions);
    }

    /**
     * Lists mute configs. If no location is specified, default is
     * global.
     *
     * The async variant is {@see SecurityCenterClient::listMuteConfigsAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/list_mute_configs.php
     *
     * @param ListMuteConfigsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMuteConfigs(ListMuteConfigsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMuteConfigs', $request, $callOptions);
    }

    /**
     * Lists notification configs.
     *
     * The async variant is {@see SecurityCenterClient::listNotificationConfigsAsync()}
     * .
     *
     * @example samples/V2/SecurityCenterClient/list_notification_configs.php
     *
     * @param ListNotificationConfigsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNotificationConfigs(
        ListNotificationConfigsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListNotificationConfigs', $request, $callOptions);
    }

    /**
     * Lists all ResourceValueConfigs.
     *
     * The async variant is
     * {@see SecurityCenterClient::listResourceValueConfigsAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/list_resource_value_configs.php
     *
     * @param ListResourceValueConfigsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listResourceValueConfigs(
        ListResourceValueConfigsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListResourceValueConfigs', $request, $callOptions);
    }

    /**
     * Lists all sources belonging to an organization.
     *
     * The async variant is {@see SecurityCenterClient::listSourcesAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/list_sources.php
     *
     * @param ListSourcesRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSources(ListSourcesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSources', $request, $callOptions);
    }

    /**
     * Lists the valued resources for a set of simulation results and filter.
     *
     * The async variant is {@see SecurityCenterClient::listValuedResourcesAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/list_valued_resources.php
     *
     * @param ListValuedResourcesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listValuedResources(ListValuedResourcesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListValuedResources', $request, $callOptions);
    }

    /**
     * Updates the state of a finding. If no location is specified, finding is
     * assumed to be in global
     *
     * The async variant is {@see SecurityCenterClient::setFindingStateAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/set_finding_state.php
     *
     * @param SetFindingStateRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Finding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setFindingState(SetFindingStateRequest $request, array $callOptions = []): Finding
    {
        return $this->startApiCall('SetFindingState', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified Source.
     *
     * The async variant is {@see SecurityCenterClient::setIamPolicyAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Updates the mute state of a finding. If no location is specified, finding
     * is assumed to be in global
     *
     * The async variant is {@see SecurityCenterClient::setMuteAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/set_mute.php
     *
     * @param SetMuteRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Finding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setMute(SetMuteRequest $request, array $callOptions = []): Finding
    {
        return $this->startApiCall('SetMute', $request, $callOptions)->wait();
    }

    /**
     * Returns the permissions that a caller has on the specified source.
     *
     * The async variant is {@see SecurityCenterClient::testIamPermissionsAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Updates a BigQuery export.
     *
     * The async variant is {@see SecurityCenterClient::updateBigQueryExportAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/update_big_query_export.php
     *
     * @param UpdateBigQueryExportRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BigQueryExport
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBigQueryExport(UpdateBigQueryExportRequest $request, array $callOptions = []): BigQueryExport
    {
        return $this->startApiCall('UpdateBigQueryExport', $request, $callOptions)->wait();
    }

    /**
     * Updates external system. This is for a given finding. If no location is
     * specified, finding is assumed to be in global
     *
     * The async variant is {@see SecurityCenterClient::updateExternalSystemAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/update_external_system.php
     *
     * @param UpdateExternalSystemRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ExternalSystem
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateExternalSystem(UpdateExternalSystemRequest $request, array $callOptions = []): ExternalSystem
    {
        return $this->startApiCall('UpdateExternalSystem', $request, $callOptions)->wait();
    }

    /**
     * Creates or updates a finding. If no location is specified, finding is
     * assumed to be in global. The corresponding source must exist for a finding
     * creation to succeed.
     *
     * The async variant is {@see SecurityCenterClient::updateFindingAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/update_finding.php
     *
     * @param UpdateFindingRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Finding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateFinding(UpdateFindingRequest $request, array $callOptions = []): Finding
    {
        return $this->startApiCall('UpdateFinding', $request, $callOptions)->wait();
    }

    /**
     * Updates a mute config. If no location is specified, default is
     * global.
     *
     * The async variant is {@see SecurityCenterClient::updateMuteConfigAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/update_mute_config.php
     *
     * @param UpdateMuteConfigRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MuteConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateMuteConfig(UpdateMuteConfigRequest $request, array $callOptions = []): MuteConfig
    {
        return $this->startApiCall('UpdateMuteConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates a notification config. The following update
     * fields are allowed: description, pubsub_topic, streaming_config.filter
     *
     * The async variant is
     * {@see SecurityCenterClient::updateNotificationConfigAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/update_notification_config.php
     *
     * @param UpdateNotificationConfigRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NotificationConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateNotificationConfig(
        UpdateNotificationConfigRequest $request,
        array $callOptions = []
    ): NotificationConfig {
        return $this->startApiCall('UpdateNotificationConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates an existing ResourceValueConfigs with new rules.
     *
     * The async variant is
     * {@see SecurityCenterClient::updateResourceValueConfigAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/update_resource_value_config.php
     *
     * @param UpdateResourceValueConfigRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ResourceValueConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateResourceValueConfig(
        UpdateResourceValueConfigRequest $request,
        array $callOptions = []
    ): ResourceValueConfig {
        return $this->startApiCall('UpdateResourceValueConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates security marks. For Finding Security marks, if no location is
     * specified, finding is assumed to be in global. Assets Security Marks can
     * only be accessed through global endpoint.
     *
     * The async variant is {@see SecurityCenterClient::updateSecurityMarksAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/update_security_marks.php
     *
     * @param UpdateSecurityMarksRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SecurityMarks
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSecurityMarks(UpdateSecurityMarksRequest $request, array $callOptions = []): SecurityMarks
    {
        return $this->startApiCall('UpdateSecurityMarks', $request, $callOptions)->wait();
    }

    /**
     * Updates a source.
     *
     * The async variant is {@see SecurityCenterClient::updateSourceAsync()} .
     *
     * @example samples/V2/SecurityCenterClient/update_source.php
     *
     * @param UpdateSourceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Source
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSource(UpdateSourceRequest $request, array $callOptions = []): Source
    {
        return $this->startApiCall('UpdateSource', $request, $callOptions)->wait();
    }
}
