<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/common.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The inventory information at a place (e.g. a store) identified
 * by a place ID.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.LocalInventory</code>
 */
class LocalInventory extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. The place ID for the current set of inventory information.
     *
     * Generated from protobuf field <code>string place_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $place_id = '';
    /**
     * Optional. Product price and cost information.
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.PriceInfo price_info = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $price_info = null;
    /**
     * Optional. Additional local inventory attributes, for example, store name,
     * promotion tags, etc.
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     * * At most 30 attributes are allowed.
     * * The key must be a UTF-8 encoded string with a length limit of 32
     *   characters.
     * * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
     *   key0LikeThis or KEY_1_LIKE_THIS.
     * * The attribute values must be of the same type (text or number).
     * * Only 1 value is allowed for each attribute.
     * * For text values, the length limit is 256 UTF-8 characters.
     * * The attribute does not support search. The `searchable` field should be
     *   unset or set to false.
     * * The max summed total bytes of custom attribute keys and values per
     *   product is 5MiB.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.retail.v2.CustomAttribute> attributes = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $attributes;
    /**
     * Optional. Supported fulfillment types. Valid fulfillment type values
     * include commonly used types (such as pickup in store and same day
     * delivery), and custom types. Customers have to map custom types to their
     * display names before rendering UI.
     * Supported values:
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Generated from protobuf field <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $fulfillment_types;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $place_id
     *           Optional. The place ID for the current set of inventory information.
     *     @type \Google\Cloud\Retail\V2\PriceInfo $price_info
     *           Optional. Product price and cost information.
     *           Google Merchant Center property
     *           [price](https://support.google.com/merchants/answer/6324371).
     *     @type array|\Google\Protobuf\Internal\MapField $attributes
     *           Optional. Additional local inventory attributes, for example, store name,
     *           promotion tags, etc.
     *           This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     *           error is returned:
     *           * At most 30 attributes are allowed.
     *           * The key must be a UTF-8 encoded string with a length limit of 32
     *             characters.
     *           * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
     *             key0LikeThis or KEY_1_LIKE_THIS.
     *           * The attribute values must be of the same type (text or number).
     *           * Only 1 value is allowed for each attribute.
     *           * For text values, the length limit is 256 UTF-8 characters.
     *           * The attribute does not support search. The `searchable` field should be
     *             unset or set to false.
     *           * The max summed total bytes of custom attribute keys and values per
     *             product is 5MiB.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $fulfillment_types
     *           Optional. Supported fulfillment types. Valid fulfillment type values
     *           include commonly used types (such as pickup in store and same day
     *           delivery), and custom types. Customers have to map custom types to their
     *           display names before rendering UI.
     *           Supported values:
     *           * "pickup-in-store"
     *           * "ship-to-store"
     *           * "same-day-delivery"
     *           * "next-day-delivery"
     *           * "custom-type-1"
     *           * "custom-type-2"
     *           * "custom-type-3"
     *           * "custom-type-4"
     *           * "custom-type-5"
     *           If this field is set to an invalid value other than these, an
     *           INVALID_ARGUMENT error is returned.
     *           All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
     *           returned.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\Common::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. The place ID for the current set of inventory information.
     *
     * Generated from protobuf field <code>string place_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPlaceId()
    {
        return $this->place_id;
    }

    /**
     * Optional. The place ID for the current set of inventory information.
     *
     * Generated from protobuf field <code>string place_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPlaceId($var)
    {
        GPBUtil::checkString($var, True);
        $this->place_id = $var;

        return $this;
    }

    /**
     * Optional. Product price and cost information.
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.PriceInfo price_info = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Retail\V2\PriceInfo|null
     */
    public function getPriceInfo()
    {
        return $this->price_info;
    }

    public function hasPriceInfo()
    {
        return isset($this->price_info);
    }

    public function clearPriceInfo()
    {
        unset($this->price_info);
    }

    /**
     * Optional. Product price and cost information.
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.PriceInfo price_info = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Retail\V2\PriceInfo $var
     * @return $this
     */
    public function setPriceInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\PriceInfo::class);
        $this->price_info = $var;

        return $this;
    }

    /**
     * Optional. Additional local inventory attributes, for example, store name,
     * promotion tags, etc.
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     * * At most 30 attributes are allowed.
     * * The key must be a UTF-8 encoded string with a length limit of 32
     *   characters.
     * * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
     *   key0LikeThis or KEY_1_LIKE_THIS.
     * * The attribute values must be of the same type (text or number).
     * * Only 1 value is allowed for each attribute.
     * * For text values, the length limit is 256 UTF-8 characters.
     * * The attribute does not support search. The `searchable` field should be
     *   unset or set to false.
     * * The max summed total bytes of custom attribute keys and values per
     *   product is 5MiB.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.retail.v2.CustomAttribute> attributes = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * Optional. Additional local inventory attributes, for example, store name,
     * promotion tags, etc.
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     * * At most 30 attributes are allowed.
     * * The key must be a UTF-8 encoded string with a length limit of 32
     *   characters.
     * * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
     *   key0LikeThis or KEY_1_LIKE_THIS.
     * * The attribute values must be of the same type (text or number).
     * * Only 1 value is allowed for each attribute.
     * * For text values, the length limit is 256 UTF-8 characters.
     * * The attribute does not support search. The `searchable` field should be
     *   unset or set to false.
     * * The max summed total bytes of custom attribute keys and values per
     *   product is 5MiB.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.retail.v2.CustomAttribute> attributes = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAttributes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Retail\V2\CustomAttribute::class);
        $this->attributes = $arr;

        return $this;
    }

    /**
     * Optional. Supported fulfillment types. Valid fulfillment type values
     * include commonly used types (such as pickup in store and same day
     * delivery), and custom types. Customers have to map custom types to their
     * display names before rendering UI.
     * Supported values:
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Generated from protobuf field <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFulfillmentTypes()
    {
        return $this->fulfillment_types;
    }

    /**
     * Optional. Supported fulfillment types. Valid fulfillment type values
     * include commonly used types (such as pickup in store and same day
     * delivery), and custom types. Customers have to map custom types to their
     * display names before rendering UI.
     * Supported values:
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Generated from protobuf field <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFulfillmentTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->fulfillment_types = $arr;

        return $this;
    }

}

