<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/policytroubleshooter/iam/v3/troubleshooter.proto

namespace Google\Cloud\PolicyTroubleshooter\Iam\V3\ConditionContext;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Core attributes for a resource. A resource is an
 * addressable (named) entity provided by the destination service. For
 * example, a Compute Engine instance.
 *
 * Generated from protobuf message <code>google.cloud.policytroubleshooter.iam.v3.ConditionContext.Resource</code>
 */
class Resource extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the service that this resource belongs to, such as
     * `compute.googleapis.com`. The service name might not match the DNS
     * hostname that actually serves the request.
     * For a full list of resource service values, see
     * https://cloud.google.com/iam/help/conditions/resource-services
     *
     * Generated from protobuf field <code>string service = 1;</code>
     */
    protected $service = '';
    /**
     * The stable identifier (name) of a resource on the `service`. A resource
     * can be logically identified as `//{resource.service}/{resource.name}`.
     * Unlike the resource URI, the resource name doesn't contain any protocol
     * and version information.
     * For a list of full resource name formats, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names
     *
     * Generated from protobuf field <code>string name = 2;</code>
     */
    protected $name = '';
    /**
     * The type of the resource, in the format `{service}/{kind}`.
     * For a full list of resource type values, see
     * https://cloud.google.com/iam/help/conditions/resource-types
     *
     * Generated from protobuf field <code>string type = 3;</code>
     */
    protected $type = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $service
     *           The name of the service that this resource belongs to, such as
     *           `compute.googleapis.com`. The service name might not match the DNS
     *           hostname that actually serves the request.
     *           For a full list of resource service values, see
     *           https://cloud.google.com/iam/help/conditions/resource-services
     *     @type string $name
     *           The stable identifier (name) of a resource on the `service`. A resource
     *           can be logically identified as `//{resource.service}/{resource.name}`.
     *           Unlike the resource URI, the resource name doesn't contain any protocol
     *           and version information.
     *           For a list of full resource name formats, see
     *           https://cloud.google.com/iam/help/troubleshooter/full-resource-names
     *     @type string $type
     *           The type of the resource, in the format `{service}/{kind}`.
     *           For a full list of resource type values, see
     *           https://cloud.google.com/iam/help/conditions/resource-types
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Policytroubleshooter\Iam\V3\Troubleshooter::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of the service that this resource belongs to, such as
     * `compute.googleapis.com`. The service name might not match the DNS
     * hostname that actually serves the request.
     * For a full list of resource service values, see
     * https://cloud.google.com/iam/help/conditions/resource-services
     *
     * Generated from protobuf field <code>string service = 1;</code>
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }

    /**
     * The name of the service that this resource belongs to, such as
     * `compute.googleapis.com`. The service name might not match the DNS
     * hostname that actually serves the request.
     * For a full list of resource service values, see
     * https://cloud.google.com/iam/help/conditions/resource-services
     *
     * Generated from protobuf field <code>string service = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setService($var)
    {
        GPBUtil::checkString($var, True);
        $this->service = $var;

        return $this;
    }

    /**
     * The stable identifier (name) of a resource on the `service`. A resource
     * can be logically identified as `//{resource.service}/{resource.name}`.
     * Unlike the resource URI, the resource name doesn't contain any protocol
     * and version information.
     * For a list of full resource name formats, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names
     *
     * Generated from protobuf field <code>string name = 2;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The stable identifier (name) of a resource on the `service`. A resource
     * can be logically identified as `//{resource.service}/{resource.name}`.
     * Unlike the resource URI, the resource name doesn't contain any protocol
     * and version information.
     * For a list of full resource name formats, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names
     *
     * Generated from protobuf field <code>string name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The type of the resource, in the format `{service}/{kind}`.
     * For a full list of resource type values, see
     * https://cloud.google.com/iam/help/conditions/resource-types
     *
     * Generated from protobuf field <code>string type = 3;</code>
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * The type of the resource, in the format `{service}/{kind}`.
     * For a full list of resource type values, see
     * https://cloud.google.com/iam/help/conditions/resource-types
     *
     * Generated from protobuf field <code>string type = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkString($var, True);
        $this->type = $var;

        return $this;
    }

}


