<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/oracledatabase/v1/db_system.proto

namespace Google\Cloud\OracleDatabase\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The properties of a DbSystem.
 *
 * Generated from protobuf message <code>google.cloud.oracledatabase.v1.DbSystemProperties</code>
 */
class DbSystemProperties extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Shape of DB System.
     *
     * Generated from protobuf field <code>string shape = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $shape = '';
    /**
     * Required. The number of CPU cores to enable for the DbSystem.
     *
     * Generated from protobuf field <code>int32 compute_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $compute_count = 0;
    /**
     * Required. The initial data storage size in GB.
     *
     * Generated from protobuf field <code>int32 initial_data_storage_size_gb = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $initial_data_storage_size_gb = 0;
    /**
     * Required. The database edition of the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemProperties.DbSystemDatabaseEdition database_edition = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $database_edition = 0;
    /**
     * Required. The license model of the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemProperties.LicenseModel license_model = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $license_model = 0;
    /**
     * Required. SSH public keys to be stored with the DbSystem.
     *
     * Generated from protobuf field <code>repeated string ssh_public_keys = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $ssh_public_keys;
    /**
     * Optional. Prefix for DB System host names.
     *
     * Generated from protobuf field <code>string hostname_prefix = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $hostname_prefix = '';
    /**
     * Output only. The hostname of the DbSystem.
     *
     * Generated from protobuf field <code>string hostname = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $hostname = '';
    /**
     * Optional. The private IP address of the DbSystem.
     *
     * Generated from protobuf field <code>string private_ip = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $private_ip = '';
    /**
     * Optional. Data collection options for diagnostics.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DataCollectionOptionsDbSystem data_collection_options = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $data_collection_options = null;
    /**
     * Optional. Time zone of the DbSystem.
     *
     * Generated from protobuf field <code>.google.type.TimeZone time_zone = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $time_zone = null;
    /**
     * Output only. State of the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemProperties.DbSystemLifecycleState lifecycle_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $lifecycle_state = 0;
    /**
     * Optional. Details for creating a Database Home.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbHome db_home = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $db_home = null;
    /**
     * Output only. OCID of the DbSystem.
     *
     * Generated from protobuf field <code>string ocid = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $ocid = '';
    /**
     * Optional. The memory size in GB.
     *
     * Generated from protobuf field <code>int32 memory_size_gb = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $memory_size_gb = 0;
    /**
     * Optional. The compute model of the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemProperties.ComputeModel compute_model = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $compute_model = 0;
    /**
     * Optional. The data storage size in GB that is currently available to
     * DbSystems.
     *
     * Generated from protobuf field <code>int32 data_storage_size_gb = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $data_storage_size_gb = 0;
    /**
     * Optional. The reco/redo storage size in GB.
     *
     * Generated from protobuf field <code>int32 reco_storage_size_gb = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $reco_storage_size_gb = 0;
    /**
     * Optional. The host domain name of the DbSystem.
     *
     * Generated from protobuf field <code>string domain = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $domain = '';
    /**
     * Optional. The number of nodes in the DbSystem.
     *
     * Generated from protobuf field <code>int32 node_count = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $node_count = 0;
    /**
     * Optional. The options for the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemOptions db_system_options = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $db_system_options = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $shape
     *           Required. Shape of DB System.
     *     @type int $compute_count
     *           Required. The number of CPU cores to enable for the DbSystem.
     *     @type int $initial_data_storage_size_gb
     *           Required. The initial data storage size in GB.
     *     @type int $database_edition
     *           Required. The database edition of the DbSystem.
     *     @type int $license_model
     *           Required. The license model of the DbSystem.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $ssh_public_keys
     *           Required. SSH public keys to be stored with the DbSystem.
     *     @type string $hostname_prefix
     *           Optional. Prefix for DB System host names.
     *     @type string $hostname
     *           Output only. The hostname of the DbSystem.
     *     @type string $private_ip
     *           Optional. The private IP address of the DbSystem.
     *     @type \Google\Cloud\OracleDatabase\V1\DataCollectionOptionsDbSystem $data_collection_options
     *           Optional. Data collection options for diagnostics.
     *     @type \Google\Type\TimeZone $time_zone
     *           Optional. Time zone of the DbSystem.
     *     @type int $lifecycle_state
     *           Output only. State of the DbSystem.
     *     @type \Google\Cloud\OracleDatabase\V1\DbHome $db_home
     *           Optional. Details for creating a Database Home.
     *     @type string $ocid
     *           Output only. OCID of the DbSystem.
     *     @type int $memory_size_gb
     *           Optional. The memory size in GB.
     *     @type int $compute_model
     *           Optional. The compute model of the DbSystem.
     *     @type int $data_storage_size_gb
     *           Optional. The data storage size in GB that is currently available to
     *           DbSystems.
     *     @type int $reco_storage_size_gb
     *           Optional. The reco/redo storage size in GB.
     *     @type string $domain
     *           Optional. The host domain name of the DbSystem.
     *     @type int $node_count
     *           Optional. The number of nodes in the DbSystem.
     *     @type \Google\Cloud\OracleDatabase\V1\DbSystemOptions $db_system_options
     *           Optional. The options for the DbSystem.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Oracledatabase\V1\DbSystem::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Shape of DB System.
     *
     * Generated from protobuf field <code>string shape = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getShape()
    {
        return $this->shape;
    }

    /**
     * Required. Shape of DB System.
     *
     * Generated from protobuf field <code>string shape = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setShape($var)
    {
        GPBUtil::checkString($var, True);
        $this->shape = $var;

        return $this;
    }

    /**
     * Required. The number of CPU cores to enable for the DbSystem.
     *
     * Generated from protobuf field <code>int32 compute_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getComputeCount()
    {
        return $this->compute_count;
    }

    /**
     * Required. The number of CPU cores to enable for the DbSystem.
     *
     * Generated from protobuf field <code>int32 compute_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setComputeCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->compute_count = $var;

        return $this;
    }

    /**
     * Required. The initial data storage size in GB.
     *
     * Generated from protobuf field <code>int32 initial_data_storage_size_gb = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getInitialDataStorageSizeGb()
    {
        return $this->initial_data_storage_size_gb;
    }

    /**
     * Required. The initial data storage size in GB.
     *
     * Generated from protobuf field <code>int32 initial_data_storage_size_gb = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setInitialDataStorageSizeGb($var)
    {
        GPBUtil::checkInt32($var);
        $this->initial_data_storage_size_gb = $var;

        return $this;
    }

    /**
     * Required. The database edition of the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemProperties.DbSystemDatabaseEdition database_edition = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getDatabaseEdition()
    {
        return $this->database_edition;
    }

    /**
     * Required. The database edition of the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemProperties.DbSystemDatabaseEdition database_edition = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setDatabaseEdition($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\DbSystemProperties\DbSystemDatabaseEdition::class);
        $this->database_edition = $var;

        return $this;
    }

    /**
     * Required. The license model of the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemProperties.LicenseModel license_model = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getLicenseModel()
    {
        return $this->license_model;
    }

    /**
     * Required. The license model of the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemProperties.LicenseModel license_model = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setLicenseModel($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\DbSystemProperties\LicenseModel::class);
        $this->license_model = $var;

        return $this;
    }

    /**
     * Required. SSH public keys to be stored with the DbSystem.
     *
     * Generated from protobuf field <code>repeated string ssh_public_keys = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSshPublicKeys()
    {
        return $this->ssh_public_keys;
    }

    /**
     * Required. SSH public keys to be stored with the DbSystem.
     *
     * Generated from protobuf field <code>repeated string ssh_public_keys = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSshPublicKeys($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->ssh_public_keys = $arr;

        return $this;
    }

    /**
     * Optional. Prefix for DB System host names.
     *
     * Generated from protobuf field <code>string hostname_prefix = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getHostnamePrefix()
    {
        return $this->hostname_prefix;
    }

    /**
     * Optional. Prefix for DB System host names.
     *
     * Generated from protobuf field <code>string hostname_prefix = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setHostnamePrefix($var)
    {
        GPBUtil::checkString($var, True);
        $this->hostname_prefix = $var;

        return $this;
    }

    /**
     * Output only. The hostname of the DbSystem.
     *
     * Generated from protobuf field <code>string hostname = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getHostname()
    {
        return $this->hostname;
    }

    /**
     * Output only. The hostname of the DbSystem.
     *
     * Generated from protobuf field <code>string hostname = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setHostname($var)
    {
        GPBUtil::checkString($var, True);
        $this->hostname = $var;

        return $this;
    }

    /**
     * Optional. The private IP address of the DbSystem.
     *
     * Generated from protobuf field <code>string private_ip = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPrivateIp()
    {
        return $this->private_ip;
    }

    /**
     * Optional. The private IP address of the DbSystem.
     *
     * Generated from protobuf field <code>string private_ip = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPrivateIp($var)
    {
        GPBUtil::checkString($var, True);
        $this->private_ip = $var;

        return $this;
    }

    /**
     * Optional. Data collection options for diagnostics.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DataCollectionOptionsDbSystem data_collection_options = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\OracleDatabase\V1\DataCollectionOptionsDbSystem|null
     */
    public function getDataCollectionOptions()
    {
        return $this->data_collection_options;
    }

    public function hasDataCollectionOptions()
    {
        return isset($this->data_collection_options);
    }

    public function clearDataCollectionOptions()
    {
        unset($this->data_collection_options);
    }

    /**
     * Optional. Data collection options for diagnostics.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DataCollectionOptionsDbSystem data_collection_options = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\OracleDatabase\V1\DataCollectionOptionsDbSystem $var
     * @return $this
     */
    public function setDataCollectionOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OracleDatabase\V1\DataCollectionOptionsDbSystem::class);
        $this->data_collection_options = $var;

        return $this;
    }

    /**
     * Optional. Time zone of the DbSystem.
     *
     * Generated from protobuf field <code>.google.type.TimeZone time_zone = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Type\TimeZone|null
     */
    public function getTimeZone()
    {
        return $this->time_zone;
    }

    public function hasTimeZone()
    {
        return isset($this->time_zone);
    }

    public function clearTimeZone()
    {
        unset($this->time_zone);
    }

    /**
     * Optional. Time zone of the DbSystem.
     *
     * Generated from protobuf field <code>.google.type.TimeZone time_zone = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Type\TimeZone $var
     * @return $this
     */
    public function setTimeZone($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\TimeZone::class);
        $this->time_zone = $var;

        return $this;
    }

    /**
     * Output only. State of the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemProperties.DbSystemLifecycleState lifecycle_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getLifecycleState()
    {
        return $this->lifecycle_state;
    }

    /**
     * Output only. State of the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemProperties.DbSystemLifecycleState lifecycle_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setLifecycleState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\DbSystemProperties\DbSystemLifecycleState::class);
        $this->lifecycle_state = $var;

        return $this;
    }

    /**
     * Optional. Details for creating a Database Home.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbHome db_home = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\OracleDatabase\V1\DbHome|null
     */
    public function getDbHome()
    {
        return $this->db_home;
    }

    public function hasDbHome()
    {
        return isset($this->db_home);
    }

    public function clearDbHome()
    {
        unset($this->db_home);
    }

    /**
     * Optional. Details for creating a Database Home.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbHome db_home = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\OracleDatabase\V1\DbHome $var
     * @return $this
     */
    public function setDbHome($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OracleDatabase\V1\DbHome::class);
        $this->db_home = $var;

        return $this;
    }

    /**
     * Output only. OCID of the DbSystem.
     *
     * Generated from protobuf field <code>string ocid = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getOcid()
    {
        return $this->ocid;
    }

    /**
     * Output only. OCID of the DbSystem.
     *
     * Generated from protobuf field <code>string ocid = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setOcid($var)
    {
        GPBUtil::checkString($var, True);
        $this->ocid = $var;

        return $this;
    }

    /**
     * Optional. The memory size in GB.
     *
     * Generated from protobuf field <code>int32 memory_size_gb = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getMemorySizeGb()
    {
        return $this->memory_size_gb;
    }

    /**
     * Optional. The memory size in GB.
     *
     * Generated from protobuf field <code>int32 memory_size_gb = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setMemorySizeGb($var)
    {
        GPBUtil::checkInt32($var);
        $this->memory_size_gb = $var;

        return $this;
    }

    /**
     * Optional. The compute model of the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemProperties.ComputeModel compute_model = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getComputeModel()
    {
        return $this->compute_model;
    }

    /**
     * Optional. The compute model of the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemProperties.ComputeModel compute_model = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setComputeModel($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\DbSystemProperties\ComputeModel::class);
        $this->compute_model = $var;

        return $this;
    }

    /**
     * Optional. The data storage size in GB that is currently available to
     * DbSystems.
     *
     * Generated from protobuf field <code>int32 data_storage_size_gb = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getDataStorageSizeGb()
    {
        return $this->data_storage_size_gb;
    }

    /**
     * Optional. The data storage size in GB that is currently available to
     * DbSystems.
     *
     * Generated from protobuf field <code>int32 data_storage_size_gb = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setDataStorageSizeGb($var)
    {
        GPBUtil::checkInt32($var);
        $this->data_storage_size_gb = $var;

        return $this;
    }

    /**
     * Optional. The reco/redo storage size in GB.
     *
     * Generated from protobuf field <code>int32 reco_storage_size_gb = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getRecoStorageSizeGb()
    {
        return $this->reco_storage_size_gb;
    }

    /**
     * Optional. The reco/redo storage size in GB.
     *
     * Generated from protobuf field <code>int32 reco_storage_size_gb = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setRecoStorageSizeGb($var)
    {
        GPBUtil::checkInt32($var);
        $this->reco_storage_size_gb = $var;

        return $this;
    }

    /**
     * Optional. The host domain name of the DbSystem.
     *
     * Generated from protobuf field <code>string domain = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDomain()
    {
        return $this->domain;
    }

    /**
     * Optional. The host domain name of the DbSystem.
     *
     * Generated from protobuf field <code>string domain = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDomain($var)
    {
        GPBUtil::checkString($var, True);
        $this->domain = $var;

        return $this;
    }

    /**
     * Optional. The number of nodes in the DbSystem.
     *
     * Generated from protobuf field <code>int32 node_count = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getNodeCount()
    {
        return $this->node_count;
    }

    /**
     * Optional. The number of nodes in the DbSystem.
     *
     * Generated from protobuf field <code>int32 node_count = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setNodeCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->node_count = $var;

        return $this;
    }

    /**
     * Optional. The options for the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemOptions db_system_options = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\OracleDatabase\V1\DbSystemOptions|null
     */
    public function getDbSystemOptions()
    {
        return $this->db_system_options;
    }

    public function hasDbSystemOptions()
    {
        return isset($this->db_system_options);
    }

    public function clearDbSystemOptions()
    {
        unset($this->db_system_options);
    }

    /**
     * Optional. The options for the DbSystem.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbSystemOptions db_system_options = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\OracleDatabase\V1\DbSystemOptions $var
     * @return $this
     */
    public function setDbSystemOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OracleDatabase\V1\DbSystemOptions::class);
        $this->db_system_options = $var;

        return $this;
    }

}

