<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkmanagement/v1/vpc_flow_logs_config.proto

namespace Google\Cloud\NetworkManagement\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A configuration to generate a response for GetEffectiveVpcFlowLogsConfig
 * request.
 *
 * Generated from protobuf message <code>google.cloud.networkmanagement.v1.EffectiveVpcFlowLogsConfig</code>
 */
class EffectiveVpcFlowLogsConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Unique name of the configuration. The name can have one of the following
     * forms:
     * - For project-level configurations:
     * `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     * - For organization-level configurations:
     * `organizations/{organization_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     * - For a Compute config, the name will be the path of the subnet:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnet_id}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * The state of the VPC Flow Log configuration. Default value is ENABLED.
     * When creating a new configuration, it must be enabled.
     * Setting state=DISABLED will pause the log generation for this config.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.State state = 3;</code>
     */
    protected $state = null;
    /**
     * The aggregation interval for the logs. Default value is INTERVAL_5_SEC.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.AggregationInterval aggregation_interval = 4;</code>
     */
    protected $aggregation_interval = null;
    /**
     * The value of the field must be in (0, 1]. The sampling rate of VPC Flow
     * Logs where 1.0 means all collected logs are reported.
     * Setting the sampling rate to 0.0 is not allowed. If you want to disable VPC
     * Flow Logs, use the state field instead.
     * Default value is 1.0.
     *
     * Generated from protobuf field <code>optional float flow_sampling = 5;</code>
     */
    protected $flow_sampling = null;
    /**
     * Configures whether all, none or a subset of metadata fields should be
     * added to the reported VPC flow logs.
     * Default value is INCLUDE_ALL_METADATA.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.Metadata metadata = 6;</code>
     */
    protected $metadata = null;
    /**
     * Custom metadata fields to include in the reported VPC flow logs.
     * Can only be specified if "metadata" was set to CUSTOM_METADATA.
     *
     * Generated from protobuf field <code>repeated string metadata_fields = 7;</code>
     */
    private $metadata_fields;
    /**
     * Export filter used to define which VPC Flow Logs should be logged.
     *
     * Generated from protobuf field <code>optional string filter_expr = 8;</code>
     */
    protected $filter_expr = null;
    /**
     * Determines whether to include cross project annotations in the logs.
     * This field is available only for organization configurations. If not
     * specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.CrossProjectMetadata cross_project_metadata = 13;</code>
     */
    protected $cross_project_metadata = null;
    /**
     * Specifies the scope of the config (e.g., SUBNET, NETWORK, ORGANIZATION..).
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.EffectiveVpcFlowLogsConfig.Scope scope = 12;</code>
     */
    protected $scope = null;
    protected $target_resource;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Unique name of the configuration. The name can have one of the following
     *           forms:
     *           - For project-level configurations:
     *           `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     *           - For organization-level configurations:
     *           `organizations/{organization_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     *           - For a Compute config, the name will be the path of the subnet:
     *           `projects/{project_id}/regions/{region}/subnetworks/{subnet_id}`
     *     @type int $state
     *           The state of the VPC Flow Log configuration. Default value is ENABLED.
     *           When creating a new configuration, it must be enabled.
     *           Setting state=DISABLED will pause the log generation for this config.
     *     @type int $aggregation_interval
     *           The aggregation interval for the logs. Default value is INTERVAL_5_SEC.
     *     @type float $flow_sampling
     *           The value of the field must be in (0, 1]. The sampling rate of VPC Flow
     *           Logs where 1.0 means all collected logs are reported.
     *           Setting the sampling rate to 0.0 is not allowed. If you want to disable VPC
     *           Flow Logs, use the state field instead.
     *           Default value is 1.0.
     *     @type int $metadata
     *           Configures whether all, none or a subset of metadata fields should be
     *           added to the reported VPC flow logs.
     *           Default value is INCLUDE_ALL_METADATA.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $metadata_fields
     *           Custom metadata fields to include in the reported VPC flow logs.
     *           Can only be specified if "metadata" was set to CUSTOM_METADATA.
     *     @type string $filter_expr
     *           Export filter used to define which VPC Flow Logs should be logged.
     *     @type int $cross_project_metadata
     *           Determines whether to include cross project annotations in the logs.
     *           This field is available only for organization configurations. If not
     *           specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
     *     @type string $network
     *           Traffic will be logged from VMs, VPN tunnels and Interconnect Attachments
     *           within the network.
     *           Format: projects/{project_id}/global/networks/{name}
     *     @type string $subnet
     *           Traffic will be logged from VMs within the subnetwork.
     *           Format: projects/{project_id}/regions/{region}/subnetworks/{name}
     *     @type string $interconnect_attachment
     *           Traffic will be logged from the Interconnect Attachment.
     *           Format:
     *           projects/{project_id}/regions/{region}/interconnectAttachments/{name}
     *     @type string $vpn_tunnel
     *           Traffic will be logged from the VPN Tunnel.
     *           Format: projects/{project_id}/regions/{region}/vpnTunnels/{name}
     *     @type int $scope
     *           Specifies the scope of the config (e.g., SUBNET, NETWORK, ORGANIZATION..).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkmanagement\V1\VpcFlowLogsConfig::initOnce();
        parent::__construct($data);
    }

    /**
     * Unique name of the configuration. The name can have one of the following
     * forms:
     * - For project-level configurations:
     * `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     * - For organization-level configurations:
     * `organizations/{organization_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     * - For a Compute config, the name will be the path of the subnet:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnet_id}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Unique name of the configuration. The name can have one of the following
     * forms:
     * - For project-level configurations:
     * `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     * - For organization-level configurations:
     * `organizations/{organization_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     * - For a Compute config, the name will be the path of the subnet:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnet_id}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The state of the VPC Flow Log configuration. Default value is ENABLED.
     * When creating a new configuration, it must be enabled.
     * Setting state=DISABLED will pause the log generation for this config.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.State state = 3;</code>
     * @return int
     */
    public function getState()
    {
        return isset($this->state) ? $this->state : 0;
    }

    public function hasState()
    {
        return isset($this->state);
    }

    public function clearState()
    {
        unset($this->state);
    }

    /**
     * The state of the VPC Flow Log configuration. Default value is ENABLED.
     * When creating a new configuration, it must be enabled.
     * Setting state=DISABLED will pause the log generation for this config.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.State state = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkManagement\V1\VpcFlowLogsConfig\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * The aggregation interval for the logs. Default value is INTERVAL_5_SEC.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.AggregationInterval aggregation_interval = 4;</code>
     * @return int
     */
    public function getAggregationInterval()
    {
        return isset($this->aggregation_interval) ? $this->aggregation_interval : 0;
    }

    public function hasAggregationInterval()
    {
        return isset($this->aggregation_interval);
    }

    public function clearAggregationInterval()
    {
        unset($this->aggregation_interval);
    }

    /**
     * The aggregation interval for the logs. Default value is INTERVAL_5_SEC.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.AggregationInterval aggregation_interval = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setAggregationInterval($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkManagement\V1\VpcFlowLogsConfig\AggregationInterval::class);
        $this->aggregation_interval = $var;

        return $this;
    }

    /**
     * The value of the field must be in (0, 1]. The sampling rate of VPC Flow
     * Logs where 1.0 means all collected logs are reported.
     * Setting the sampling rate to 0.0 is not allowed. If you want to disable VPC
     * Flow Logs, use the state field instead.
     * Default value is 1.0.
     *
     * Generated from protobuf field <code>optional float flow_sampling = 5;</code>
     * @return float
     */
    public function getFlowSampling()
    {
        return isset($this->flow_sampling) ? $this->flow_sampling : 0.0;
    }

    public function hasFlowSampling()
    {
        return isset($this->flow_sampling);
    }

    public function clearFlowSampling()
    {
        unset($this->flow_sampling);
    }

    /**
     * The value of the field must be in (0, 1]. The sampling rate of VPC Flow
     * Logs where 1.0 means all collected logs are reported.
     * Setting the sampling rate to 0.0 is not allowed. If you want to disable VPC
     * Flow Logs, use the state field instead.
     * Default value is 1.0.
     *
     * Generated from protobuf field <code>optional float flow_sampling = 5;</code>
     * @param float $var
     * @return $this
     */
    public function setFlowSampling($var)
    {
        GPBUtil::checkFloat($var);
        $this->flow_sampling = $var;

        return $this;
    }

    /**
     * Configures whether all, none or a subset of metadata fields should be
     * added to the reported VPC flow logs.
     * Default value is INCLUDE_ALL_METADATA.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.Metadata metadata = 6;</code>
     * @return int
     */
    public function getMetadata()
    {
        return isset($this->metadata) ? $this->metadata : 0;
    }

    public function hasMetadata()
    {
        return isset($this->metadata);
    }

    public function clearMetadata()
    {
        unset($this->metadata);
    }

    /**
     * Configures whether all, none or a subset of metadata fields should be
     * added to the reported VPC flow logs.
     * Default value is INCLUDE_ALL_METADATA.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.Metadata metadata = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setMetadata($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkManagement\V1\VpcFlowLogsConfig\Metadata::class);
        $this->metadata = $var;

        return $this;
    }

    /**
     * Custom metadata fields to include in the reported VPC flow logs.
     * Can only be specified if "metadata" was set to CUSTOM_METADATA.
     *
     * Generated from protobuf field <code>repeated string metadata_fields = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMetadataFields()
    {
        return $this->metadata_fields;
    }

    /**
     * Custom metadata fields to include in the reported VPC flow logs.
     * Can only be specified if "metadata" was set to CUSTOM_METADATA.
     *
     * Generated from protobuf field <code>repeated string metadata_fields = 7;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMetadataFields($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->metadata_fields = $arr;

        return $this;
    }

    /**
     * Export filter used to define which VPC Flow Logs should be logged.
     *
     * Generated from protobuf field <code>optional string filter_expr = 8;</code>
     * @return string
     */
    public function getFilterExpr()
    {
        return isset($this->filter_expr) ? $this->filter_expr : '';
    }

    public function hasFilterExpr()
    {
        return isset($this->filter_expr);
    }

    public function clearFilterExpr()
    {
        unset($this->filter_expr);
    }

    /**
     * Export filter used to define which VPC Flow Logs should be logged.
     *
     * Generated from protobuf field <code>optional string filter_expr = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setFilterExpr($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter_expr = $var;

        return $this;
    }

    /**
     * Determines whether to include cross project annotations in the logs.
     * This field is available only for organization configurations. If not
     * specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.CrossProjectMetadata cross_project_metadata = 13;</code>
     * @return int
     */
    public function getCrossProjectMetadata()
    {
        return isset($this->cross_project_metadata) ? $this->cross_project_metadata : 0;
    }

    public function hasCrossProjectMetadata()
    {
        return isset($this->cross_project_metadata);
    }

    public function clearCrossProjectMetadata()
    {
        unset($this->cross_project_metadata);
    }

    /**
     * Determines whether to include cross project annotations in the logs.
     * This field is available only for organization configurations. If not
     * specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.CrossProjectMetadata cross_project_metadata = 13;</code>
     * @param int $var
     * @return $this
     */
    public function setCrossProjectMetadata($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkManagement\V1\VpcFlowLogsConfig\CrossProjectMetadata::class);
        $this->cross_project_metadata = $var;

        return $this;
    }

    /**
     * Traffic will be logged from VMs, VPN tunnels and Interconnect Attachments
     * within the network.
     * Format: projects/{project_id}/global/networks/{name}
     *
     * Generated from protobuf field <code>string network = 100;</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->readOneof(100);
    }

    public function hasNetwork()
    {
        return $this->hasOneof(100);
    }

    /**
     * Traffic will be logged from VMs, VPN tunnels and Interconnect Attachments
     * within the network.
     * Format: projects/{project_id}/global/networks/{name}
     *
     * Generated from protobuf field <code>string network = 100;</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(100, $var);

        return $this;
    }

    /**
     * Traffic will be logged from VMs within the subnetwork.
     * Format: projects/{project_id}/regions/{region}/subnetworks/{name}
     *
     * Generated from protobuf field <code>string subnet = 101;</code>
     * @return string
     */
    public function getSubnet()
    {
        return $this->readOneof(101);
    }

    public function hasSubnet()
    {
        return $this->hasOneof(101);
    }

    /**
     * Traffic will be logged from VMs within the subnetwork.
     * Format: projects/{project_id}/regions/{region}/subnetworks/{name}
     *
     * Generated from protobuf field <code>string subnet = 101;</code>
     * @param string $var
     * @return $this
     */
    public function setSubnet($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(101, $var);

        return $this;
    }

    /**
     * Traffic will be logged from the Interconnect Attachment.
     * Format:
     * projects/{project_id}/regions/{region}/interconnectAttachments/{name}
     *
     * Generated from protobuf field <code>string interconnect_attachment = 102;</code>
     * @return string
     */
    public function getInterconnectAttachment()
    {
        return $this->readOneof(102);
    }

    public function hasInterconnectAttachment()
    {
        return $this->hasOneof(102);
    }

    /**
     * Traffic will be logged from the Interconnect Attachment.
     * Format:
     * projects/{project_id}/regions/{region}/interconnectAttachments/{name}
     *
     * Generated from protobuf field <code>string interconnect_attachment = 102;</code>
     * @param string $var
     * @return $this
     */
    public function setInterconnectAttachment($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(102, $var);

        return $this;
    }

    /**
     * Traffic will be logged from the VPN Tunnel.
     * Format: projects/{project_id}/regions/{region}/vpnTunnels/{name}
     *
     * Generated from protobuf field <code>string vpn_tunnel = 103;</code>
     * @return string
     */
    public function getVpnTunnel()
    {
        return $this->readOneof(103);
    }

    public function hasVpnTunnel()
    {
        return $this->hasOneof(103);
    }

    /**
     * Traffic will be logged from the VPN Tunnel.
     * Format: projects/{project_id}/regions/{region}/vpnTunnels/{name}
     *
     * Generated from protobuf field <code>string vpn_tunnel = 103;</code>
     * @param string $var
     * @return $this
     */
    public function setVpnTunnel($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(103, $var);

        return $this;
    }

    /**
     * Specifies the scope of the config (e.g., SUBNET, NETWORK, ORGANIZATION..).
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.EffectiveVpcFlowLogsConfig.Scope scope = 12;</code>
     * @return int
     */
    public function getScope()
    {
        return isset($this->scope) ? $this->scope : 0;
    }

    public function hasScope()
    {
        return isset($this->scope);
    }

    public function clearScope()
    {
        unset($this->scope);
    }

    /**
     * Specifies the scope of the config (e.g., SUBNET, NETWORK, ORGANIZATION..).
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.EffectiveVpcFlowLogsConfig.Scope scope = 12;</code>
     * @param int $var
     * @return $this
     */
    public function setScope($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkManagement\V1\EffectiveVpcFlowLogsConfig\Scope::class);
        $this->scope = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTargetResource()
    {
        return $this->whichOneof("target_resource");
    }

}

