<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/netapp/v1/volume.proto

namespace Google\Cloud\NetApp\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Block device represents the device(s) which are stored in the block volume.
 *
 * Generated from protobuf message <code>google.cloud.netapp.v1.BlockDevice</code>
 */
class BlockDevice extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. User-defined name for the block device, unique within the volume.
     * In case no user input is provided, name will be auto-generated in the
     * backend. The name must meet the following requirements:
     * *   Be between 1 and 255 characters long.
     * *   Contain only uppercase or lowercase letters (A-Z, a-z), numbers (0-9),
     *     and the following special characters: "-", "_", "}", "{", ".".
     * *   Spaces are not allowed.
     *
     * Generated from protobuf field <code>optional string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $name = null;
    /**
     * Optional. A list of host groups that identify hosts that can mount the
     * block volume. Format:
     * `projects/{project_id}/locations/{location}/hostGroups/{host_group_id}`
     * This field can be updated after the block device is created.
     *
     * Generated from protobuf field <code>repeated string host_groups = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $host_groups;
    /**
     * Output only. Device identifier of the block volume. This represents
     * `lun_serial_number` for iSCSI volumes.
     *
     * Generated from protobuf field <code>string identifier = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $identifier = '';
    /**
     * Optional. The size of the block device in GiB.
     * Any value provided for the `size_gib` field during volume creation is
     * ignored. The block device's size is system-managed and will be set to match
     * the parent Volume's `capacity_gib`.
     *
     * Generated from protobuf field <code>optional int64 size_gib = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $size_gib = null;
    /**
     * Required. Immutable. The OS type of the volume.
     * This field can't be changed after the block device is created.
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.OsType os_type = 5 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $os_type = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Optional. User-defined name for the block device, unique within the volume.
     *           In case no user input is provided, name will be auto-generated in the
     *           backend. The name must meet the following requirements:
     *           *   Be between 1 and 255 characters long.
     *           *   Contain only uppercase or lowercase letters (A-Z, a-z), numbers (0-9),
     *               and the following special characters: "-", "_", "}", "{", ".".
     *           *   Spaces are not allowed.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $host_groups
     *           Optional. A list of host groups that identify hosts that can mount the
     *           block volume. Format:
     *           `projects/{project_id}/locations/{location}/hostGroups/{host_group_id}`
     *           This field can be updated after the block device is created.
     *     @type string $identifier
     *           Output only. Device identifier of the block volume. This represents
     *           `lun_serial_number` for iSCSI volumes.
     *     @type int|string $size_gib
     *           Optional. The size of the block device in GiB.
     *           Any value provided for the `size_gib` field during volume creation is
     *           ignored. The block device's size is system-managed and will be set to match
     *           the parent Volume's `capacity_gib`.
     *     @type int $os_type
     *           Required. Immutable. The OS type of the volume.
     *           This field can't be changed after the block device is created.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Netapp\V1\Volume::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. User-defined name for the block device, unique within the volume.
     * In case no user input is provided, name will be auto-generated in the
     * backend. The name must meet the following requirements:
     * *   Be between 1 and 255 characters long.
     * *   Contain only uppercase or lowercase letters (A-Z, a-z), numbers (0-9),
     *     and the following special characters: "-", "_", "}", "{", ".".
     * *   Spaces are not allowed.
     *
     * Generated from protobuf field <code>optional string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : '';
    }

    public function hasName()
    {
        return isset($this->name);
    }

    public function clearName()
    {
        unset($this->name);
    }

    /**
     * Optional. User-defined name for the block device, unique within the volume.
     * In case no user input is provided, name will be auto-generated in the
     * backend. The name must meet the following requirements:
     * *   Be between 1 and 255 characters long.
     * *   Contain only uppercase or lowercase letters (A-Z, a-z), numbers (0-9),
     *     and the following special characters: "-", "_", "}", "{", ".".
     * *   Spaces are not allowed.
     *
     * Generated from protobuf field <code>optional string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. A list of host groups that identify hosts that can mount the
     * block volume. Format:
     * `projects/{project_id}/locations/{location}/hostGroups/{host_group_id}`
     * This field can be updated after the block device is created.
     *
     * Generated from protobuf field <code>repeated string host_groups = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getHostGroups()
    {
        return $this->host_groups;
    }

    /**
     * Optional. A list of host groups that identify hosts that can mount the
     * block volume. Format:
     * `projects/{project_id}/locations/{location}/hostGroups/{host_group_id}`
     * This field can be updated after the block device is created.
     *
     * Generated from protobuf field <code>repeated string host_groups = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setHostGroups($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->host_groups = $arr;

        return $this;
    }

    /**
     * Output only. Device identifier of the block volume. This represents
     * `lun_serial_number` for iSCSI volumes.
     *
     * Generated from protobuf field <code>string identifier = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /**
     * Output only. Device identifier of the block volume. This represents
     * `lun_serial_number` for iSCSI volumes.
     *
     * Generated from protobuf field <code>string identifier = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setIdentifier($var)
    {
        GPBUtil::checkString($var, True);
        $this->identifier = $var;

        return $this;
    }

    /**
     * Optional. The size of the block device in GiB.
     * Any value provided for the `size_gib` field during volume creation is
     * ignored. The block device's size is system-managed and will be set to match
     * the parent Volume's `capacity_gib`.
     *
     * Generated from protobuf field <code>optional int64 size_gib = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getSizeGib()
    {
        return isset($this->size_gib) ? $this->size_gib : 0;
    }

    public function hasSizeGib()
    {
        return isset($this->size_gib);
    }

    public function clearSizeGib()
    {
        unset($this->size_gib);
    }

    /**
     * Optional. The size of the block device in GiB.
     * Any value provided for the `size_gib` field during volume creation is
     * ignored. The block device's size is system-managed and will be set to match
     * the parent Volume's `capacity_gib`.
     *
     * Generated from protobuf field <code>optional int64 size_gib = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setSizeGib($var)
    {
        GPBUtil::checkInt64($var);
        $this->size_gib = $var;

        return $this;
    }

    /**
     * Required. Immutable. The OS type of the volume.
     * This field can't be changed after the block device is created.
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.OsType os_type = 5 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getOsType()
    {
        return $this->os_type;
    }

    /**
     * Required. Immutable. The OS type of the volume.
     * This field can't be changed after the block device is created.
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.OsType os_type = 5 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setOsType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetApp\V1\OsType::class);
        $this->os_type = $var;

        return $this;
    }

}

