<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/managedkafka/v1/managed_kafka.proto

namespace Google\Cloud\ManagedKafka\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request for CreateCluster.
 *
 * Generated from protobuf message <code>google.cloud.managedkafka.v1.CreateClusterRequest</code>
 */
class CreateClusterRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent region in which to create the cluster. Structured like
     * `projects/{project}/locations/{location}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The ID to use for the cluster, which will become the final
     * component of the cluster's name. The ID must be 1-63 characters long, and
     * match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply with
     * RFC 1035.
     * This value is structured like: `my-cluster-id`.
     *
     * Generated from protobuf field <code>string cluster_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $cluster_id = '';
    /**
     * Required. Configuration of the cluster to create. Its `name` field is
     * ignored.
     *
     * Generated from protobuf field <code>.google.cloud.managedkafka.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $cluster = null;
    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID to avoid duplication of requests. If a request times out or
     * fails, retrying with the same ID allows the server to recognize the
     * previous attempt. For at least 60 minutes, the server ignores duplicate
     * requests bearing the same ID.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID
     * within 60 minutes of the last request, the server checks if an original
     * operation with the same request ID was received. If so, the server ignores
     * the second request.
     * The request ID must be a valid UUID. A zero UUID is not supported
     * (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = {</code>
     */
    protected $request_id = '';

    /**
     * @param string                                $parent    Required. The parent region in which to create the cluster. Structured like
     *                                                         `projects/{project}/locations/{location}`. Please see
     *                                                         {@see ManagedKafkaClient::locationName()} for help formatting this field.
     * @param \Google\Cloud\ManagedKafka\V1\Cluster $cluster   Required. Configuration of the cluster to create. Its `name` field is
     *                                                         ignored.
     * @param string                                $clusterId Required. The ID to use for the cluster, which will become the final
     *                                                         component of the cluster's name. The ID must be 1-63 characters long, and
     *                                                         match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply with
     *                                                         RFC 1035.
     *
     *                                                         This value is structured like: `my-cluster-id`.
     *
     * @return \Google\Cloud\ManagedKafka\V1\CreateClusterRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\ManagedKafka\V1\Cluster $cluster, string $clusterId): self
    {
        return (new self())
            ->setParent($parent)
            ->setCluster($cluster)
            ->setClusterId($clusterId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent region in which to create the cluster. Structured like
     *           `projects/{project}/locations/{location}`.
     *     @type string $cluster_id
     *           Required. The ID to use for the cluster, which will become the final
     *           component of the cluster's name. The ID must be 1-63 characters long, and
     *           match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply with
     *           RFC 1035.
     *           This value is structured like: `my-cluster-id`.
     *     @type \Google\Cloud\ManagedKafka\V1\Cluster $cluster
     *           Required. Configuration of the cluster to create. Its `name` field is
     *           ignored.
     *     @type string $request_id
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID to avoid duplication of requests. If a request times out or
     *           fails, retrying with the same ID allows the server to recognize the
     *           previous attempt. For at least 60 minutes, the server ignores duplicate
     *           requests bearing the same ID.
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID
     *           within 60 minutes of the last request, the server checks if an original
     *           operation with the same request ID was received. If so, the server ignores
     *           the second request.
     *           The request ID must be a valid UUID. A zero UUID is not supported
     *           (00000000-0000-0000-0000-000000000000).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Managedkafka\V1\ManagedKafka::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent region in which to create the cluster. Structured like
     * `projects/{project}/locations/{location}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent region in which to create the cluster. Structured like
     * `projects/{project}/locations/{location}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The ID to use for the cluster, which will become the final
     * component of the cluster's name. The ID must be 1-63 characters long, and
     * match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply with
     * RFC 1035.
     * This value is structured like: `my-cluster-id`.
     *
     * Generated from protobuf field <code>string cluster_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getClusterId()
    {
        return $this->cluster_id;
    }

    /**
     * Required. The ID to use for the cluster, which will become the final
     * component of the cluster's name. The ID must be 1-63 characters long, and
     * match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply with
     * RFC 1035.
     * This value is structured like: `my-cluster-id`.
     *
     * Generated from protobuf field <code>string cluster_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setClusterId($var)
    {
        GPBUtil::checkString($var, True);
        $this->cluster_id = $var;

        return $this;
    }

    /**
     * Required. Configuration of the cluster to create. Its `name` field is
     * ignored.
     *
     * Generated from protobuf field <code>.google.cloud.managedkafka.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\ManagedKafka\V1\Cluster|null
     */
    public function getCluster()
    {
        return $this->cluster;
    }

    public function hasCluster()
    {
        return isset($this->cluster);
    }

    public function clearCluster()
    {
        unset($this->cluster);
    }

    /**
     * Required. Configuration of the cluster to create. Its `name` field is
     * ignored.
     *
     * Generated from protobuf field <code>.google.cloud.managedkafka.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\ManagedKafka\V1\Cluster $var
     * @return $this
     */
    public function setCluster($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ManagedKafka\V1\Cluster::class);
        $this->cluster = $var;

        return $this;
    }

    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID to avoid duplication of requests. If a request times out or
     * fails, retrying with the same ID allows the server to recognize the
     * previous attempt. For at least 60 minutes, the server ignores duplicate
     * requests bearing the same ID.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID
     * within 60 minutes of the last request, the server checks if an original
     * operation with the same request ID was received. If so, the server ignores
     * the second request.
     * The request ID must be a valid UUID. A zero UUID is not supported
     * (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = {</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID to avoid duplication of requests. If a request times out or
     * fails, retrying with the same ID allows the server to recognize the
     * previous attempt. For at least 60 minutes, the server ignores duplicate
     * requests bearing the same ID.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID
     * within 60 minutes of the last request, the server checks if an original
     * operation with the same request ID was received. If so, the server ignores
     * the second request.
     * The request ID must be a valid UUID. A zero UUID is not supported
     * (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = {</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

}

