<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/eventarc/v1/pipeline.proto

namespace Google\Cloud\Eventarc\V1\Pipeline\Destination\AuthenticationConfig;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a config used to authenticate with a Google OIDC token using
 * a Google Cloud service account. Use this authentication method to
 * invoke your Cloud Run and Cloud Functions destinations or HTTP
 * endpoints that support Google OIDC.
 *
 * Generated from protobuf message <code>google.cloud.eventarc.v1.Pipeline.Destination.AuthenticationConfig.OidcToken</code>
 */
class OidcToken extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Service account email used to generate the OIDC Token.
     * The principal who calls this API must have
     * iam.serviceAccounts.actAs permission in the service account. See
     * https://cloud.google.com/iam/docs/understanding-service-accounts
     * for more information. Eventarc service agents must have
     * roles/roles/iam.serviceAccountTokenCreator role to allow the
     * Pipeline to create OpenID tokens for authenticated requests.
     *
     * Generated from protobuf field <code>string service_account = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $service_account = '';
    /**
     * Optional. Audience to be used to generate the OIDC Token. The
     * audience claim identifies the recipient that the JWT is intended for.
     * If unspecified, the destination URI will be used.
     *
     * Generated from protobuf field <code>string audience = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $audience = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $service_account
     *           Required. Service account email used to generate the OIDC Token.
     *           The principal who calls this API must have
     *           iam.serviceAccounts.actAs permission in the service account. See
     *           https://cloud.google.com/iam/docs/understanding-service-accounts
     *           for more information. Eventarc service agents must have
     *           roles/roles/iam.serviceAccountTokenCreator role to allow the
     *           Pipeline to create OpenID tokens for authenticated requests.
     *     @type string $audience
     *           Optional. Audience to be used to generate the OIDC Token. The
     *           audience claim identifies the recipient that the JWT is intended for.
     *           If unspecified, the destination URI will be used.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Eventarc\V1\Pipeline::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Service account email used to generate the OIDC Token.
     * The principal who calls this API must have
     * iam.serviceAccounts.actAs permission in the service account. See
     * https://cloud.google.com/iam/docs/understanding-service-accounts
     * for more information. Eventarc service agents must have
     * roles/roles/iam.serviceAccountTokenCreator role to allow the
     * Pipeline to create OpenID tokens for authenticated requests.
     *
     * Generated from protobuf field <code>string service_account = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * Required. Service account email used to generate the OIDC Token.
     * The principal who calls this API must have
     * iam.serviceAccounts.actAs permission in the service account. See
     * https://cloud.google.com/iam/docs/understanding-service-accounts
     * for more information. Eventarc service agents must have
     * roles/roles/iam.serviceAccountTokenCreator role to allow the
     * Pipeline to create OpenID tokens for authenticated requests.
     *
     * Generated from protobuf field <code>string service_account = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account = $var;

        return $this;
    }

    /**
     * Optional. Audience to be used to generate the OIDC Token. The
     * audience claim identifies the recipient that the JWT is intended for.
     * If unspecified, the destination URI will be used.
     *
     * Generated from protobuf field <code>string audience = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAudience()
    {
        return $this->audience;
    }

    /**
     * Optional. Audience to be used to generate the OIDC Token. The
     * audience claim identifies the recipient that the JWT is intended for.
     * If unspecified, the destination URI will be used.
     *
     * Generated from protobuf field <code>string audience = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAudience($var)
    {
        GPBUtil::checkString($var, True);
        $this->audience = $var;

        return $this;
    }

}


