<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/documentai/v1/document_processor_service.proto

namespace Google\Cloud\DocumentAI\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for the
 * [CreateProcessor][google.cloud.documentai.v1.DocumentProcessorService.CreateProcessor]
 * method. Notice this request is sent to a regionalized backend service. If the
 * [ProcessorType][google.cloud.documentai.v1.ProcessorType] isn't available in
 * that region, the creation fails.
 *
 * Generated from protobuf message <code>google.cloud.documentai.v1.CreateProcessorRequest</code>
 */
class CreateProcessorRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent (project and location) under which to create the
     * processor. Format: `projects/{project}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The processor to be created, requires
     * [Processor.type][google.cloud.documentai.v1.Processor.type] and
     * [Processor.display_name][google.cloud.documentai.v1.Processor.display_name]
     * to be set. Also, the
     * [Processor.kms_key_name][google.cloud.documentai.v1.Processor.kms_key_name]
     * field must be set if the processor is under CMEK.
     *
     * Generated from protobuf field <code>.google.cloud.documentai.v1.Processor processor = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $processor = null;

    /**
     * @param string                                $parent    Required. The parent (project and location) under which to create the
     *                                                         processor. Format: `projects/{project}/locations/{location}`
     *                                                         Please see {@see DocumentProcessorServiceClient::locationName()} for help formatting this field.
     * @param \Google\Cloud\DocumentAI\V1\Processor $processor Required. The processor to be created, requires
     *                                                         [Processor.type][google.cloud.documentai.v1.Processor.type] and
     *                                                         [Processor.display_name][google.cloud.documentai.v1.Processor.display_name]
     *                                                         to be set. Also, the
     *                                                         [Processor.kms_key_name][google.cloud.documentai.v1.Processor.kms_key_name]
     *                                                         field must be set if the processor is under CMEK.
     *
     * @return \Google\Cloud\DocumentAI\V1\CreateProcessorRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\DocumentAI\V1\Processor $processor): self
    {
        return (new self())
            ->setParent($parent)
            ->setProcessor($processor);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent (project and location) under which to create the
     *           processor. Format: `projects/{project}/locations/{location}`
     *     @type \Google\Cloud\DocumentAI\V1\Processor $processor
     *           Required. The processor to be created, requires
     *           [Processor.type][google.cloud.documentai.v1.Processor.type] and
     *           [Processor.display_name][google.cloud.documentai.v1.Processor.display_name]
     *           to be set. Also, the
     *           [Processor.kms_key_name][google.cloud.documentai.v1.Processor.kms_key_name]
     *           field must be set if the processor is under CMEK.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Documentai\V1\DocumentProcessorService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent (project and location) under which to create the
     * processor. Format: `projects/{project}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent (project and location) under which to create the
     * processor. Format: `projects/{project}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The processor to be created, requires
     * [Processor.type][google.cloud.documentai.v1.Processor.type] and
     * [Processor.display_name][google.cloud.documentai.v1.Processor.display_name]
     * to be set. Also, the
     * [Processor.kms_key_name][google.cloud.documentai.v1.Processor.kms_key_name]
     * field must be set if the processor is under CMEK.
     *
     * Generated from protobuf field <code>.google.cloud.documentai.v1.Processor processor = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\DocumentAI\V1\Processor|null
     */
    public function getProcessor()
    {
        return $this->processor;
    }

    public function hasProcessor()
    {
        return isset($this->processor);
    }

    public function clearProcessor()
    {
        unset($this->processor);
    }

    /**
     * Required. The processor to be created, requires
     * [Processor.type][google.cloud.documentai.v1.Processor.type] and
     * [Processor.display_name][google.cloud.documentai.v1.Processor.display_name]
     * to be set. Also, the
     * [Processor.kms_key_name][google.cloud.documentai.v1.Processor.kms_key_name]
     * field must be set if the processor is under CMEK.
     *
     * Generated from protobuf field <code>.google.cloud.documentai.v1.Processor processor = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\DocumentAI\V1\Processor $var
     * @return $this
     */
    public function setProcessor($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DocumentAI\V1\Processor::class);
        $this->processor = $var;

        return $this;
    }

}

