<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/webhook.proto

namespace Google\Cloud\Dialogflow\Cx\V3\Webhook;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents configuration for a generic web service.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.Webhook.GenericWebService</code>
 */
class GenericWebService extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The webhook URI for receiving POST requests. It must use https
     * protocol.
     *
     * Generated from protobuf field <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $uri = '';
    /**
     * The user name for HTTP Basic authentication.
     *
     * Generated from protobuf field <code>string username = 2 [deprecated = true];</code>
     * @deprecated
     */
    protected $username = '';
    /**
     * The password for HTTP Basic authentication.
     *
     * Generated from protobuf field <code>string password = 3 [deprecated = true];</code>
     * @deprecated
     */
    protected $password = '';
    /**
     * Optional. The SecretManager secret version resource storing the
     * username:password pair for HTTP Basic authentication. Format:
     * `projects/{project}/secrets/{secret}/versions/{version}`
     *
     * Generated from protobuf field <code>string secret_version_for_username_password = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $secret_version_for_username_password = '';
    /**
     * The HTTP request headers to send together with webhook requests.
     *
     * Generated from protobuf field <code>map<string, string> request_headers = 4;</code>
     */
    private $request_headers;
    /**
     * Optional. The HTTP request headers to send together with webhook
     * requests. Header values are stored in SecretManager secret versions.
     * When the same header name is specified in both `request_headers` and
     * `secret_versions_for_request_headers`, the value in
     * `secret_versions_for_request_headers` will be used.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.SecretVersionHeaderValue> secret_versions_for_request_headers = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $secret_versions_for_request_headers;
    /**
     * Optional. Specifies a list of allowed custom CA certificates (in DER
     * format) for HTTPS verification. This overrides the default SSL trust
     * store. If this is empty or unspecified, Dialogflow will use Google's
     * default trust store to verify certificates. N.B. Make sure the HTTPS
     * server certificates are signed with "subject alt name". For instance a
     * certificate can be self-signed using the following command,
     * ```
     *    openssl x509 -req -days 200 -in example.com.csr \
     *      -signkey example.com.key \
     *      -out example.com.crt \
     *      -extfile <(printf "\nsubjectAltName='DNS:www.example.com'")
     * ```
     *
     * Generated from protobuf field <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $allowed_ca_certs;
    /**
     * Optional. The OAuth configuration of the webhook. If specified,
     * Dialogflow will initiate the OAuth client credential flow to exchange an
     * access token from the 3rd party platform and put it in the auth header.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.OAuthConfig oauth_config = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $oauth_config = null;
    /**
     * Optional. Indicate the auth token type generated from the [Diglogflow
     * service
     * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
     * The generated token is sent in the Authorization header.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.ServiceAgentAuth service_agent_auth = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $service_agent_auth = 0;
    /**
     * Optional. Configuration for service account authentication.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.ServiceAccountAuthConfig service_account_auth_config = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $service_account_auth_config = null;
    /**
     * Optional. Type of the webhook.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.WebhookType webhook_type = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $webhook_type = 0;
    /**
     * Optional. HTTP method for the flexible webhook calls. Standard webhook
     * always uses POST.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.HttpMethod http_method = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $http_method = 0;
    /**
     * Optional. Defines a custom JSON object as request body to send to
     * flexible webhook.
     *
     * Generated from protobuf field <code>string request_body = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $request_body = '';
    /**
     * Optional. Maps the values extracted from specific fields of the flexible
     * webhook response into session parameters.
     * - Key: session parameter name
     * - Value: field path in the webhook response
     *
     * Generated from protobuf field <code>map<string, string> parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $parameter_mapping;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $uri
     *           Required. The webhook URI for receiving POST requests. It must use https
     *           protocol.
     *     @type string $username
     *           The user name for HTTP Basic authentication.
     *     @type string $password
     *           The password for HTTP Basic authentication.
     *     @type string $secret_version_for_username_password
     *           Optional. The SecretManager secret version resource storing the
     *           username:password pair for HTTP Basic authentication. Format:
     *           `projects/{project}/secrets/{secret}/versions/{version}`
     *     @type array|\Google\Protobuf\Internal\MapField $request_headers
     *           The HTTP request headers to send together with webhook requests.
     *     @type array|\Google\Protobuf\Internal\MapField $secret_versions_for_request_headers
     *           Optional. The HTTP request headers to send together with webhook
     *           requests. Header values are stored in SecretManager secret versions.
     *           When the same header name is specified in both `request_headers` and
     *           `secret_versions_for_request_headers`, the value in
     *           `secret_versions_for_request_headers` will be used.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $allowed_ca_certs
     *           Optional. Specifies a list of allowed custom CA certificates (in DER
     *           format) for HTTPS verification. This overrides the default SSL trust
     *           store. If this is empty or unspecified, Dialogflow will use Google's
     *           default trust store to verify certificates. N.B. Make sure the HTTPS
     *           server certificates are signed with "subject alt name". For instance a
     *           certificate can be self-signed using the following command,
     *           ```
     *              openssl x509 -req -days 200 -in example.com.csr \
     *                -signkey example.com.key \
     *                -out example.com.crt \
     *                -extfile <(printf "\nsubjectAltName='DNS:www.example.com'")
     *           ```
     *     @type \Google\Cloud\Dialogflow\Cx\V3\Webhook\GenericWebService\OAuthConfig $oauth_config
     *           Optional. The OAuth configuration of the webhook. If specified,
     *           Dialogflow will initiate the OAuth client credential flow to exchange an
     *           access token from the 3rd party platform and put it in the auth header.
     *     @type int $service_agent_auth
     *           Optional. Indicate the auth token type generated from the [Diglogflow
     *           service
     *           agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
     *           The generated token is sent in the Authorization header.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\Webhook\GenericWebService\ServiceAccountAuthConfig $service_account_auth_config
     *           Optional. Configuration for service account authentication.
     *     @type int $webhook_type
     *           Optional. Type of the webhook.
     *     @type int $http_method
     *           Optional. HTTP method for the flexible webhook calls. Standard webhook
     *           always uses POST.
     *     @type string $request_body
     *           Optional. Defines a custom JSON object as request body to send to
     *           flexible webhook.
     *     @type array|\Google\Protobuf\Internal\MapField $parameter_mapping
     *           Optional. Maps the values extracted from specific fields of the flexible
     *           webhook response into session parameters.
     *           - Key: session parameter name
     *           - Value: field path in the webhook response
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\Webhook::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The webhook URI for receiving POST requests. It must use https
     * protocol.
     *
     * Generated from protobuf field <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getUri()
    {
        return $this->uri;
    }

    /**
     * Required. The webhook URI for receiving POST requests. It must use https
     * protocol.
     *
     * Generated from protobuf field <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->uri = $var;

        return $this;
    }

    /**
     * The user name for HTTP Basic authentication.
     *
     * Generated from protobuf field <code>string username = 2 [deprecated = true];</code>
     * @return string
     * @deprecated
     */
    public function getUsername()
    {
        if ($this->username !== '') {
            @trigger_error('username is deprecated.', E_USER_DEPRECATED);
        }
        return $this->username;
    }

    /**
     * The user name for HTTP Basic authentication.
     *
     * Generated from protobuf field <code>string username = 2 [deprecated = true];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setUsername($var)
    {
        @trigger_error('username is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->username = $var;

        return $this;
    }

    /**
     * The password for HTTP Basic authentication.
     *
     * Generated from protobuf field <code>string password = 3 [deprecated = true];</code>
     * @return string
     * @deprecated
     */
    public function getPassword()
    {
        if ($this->password !== '') {
            @trigger_error('password is deprecated.', E_USER_DEPRECATED);
        }
        return $this->password;
    }

    /**
     * The password for HTTP Basic authentication.
     *
     * Generated from protobuf field <code>string password = 3 [deprecated = true];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setPassword($var)
    {
        @trigger_error('password is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->password = $var;

        return $this;
    }

    /**
     * Optional. The SecretManager secret version resource storing the
     * username:password pair for HTTP Basic authentication. Format:
     * `projects/{project}/secrets/{secret}/versions/{version}`
     *
     * Generated from protobuf field <code>string secret_version_for_username_password = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSecretVersionForUsernamePassword()
    {
        return $this->secret_version_for_username_password;
    }

    /**
     * Optional. The SecretManager secret version resource storing the
     * username:password pair for HTTP Basic authentication. Format:
     * `projects/{project}/secrets/{secret}/versions/{version}`
     *
     * Generated from protobuf field <code>string secret_version_for_username_password = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSecretVersionForUsernamePassword($var)
    {
        GPBUtil::checkString($var, True);
        $this->secret_version_for_username_password = $var;

        return $this;
    }

    /**
     * The HTTP request headers to send together with webhook requests.
     *
     * Generated from protobuf field <code>map<string, string> request_headers = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getRequestHeaders()
    {
        return $this->request_headers;
    }

    /**
     * The HTTP request headers to send together with webhook requests.
     *
     * Generated from protobuf field <code>map<string, string> request_headers = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setRequestHeaders($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->request_headers = $arr;

        return $this;
    }

    /**
     * Optional. The HTTP request headers to send together with webhook
     * requests. Header values are stored in SecretManager secret versions.
     * When the same header name is specified in both `request_headers` and
     * `secret_versions_for_request_headers`, the value in
     * `secret_versions_for_request_headers` will be used.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.SecretVersionHeaderValue> secret_versions_for_request_headers = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getSecretVersionsForRequestHeaders()
    {
        return $this->secret_versions_for_request_headers;
    }

    /**
     * Optional. The HTTP request headers to send together with webhook
     * requests. Header values are stored in SecretManager secret versions.
     * When the same header name is specified in both `request_headers` and
     * `secret_versions_for_request_headers`, the value in
     * `secret_versions_for_request_headers` will be used.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.SecretVersionHeaderValue> secret_versions_for_request_headers = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setSecretVersionsForRequestHeaders($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\Webhook\GenericWebService\SecretVersionHeaderValue::class);
        $this->secret_versions_for_request_headers = $arr;

        return $this;
    }

    /**
     * Optional. Specifies a list of allowed custom CA certificates (in DER
     * format) for HTTPS verification. This overrides the default SSL trust
     * store. If this is empty or unspecified, Dialogflow will use Google's
     * default trust store to verify certificates. N.B. Make sure the HTTPS
     * server certificates are signed with "subject alt name". For instance a
     * certificate can be self-signed using the following command,
     * ```
     *    openssl x509 -req -days 200 -in example.com.csr \
     *      -signkey example.com.key \
     *      -out example.com.crt \
     *      -extfile <(printf "\nsubjectAltName='DNS:www.example.com'")
     * ```
     *
     * Generated from protobuf field <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowedCaCerts()
    {
        return $this->allowed_ca_certs;
    }

    /**
     * Optional. Specifies a list of allowed custom CA certificates (in DER
     * format) for HTTPS verification. This overrides the default SSL trust
     * store. If this is empty or unspecified, Dialogflow will use Google's
     * default trust store to verify certificates. N.B. Make sure the HTTPS
     * server certificates are signed with "subject alt name". For instance a
     * certificate can be self-signed using the following command,
     * ```
     *    openssl x509 -req -days 200 -in example.com.csr \
     *      -signkey example.com.key \
     *      -out example.com.crt \
     *      -extfile <(printf "\nsubjectAltName='DNS:www.example.com'")
     * ```
     *
     * Generated from protobuf field <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowedCaCerts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::BYTES);
        $this->allowed_ca_certs = $arr;

        return $this;
    }

    /**
     * Optional. The OAuth configuration of the webhook. If specified,
     * Dialogflow will initiate the OAuth client credential flow to exchange an
     * access token from the 3rd party platform and put it in the auth header.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.OAuthConfig oauth_config = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\Webhook\GenericWebService\OAuthConfig|null
     */
    public function getOauthConfig()
    {
        return $this->oauth_config;
    }

    public function hasOauthConfig()
    {
        return isset($this->oauth_config);
    }

    public function clearOauthConfig()
    {
        unset($this->oauth_config);
    }

    /**
     * Optional. The OAuth configuration of the webhook. If specified,
     * Dialogflow will initiate the OAuth client credential flow to exchange an
     * access token from the 3rd party platform and put it in the auth header.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.OAuthConfig oauth_config = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\Webhook\GenericWebService\OAuthConfig $var
     * @return $this
     */
    public function setOauthConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\Webhook\GenericWebService\OAuthConfig::class);
        $this->oauth_config = $var;

        return $this;
    }

    /**
     * Optional. Indicate the auth token type generated from the [Diglogflow
     * service
     * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
     * The generated token is sent in the Authorization header.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.ServiceAgentAuth service_agent_auth = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getServiceAgentAuth()
    {
        return $this->service_agent_auth;
    }

    /**
     * Optional. Indicate the auth token type generated from the [Diglogflow
     * service
     * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
     * The generated token is sent in the Authorization header.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.ServiceAgentAuth service_agent_auth = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setServiceAgentAuth($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\Cx\V3\Webhook\GenericWebService\ServiceAgentAuth::class);
        $this->service_agent_auth = $var;

        return $this;
    }

    /**
     * Optional. Configuration for service account authentication.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.ServiceAccountAuthConfig service_account_auth_config = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\Webhook\GenericWebService\ServiceAccountAuthConfig|null
     */
    public function getServiceAccountAuthConfig()
    {
        return $this->service_account_auth_config;
    }

    public function hasServiceAccountAuthConfig()
    {
        return isset($this->service_account_auth_config);
    }

    public function clearServiceAccountAuthConfig()
    {
        unset($this->service_account_auth_config);
    }

    /**
     * Optional. Configuration for service account authentication.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.ServiceAccountAuthConfig service_account_auth_config = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\Webhook\GenericWebService\ServiceAccountAuthConfig $var
     * @return $this
     */
    public function setServiceAccountAuthConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\Webhook\GenericWebService\ServiceAccountAuthConfig::class);
        $this->service_account_auth_config = $var;

        return $this;
    }

    /**
     * Optional. Type of the webhook.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.WebhookType webhook_type = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getWebhookType()
    {
        return $this->webhook_type;
    }

    /**
     * Optional. Type of the webhook.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.WebhookType webhook_type = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setWebhookType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\Cx\V3\Webhook\GenericWebService\WebhookType::class);
        $this->webhook_type = $var;

        return $this;
    }

    /**
     * Optional. HTTP method for the flexible webhook calls. Standard webhook
     * always uses POST.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.HttpMethod http_method = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getHttpMethod()
    {
        return $this->http_method;
    }

    /**
     * Optional. HTTP method for the flexible webhook calls. Standard webhook
     * always uses POST.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.HttpMethod http_method = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setHttpMethod($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\Cx\V3\Webhook\GenericWebService\HttpMethod::class);
        $this->http_method = $var;

        return $this;
    }

    /**
     * Optional. Defines a custom JSON object as request body to send to
     * flexible webhook.
     *
     * Generated from protobuf field <code>string request_body = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getRequestBody()
    {
        return $this->request_body;
    }

    /**
     * Optional. Defines a custom JSON object as request body to send to
     * flexible webhook.
     *
     * Generated from protobuf field <code>string request_body = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setRequestBody($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_body = $var;

        return $this;
    }

    /**
     * Optional. Maps the values extracted from specific fields of the flexible
     * webhook response into session parameters.
     * - Key: session parameter name
     * - Value: field path in the webhook response
     *
     * Generated from protobuf field <code>map<string, string> parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getParameterMapping()
    {
        return $this->parameter_mapping;
    }

    /**
     * Optional. Maps the values extracted from specific fields of the flexible
     * webhook response into session parameters.
     * - Key: session parameter name
     * - Value: field path in the webhook response
     *
     * Generated from protobuf field <code>map<string, string> parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setParameterMapping($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->parameter_mapping = $arr;

        return $this;
    }

}


