<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/devicestreaming/v1/service.proto

namespace Google\Cloud\DeviceStreaming\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Protobuf message describing the device message, used from several RPCs.
 *
 * Generated from protobuf message <code>google.cloud.devicestreaming.v1.DeviceSession</code>
 */
class DeviceSession extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Name of the DeviceSession, e.g.
     * "projects/{project_id}/deviceSessions/{session_id}"
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $name = '';
    /**
     * Output only. The title of the DeviceSession to be presented in the UI.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $display_name = '';
    /**
     * Output only. Current state of the DeviceSession.
     *
     * Generated from protobuf field <code>.google.cloud.devicestreaming.v1.DeviceSession.SessionState state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. The historical state transitions of the session_state message
     * including the current session state.
     *
     * Generated from protobuf field <code>repeated .google.cloud.devicestreaming.v1.DeviceSession.SessionStateEvent state_histories = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state_histories;
    /**
     * Output only. The interval of time that this device must be interacted with
     * before it transitions from ACTIVE to TIMEOUT_INACTIVITY.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration inactivity_timeout = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $inactivity_timeout = null;
    /**
     * Output only. The time that the Session was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The timestamp that the session first became ACTIVE.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp active_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $active_start_time = null;
    /**
     * Required. The requested device
     *
     * Generated from protobuf field <code>.google.cloud.devicestreaming.v1.AndroidDevice android_device = 15 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $android_device = null;
    protected $expiration;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Optional. Name of the DeviceSession, e.g.
     *           "projects/{project_id}/deviceSessions/{session_id}"
     *     @type string $display_name
     *           Output only. The title of the DeviceSession to be presented in the UI.
     *     @type int $state
     *           Output only. Current state of the DeviceSession.
     *     @type array<\Google\Cloud\DeviceStreaming\V1\DeviceSession\SessionStateEvent>|\Google\Protobuf\Internal\RepeatedField $state_histories
     *           Output only. The historical state transitions of the session_state message
     *           including the current session state.
     *     @type \Google\Protobuf\Duration $ttl
     *           Optional. The amount of time that a device will be initially allocated
     *           for. This can eventually be extended with the UpdateDeviceSession RPC.
     *           Default: 15 minutes.
     *     @type \Google\Protobuf\Timestamp $expire_time
     *           Optional. If the device is still in use at this time, any connections
     *           will be ended and the SessionState will transition from ACTIVE to
     *           FINISHED.
     *     @type \Google\Protobuf\Duration $inactivity_timeout
     *           Output only. The interval of time that this device must be interacted with
     *           before it transitions from ACTIVE to TIMEOUT_INACTIVITY.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time that the Session was created.
     *     @type \Google\Protobuf\Timestamp $active_start_time
     *           Output only. The timestamp that the session first became ACTIVE.
     *     @type \Google\Cloud\DeviceStreaming\V1\AndroidDevice $android_device
     *           Required. The requested device
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Devicestreaming\V1\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Name of the DeviceSession, e.g.
     * "projects/{project_id}/deviceSessions/{session_id}"
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Optional. Name of the DeviceSession, e.g.
     * "projects/{project_id}/deviceSessions/{session_id}"
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The title of the DeviceSession to be presented in the UI.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Output only. The title of the DeviceSession to be presented in the UI.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Output only. Current state of the DeviceSession.
     *
     * Generated from protobuf field <code>.google.cloud.devicestreaming.v1.DeviceSession.SessionState state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. Current state of the DeviceSession.
     *
     * Generated from protobuf field <code>.google.cloud.devicestreaming.v1.DeviceSession.SessionState state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DeviceStreaming\V1\DeviceSession\SessionState::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The historical state transitions of the session_state message
     * including the current session state.
     *
     * Generated from protobuf field <code>repeated .google.cloud.devicestreaming.v1.DeviceSession.SessionStateEvent state_histories = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStateHistories()
    {
        return $this->state_histories;
    }

    /**
     * Output only. The historical state transitions of the session_state message
     * including the current session state.
     *
     * Generated from protobuf field <code>repeated .google.cloud.devicestreaming.v1.DeviceSession.SessionStateEvent state_histories = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\DeviceStreaming\V1\DeviceSession\SessionStateEvent>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStateHistories($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\DeviceStreaming\V1\DeviceSession\SessionStateEvent::class);
        $this->state_histories = $arr;

        return $this;
    }

    /**
     * Optional. The amount of time that a device will be initially allocated
     * for. This can eventually be extended with the UpdateDeviceSession RPC.
     * Default: 15 minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration ttl = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTtl()
    {
        return $this->readOneof(13);
    }

    public function hasTtl()
    {
        return $this->hasOneof(13);
    }

    /**
     * Optional. The amount of time that a device will be initially allocated
     * for. This can eventually be extended with the UpdateDeviceSession RPC.
     * Default: 15 minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration ttl = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTtl($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->writeOneof(13, $var);

        return $this;
    }

    /**
     * Optional. If the device is still in use at this time, any connections
     * will be ended and the SessionState will transition from ACTIVE to
     * FINISHED.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpireTime()
    {
        return $this->readOneof(5);
    }

    public function hasExpireTime()
    {
        return $this->hasOneof(5);
    }

    /**
     * Optional. If the device is still in use at this time, any connections
     * will be ended and the SessionState will transition from ACTIVE to
     * FINISHED.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Output only. The interval of time that this device must be interacted with
     * before it transitions from ACTIVE to TIMEOUT_INACTIVITY.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration inactivity_timeout = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getInactivityTimeout()
    {
        return $this->inactivity_timeout;
    }

    public function hasInactivityTimeout()
    {
        return isset($this->inactivity_timeout);
    }

    public function clearInactivityTimeout()
    {
        unset($this->inactivity_timeout);
    }

    /**
     * Output only. The interval of time that this device must be interacted with
     * before it transitions from ACTIVE to TIMEOUT_INACTIVITY.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration inactivity_timeout = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setInactivityTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->inactivity_timeout = $var;

        return $this;
    }

    /**
     * Output only. The time that the Session was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time that the Session was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp that the session first became ACTIVE.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp active_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getActiveStartTime()
    {
        return $this->active_start_time;
    }

    public function hasActiveStartTime()
    {
        return isset($this->active_start_time);
    }

    public function clearActiveStartTime()
    {
        unset($this->active_start_time);
    }

    /**
     * Output only. The timestamp that the session first became ACTIVE.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp active_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setActiveStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->active_start_time = $var;

        return $this;
    }

    /**
     * Required. The requested device
     *
     * Generated from protobuf field <code>.google.cloud.devicestreaming.v1.AndroidDevice android_device = 15 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\DeviceStreaming\V1\AndroidDevice|null
     */
    public function getAndroidDevice()
    {
        return $this->android_device;
    }

    public function hasAndroidDevice()
    {
        return isset($this->android_device);
    }

    public function clearAndroidDevice()
    {
        unset($this->android_device);
    }

    /**
     * Required. The requested device
     *
     * Generated from protobuf field <code>.google.cloud.devicestreaming.v1.AndroidDevice android_device = 15 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\DeviceStreaming\V1\AndroidDevice $var
     * @return $this
     */
    public function setAndroidDevice($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DeviceStreaming\V1\AndroidDevice::class);
        $this->android_device = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getExpiration()
    {
        return $this->whichOneof("expiration");
    }

}

