<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dataplex/v1/data_profile.proto

namespace Google\Cloud\Dataplex\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * DataProfileScan related setting.
 *
 * Generated from protobuf message <code>google.cloud.dataplex.v1.DataProfileSpec</code>
 */
class DataProfileSpec extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. The percentage of the records to be selected from the dataset for
     * DataScan.
     * * Value can range between 0.0 and 100.0 with up to 3 significant decimal
     * digits.
     * * Sampling is not applied if `sampling_percent` is not specified, 0 or
     * 100.
     *
     * Generated from protobuf field <code>float sampling_percent = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $sampling_percent = 0.0;
    /**
     * Optional. A filter applied to all rows in a single DataScan job.
     * The filter needs to be a valid SQL expression for a WHERE clause in
     * BigQuery standard SQL syntax.
     * Example: col1 >= 0 AND col2 < 10
     *
     * Generated from protobuf field <code>string row_filter = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $row_filter = '';
    /**
     * Optional. Actions to take upon job completion..
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.DataProfileSpec.PostScanActions post_scan_actions = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $post_scan_actions = null;
    /**
     * Optional. The fields to include in data profile.
     * If not specified, all fields at the time of profile scan job execution are
     * included, except for ones listed in `exclude_fields`.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.DataProfileSpec.SelectedFields include_fields = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $include_fields = null;
    /**
     * Optional. The fields to exclude from data profile.
     * If specified, the fields will be excluded from data profile, regardless of
     * `include_fields` value.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.DataProfileSpec.SelectedFields exclude_fields = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $exclude_fields = null;
    /**
     * Optional. If set, the latest DataScan job result will be published as
     * Dataplex Universal Catalog metadata.
     *
     * Generated from protobuf field <code>bool catalog_publishing_enabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $catalog_publishing_enabled = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type float $sampling_percent
     *           Optional. The percentage of the records to be selected from the dataset for
     *           DataScan.
     *           * Value can range between 0.0 and 100.0 with up to 3 significant decimal
     *           digits.
     *           * Sampling is not applied if `sampling_percent` is not specified, 0 or
     *           100.
     *     @type string $row_filter
     *           Optional. A filter applied to all rows in a single DataScan job.
     *           The filter needs to be a valid SQL expression for a WHERE clause in
     *           BigQuery standard SQL syntax.
     *           Example: col1 >= 0 AND col2 < 10
     *     @type \Google\Cloud\Dataplex\V1\DataProfileSpec\PostScanActions $post_scan_actions
     *           Optional. Actions to take upon job completion..
     *     @type \Google\Cloud\Dataplex\V1\DataProfileSpec\SelectedFields $include_fields
     *           Optional. The fields to include in data profile.
     *           If not specified, all fields at the time of profile scan job execution are
     *           included, except for ones listed in `exclude_fields`.
     *     @type \Google\Cloud\Dataplex\V1\DataProfileSpec\SelectedFields $exclude_fields
     *           Optional. The fields to exclude from data profile.
     *           If specified, the fields will be excluded from data profile, regardless of
     *           `include_fields` value.
     *     @type bool $catalog_publishing_enabled
     *           Optional. If set, the latest DataScan job result will be published as
     *           Dataplex Universal Catalog metadata.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dataplex\V1\DataProfile::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. The percentage of the records to be selected from the dataset for
     * DataScan.
     * * Value can range between 0.0 and 100.0 with up to 3 significant decimal
     * digits.
     * * Sampling is not applied if `sampling_percent` is not specified, 0 or
     * 100.
     *
     * Generated from protobuf field <code>float sampling_percent = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return float
     */
    public function getSamplingPercent()
    {
        return $this->sampling_percent;
    }

    /**
     * Optional. The percentage of the records to be selected from the dataset for
     * DataScan.
     * * Value can range between 0.0 and 100.0 with up to 3 significant decimal
     * digits.
     * * Sampling is not applied if `sampling_percent` is not specified, 0 or
     * 100.
     *
     * Generated from protobuf field <code>float sampling_percent = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param float $var
     * @return $this
     */
    public function setSamplingPercent($var)
    {
        GPBUtil::checkFloat($var);
        $this->sampling_percent = $var;

        return $this;
    }

    /**
     * Optional. A filter applied to all rows in a single DataScan job.
     * The filter needs to be a valid SQL expression for a WHERE clause in
     * BigQuery standard SQL syntax.
     * Example: col1 >= 0 AND col2 < 10
     *
     * Generated from protobuf field <code>string row_filter = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getRowFilter()
    {
        return $this->row_filter;
    }

    /**
     * Optional. A filter applied to all rows in a single DataScan job.
     * The filter needs to be a valid SQL expression for a WHERE clause in
     * BigQuery standard SQL syntax.
     * Example: col1 >= 0 AND col2 < 10
     *
     * Generated from protobuf field <code>string row_filter = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setRowFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->row_filter = $var;

        return $this;
    }

    /**
     * Optional. Actions to take upon job completion..
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.DataProfileSpec.PostScanActions post_scan_actions = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dataplex\V1\DataProfileSpec\PostScanActions|null
     */
    public function getPostScanActions()
    {
        return $this->post_scan_actions;
    }

    public function hasPostScanActions()
    {
        return isset($this->post_scan_actions);
    }

    public function clearPostScanActions()
    {
        unset($this->post_scan_actions);
    }

    /**
     * Optional. Actions to take upon job completion..
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.DataProfileSpec.PostScanActions post_scan_actions = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dataplex\V1\DataProfileSpec\PostScanActions $var
     * @return $this
     */
    public function setPostScanActions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataplex\V1\DataProfileSpec\PostScanActions::class);
        $this->post_scan_actions = $var;

        return $this;
    }

    /**
     * Optional. The fields to include in data profile.
     * If not specified, all fields at the time of profile scan job execution are
     * included, except for ones listed in `exclude_fields`.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.DataProfileSpec.SelectedFields include_fields = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dataplex\V1\DataProfileSpec\SelectedFields|null
     */
    public function getIncludeFields()
    {
        return $this->include_fields;
    }

    public function hasIncludeFields()
    {
        return isset($this->include_fields);
    }

    public function clearIncludeFields()
    {
        unset($this->include_fields);
    }

    /**
     * Optional. The fields to include in data profile.
     * If not specified, all fields at the time of profile scan job execution are
     * included, except for ones listed in `exclude_fields`.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.DataProfileSpec.SelectedFields include_fields = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dataplex\V1\DataProfileSpec\SelectedFields $var
     * @return $this
     */
    public function setIncludeFields($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataplex\V1\DataProfileSpec\SelectedFields::class);
        $this->include_fields = $var;

        return $this;
    }

    /**
     * Optional. The fields to exclude from data profile.
     * If specified, the fields will be excluded from data profile, regardless of
     * `include_fields` value.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.DataProfileSpec.SelectedFields exclude_fields = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dataplex\V1\DataProfileSpec\SelectedFields|null
     */
    public function getExcludeFields()
    {
        return $this->exclude_fields;
    }

    public function hasExcludeFields()
    {
        return isset($this->exclude_fields);
    }

    public function clearExcludeFields()
    {
        unset($this->exclude_fields);
    }

    /**
     * Optional. The fields to exclude from data profile.
     * If specified, the fields will be excluded from data profile, regardless of
     * `include_fields` value.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.DataProfileSpec.SelectedFields exclude_fields = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dataplex\V1\DataProfileSpec\SelectedFields $var
     * @return $this
     */
    public function setExcludeFields($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataplex\V1\DataProfileSpec\SelectedFields::class);
        $this->exclude_fields = $var;

        return $this;
    }

    /**
     * Optional. If set, the latest DataScan job result will be published as
     * Dataplex Universal Catalog metadata.
     *
     * Generated from protobuf field <code>bool catalog_publishing_enabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getCatalogPublishingEnabled()
    {
        return $this->catalog_publishing_enabled;
    }

    /**
     * Optional. If set, the latest DataScan job result will be published as
     * Dataplex Universal Catalog metadata.
     *
     * Generated from protobuf field <code>bool catalog_publishing_enabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setCatalogPublishingEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->catalog_publishing_enabled = $var;

        return $this;
    }

}

