<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1\ContainerdConfig;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * RegistryHostConfig configures the top-level structure for a single
 * containerd registry server's configuration, which represents one hosts.toml
 * file on the node. It will override the same fqdns in
 * PrivateRegistryAccessConfig.
 *
 * Generated from protobuf message <code>google.container.v1.ContainerdConfig.RegistryHostConfig</code>
 */
class RegistryHostConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Defines the host name of the registry server, which will be used to
     * create configuration file as /etc/containerd/hosts.d/<server>/hosts.toml.
     * It supports fully qualified domain names (FQDN) and IP addresses:
     * Specifying port is supported.
     * Wildcards are NOT supported.
     * Examples:
     * - my.customdomain.com
     * - 10.0.1.2:5000
     *
     * Generated from protobuf field <code>string server = 1;</code>
     */
    protected $server = '';
    /**
     * HostConfig configures a list of host-specific configurations for the
     * server.
     * Each server can have at most 10 host configurations.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.ContainerdConfig.RegistryHostConfig.HostConfig hosts = 2;</code>
     */
    private $hosts;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $server
     *           Defines the host name of the registry server, which will be used to
     *           create configuration file as /etc/containerd/hosts.d/<server>/hosts.toml.
     *           It supports fully qualified domain names (FQDN) and IP addresses:
     *           Specifying port is supported.
     *           Wildcards are NOT supported.
     *           Examples:
     *           - my.customdomain.com
     *           - 10.0.1.2:5000
     *     @type array<\Google\Cloud\Container\V1\ContainerdConfig\RegistryHostConfig\HostConfig>|\Google\Protobuf\Internal\RepeatedField $hosts
     *           HostConfig configures a list of host-specific configurations for the
     *           server.
     *           Each server can have at most 10 host configurations.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * Defines the host name of the registry server, which will be used to
     * create configuration file as /etc/containerd/hosts.d/<server>/hosts.toml.
     * It supports fully qualified domain names (FQDN) and IP addresses:
     * Specifying port is supported.
     * Wildcards are NOT supported.
     * Examples:
     * - my.customdomain.com
     * - 10.0.1.2:5000
     *
     * Generated from protobuf field <code>string server = 1;</code>
     * @return string
     */
    public function getServer()
    {
        return $this->server;
    }

    /**
     * Defines the host name of the registry server, which will be used to
     * create configuration file as /etc/containerd/hosts.d/<server>/hosts.toml.
     * It supports fully qualified domain names (FQDN) and IP addresses:
     * Specifying port is supported.
     * Wildcards are NOT supported.
     * Examples:
     * - my.customdomain.com
     * - 10.0.1.2:5000
     *
     * Generated from protobuf field <code>string server = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setServer($var)
    {
        GPBUtil::checkString($var, True);
        $this->server = $var;

        return $this;
    }

    /**
     * HostConfig configures a list of host-specific configurations for the
     * server.
     * Each server can have at most 10 host configurations.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.ContainerdConfig.RegistryHostConfig.HostConfig hosts = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getHosts()
    {
        return $this->hosts;
    }

    /**
     * HostConfig configures a list of host-specific configurations for the
     * server.
     * Each server can have at most 10 host configurations.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.ContainerdConfig.RegistryHostConfig.HostConfig hosts = 2;</code>
     * @param array<\Google\Cloud\Container\V1\ContainerdConfig\RegistryHostConfig\HostConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setHosts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Container\V1\ContainerdConfig\RegistryHostConfig\HostConfig::class);
        $this->hosts = $arr;

        return $this;
    }

}


