<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/confidentialcomputing/v1/service.proto

namespace Google\Cloud\ConfidentialComputing\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request for an attestation token, providing all the necessary information
 * needed for this service to verify the platform state of the requestor.
 *
 * Generated from protobuf message <code>google.cloud.confidentialcomputing.v1.VerifyConfidentialSpaceRequest</code>
 */
class VerifyConfidentialSpaceRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the Challenge whose nonce was used to generate the
     * attestation, in the format `projects/&#42;&#47;locations/&#42;&#47;challenges/&#42;`. The
     * provided Challenge will be consumed, and cannot be used again.
     *
     * Generated from protobuf field <code>string challenge = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $challenge = '';
    /**
     * Optional. Credentials used to populate the "emails" claim in the
     * claims_token. If not present, token will not contain the "emails" claim.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.GcpCredentials gcp_credentials = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $gcp_credentials = null;
    /**
     * Optional. A list of signed entities containing container image signatures
     * that can be used for server-side signature verification.
     *
     * Generated from protobuf field <code>repeated .google.cloud.confidentialcomputing.v1.SignedEntity signed_entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $signed_entities;
    /**
     * Optional. Information about the associated Compute Engine instance.
     * Required for td_ccel requests only - tpm_attestation requests will provide
     * this information in the attestation.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.GceShieldedIdentity gce_shielded_identity = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $gce_shielded_identity = null;
    /**
     * Optional. A collection of fields that modify the token output.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.VerifyConfidentialSpaceRequest.ConfidentialSpaceOptions options = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $options = null;
    /**
     * Optional. An optional Nvidia attestation report, used to populate hardware
     * rooted claims for Nvidia devices.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.NvidiaAttestation nvidia_attestation = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $nvidia_attestation = null;
    protected $tee_attestation;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\ConfidentialComputing\V1\TdxCcelAttestation $td_ccel
     *           Input only. A TDX with CCEL and RTMR Attestation Quote.
     *     @type \Google\Cloud\ConfidentialComputing\V1\TpmAttestation $tpm_attestation
     *           Input only. The TPM-specific data provided by the attesting platform,
     *           used to populate any of the claims regarding platform state.
     *     @type string $challenge
     *           Required. The name of the Challenge whose nonce was used to generate the
     *           attestation, in the format `projects/&#42;&#47;locations/&#42;&#47;challenges/&#42;`. The
     *           provided Challenge will be consumed, and cannot be used again.
     *     @type \Google\Cloud\ConfidentialComputing\V1\GcpCredentials $gcp_credentials
     *           Optional. Credentials used to populate the "emails" claim in the
     *           claims_token. If not present, token will not contain the "emails" claim.
     *     @type array<\Google\Cloud\ConfidentialComputing\V1\SignedEntity>|\Google\Protobuf\Internal\RepeatedField $signed_entities
     *           Optional. A list of signed entities containing container image signatures
     *           that can be used for server-side signature verification.
     *     @type \Google\Cloud\ConfidentialComputing\V1\GceShieldedIdentity $gce_shielded_identity
     *           Optional. Information about the associated Compute Engine instance.
     *           Required for td_ccel requests only - tpm_attestation requests will provide
     *           this information in the attestation.
     *     @type \Google\Cloud\ConfidentialComputing\V1\VerifyConfidentialSpaceRequest\ConfidentialSpaceOptions $options
     *           Optional. A collection of fields that modify the token output.
     *     @type \Google\Cloud\ConfidentialComputing\V1\NvidiaAttestation $nvidia_attestation
     *           Optional. An optional Nvidia attestation report, used to populate hardware
     *           rooted claims for Nvidia devices.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Confidentialcomputing\V1\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * Input only. A TDX with CCEL and RTMR Attestation Quote.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.TdxCcelAttestation td_ccel = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Cloud\ConfidentialComputing\V1\TdxCcelAttestation|null
     */
    public function getTdCcel()
    {
        return $this->readOneof(3);
    }

    public function hasTdCcel()
    {
        return $this->hasOneof(3);
    }

    /**
     * Input only. A TDX with CCEL and RTMR Attestation Quote.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.TdxCcelAttestation td_ccel = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Cloud\ConfidentialComputing\V1\TdxCcelAttestation $var
     * @return $this
     */
    public function setTdCcel($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ConfidentialComputing\V1\TdxCcelAttestation::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Input only. The TPM-specific data provided by the attesting platform,
     * used to populate any of the claims regarding platform state.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.TpmAttestation tpm_attestation = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Cloud\ConfidentialComputing\V1\TpmAttestation|null
     */
    public function getTpmAttestation()
    {
        return $this->readOneof(4);
    }

    public function hasTpmAttestation()
    {
        return $this->hasOneof(4);
    }

    /**
     * Input only. The TPM-specific data provided by the attesting platform,
     * used to populate any of the claims regarding platform state.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.TpmAttestation tpm_attestation = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Cloud\ConfidentialComputing\V1\TpmAttestation $var
     * @return $this
     */
    public function setTpmAttestation($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ConfidentialComputing\V1\TpmAttestation::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Required. The name of the Challenge whose nonce was used to generate the
     * attestation, in the format `projects/&#42;&#47;locations/&#42;&#47;challenges/&#42;`. The
     * provided Challenge will be consumed, and cannot be used again.
     *
     * Generated from protobuf field <code>string challenge = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getChallenge()
    {
        return $this->challenge;
    }

    /**
     * Required. The name of the Challenge whose nonce was used to generate the
     * attestation, in the format `projects/&#42;&#47;locations/&#42;&#47;challenges/&#42;`. The
     * provided Challenge will be consumed, and cannot be used again.
     *
     * Generated from protobuf field <code>string challenge = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setChallenge($var)
    {
        GPBUtil::checkString($var, True);
        $this->challenge = $var;

        return $this;
    }

    /**
     * Optional. Credentials used to populate the "emails" claim in the
     * claims_token. If not present, token will not contain the "emails" claim.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.GcpCredentials gcp_credentials = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ConfidentialComputing\V1\GcpCredentials|null
     */
    public function getGcpCredentials()
    {
        return $this->gcp_credentials;
    }

    public function hasGcpCredentials()
    {
        return isset($this->gcp_credentials);
    }

    public function clearGcpCredentials()
    {
        unset($this->gcp_credentials);
    }

    /**
     * Optional. Credentials used to populate the "emails" claim in the
     * claims_token. If not present, token will not contain the "emails" claim.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.GcpCredentials gcp_credentials = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ConfidentialComputing\V1\GcpCredentials $var
     * @return $this
     */
    public function setGcpCredentials($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ConfidentialComputing\V1\GcpCredentials::class);
        $this->gcp_credentials = $var;

        return $this;
    }

    /**
     * Optional. A list of signed entities containing container image signatures
     * that can be used for server-side signature verification.
     *
     * Generated from protobuf field <code>repeated .google.cloud.confidentialcomputing.v1.SignedEntity signed_entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSignedEntities()
    {
        return $this->signed_entities;
    }

    /**
     * Optional. A list of signed entities containing container image signatures
     * that can be used for server-side signature verification.
     *
     * Generated from protobuf field <code>repeated .google.cloud.confidentialcomputing.v1.SignedEntity signed_entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\ConfidentialComputing\V1\SignedEntity>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSignedEntities($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\ConfidentialComputing\V1\SignedEntity::class);
        $this->signed_entities = $arr;

        return $this;
    }

    /**
     * Optional. Information about the associated Compute Engine instance.
     * Required for td_ccel requests only - tpm_attestation requests will provide
     * this information in the attestation.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.GceShieldedIdentity gce_shielded_identity = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ConfidentialComputing\V1\GceShieldedIdentity|null
     */
    public function getGceShieldedIdentity()
    {
        return $this->gce_shielded_identity;
    }

    public function hasGceShieldedIdentity()
    {
        return isset($this->gce_shielded_identity);
    }

    public function clearGceShieldedIdentity()
    {
        unset($this->gce_shielded_identity);
    }

    /**
     * Optional. Information about the associated Compute Engine instance.
     * Required for td_ccel requests only - tpm_attestation requests will provide
     * this information in the attestation.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.GceShieldedIdentity gce_shielded_identity = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ConfidentialComputing\V1\GceShieldedIdentity $var
     * @return $this
     */
    public function setGceShieldedIdentity($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ConfidentialComputing\V1\GceShieldedIdentity::class);
        $this->gce_shielded_identity = $var;

        return $this;
    }

    /**
     * Optional. A collection of fields that modify the token output.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.VerifyConfidentialSpaceRequest.ConfidentialSpaceOptions options = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ConfidentialComputing\V1\VerifyConfidentialSpaceRequest\ConfidentialSpaceOptions|null
     */
    public function getOptions()
    {
        return $this->options;
    }

    public function hasOptions()
    {
        return isset($this->options);
    }

    public function clearOptions()
    {
        unset($this->options);
    }

    /**
     * Optional. A collection of fields that modify the token output.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.VerifyConfidentialSpaceRequest.ConfidentialSpaceOptions options = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ConfidentialComputing\V1\VerifyConfidentialSpaceRequest\ConfidentialSpaceOptions $var
     * @return $this
     */
    public function setOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ConfidentialComputing\V1\VerifyConfidentialSpaceRequest\ConfidentialSpaceOptions::class);
        $this->options = $var;

        return $this;
    }

    /**
     * Optional. An optional Nvidia attestation report, used to populate hardware
     * rooted claims for Nvidia devices.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.NvidiaAttestation nvidia_attestation = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ConfidentialComputing\V1\NvidiaAttestation|null
     */
    public function getNvidiaAttestation()
    {
        return $this->nvidia_attestation;
    }

    public function hasNvidiaAttestation()
    {
        return isset($this->nvidia_attestation);
    }

    public function clearNvidiaAttestation()
    {
        unset($this->nvidia_attestation);
    }

    /**
     * Optional. An optional Nvidia attestation report, used to populate hardware
     * rooted claims for Nvidia devices.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.NvidiaAttestation nvidia_attestation = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ConfidentialComputing\V1\NvidiaAttestation $var
     * @return $this
     */
    public function setNvidiaAttestation($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ConfidentialComputing\V1\NvidiaAttestation::class);
        $this->nvidia_attestation = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTeeAttestation()
    {
        return $this->whichOneof("tee_attestation");
    }

}

