<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/confidentialcomputing/v1/service.proto

namespace Google\Cloud\ConfidentialComputing\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request for an attestation token, providing all the necessary information
 * needed for this service to verify the platform state of the requestor.
 *
 * Generated from protobuf message <code>google.cloud.confidentialcomputing.v1.VerifyAttestationRequest</code>
 */
class VerifyAttestationRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the Challenge whose nonce was used to generate the
     * attestation, in the format `projects/&#42;&#47;locations/&#42;&#47;challenges/&#42;`. The
     * provided Challenge will be consumed, and cannot be used again.
     *
     * Generated from protobuf field <code>string challenge = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $challenge = '';
    /**
     * Optional. Credentials used to populate the "emails" claim in the
     * claims_token.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.GcpCredentials gcp_credentials = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $gcp_credentials = null;
    /**
     * Required. The TPM-specific data provided by the attesting platform, used to
     * populate any of the claims regarding platform state.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.TpmAttestation tpm_attestation = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $tpm_attestation = null;
    /**
     * Optional. Optional information related to the Confidential Space TEE.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.ConfidentialSpaceInfo confidential_space_info = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $confidential_space_info = null;
    /**
     * Optional. A collection of optional, workload-specified claims that modify
     * the token output.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.TokenOptions token_options = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $token_options = null;
    /**
     * Optional. An optional indicator of the attester, only applies to certain
     * products.
     *
     * Generated from protobuf field <code>string attester = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $attester = '';
    protected $tee_attestation;
    protected $device_attestation;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\ConfidentialComputing\V1\TdxCcelAttestation $td_ccel
     *           Optional. A TDX with CCEL and RTMR Attestation Quote.
     *     @type \Google\Cloud\ConfidentialComputing\V1\SevSnpAttestation $sev_snp_attestation
     *           Optional. An SEV-SNP Attestation Report.
     *     @type \Google\Cloud\ConfidentialComputing\V1\NvidiaAttestation $nvidia_attestation
     *           Optional. An Nvidia attestation report for GPU and NVSwitch devices.
     *     @type string $challenge
     *           Required. The name of the Challenge whose nonce was used to generate the
     *           attestation, in the format `projects/&#42;&#47;locations/&#42;&#47;challenges/&#42;`. The
     *           provided Challenge will be consumed, and cannot be used again.
     *     @type \Google\Cloud\ConfidentialComputing\V1\GcpCredentials $gcp_credentials
     *           Optional. Credentials used to populate the "emails" claim in the
     *           claims_token.
     *     @type \Google\Cloud\ConfidentialComputing\V1\TpmAttestation $tpm_attestation
     *           Required. The TPM-specific data provided by the attesting platform, used to
     *           populate any of the claims regarding platform state.
     *     @type \Google\Cloud\ConfidentialComputing\V1\ConfidentialSpaceInfo $confidential_space_info
     *           Optional. Optional information related to the Confidential Space TEE.
     *     @type \Google\Cloud\ConfidentialComputing\V1\TokenOptions $token_options
     *           Optional. A collection of optional, workload-specified claims that modify
     *           the token output.
     *     @type string $attester
     *           Optional. An optional indicator of the attester, only applies to certain
     *           products.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Confidentialcomputing\V1\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. A TDX with CCEL and RTMR Attestation Quote.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.TdxCcelAttestation td_ccel = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ConfidentialComputing\V1\TdxCcelAttestation|null
     */
    public function getTdCcel()
    {
        return $this->readOneof(6);
    }

    public function hasTdCcel()
    {
        return $this->hasOneof(6);
    }

    /**
     * Optional. A TDX with CCEL and RTMR Attestation Quote.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.TdxCcelAttestation td_ccel = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ConfidentialComputing\V1\TdxCcelAttestation $var
     * @return $this
     */
    public function setTdCcel($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ConfidentialComputing\V1\TdxCcelAttestation::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Optional. An SEV-SNP Attestation Report.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.SevSnpAttestation sev_snp_attestation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ConfidentialComputing\V1\SevSnpAttestation|null
     */
    public function getSevSnpAttestation()
    {
        return $this->readOneof(7);
    }

    public function hasSevSnpAttestation()
    {
        return $this->hasOneof(7);
    }

    /**
     * Optional. An SEV-SNP Attestation Report.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.SevSnpAttestation sev_snp_attestation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ConfidentialComputing\V1\SevSnpAttestation $var
     * @return $this
     */
    public function setSevSnpAttestation($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ConfidentialComputing\V1\SevSnpAttestation::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Optional. An Nvidia attestation report for GPU and NVSwitch devices.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.NvidiaAttestation nvidia_attestation = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ConfidentialComputing\V1\NvidiaAttestation|null
     */
    public function getNvidiaAttestation()
    {
        return $this->readOneof(9);
    }

    public function hasNvidiaAttestation()
    {
        return $this->hasOneof(9);
    }

    /**
     * Optional. An Nvidia attestation report for GPU and NVSwitch devices.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.NvidiaAttestation nvidia_attestation = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ConfidentialComputing\V1\NvidiaAttestation $var
     * @return $this
     */
    public function setNvidiaAttestation($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ConfidentialComputing\V1\NvidiaAttestation::class);
        $this->writeOneof(9, $var);

        return $this;
    }

    /**
     * Required. The name of the Challenge whose nonce was used to generate the
     * attestation, in the format `projects/&#42;&#47;locations/&#42;&#47;challenges/&#42;`. The
     * provided Challenge will be consumed, and cannot be used again.
     *
     * Generated from protobuf field <code>string challenge = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getChallenge()
    {
        return $this->challenge;
    }

    /**
     * Required. The name of the Challenge whose nonce was used to generate the
     * attestation, in the format `projects/&#42;&#47;locations/&#42;&#47;challenges/&#42;`. The
     * provided Challenge will be consumed, and cannot be used again.
     *
     * Generated from protobuf field <code>string challenge = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setChallenge($var)
    {
        GPBUtil::checkString($var, True);
        $this->challenge = $var;

        return $this;
    }

    /**
     * Optional. Credentials used to populate the "emails" claim in the
     * claims_token.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.GcpCredentials gcp_credentials = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ConfidentialComputing\V1\GcpCredentials|null
     */
    public function getGcpCredentials()
    {
        return $this->gcp_credentials;
    }

    public function hasGcpCredentials()
    {
        return isset($this->gcp_credentials);
    }

    public function clearGcpCredentials()
    {
        unset($this->gcp_credentials);
    }

    /**
     * Optional. Credentials used to populate the "emails" claim in the
     * claims_token.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.GcpCredentials gcp_credentials = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ConfidentialComputing\V1\GcpCredentials $var
     * @return $this
     */
    public function setGcpCredentials($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ConfidentialComputing\V1\GcpCredentials::class);
        $this->gcp_credentials = $var;

        return $this;
    }

    /**
     * Required. The TPM-specific data provided by the attesting platform, used to
     * populate any of the claims regarding platform state.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.TpmAttestation tpm_attestation = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\ConfidentialComputing\V1\TpmAttestation|null
     */
    public function getTpmAttestation()
    {
        return $this->tpm_attestation;
    }

    public function hasTpmAttestation()
    {
        return isset($this->tpm_attestation);
    }

    public function clearTpmAttestation()
    {
        unset($this->tpm_attestation);
    }

    /**
     * Required. The TPM-specific data provided by the attesting platform, used to
     * populate any of the claims regarding platform state.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.TpmAttestation tpm_attestation = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\ConfidentialComputing\V1\TpmAttestation $var
     * @return $this
     */
    public function setTpmAttestation($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ConfidentialComputing\V1\TpmAttestation::class);
        $this->tpm_attestation = $var;

        return $this;
    }

    /**
     * Optional. Optional information related to the Confidential Space TEE.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.ConfidentialSpaceInfo confidential_space_info = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ConfidentialComputing\V1\ConfidentialSpaceInfo|null
     */
    public function getConfidentialSpaceInfo()
    {
        return $this->confidential_space_info;
    }

    public function hasConfidentialSpaceInfo()
    {
        return isset($this->confidential_space_info);
    }

    public function clearConfidentialSpaceInfo()
    {
        unset($this->confidential_space_info);
    }

    /**
     * Optional. Optional information related to the Confidential Space TEE.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.ConfidentialSpaceInfo confidential_space_info = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ConfidentialComputing\V1\ConfidentialSpaceInfo $var
     * @return $this
     */
    public function setConfidentialSpaceInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ConfidentialComputing\V1\ConfidentialSpaceInfo::class);
        $this->confidential_space_info = $var;

        return $this;
    }

    /**
     * Optional. A collection of optional, workload-specified claims that modify
     * the token output.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.TokenOptions token_options = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ConfidentialComputing\V1\TokenOptions|null
     */
    public function getTokenOptions()
    {
        return $this->token_options;
    }

    public function hasTokenOptions()
    {
        return isset($this->token_options);
    }

    public function clearTokenOptions()
    {
        unset($this->token_options);
    }

    /**
     * Optional. A collection of optional, workload-specified claims that modify
     * the token output.
     *
     * Generated from protobuf field <code>.google.cloud.confidentialcomputing.v1.TokenOptions token_options = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ConfidentialComputing\V1\TokenOptions $var
     * @return $this
     */
    public function setTokenOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ConfidentialComputing\V1\TokenOptions::class);
        $this->token_options = $var;

        return $this;
    }

    /**
     * Optional. An optional indicator of the attester, only applies to certain
     * products.
     *
     * Generated from protobuf field <code>string attester = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAttester()
    {
        return $this->attester;
    }

    /**
     * Optional. An optional indicator of the attester, only applies to certain
     * products.
     *
     * Generated from protobuf field <code>string attester = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAttester($var)
    {
        GPBUtil::checkString($var, True);
        $this->attester = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTeeAttestation()
    {
        return $this->whichOneof("tee_attestation");
    }

    /**
     * @return string
     */
    public function getDeviceAttestation()
    {
        return $this->whichOneof("device_attestation");
    }

}

