<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * LINT.IfChange
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput</code>
 */
class InterconnectGroupsCreateMembersInterconnectInput extends \Google\Protobuf\Internal\Message
{
    /**
     * Administrative status of the interconnect. When this is set to true, the
     * Interconnect is functional and can carry traffic.
     * When set to false, no packets can be carried over the interconnect and
     * no BGP routes are exchanged over it. By default, the status is set to
     * true.
     *
     * Generated from protobuf field <code>optional bool admin_enabled = 445675089;</code>
     */
    protected $admin_enabled = null;
    /**
     * Customer name, to put in the Letter of Authorization as the party
     * authorized to request a crossconnect.
     *
     * Generated from protobuf field <code>optional string customer_name = 3665484;</code>
     */
    protected $customer_name = null;
    /**
     * An optional description of this resource. Provide this property when you
     * create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     */
    protected $description = null;
    /**
     * A zone-free location to use for all Interconnects created in this call,
     * like "iad-1234".
     *
     * Generated from protobuf field <code>optional string facility = 501116579;</code>
     */
    protected $facility = null;
    /**
     * Type of interconnect, which can take one of the following values:
     *    - PARTNER: A partner-managed interconnection shared between
     *    customers though a partner.
     *    - DEDICATED: A dedicated physical
     *    interconnection with the customer.
     *  Note that a value IT_PRIVATE
     * has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string interconnect_type = 515165259;</code>
     */
    protected $interconnect_type = null;
    /**
     * Type of link requested, which can take one of the following values:
     *    - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics
     *    - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics.
     *    - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4
     *    optics.
     *  Note that this field indicates the speed of each of the
     * links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string link_type = 523207775;</code>
     */
    protected $link_type = null;
    /**
     * Name of the Interconnects to be created. This must be specified on the
     * template and/or on each individual interconnect. The name, if not empty,
     * must be 1-63 characters long, and comply with RFC1035.
     * Specifically, any nonempty name must be 1-63 characters long and match
     * the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must
     * be a dash, lowercase letter, or digit, except the last character, which
     * cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     */
    protected $name = null;
    /**
     * Email address to contact the customer NOC for operations and maintenance
     * notifications regarding this Interconnect. If specified, this will be
     * used for notifications in addition to all other forms described, such as
     * Cloud Monitoring logs alerting and Cloud Notifications. This field is
     * required for users who sign up for Cloud Interconnect using
     * workforce identity federation.
     *
     * Generated from protobuf field <code>optional string noc_contact_email = 14072832;</code>
     */
    protected $noc_contact_email = null;
    /**
     * Indicates that this is a Cross-Cloud Interconnect. This field specifies
     * the location outside of Google's network that the interconnect is
     * connected to.
     *
     * Generated from protobuf field <code>optional string remote_location = 324388750;</code>
     */
    protected $remote_location = null;
    /**
     * Optional. List of features requested for this Interconnect connection,
     * which can take one of the following values:
     *    - IF_MACSEC: If specified, then the connection is created on MACsec
     *    capable hardware ports. If not specified, non-MACsec capable ports will
     *    also be considered.
     *    - IF_CROSS_SITE_NETWORK: If specified, then the connection is created
     *    exclusively for Cross-Site Networking. The connection can not be used for
     *    Cross-Site Networking unless this feature is specified.
     * Check the RequestedFeatures enum for the list of possible values.
     *
     * Generated from protobuf field <code>repeated string requested_features = 461240814;</code>
     */
    private $requested_features;
    /**
     * Target number of physical links in the link bundle, as requested by the
     * customer.
     *
     * Generated from protobuf field <code>optional int32 requested_link_count = 45051387;</code>
     */
    protected $requested_link_count = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $admin_enabled
     *           Administrative status of the interconnect. When this is set to true, the
     *           Interconnect is functional and can carry traffic.
     *           When set to false, no packets can be carried over the interconnect and
     *           no BGP routes are exchanged over it. By default, the status is set to
     *           true.
     *     @type string $customer_name
     *           Customer name, to put in the Letter of Authorization as the party
     *           authorized to request a crossconnect.
     *     @type string $description
     *           An optional description of this resource. Provide this property when you
     *           create the resource.
     *     @type string $facility
     *           A zone-free location to use for all Interconnects created in this call,
     *           like "iad-1234".
     *     @type string $interconnect_type
     *           Type of interconnect, which can take one of the following values:
     *              - PARTNER: A partner-managed interconnection shared between
     *              customers though a partner.
     *              - DEDICATED: A dedicated physical
     *              interconnection with the customer.
     *            Note that a value IT_PRIVATE
     *           has been deprecated in favor of DEDICATED.
     *           Check the InterconnectType enum for the list of possible values.
     *     @type string $link_type
     *           Type of link requested, which can take one of the following values:
     *              - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics
     *              - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics.
     *              - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4
     *              optics.
     *            Note that this field indicates the speed of each of the
     *           links in the bundle, not the speed of the entire bundle.
     *           Check the LinkType enum for the list of possible values.
     *     @type string $name
     *           Name of the Interconnects to be created. This must be specified on the
     *           template and/or on each individual interconnect. The name, if not empty,
     *           must be 1-63 characters long, and comply with RFC1035.
     *           Specifically, any nonempty name must be 1-63 characters long and match
     *           the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     *           character must be a lowercase letter, and all following characters must
     *           be a dash, lowercase letter, or digit, except the last character, which
     *           cannot be a dash.
     *     @type string $noc_contact_email
     *           Email address to contact the customer NOC for operations and maintenance
     *           notifications regarding this Interconnect. If specified, this will be
     *           used for notifications in addition to all other forms described, such as
     *           Cloud Monitoring logs alerting and Cloud Notifications. This field is
     *           required for users who sign up for Cloud Interconnect using
     *           workforce identity federation.
     *     @type string $remote_location
     *           Indicates that this is a Cross-Cloud Interconnect. This field specifies
     *           the location outside of Google's network that the interconnect is
     *           connected to.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $requested_features
     *           Optional. List of features requested for this Interconnect connection,
     *           which can take one of the following values:
     *              - IF_MACSEC: If specified, then the connection is created on MACsec
     *              capable hardware ports. If not specified, non-MACsec capable ports will
     *              also be considered.
     *              - IF_CROSS_SITE_NETWORK: If specified, then the connection is created
     *              exclusively for Cross-Site Networking. The connection can not be used for
     *              Cross-Site Networking unless this feature is specified.
     *           Check the RequestedFeatures enum for the list of possible values.
     *     @type int $requested_link_count
     *           Target number of physical links in the link bundle, as requested by the
     *           customer.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Administrative status of the interconnect. When this is set to true, the
     * Interconnect is functional and can carry traffic.
     * When set to false, no packets can be carried over the interconnect and
     * no BGP routes are exchanged over it. By default, the status is set to
     * true.
     *
     * Generated from protobuf field <code>optional bool admin_enabled = 445675089;</code>
     * @return bool
     */
    public function getAdminEnabled()
    {
        return isset($this->admin_enabled) ? $this->admin_enabled : false;
    }

    public function hasAdminEnabled()
    {
        return isset($this->admin_enabled);
    }

    public function clearAdminEnabled()
    {
        unset($this->admin_enabled);
    }

    /**
     * Administrative status of the interconnect. When this is set to true, the
     * Interconnect is functional and can carry traffic.
     * When set to false, no packets can be carried over the interconnect and
     * no BGP routes are exchanged over it. By default, the status is set to
     * true.
     *
     * Generated from protobuf field <code>optional bool admin_enabled = 445675089;</code>
     * @param bool $var
     * @return $this
     */
    public function setAdminEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->admin_enabled = $var;

        return $this;
    }

    /**
     * Customer name, to put in the Letter of Authorization as the party
     * authorized to request a crossconnect.
     *
     * Generated from protobuf field <code>optional string customer_name = 3665484;</code>
     * @return string
     */
    public function getCustomerName()
    {
        return isset($this->customer_name) ? $this->customer_name : '';
    }

    public function hasCustomerName()
    {
        return isset($this->customer_name);
    }

    public function clearCustomerName()
    {
        unset($this->customer_name);
    }

    /**
     * Customer name, to put in the Letter of Authorization as the party
     * authorized to request a crossconnect.
     *
     * Generated from protobuf field <code>optional string customer_name = 3665484;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomerName($var)
    {
        GPBUtil::checkString($var, True);
        $this->customer_name = $var;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you
     * create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * An optional description of this resource. Provide this property when you
     * create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * A zone-free location to use for all Interconnects created in this call,
     * like "iad-1234".
     *
     * Generated from protobuf field <code>optional string facility = 501116579;</code>
     * @return string
     */
    public function getFacility()
    {
        return isset($this->facility) ? $this->facility : '';
    }

    public function hasFacility()
    {
        return isset($this->facility);
    }

    public function clearFacility()
    {
        unset($this->facility);
    }

    /**
     * A zone-free location to use for all Interconnects created in this call,
     * like "iad-1234".
     *
     * Generated from protobuf field <code>optional string facility = 501116579;</code>
     * @param string $var
     * @return $this
     */
    public function setFacility($var)
    {
        GPBUtil::checkString($var, True);
        $this->facility = $var;

        return $this;
    }

    /**
     * Type of interconnect, which can take one of the following values:
     *    - PARTNER: A partner-managed interconnection shared between
     *    customers though a partner.
     *    - DEDICATED: A dedicated physical
     *    interconnection with the customer.
     *  Note that a value IT_PRIVATE
     * has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string interconnect_type = 515165259;</code>
     * @return string
     */
    public function getInterconnectType()
    {
        return isset($this->interconnect_type) ? $this->interconnect_type : '';
    }

    public function hasInterconnectType()
    {
        return isset($this->interconnect_type);
    }

    public function clearInterconnectType()
    {
        unset($this->interconnect_type);
    }

    /**
     * Type of interconnect, which can take one of the following values:
     *    - PARTNER: A partner-managed interconnection shared between
     *    customers though a partner.
     *    - DEDICATED: A dedicated physical
     *    interconnection with the customer.
     *  Note that a value IT_PRIVATE
     * has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string interconnect_type = 515165259;</code>
     * @param string $var
     * @return $this
     */
    public function setInterconnectType($var)
    {
        GPBUtil::checkString($var, True);
        $this->interconnect_type = $var;

        return $this;
    }

    /**
     * Type of link requested, which can take one of the following values:
     *    - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics
     *    - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics.
     *    - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4
     *    optics.
     *  Note that this field indicates the speed of each of the
     * links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string link_type = 523207775;</code>
     * @return string
     */
    public function getLinkType()
    {
        return isset($this->link_type) ? $this->link_type : '';
    }

    public function hasLinkType()
    {
        return isset($this->link_type);
    }

    public function clearLinkType()
    {
        unset($this->link_type);
    }

    /**
     * Type of link requested, which can take one of the following values:
     *    - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics
     *    - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics.
     *    - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4
     *    optics.
     *  Note that this field indicates the speed of each of the
     * links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string link_type = 523207775;</code>
     * @param string $var
     * @return $this
     */
    public function setLinkType($var)
    {
        GPBUtil::checkString($var, True);
        $this->link_type = $var;

        return $this;
    }

    /**
     * Name of the Interconnects to be created. This must be specified on the
     * template and/or on each individual interconnect. The name, if not empty,
     * must be 1-63 characters long, and comply with RFC1035.
     * Specifically, any nonempty name must be 1-63 characters long and match
     * the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must
     * be a dash, lowercase letter, or digit, except the last character, which
     * cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : '';
    }

    public function hasName()
    {
        return isset($this->name);
    }

    public function clearName()
    {
        unset($this->name);
    }

    /**
     * Name of the Interconnects to be created. This must be specified on the
     * template and/or on each individual interconnect. The name, if not empty,
     * must be 1-63 characters long, and comply with RFC1035.
     * Specifically, any nonempty name must be 1-63 characters long and match
     * the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must
     * be a dash, lowercase letter, or digit, except the last character, which
     * cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Email address to contact the customer NOC for operations and maintenance
     * notifications regarding this Interconnect. If specified, this will be
     * used for notifications in addition to all other forms described, such as
     * Cloud Monitoring logs alerting and Cloud Notifications. This field is
     * required for users who sign up for Cloud Interconnect using
     * workforce identity federation.
     *
     * Generated from protobuf field <code>optional string noc_contact_email = 14072832;</code>
     * @return string
     */
    public function getNocContactEmail()
    {
        return isset($this->noc_contact_email) ? $this->noc_contact_email : '';
    }

    public function hasNocContactEmail()
    {
        return isset($this->noc_contact_email);
    }

    public function clearNocContactEmail()
    {
        unset($this->noc_contact_email);
    }

    /**
     * Email address to contact the customer NOC for operations and maintenance
     * notifications regarding this Interconnect. If specified, this will be
     * used for notifications in addition to all other forms described, such as
     * Cloud Monitoring logs alerting and Cloud Notifications. This field is
     * required for users who sign up for Cloud Interconnect using
     * workforce identity federation.
     *
     * Generated from protobuf field <code>optional string noc_contact_email = 14072832;</code>
     * @param string $var
     * @return $this
     */
    public function setNocContactEmail($var)
    {
        GPBUtil::checkString($var, True);
        $this->noc_contact_email = $var;

        return $this;
    }

    /**
     * Indicates that this is a Cross-Cloud Interconnect. This field specifies
     * the location outside of Google's network that the interconnect is
     * connected to.
     *
     * Generated from protobuf field <code>optional string remote_location = 324388750;</code>
     * @return string
     */
    public function getRemoteLocation()
    {
        return isset($this->remote_location) ? $this->remote_location : '';
    }

    public function hasRemoteLocation()
    {
        return isset($this->remote_location);
    }

    public function clearRemoteLocation()
    {
        unset($this->remote_location);
    }

    /**
     * Indicates that this is a Cross-Cloud Interconnect. This field specifies
     * the location outside of Google's network that the interconnect is
     * connected to.
     *
     * Generated from protobuf field <code>optional string remote_location = 324388750;</code>
     * @param string $var
     * @return $this
     */
    public function setRemoteLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->remote_location = $var;

        return $this;
    }

    /**
     * Optional. List of features requested for this Interconnect connection,
     * which can take one of the following values:
     *    - IF_MACSEC: If specified, then the connection is created on MACsec
     *    capable hardware ports. If not specified, non-MACsec capable ports will
     *    also be considered.
     *    - IF_CROSS_SITE_NETWORK: If specified, then the connection is created
     *    exclusively for Cross-Site Networking. The connection can not be used for
     *    Cross-Site Networking unless this feature is specified.
     * Check the RequestedFeatures enum for the list of possible values.
     *
     * Generated from protobuf field <code>repeated string requested_features = 461240814;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRequestedFeatures()
    {
        return $this->requested_features;
    }

    /**
     * Optional. List of features requested for this Interconnect connection,
     * which can take one of the following values:
     *    - IF_MACSEC: If specified, then the connection is created on MACsec
     *    capable hardware ports. If not specified, non-MACsec capable ports will
     *    also be considered.
     *    - IF_CROSS_SITE_NETWORK: If specified, then the connection is created
     *    exclusively for Cross-Site Networking. The connection can not be used for
     *    Cross-Site Networking unless this feature is specified.
     * Check the RequestedFeatures enum for the list of possible values.
     *
     * Generated from protobuf field <code>repeated string requested_features = 461240814;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRequestedFeatures($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->requested_features = $arr;

        return $this;
    }

    /**
     * Target number of physical links in the link bundle, as requested by the
     * customer.
     *
     * Generated from protobuf field <code>optional int32 requested_link_count = 45051387;</code>
     * @return int
     */
    public function getRequestedLinkCount()
    {
        return isset($this->requested_link_count) ? $this->requested_link_count : 0;
    }

    public function hasRequestedLinkCount()
    {
        return isset($this->requested_link_count);
    }

    public function clearRequestedLinkCount()
    {
        unset($this->requested_link_count);
    }

    /**
     * Target number of physical links in the link bundle, as requested by the
     * customer.
     *
     * Generated from protobuf field <code>optional int32 requested_link_count = 45051387;</code>
     * @param int $var
     * @return $this
     */
    public function setRequestedLinkCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->requested_link_count = $var;

        return $this;
    }

}

