<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/capacityplanner/v1beta/usage_service.proto

namespace Google\Cloud\CapacityPlanner\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The `QueryReservations` request.
 *
 * Generated from protobuf message <code>google.cloud.capacityplanner.v1beta.QueryReservationsRequest</code>
 */
class QueryReservationsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The compute engine resource and location for the time series
     * values to return. The format is:
     * projects/{project}/locations/{location} or
     * organizations/{organization}/locations/{location} or
     * folders/{folder}/locations/{location}
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Optional. The location level of the reservations usage timeseries.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.TimeSeries.LocationType location_level = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $location_level = 0;
    /**
     * Optional. The machine family to use to select the aggregate reserved values
     * to return. Possible values include "n1", and "n2d" etc. Empty
     * machine_family will return results matching all machine families.
     *
     * Generated from protobuf field <code>string machine_family = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $machine_family = '';
    /**
     * Optional. The machine_shape as a filter to select matching reservations.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.MachineShape machine_shape = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $machine_shape = null;
    /**
     * Optional. The GPU type for the reserved values to return. Sample values
     * are "nvidia-tesla-t4", and "nvidia-tesla-a100". See
     * https://cloud.google.com/compute/docs/gpus for a list. Empty gpu_type
     * will return results matching all GPUs.
     *
     * Generated from protobuf field <code>string gpu_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $gpu_type = '';
    /**
     * Required. The resource for the reserved values to return. Possible values
     * include "gce-vcpus", "gce-ram", "gce-local-ssd", "gce-gpu" and "gce-vm".
     *
     * Generated from protobuf field <code>string cloud_resource_type = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $cloud_resource_type = '';
    /**
     * Required. The Reservation type for example, future reservation request and
     * allocation. If unspecified, all types are
     * included.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.QueryReservationsRequest.ReservationType reservation_type = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $reservation_type = 0;
    /**
     * Optional. Types of share settings to filter reservations in response. If
     * unspecified, all types are included.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.QueryReservationsRequest.ShareType share_type = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $share_type = 0;
    /**
     * Optional. Types of ownerships to filter reservations based on.
     * In case of OWNED, it filters reservations which are owned by selected
     * parent project/folder/organization. If unspecified, all types are
     * included.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.QueryReservationsRequest.OwnershipType ownership_type = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $ownership_type = 0;
    /**
     * Required. Reservations output data format.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.QueryReservationsRequest.ReservationDataLevel reservation_data_level = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $reservation_data_level = 0;
    /**
     * Optional. Whether to include pending for approval reservations in the
     * response. This field is only applicable for future reservations.
     *
     * Generated from protobuf field <code>bool include_unapproved_reservations = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $include_unapproved_reservations = false;
    /**
     * Optional. Aggregation Method of the historical reservation usage
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.UsageHistory.AggregationMethod aggregation_method = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $aggregation_method = 0;
    /**
     * Optional. The start date of reservations usage.
     *
     * Generated from protobuf field <code>.google.type.Date start_date = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $start_date = null;
    /**
     * Optional. The end date of reservations usage.
     *
     * Generated from protobuf field <code>.google.type.Date end_date = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $end_date = null;

    /**
     * @param string $parent Required. The compute engine resource and location for the time series
     *                       values to return. The format is:
     *
     *                       projects/{project}/locations/{location} or
     *                       organizations/{organization}/locations/{location} or
     *                       folders/{folder}/locations/{location}
     *                       Please see {@see UsageServiceClient::locationName()} for help formatting this field.
     *
     * @return \Google\Cloud\CapacityPlanner\V1beta\QueryReservationsRequest
     *
     * @experimental
     */
    public static function build(string $parent): self
    {
        return (new self())
            ->setParent($parent);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The compute engine resource and location for the time series
     *           values to return. The format is:
     *           projects/{project}/locations/{location} or
     *           organizations/{organization}/locations/{location} or
     *           folders/{folder}/locations/{location}
     *     @type int $location_level
     *           Optional. The location level of the reservations usage timeseries.
     *     @type string $machine_family
     *           Optional. The machine family to use to select the aggregate reserved values
     *           to return. Possible values include "n1", and "n2d" etc. Empty
     *           machine_family will return results matching all machine families.
     *     @type \Google\Cloud\CapacityPlanner\V1beta\MachineShape $machine_shape
     *           Optional. The machine_shape as a filter to select matching reservations.
     *     @type string $gpu_type
     *           Optional. The GPU type for the reserved values to return. Sample values
     *           are "nvidia-tesla-t4", and "nvidia-tesla-a100". See
     *           https://cloud.google.com/compute/docs/gpus for a list. Empty gpu_type
     *           will return results matching all GPUs.
     *     @type string $cloud_resource_type
     *           Required. The resource for the reserved values to return. Possible values
     *           include "gce-vcpus", "gce-ram", "gce-local-ssd", "gce-gpu" and "gce-vm".
     *     @type int $reservation_type
     *           Required. The Reservation type for example, future reservation request and
     *           allocation. If unspecified, all types are
     *           included.
     *     @type int $share_type
     *           Optional. Types of share settings to filter reservations in response. If
     *           unspecified, all types are included.
     *     @type int $ownership_type
     *           Optional. Types of ownerships to filter reservations based on.
     *           In case of OWNED, it filters reservations which are owned by selected
     *           parent project/folder/organization. If unspecified, all types are
     *           included.
     *     @type int $reservation_data_level
     *           Required. Reservations output data format.
     *     @type bool $include_unapproved_reservations
     *           Optional. Whether to include pending for approval reservations in the
     *           response. This field is only applicable for future reservations.
     *     @type int $aggregation_method
     *           Optional. Aggregation Method of the historical reservation usage
     *     @type \Google\Type\Date $start_date
     *           Optional. The start date of reservations usage.
     *     @type \Google\Type\Date $end_date
     *           Optional. The end date of reservations usage.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Capacityplanner\V1Beta\UsageService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The compute engine resource and location for the time series
     * values to return. The format is:
     * projects/{project}/locations/{location} or
     * organizations/{organization}/locations/{location} or
     * folders/{folder}/locations/{location}
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The compute engine resource and location for the time series
     * values to return. The format is:
     * projects/{project}/locations/{location} or
     * organizations/{organization}/locations/{location} or
     * folders/{folder}/locations/{location}
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Optional. The location level of the reservations usage timeseries.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.TimeSeries.LocationType location_level = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getLocationLevel()
    {
        return $this->location_level;
    }

    /**
     * Optional. The location level of the reservations usage timeseries.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.TimeSeries.LocationType location_level = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setLocationLevel($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CapacityPlanner\V1beta\TimeSeries\LocationType::class);
        $this->location_level = $var;

        return $this;
    }

    /**
     * Optional. The machine family to use to select the aggregate reserved values
     * to return. Possible values include "n1", and "n2d" etc. Empty
     * machine_family will return results matching all machine families.
     *
     * Generated from protobuf field <code>string machine_family = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getMachineFamily()
    {
        return $this->machine_family;
    }

    /**
     * Optional. The machine family to use to select the aggregate reserved values
     * to return. Possible values include "n1", and "n2d" etc. Empty
     * machine_family will return results matching all machine families.
     *
     * Generated from protobuf field <code>string machine_family = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setMachineFamily($var)
    {
        GPBUtil::checkString($var, True);
        $this->machine_family = $var;

        return $this;
    }

    /**
     * Optional. The machine_shape as a filter to select matching reservations.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.MachineShape machine_shape = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\CapacityPlanner\V1beta\MachineShape|null
     */
    public function getMachineShape()
    {
        return $this->machine_shape;
    }

    public function hasMachineShape()
    {
        return isset($this->machine_shape);
    }

    public function clearMachineShape()
    {
        unset($this->machine_shape);
    }

    /**
     * Optional. The machine_shape as a filter to select matching reservations.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.MachineShape machine_shape = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\CapacityPlanner\V1beta\MachineShape $var
     * @return $this
     */
    public function setMachineShape($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CapacityPlanner\V1beta\MachineShape::class);
        $this->machine_shape = $var;

        return $this;
    }

    /**
     * Optional. The GPU type for the reserved values to return. Sample values
     * are "nvidia-tesla-t4", and "nvidia-tesla-a100". See
     * https://cloud.google.com/compute/docs/gpus for a list. Empty gpu_type
     * will return results matching all GPUs.
     *
     * Generated from protobuf field <code>string gpu_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getGpuType()
    {
        return $this->gpu_type;
    }

    /**
     * Optional. The GPU type for the reserved values to return. Sample values
     * are "nvidia-tesla-t4", and "nvidia-tesla-a100". See
     * https://cloud.google.com/compute/docs/gpus for a list. Empty gpu_type
     * will return results matching all GPUs.
     *
     * Generated from protobuf field <code>string gpu_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setGpuType($var)
    {
        GPBUtil::checkString($var, True);
        $this->gpu_type = $var;

        return $this;
    }

    /**
     * Required. The resource for the reserved values to return. Possible values
     * include "gce-vcpus", "gce-ram", "gce-local-ssd", "gce-gpu" and "gce-vm".
     *
     * Generated from protobuf field <code>string cloud_resource_type = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getCloudResourceType()
    {
        return $this->cloud_resource_type;
    }

    /**
     * Required. The resource for the reserved values to return. Possible values
     * include "gce-vcpus", "gce-ram", "gce-local-ssd", "gce-gpu" and "gce-vm".
     *
     * Generated from protobuf field <code>string cloud_resource_type = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setCloudResourceType($var)
    {
        GPBUtil::checkString($var, True);
        $this->cloud_resource_type = $var;

        return $this;
    }

    /**
     * Required. The Reservation type for example, future reservation request and
     * allocation. If unspecified, all types are
     * included.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.QueryReservationsRequest.ReservationType reservation_type = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getReservationType()
    {
        return $this->reservation_type;
    }

    /**
     * Required. The Reservation type for example, future reservation request and
     * allocation. If unspecified, all types are
     * included.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.QueryReservationsRequest.ReservationType reservation_type = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setReservationType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CapacityPlanner\V1beta\QueryReservationsRequest\ReservationType::class);
        $this->reservation_type = $var;

        return $this;
    }

    /**
     * Optional. Types of share settings to filter reservations in response. If
     * unspecified, all types are included.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.QueryReservationsRequest.ShareType share_type = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getShareType()
    {
        return $this->share_type;
    }

    /**
     * Optional. Types of share settings to filter reservations in response. If
     * unspecified, all types are included.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.QueryReservationsRequest.ShareType share_type = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setShareType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CapacityPlanner\V1beta\QueryReservationsRequest\ShareType::class);
        $this->share_type = $var;

        return $this;
    }

    /**
     * Optional. Types of ownerships to filter reservations based on.
     * In case of OWNED, it filters reservations which are owned by selected
     * parent project/folder/organization. If unspecified, all types are
     * included.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.QueryReservationsRequest.OwnershipType ownership_type = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getOwnershipType()
    {
        return $this->ownership_type;
    }

    /**
     * Optional. Types of ownerships to filter reservations based on.
     * In case of OWNED, it filters reservations which are owned by selected
     * parent project/folder/organization. If unspecified, all types are
     * included.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.QueryReservationsRequest.OwnershipType ownership_type = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setOwnershipType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CapacityPlanner\V1beta\QueryReservationsRequest\OwnershipType::class);
        $this->ownership_type = $var;

        return $this;
    }

    /**
     * Required. Reservations output data format.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.QueryReservationsRequest.ReservationDataLevel reservation_data_level = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getReservationDataLevel()
    {
        return $this->reservation_data_level;
    }

    /**
     * Required. Reservations output data format.
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.QueryReservationsRequest.ReservationDataLevel reservation_data_level = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setReservationDataLevel($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CapacityPlanner\V1beta\QueryReservationsRequest\ReservationDataLevel::class);
        $this->reservation_data_level = $var;

        return $this;
    }

    /**
     * Optional. Whether to include pending for approval reservations in the
     * response. This field is only applicable for future reservations.
     *
     * Generated from protobuf field <code>bool include_unapproved_reservations = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getIncludeUnapprovedReservations()
    {
        return $this->include_unapproved_reservations;
    }

    /**
     * Optional. Whether to include pending for approval reservations in the
     * response. This field is only applicable for future reservations.
     *
     * Generated from protobuf field <code>bool include_unapproved_reservations = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setIncludeUnapprovedReservations($var)
    {
        GPBUtil::checkBool($var);
        $this->include_unapproved_reservations = $var;

        return $this;
    }

    /**
     * Optional. Aggregation Method of the historical reservation usage
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.UsageHistory.AggregationMethod aggregation_method = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getAggregationMethod()
    {
        return $this->aggregation_method;
    }

    /**
     * Optional. Aggregation Method of the historical reservation usage
     *
     * Generated from protobuf field <code>.google.cloud.capacityplanner.v1beta.UsageHistory.AggregationMethod aggregation_method = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setAggregationMethod($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CapacityPlanner\V1beta\UsageHistory\AggregationMethod::class);
        $this->aggregation_method = $var;

        return $this;
    }

    /**
     * Optional. The start date of reservations usage.
     *
     * Generated from protobuf field <code>.google.type.Date start_date = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Type\Date|null
     */
    public function getStartDate()
    {
        return $this->start_date;
    }

    public function hasStartDate()
    {
        return isset($this->start_date);
    }

    public function clearStartDate()
    {
        unset($this->start_date);
    }

    /**
     * Optional. The start date of reservations usage.
     *
     * Generated from protobuf field <code>.google.type.Date start_date = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Type\Date $var
     * @return $this
     */
    public function setStartDate($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Date::class);
        $this->start_date = $var;

        return $this;
    }

    /**
     * Optional. The end date of reservations usage.
     *
     * Generated from protobuf field <code>.google.type.Date end_date = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Type\Date|null
     */
    public function getEndDate()
    {
        return $this->end_date;
    }

    public function hasEndDate()
    {
        return isset($this->end_date);
    }

    public function clearEndDate()
    {
        unset($this->end_date);
    }

    /**
     * Optional. The end date of reservations usage.
     *
     * Generated from protobuf field <code>.google.type.Date end_date = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Type\Date $var
     * @return $this
     */
    public function setEndDate($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Date::class);
        $this->end_date = $var;

        return $this;
    }

}

