<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/bigtable/admin/v2/bigtable_table_admin.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Bigtable\Admin\V2\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\InsecureCredentialsWrapper;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Bigtable\Admin\V2\AuthorizedView;
use Google\Cloud\Bigtable\Admin\V2\Backup;
use Google\Cloud\Bigtable\Admin\V2\CheckConsistencyRequest;
use Google\Cloud\Bigtable\Admin\V2\CheckConsistencyResponse;
use Google\Cloud\Bigtable\Admin\V2\CopyBackupRequest;
use Google\Cloud\Bigtable\Admin\V2\CreateAuthorizedViewRequest;
use Google\Cloud\Bigtable\Admin\V2\CreateBackupMetadata;
use Google\Cloud\Bigtable\Admin\V2\CreateBackupRequest;
use Google\Cloud\Bigtable\Admin\V2\CreateSchemaBundleRequest;
use Google\Cloud\Bigtable\Admin\V2\CreateTableFromSnapshotRequest;
use Google\Cloud\Bigtable\Admin\V2\CreateTableRequest;
use Google\Cloud\Bigtable\Admin\V2\DeleteAuthorizedViewRequest;
use Google\Cloud\Bigtable\Admin\V2\DeleteBackupRequest;
use Google\Cloud\Bigtable\Admin\V2\DeleteSchemaBundleRequest;
use Google\Cloud\Bigtable\Admin\V2\DeleteSnapshotRequest;
use Google\Cloud\Bigtable\Admin\V2\DeleteTableRequest;
use Google\Cloud\Bigtable\Admin\V2\DropRowRangeRequest;
use Google\Cloud\Bigtable\Admin\V2\GenerateConsistencyTokenRequest;
use Google\Cloud\Bigtable\Admin\V2\GenerateConsistencyTokenResponse;
use Google\Cloud\Bigtable\Admin\V2\GetAuthorizedViewRequest;
use Google\Cloud\Bigtable\Admin\V2\GetBackupRequest;
use Google\Cloud\Bigtable\Admin\V2\GetSchemaBundleRequest;
use Google\Cloud\Bigtable\Admin\V2\GetSnapshotRequest;
use Google\Cloud\Bigtable\Admin\V2\GetTableRequest;
use Google\Cloud\Bigtable\Admin\V2\ListAuthorizedViewsRequest;
use Google\Cloud\Bigtable\Admin\V2\ListBackupsRequest;
use Google\Cloud\Bigtable\Admin\V2\ListSchemaBundlesRequest;
use Google\Cloud\Bigtable\Admin\V2\ListSnapshotsRequest;
use Google\Cloud\Bigtable\Admin\V2\ListTablesRequest;
use Google\Cloud\Bigtable\Admin\V2\ModifyColumnFamiliesRequest;
use Google\Cloud\Bigtable\Admin\V2\RestoreTableMetadata;
use Google\Cloud\Bigtable\Admin\V2\RestoreTableRequest;
use Google\Cloud\Bigtable\Admin\V2\SchemaBundle;
use Google\Cloud\Bigtable\Admin\V2\Snapshot;
use Google\Cloud\Bigtable\Admin\V2\SnapshotTableRequest;
use Google\Cloud\Bigtable\Admin\V2\Table;
use Google\Cloud\Bigtable\Admin\V2\UndeleteTableRequest;
use Google\Cloud\Bigtable\Admin\V2\UpdateAuthorizedViewRequest;
use Google\Cloud\Bigtable\Admin\V2\UpdateBackupRequest;
use Google\Cloud\Bigtable\Admin\V2\UpdateSchemaBundleRequest;
use Google\Cloud\Bigtable\Admin\V2\UpdateTableRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use Grpc\ChannelCredentials;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Service for creating, configuring, and deleting Cloud Bigtable tables.
 *
 *
 * Provides access to the table schemas only, not the data stored within
 * the tables.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<CheckConsistencyResponse> checkConsistencyAsync(CheckConsistencyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> copyBackupAsync(CopyBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createAuthorizedViewAsync(CreateAuthorizedViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createBackupAsync(CreateBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createSchemaBundleAsync(CreateSchemaBundleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Table> createTableAsync(CreateTableRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createTableFromSnapshotAsync(CreateTableFromSnapshotRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteAuthorizedViewAsync(DeleteAuthorizedViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteBackupAsync(DeleteBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteSchemaBundleAsync(DeleteSchemaBundleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteSnapshotAsync(DeleteSnapshotRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteTableAsync(DeleteTableRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> dropRowRangeAsync(DropRowRangeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<GenerateConsistencyTokenResponse> generateConsistencyTokenAsync(GenerateConsistencyTokenRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AuthorizedView> getAuthorizedViewAsync(GetAuthorizedViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Backup> getBackupAsync(GetBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SchemaBundle> getSchemaBundleAsync(GetSchemaBundleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Snapshot> getSnapshotAsync(GetSnapshotRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Table> getTableAsync(GetTableRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAuthorizedViewsAsync(ListAuthorizedViewsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listBackupsAsync(ListBackupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSchemaBundlesAsync(ListSchemaBundlesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSnapshotsAsync(ListSnapshotsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTablesAsync(ListTablesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Table> modifyColumnFamiliesAsync(ModifyColumnFamiliesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> restoreTableAsync(RestoreTableRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> snapshotTableAsync(SnapshotTableRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> undeleteTableAsync(UndeleteTableRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateAuthorizedViewAsync(UpdateAuthorizedViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Backup> updateBackupAsync(UpdateBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateSchemaBundleAsync(UpdateSchemaBundleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateTableAsync(UpdateTableRequest $request, array $optionalArgs = [])
 */
final class BigtableTableAdminClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.bigtable.admin.v2.BigtableTableAdmin';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'bigtableadmin.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'bigtableadmin.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/bigtable.admin',
        'https://www.googleapis.com/auth/bigtable.admin.table',
        'https://www.googleapis.com/auth/cloud-bigtable.admin',
        'https://www.googleapis.com/auth/cloud-bigtable.admin.table',
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/cloud-platform.read-only',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/bigtable_table_admin_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/bigtable_table_admin_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/bigtable_table_admin_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/bigtable_table_admin_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * authorized_view resource.
     *
     * @param string $project
     * @param string $instance
     * @param string $table
     * @param string $authorizedView
     *
     * @return string The formatted authorized_view resource.
     */
    public static function authorizedViewName(string $project, string $instance, string $table, string $authorizedView): string
    {
        return self::getPathTemplate('authorizedView')->render([
            'project' => $project,
            'instance' => $instance,
            'table' => $table,
            'authorized_view' => $authorizedView,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup
     * resource.
     *
     * @param string $project
     * @param string $instance
     * @param string $cluster
     * @param string $backup
     *
     * @return string The formatted backup resource.
     */
    public static function backupName(string $project, string $instance, string $cluster, string $backup): string
    {
        return self::getPathTemplate('backup')->render([
            'project' => $project,
            'instance' => $instance,
            'cluster' => $cluster,
            'backup' => $backup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cluster
     * resource.
     *
     * @param string $project
     * @param string $instance
     * @param string $cluster
     *
     * @return string The formatted cluster resource.
     */
    public static function clusterName(string $project, string $instance, string $cluster): string
    {
        return self::getPathTemplate('cluster')->render([
            'project' => $project,
            'instance' => $instance,
            'cluster' => $cluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * crypto_key_version resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     * @param string $cryptoKeyVersion
     *
     * @return string The formatted crypto_key_version resource.
     */
    public static function cryptoKeyVersionName(string $project, string $location, string $keyRing, string $cryptoKey, string $cryptoKeyVersion): string
    {
        return self::getPathTemplate('cryptoKeyVersion')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
            'crypto_key_version' => $cryptoKeyVersion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName(string $project, string $instance): string
    {
        return self::getPathTemplate('instance')->render([
            'project' => $project,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * schema_bundle resource.
     *
     * @param string $project
     * @param string $instance
     * @param string $table
     * @param string $schemaBundle
     *
     * @return string The formatted schema_bundle resource.
     */
    public static function schemaBundleName(string $project, string $instance, string $table, string $schemaBundle): string
    {
        return self::getPathTemplate('schemaBundle')->render([
            'project' => $project,
            'instance' => $instance,
            'table' => $table,
            'schema_bundle' => $schemaBundle,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a snapshot
     * resource.
     *
     * @param string $project
     * @param string $instance
     * @param string $cluster
     * @param string $snapshot
     *
     * @return string The formatted snapshot resource.
     */
    public static function snapshotName(string $project, string $instance, string $cluster, string $snapshot): string
    {
        return self::getPathTemplate('snapshot')->render([
            'project' => $project,
            'instance' => $instance,
            'cluster' => $cluster,
            'snapshot' => $snapshot,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a table
     * resource.
     *
     * @param string $project
     * @param string $instance
     * @param string $table
     *
     * @return string The formatted table resource.
     */
    public static function tableName(string $project, string $instance, string $table): string
    {
        return self::getPathTemplate('table')->render([
            'project' => $project,
            'instance' => $instance,
            'table' => $table,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - authorizedView: projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}
     * - backup: projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup}
     * - cluster: projects/{project}/instances/{instance}/clusters/{cluster}
     * - cryptoKeyVersion: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}
     * - instance: projects/{project}/instances/{instance}
     * - schemaBundle: projects/{project}/instances/{instance}/tables/{table}/schemaBundles/{schema_bundle}
     * - snapshot: projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}
     * - table: projects/{project}/instances/{instance}/tables/{table}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * Setting the "BIGTABLE_EMULATOR_HOST" environment variable will automatically set
     * the API Endpoint to the value specified in the variable, as well as ensure that
     * empty credentials are used in the transport layer.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'bigtableadmin.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Bigtable\Admin\V2\BigtableTableAdminClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new BigtableTableAdminClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $options = $this->setDefaultEmulatorConfig($options);
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Checks replication consistency based on a consistency token, that is, if
     * replication has caught up based on the conditions specified in the token
     * and the check request.
     *
     * The async variant is {@see BigtableTableAdminClient::checkConsistencyAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/check_consistency.php
     *
     * @param CheckConsistencyRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CheckConsistencyResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function checkConsistency(CheckConsistencyRequest $request, array $callOptions = []): CheckConsistencyResponse
    {
        return $this->startApiCall('CheckConsistency', $request, $callOptions)->wait();
    }

    /**
     * Copy a Cloud Bigtable backup to a new backup in the destination cluster
     * located in the destination instance and project.
     *
     * The async variant is {@see BigtableTableAdminClient::copyBackupAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/copy_backup.php
     *
     * @param CopyBackupRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Backup>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function copyBackup(CopyBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CopyBackup', $request, $callOptions)->wait();
    }

    /**
     * Creates a new AuthorizedView in a table.
     *
     * The async variant is
     * {@see BigtableTableAdminClient::createAuthorizedViewAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/create_authorized_view.php
     *
     * @param CreateAuthorizedViewRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<AuthorizedView>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAuthorizedView(CreateAuthorizedViewRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateAuthorizedView', $request, $callOptions)->wait();
    }

    /**
     * Starts creating a new Cloud Bigtable Backup.  The returned backup
     * [long-running operation][google.longrunning.Operation] can be used to
     * track creation of the backup. The
     * [metadata][google.longrunning.Operation.metadata] field type is
     * [CreateBackupMetadata][google.bigtable.admin.v2.CreateBackupMetadata]. The
     * [response][google.longrunning.Operation.response] field type is
     * [Backup][google.bigtable.admin.v2.Backup], if successful. Cancelling the
     * returned operation will stop the creation and delete the backup.
     *
     * The async variant is {@see BigtableTableAdminClient::createBackupAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/create_backup.php
     *
     * @param CreateBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Backup>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBackup(CreateBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateBackup', $request, $callOptions)->wait();
    }

    /**
     * Creates a new schema bundle in the specified table.
     *
     * The async variant is {@see BigtableTableAdminClient::createSchemaBundleAsync()}
     * .
     *
     * @example samples/V2/BigtableTableAdminClient/create_schema_bundle.php
     *
     * @param CreateSchemaBundleRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<SchemaBundle>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSchemaBundle(CreateSchemaBundleRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateSchemaBundle', $request, $callOptions)->wait();
    }

    /**
     * Creates a new table in the specified instance.
     * The table can be created with a full set of initial column families,
     * specified in the request.
     *
     * The async variant is {@see BigtableTableAdminClient::createTableAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/create_table.php
     *
     * @param CreateTableRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Table
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTable(CreateTableRequest $request, array $callOptions = []): Table
    {
        return $this->startApiCall('CreateTable', $request, $callOptions)->wait();
    }

    /**
     * Creates a new table from the specified snapshot. The target table must
     * not exist. The snapshot and the table must be in the same instance.
     *
     * Note: This is a private alpha release of Cloud Bigtable snapshots. This
     * feature is not currently available to most Cloud Bigtable customers. This
     * feature might be changed in backward-incompatible ways and is not
     * recommended for production use. It is not subject to any SLA or deprecation
     * policy.
     *
     * The async variant is
     * {@see BigtableTableAdminClient::createTableFromSnapshotAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/create_table_from_snapshot.php
     *
     * @param CreateTableFromSnapshotRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Table>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTableFromSnapshot(CreateTableFromSnapshotRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateTableFromSnapshot', $request, $callOptions)->wait();
    }

    /**
     * Permanently deletes a specified AuthorizedView.
     *
     * The async variant is
     * {@see BigtableTableAdminClient::deleteAuthorizedViewAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/delete_authorized_view.php
     *
     * @param DeleteAuthorizedViewRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAuthorizedView(DeleteAuthorizedViewRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAuthorizedView', $request, $callOptions)->wait();
    }

    /**
     * Deletes a pending or completed Cloud Bigtable backup.
     *
     * The async variant is {@see BigtableTableAdminClient::deleteBackupAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/delete_backup.php
     *
     * @param DeleteBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBackup(DeleteBackupRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteBackup', $request, $callOptions)->wait();
    }

    /**
     * Deletes a schema bundle in the specified table.
     *
     * The async variant is {@see BigtableTableAdminClient::deleteSchemaBundleAsync()}
     * .
     *
     * @example samples/V2/BigtableTableAdminClient/delete_schema_bundle.php
     *
     * @param DeleteSchemaBundleRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSchemaBundle(DeleteSchemaBundleRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteSchemaBundle', $request, $callOptions)->wait();
    }

    /**
     * Permanently deletes the specified snapshot.
     *
     * Note: This is a private alpha release of Cloud Bigtable snapshots. This
     * feature is not currently available to most Cloud Bigtable customers. This
     * feature might be changed in backward-incompatible ways and is not
     * recommended for production use. It is not subject to any SLA or deprecation
     * policy.
     *
     * The async variant is {@see BigtableTableAdminClient::deleteSnapshotAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/delete_snapshot.php
     *
     * @param DeleteSnapshotRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSnapshot(DeleteSnapshotRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteSnapshot', $request, $callOptions)->wait();
    }

    /**
     * Permanently deletes a specified table and all of its data.
     *
     * The async variant is {@see BigtableTableAdminClient::deleteTableAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/delete_table.php
     *
     * @param DeleteTableRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTable(DeleteTableRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteTable', $request, $callOptions)->wait();
    }

    /**
     * Permanently drop/delete a row range from a specified table. The request can
     * specify whether to delete all rows in a table, or only those that match a
     * particular prefix.
     *
     * The async variant is {@see BigtableTableAdminClient::dropRowRangeAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/drop_row_range.php
     *
     * @param DropRowRangeRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function dropRowRange(DropRowRangeRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DropRowRange', $request, $callOptions)->wait();
    }

    /**
     * Generates a consistency token for a Table, which can be used in
     * CheckConsistency to check whether mutations to the table that finished
     * before this call started have been replicated. The tokens will be available
     * for 90 days.
     *
     * The async variant is
     * {@see BigtableTableAdminClient::generateConsistencyTokenAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/generate_consistency_token.php
     *
     * @param GenerateConsistencyTokenRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GenerateConsistencyTokenResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function generateConsistencyToken(GenerateConsistencyTokenRequest $request, array $callOptions = []): GenerateConsistencyTokenResponse
    {
        return $this->startApiCall('GenerateConsistencyToken', $request, $callOptions)->wait();
    }

    /**
     * Gets information from a specified AuthorizedView.
     *
     * The async variant is {@see BigtableTableAdminClient::getAuthorizedViewAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/get_authorized_view.php
     *
     * @param GetAuthorizedViewRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AuthorizedView
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAuthorizedView(GetAuthorizedViewRequest $request, array $callOptions = []): AuthorizedView
    {
        return $this->startApiCall('GetAuthorizedView', $request, $callOptions)->wait();
    }

    /**
     * Gets metadata on a pending or completed Cloud Bigtable Backup.
     *
     * The async variant is {@see BigtableTableAdminClient::getBackupAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/get_backup.php
     *
     * @param GetBackupRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Backup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBackup(GetBackupRequest $request, array $callOptions = []): Backup
    {
        return $this->startApiCall('GetBackup', $request, $callOptions)->wait();
    }

    /**
     * Gets the access control policy for a Bigtable resource.
     * Returns an empty policy if the resource exists but does not have a policy
     * set.
     *
     * The async variant is {@see BigtableTableAdminClient::getIamPolicyAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets metadata information about the specified schema bundle.
     *
     * The async variant is {@see BigtableTableAdminClient::getSchemaBundleAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/get_schema_bundle.php
     *
     * @param GetSchemaBundleRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SchemaBundle
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSchemaBundle(GetSchemaBundleRequest $request, array $callOptions = []): SchemaBundle
    {
        return $this->startApiCall('GetSchemaBundle', $request, $callOptions)->wait();
    }

    /**
     * Gets metadata information about the specified snapshot.
     *
     * Note: This is a private alpha release of Cloud Bigtable snapshots. This
     * feature is not currently available to most Cloud Bigtable customers. This
     * feature might be changed in backward-incompatible ways and is not
     * recommended for production use. It is not subject to any SLA or deprecation
     * policy.
     *
     * The async variant is {@see BigtableTableAdminClient::getSnapshotAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/get_snapshot.php
     *
     * @param GetSnapshotRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Snapshot
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSnapshot(GetSnapshotRequest $request, array $callOptions = []): Snapshot
    {
        return $this->startApiCall('GetSnapshot', $request, $callOptions)->wait();
    }

    /**
     * Gets metadata information about the specified table.
     *
     * The async variant is {@see BigtableTableAdminClient::getTableAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/get_table.php
     *
     * @param GetTableRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Table
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTable(GetTableRequest $request, array $callOptions = []): Table
    {
        return $this->startApiCall('GetTable', $request, $callOptions)->wait();
    }

    /**
     * Lists all AuthorizedViews from a specific table.
     *
     * The async variant is {@see BigtableTableAdminClient::listAuthorizedViewsAsync()}
     * .
     *
     * @example samples/V2/BigtableTableAdminClient/list_authorized_views.php
     *
     * @param ListAuthorizedViewsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAuthorizedViews(ListAuthorizedViewsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAuthorizedViews', $request, $callOptions);
    }

    /**
     * Lists Cloud Bigtable backups. Returns both completed and pending
     * backups.
     *
     * The async variant is {@see BigtableTableAdminClient::listBackupsAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/list_backups.php
     *
     * @param ListBackupsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackups(ListBackupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBackups', $request, $callOptions);
    }

    /**
     * Lists all schema bundles associated with the specified table.
     *
     * The async variant is {@see BigtableTableAdminClient::listSchemaBundlesAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/list_schema_bundles.php
     *
     * @param ListSchemaBundlesRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSchemaBundles(ListSchemaBundlesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSchemaBundles', $request, $callOptions);
    }

    /**
     * Lists all snapshots associated with the specified cluster.
     *
     * Note: This is a private alpha release of Cloud Bigtable snapshots. This
     * feature is not currently available to most Cloud Bigtable customers. This
     * feature might be changed in backward-incompatible ways and is not
     * recommended for production use. It is not subject to any SLA or deprecation
     * policy.
     *
     * The async variant is {@see BigtableTableAdminClient::listSnapshotsAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/list_snapshots.php
     *
     * @param ListSnapshotsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSnapshots(ListSnapshotsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSnapshots', $request, $callOptions);
    }

    /**
     * Lists all tables served from a specified instance.
     *
     * The async variant is {@see BigtableTableAdminClient::listTablesAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/list_tables.php
     *
     * @param ListTablesRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTables(ListTablesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTables', $request, $callOptions);
    }

    /**
     * Performs a series of column family modifications on the specified table.
     * Either all or none of the modifications will occur before this method
     * returns, but data requests received prior to that point may see a table
     * where only some modifications have taken effect.
     *
     * The async variant is
     * {@see BigtableTableAdminClient::modifyColumnFamiliesAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/modify_column_families.php
     *
     * @param ModifyColumnFamiliesRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Table
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function modifyColumnFamilies(ModifyColumnFamiliesRequest $request, array $callOptions = []): Table
    {
        return $this->startApiCall('ModifyColumnFamilies', $request, $callOptions)->wait();
    }

    /**
     * Create a new table by restoring from a completed backup.  The
     * returned table [long-running operation][google.longrunning.Operation] can
     * be used to track the progress of the operation, and to cancel it.  The
     * [metadata][google.longrunning.Operation.metadata] field type is
     * [RestoreTableMetadata][google.bigtable.admin.v2.RestoreTableMetadata].  The
     * [response][google.longrunning.Operation.response] type is
     * [Table][google.bigtable.admin.v2.Table], if successful.
     *
     * The async variant is {@see BigtableTableAdminClient::restoreTableAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/restore_table.php
     *
     * @param RestoreTableRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Table>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function restoreTable(RestoreTableRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RestoreTable', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on a Bigtable resource.
     * Replaces any existing policy.
     *
     * The async variant is {@see BigtableTableAdminClient::setIamPolicyAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Creates a new snapshot in the specified cluster from the specified
     * source table. The cluster and the table must be in the same instance.
     *
     * Note: This is a private alpha release of Cloud Bigtable snapshots. This
     * feature is not currently available to most Cloud Bigtable customers. This
     * feature might be changed in backward-incompatible ways and is not
     * recommended for production use. It is not subject to any SLA or deprecation
     * policy.
     *
     * The async variant is {@see BigtableTableAdminClient::snapshotTableAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/snapshot_table.php
     *
     * @param SnapshotTableRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Snapshot>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function snapshotTable(SnapshotTableRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SnapshotTable', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that the caller has on the specified Bigtable
     * resource.
     *
     * The async variant is {@see BigtableTableAdminClient::testIamPermissionsAsync()}
     * .
     *
     * @example samples/V2/BigtableTableAdminClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Restores a specified table which was accidentally deleted.
     *
     * The async variant is {@see BigtableTableAdminClient::undeleteTableAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/undelete_table.php
     *
     * @param UndeleteTableRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Table>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function undeleteTable(UndeleteTableRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UndeleteTable', $request, $callOptions)->wait();
    }

    /**
     * Updates an AuthorizedView in a table.
     *
     * The async variant is
     * {@see BigtableTableAdminClient::updateAuthorizedViewAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/update_authorized_view.php
     *
     * @param UpdateAuthorizedViewRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<AuthorizedView>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAuthorizedView(UpdateAuthorizedViewRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateAuthorizedView', $request, $callOptions)->wait();
    }

    /**
     * Updates a pending or completed Cloud Bigtable Backup.
     *
     * The async variant is {@see BigtableTableAdminClient::updateBackupAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/update_backup.php
     *
     * @param UpdateBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Backup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBackup(UpdateBackupRequest $request, array $callOptions = []): Backup
    {
        return $this->startApiCall('UpdateBackup', $request, $callOptions)->wait();
    }

    /**
     * Updates a schema bundle in the specified table.
     *
     * The async variant is {@see BigtableTableAdminClient::updateSchemaBundleAsync()}
     * .
     *
     * @example samples/V2/BigtableTableAdminClient/update_schema_bundle.php
     *
     * @param UpdateSchemaBundleRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<SchemaBundle>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSchemaBundle(UpdateSchemaBundleRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateSchemaBundle', $request, $callOptions)->wait();
    }

    /**
     * Updates a specified table.
     *
     * The async variant is {@see BigtableTableAdminClient::updateTableAsync()} .
     *
     * @example samples/V2/BigtableTableAdminClient/update_table.php
     *
     * @param UpdateTableRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Table>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTable(UpdateTableRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateTable', $request, $callOptions)->wait();
    }

    /** Configure the gapic configuration to use a service emulator. */
    private function setDefaultEmulatorConfig(array $options): array
    {
        $emulatorHost = getenv('BIGTABLE_EMULATOR_HOST');
        if (empty($emulatorHost)) {
            return $options;
        }

        if ($scheme = parse_url($emulatorHost, PHP_URL_SCHEME)) {
            $search = $scheme . '://';
            $emulatorHost = str_replace($search, '', $emulatorHost);
        }

        $options['apiEndpoint'] ??= $emulatorHost;
        if (class_exists(ChannelCredentials::class)) {
            $options['transportConfig']['grpc']['stubOpts']['credentials'] ??= ChannelCredentials::createInsecure();
        }

        $options['credentials'] ??= new InsecureCredentialsWrapper();
        return $options;
    }
}
