<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/bigquery/datatransfer/v1/datatransfer.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\BigQuery\DataTransfer\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\BigQuery\DataTransfer\V1\CheckValidCredsRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\CheckValidCredsResponse;
use Google\Cloud\BigQuery\DataTransfer\V1\CreateTransferConfigRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\DataSource;
use Google\Cloud\BigQuery\DataTransfer\V1\DeleteTransferConfigRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\DeleteTransferRunRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\EnrollDataSourcesRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\GetDataSourceRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\GetTransferConfigRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\GetTransferRunRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\ListDataSourcesRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\ListTransferConfigsRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\ListTransferLogsRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\ListTransferRunsRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\ScheduleTransferRunsRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\ScheduleTransferRunsResponse;
use Google\Cloud\BigQuery\DataTransfer\V1\StartManualTransferRunsRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\StartManualTransferRunsResponse;
use Google\Cloud\BigQuery\DataTransfer\V1\TransferConfig;
use Google\Cloud\BigQuery\DataTransfer\V1\TransferRun;
use Google\Cloud\BigQuery\DataTransfer\V1\UnenrollDataSourcesRequest;
use Google\Cloud\BigQuery\DataTransfer\V1\UpdateTransferConfigRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: This API allows users to manage their data transfers into BigQuery.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<CheckValidCredsResponse> checkValidCredsAsync(CheckValidCredsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TransferConfig> createTransferConfigAsync(CreateTransferConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteTransferConfigAsync(DeleteTransferConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteTransferRunAsync(DeleteTransferRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> enrollDataSourcesAsync(EnrollDataSourcesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataSource> getDataSourceAsync(GetDataSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TransferConfig> getTransferConfigAsync(GetTransferConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TransferRun> getTransferRunAsync(GetTransferRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDataSourcesAsync(ListDataSourcesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTransferConfigsAsync(ListTransferConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTransferLogsAsync(ListTransferLogsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTransferRunsAsync(ListTransferRunsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ScheduleTransferRunsResponse> scheduleTransferRunsAsync(ScheduleTransferRunsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<StartManualTransferRunsResponse> startManualTransferRunsAsync(StartManualTransferRunsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> unenrollDataSourcesAsync(UnenrollDataSourcesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TransferConfig> updateTransferConfigAsync(UpdateTransferConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class DataTransferServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.bigquery.datatransfer.v1.DataTransferService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'bigquerydatatransfer.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'bigquerydatatransfer.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/data_transfer_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/data_transfer_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/data_transfer_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/data_transfer_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a data_source
     * resource.
     *
     * @param string $project
     * @param string $dataSource
     *
     * @return string The formatted data_source resource.
     */
    public static function dataSourceName(string $project, string $dataSource): string
    {
        return self::getPathTemplate('dataSource')->render([
            'project' => $project,
            'data_source' => $dataSource,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_data_source resource.
     *
     * @param string $project
     * @param string $dataSource
     *
     * @return string The formatted project_data_source resource.
     */
    public static function projectDataSourceName(string $project, string $dataSource): string
    {
        return self::getPathTemplate('projectDataSource')->render([
            'project' => $project,
            'data_source' => $dataSource,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_data_source resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataSource
     *
     * @return string The formatted project_location_data_source resource.
     */
    public static function projectLocationDataSourceName(string $project, string $location, string $dataSource): string
    {
        return self::getPathTemplate('projectLocationDataSource')->render([
            'project' => $project,
            'location' => $location,
            'data_source' => $dataSource,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_transfer_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $transferConfig
     *
     * @return string The formatted project_location_transfer_config resource.
     */
    public static function projectLocationTransferConfigName(
        string $project,
        string $location,
        string $transferConfig
    ): string {
        return self::getPathTemplate('projectLocationTransferConfig')->render([
            'project' => $project,
            'location' => $location,
            'transfer_config' => $transferConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_transfer_config_run resource.
     *
     * @param string $project
     * @param string $location
     * @param string $transferConfig
     * @param string $run
     *
     * @return string The formatted project_location_transfer_config_run resource.
     */
    public static function projectLocationTransferConfigRunName(
        string $project,
        string $location,
        string $transferConfig,
        string $run
    ): string {
        return self::getPathTemplate('projectLocationTransferConfigRun')->render([
            'project' => $project,
            'location' => $location,
            'transfer_config' => $transferConfig,
            'run' => $run,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_transfer_config resource.
     *
     * @param string $project
     * @param string $transferConfig
     *
     * @return string The formatted project_transfer_config resource.
     */
    public static function projectTransferConfigName(string $project, string $transferConfig): string
    {
        return self::getPathTemplate('projectTransferConfig')->render([
            'project' => $project,
            'transfer_config' => $transferConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_transfer_config_run resource.
     *
     * @param string $project
     * @param string $transferConfig
     * @param string $run
     *
     * @return string The formatted project_transfer_config_run resource.
     */
    public static function projectTransferConfigRunName(string $project, string $transferConfig, string $run): string
    {
        return self::getPathTemplate('projectTransferConfigRun')->render([
            'project' => $project,
            'transfer_config' => $transferConfig,
            'run' => $run,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a run
     * resource.
     *
     * @param string $project
     * @param string $transferConfig
     * @param string $run
     *
     * @return string The formatted run resource.
     */
    public static function runName(string $project, string $transferConfig, string $run): string
    {
        return self::getPathTemplate('run')->render([
            'project' => $project,
            'transfer_config' => $transferConfig,
            'run' => $run,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * transfer_config resource.
     *
     * @param string $project
     * @param string $transferConfig
     *
     * @return string The formatted transfer_config resource.
     */
    public static function transferConfigName(string $project, string $transferConfig): string
    {
        return self::getPathTemplate('transferConfig')->render([
            'project' => $project,
            'transfer_config' => $transferConfig,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - dataSource: projects/{project}/dataSources/{data_source}
     * - location: projects/{project}/locations/{location}
     * - project: projects/{project}
     * - projectDataSource: projects/{project}/dataSources/{data_source}
     * - projectLocationDataSource: projects/{project}/locations/{location}/dataSources/{data_source}
     * - projectLocationTransferConfig: projects/{project}/locations/{location}/transferConfigs/{transfer_config}
     * - projectLocationTransferConfigRun: projects/{project}/locations/{location}/transferConfigs/{transfer_config}/runs/{run}
     * - projectTransferConfig: projects/{project}/transferConfigs/{transfer_config}
     * - projectTransferConfigRun: projects/{project}/transferConfigs/{transfer_config}/runs/{run}
     * - run: projects/{project}/transferConfigs/{transfer_config}/runs/{run}
     * - transferConfig: projects/{project}/transferConfigs/{transfer_config}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'bigquerydatatransfer.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\BigQuery\DataTransfer\V1\DataTransferServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new DataTransferServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Returns true if valid credentials exist for the given data source and
     * requesting user.
     *
     * The async variant is {@see DataTransferServiceClient::checkValidCredsAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/check_valid_creds.php
     *
     * @param CheckValidCredsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CheckValidCredsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function checkValidCreds(CheckValidCredsRequest $request, array $callOptions = []): CheckValidCredsResponse
    {
        return $this->startApiCall('CheckValidCreds', $request, $callOptions)->wait();
    }

    /**
     * Creates a new data transfer configuration.
     *
     * The async variant is
     * {@see DataTransferServiceClient::createTransferConfigAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/create_transfer_config.php
     *
     * @param CreateTransferConfigRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TransferConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTransferConfig(CreateTransferConfigRequest $request, array $callOptions = []): TransferConfig
    {
        return $this->startApiCall('CreateTransferConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes a data transfer configuration, including any associated transfer
     * runs and logs.
     *
     * The async variant is
     * {@see DataTransferServiceClient::deleteTransferConfigAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/delete_transfer_config.php
     *
     * @param DeleteTransferConfigRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTransferConfig(DeleteTransferConfigRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteTransferConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified transfer run.
     *
     * The async variant is {@see DataTransferServiceClient::deleteTransferRunAsync()}
     * .
     *
     * @example samples/V1/DataTransferServiceClient/delete_transfer_run.php
     *
     * @param DeleteTransferRunRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTransferRun(DeleteTransferRunRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteTransferRun', $request, $callOptions)->wait();
    }

    /**
     * Enroll data sources in a user project. This allows users to create transfer
     * configurations for these data sources. They will also appear in the
     * ListDataSources RPC and as such, will appear in the
     * [BigQuery UI](https://console.cloud.google.com/bigquery), and the documents
     * can be found in the public guide for
     * [BigQuery Web UI](https://cloud.google.com/bigquery/bigquery-web-ui) and
     * [Data Transfer
     * Service](https://cloud.google.com/bigquery/docs/working-with-transfers).
     *
     * The async variant is {@see DataTransferServiceClient::enrollDataSourcesAsync()}
     * .
     *
     * @example samples/V1/DataTransferServiceClient/enroll_data_sources.php
     *
     * @param EnrollDataSourcesRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function enrollDataSources(EnrollDataSourcesRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('EnrollDataSources', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a supported data source and returns its settings.
     *
     * The async variant is {@see DataTransferServiceClient::getDataSourceAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/get_data_source.php
     *
     * @param GetDataSourceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataSource
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDataSource(GetDataSourceRequest $request, array $callOptions = []): DataSource
    {
        return $this->startApiCall('GetDataSource', $request, $callOptions)->wait();
    }

    /**
     * Returns information about a data transfer config.
     *
     * The async variant is {@see DataTransferServiceClient::getTransferConfigAsync()}
     * .
     *
     * @example samples/V1/DataTransferServiceClient/get_transfer_config.php
     *
     * @param GetTransferConfigRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TransferConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTransferConfig(GetTransferConfigRequest $request, array $callOptions = []): TransferConfig
    {
        return $this->startApiCall('GetTransferConfig', $request, $callOptions)->wait();
    }

    /**
     * Returns information about the particular transfer run.
     *
     * The async variant is {@see DataTransferServiceClient::getTransferRunAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/get_transfer_run.php
     *
     * @param GetTransferRunRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TransferRun
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTransferRun(GetTransferRunRequest $request, array $callOptions = []): TransferRun
    {
        return $this->startApiCall('GetTransferRun', $request, $callOptions)->wait();
    }

    /**
     * Lists supported data sources and returns their settings.
     *
     * The async variant is {@see DataTransferServiceClient::listDataSourcesAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/list_data_sources.php
     *
     * @param ListDataSourcesRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDataSources(ListDataSourcesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDataSources', $request, $callOptions);
    }

    /**
     * Returns information about all transfer configs owned by a project in the
     * specified location.
     *
     * The async variant is
     * {@see DataTransferServiceClient::listTransferConfigsAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/list_transfer_configs.php
     *
     * @param ListTransferConfigsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTransferConfigs(ListTransferConfigsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTransferConfigs', $request, $callOptions);
    }

    /**
     * Returns log messages for the transfer run.
     *
     * The async variant is {@see DataTransferServiceClient::listTransferLogsAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/list_transfer_logs.php
     *
     * @param ListTransferLogsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTransferLogs(ListTransferLogsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTransferLogs', $request, $callOptions);
    }

    /**
     * Returns information about running and completed transfer runs.
     *
     * The async variant is {@see DataTransferServiceClient::listTransferRunsAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/list_transfer_runs.php
     *
     * @param ListTransferRunsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTransferRuns(ListTransferRunsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTransferRuns', $request, $callOptions);
    }

    /**
     * Creates transfer runs for a time range [start_time, end_time].
     * For each date - or whatever granularity the data source supports - in the
     * range, one transfer run is created.
     * Note that runs are created per UTC time in the time range.
     * DEPRECATED: use StartManualTransferRuns instead.
     *
     * The async variant is
     * {@see DataTransferServiceClient::scheduleTransferRunsAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/schedule_transfer_runs.php
     *
     * @param ScheduleTransferRunsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ScheduleTransferRunsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function scheduleTransferRuns(
        ScheduleTransferRunsRequest $request,
        array $callOptions = []
    ): ScheduleTransferRunsResponse {
        return $this->startApiCall('ScheduleTransferRuns', $request, $callOptions)->wait();
    }

    /**
     * Start manual transfer runs to be executed now with schedule_time equal to
     * current time. The transfer runs can be created for a time range where the
     * run_time is between start_time (inclusive) and end_time (exclusive), or for
     * a specific run_time.
     *
     * The async variant is
     * {@see DataTransferServiceClient::startManualTransferRunsAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/start_manual_transfer_runs.php
     *
     * @param StartManualTransferRunsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return StartManualTransferRunsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function startManualTransferRuns(
        StartManualTransferRunsRequest $request,
        array $callOptions = []
    ): StartManualTransferRunsResponse {
        return $this->startApiCall('StartManualTransferRuns', $request, $callOptions)->wait();
    }

    /**
     * Unenroll data sources in a user project. This allows users to remove
     * transfer configurations for these data sources. They will no longer appear
     * in the ListDataSources RPC and will also no longer appear in the [BigQuery
     * UI](https://console.cloud.google.com/bigquery). Data transfers
     * configurations of unenrolled data sources will not be scheduled.
     *
     * The async variant is
     * {@see DataTransferServiceClient::unenrollDataSourcesAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/unenroll_data_sources.php
     *
     * @param UnenrollDataSourcesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function unenrollDataSources(UnenrollDataSourcesRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('UnenrollDataSources', $request, $callOptions)->wait();
    }

    /**
     * Updates a data transfer configuration.
     * All fields must be set, even if they are not updated.
     *
     * The async variant is
     * {@see DataTransferServiceClient::updateTransferConfigAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/update_transfer_config.php
     *
     * @param UpdateTransferConfigRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TransferConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTransferConfig(UpdateTransferConfigRequest $request, array $callOptions = []): TransferConfig
    {
        return $this->startApiCall('UpdateTransferConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see DataTransferServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see DataTransferServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
