<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/backupdr/v1/backupplan.proto

namespace Google\Cloud\BackupDR\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A `BackupPlan` specifies some common fields, such as `description` as well
 * as one or more `BackupRule` messages. Each `BackupRule` has a retention
 * policy and defines a schedule by which the system is to perform backup
 * workloads.
 *
 * Generated from protobuf message <code>google.cloud.backupdr.v1.BackupPlan</code>
 */
class BackupPlan extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Identifier. The resource name of the `BackupPlan`.
     * Format: `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Optional. The description of the `BackupPlan` resource.
     * The description allows for additional details about `BackupPlan` and its
     * use cases to be provided. An example description is the following:  "This
     * is a backup plan that performs a daily backup at 6pm and retains data for 3
     * months". The description must be at most 2048 characters.
     *
     * Generated from protobuf field <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. This collection of key/value pairs allows for custom labels to be
     * supplied by the user.  Example, {"tag": "Weekly"}.
     *
     * Generated from protobuf field <code>map<string, string> labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Output only. When the `BackupPlan` was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. When the `BackupPlan` was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Required. The backup rules for this `BackupPlan`. There must be at least
     * one `BackupRule` message.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.BackupRule backup_rules = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $backup_rules;
    /**
     * Output only. The `State` for the `BackupPlan`.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.BackupPlan.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Required. The resource type to which the `BackupPlan` will be applied.
     * Examples include, "compute.googleapis.com/Instance",
     * "sqladmin.googleapis.com/Instance", "alloydb.googleapis.com/Cluster",
     * "compute.googleapis.com/Disk".
     *
     * Generated from protobuf field <code>string resource_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $resource_type = '';
    /**
     * Optional. `etag` is returned from the service in the response. As a user of
     * the service, you may provide an etag value in this field to prevent stale
     * resources.
     *
     * Generated from protobuf field <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $etag = '';
    /**
     * Required. Resource name of backup vault which will be used as storage
     * location for backups. Format:
     * projects/{project}/locations/{location}/backupVaults/{backupvault}
     *
     * Generated from protobuf field <code>string backup_vault = 10 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $backup_vault = '';
    /**
     * Output only. The Google Cloud Platform Service Account to be used by the
     * BackupVault for taking backups. Specify the email address of the Backup
     * Vault Service Account.
     *
     * Generated from protobuf field <code>string backup_vault_service_account = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $backup_vault_service_account = '';
    /**
     * Optional. Applicable only for CloudSQL and AlloyDB resource_type.
     * Configures how long logs will be stored. It is defined in “days”. This
     * value should be greater than or equal to minimum enforced log retention
     * duration of the backup vault.
     *
     * Generated from protobuf field <code>int64 log_retention_days = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $log_retention_days = 0;
    /**
     * Output only. All resource types to which backupPlan can be applied.
     *
     * Generated from protobuf field <code>repeated string supported_resource_types = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $supported_resource_types;
    /**
     * Output only. The user friendly revision ID of the `BackupPlanRevision`.
     * Example: v0, v1, v2, etc.
     *
     * Generated from protobuf field <code>string revision_id = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $revision_id = '';
    /**
     * Output only. The resource id of the `BackupPlanRevision`.
     * Format:
     * `projects/{project}/locations/{location}/backupPlans/{backup_plan}/revisions/{revision_id}`
     *
     * Generated from protobuf field <code>string revision_name = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $revision_name = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Identifier. The resource name of the `BackupPlan`.
     *           Format: `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
     *     @type string $description
     *           Optional. The description of the `BackupPlan` resource.
     *           The description allows for additional details about `BackupPlan` and its
     *           use cases to be provided. An example description is the following:  "This
     *           is a backup plan that performs a daily backup at 6pm and retains data for 3
     *           months". The description must be at most 2048 characters.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. This collection of key/value pairs allows for custom labels to be
     *           supplied by the user.  Example, {"tag": "Weekly"}.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. When the `BackupPlan` was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. When the `BackupPlan` was last updated.
     *     @type array<\Google\Cloud\BackupDR\V1\BackupRule>|\Google\Protobuf\Internal\RepeatedField $backup_rules
     *           Required. The backup rules for this `BackupPlan`. There must be at least
     *           one `BackupRule` message.
     *     @type int $state
     *           Output only. The `State` for the `BackupPlan`.
     *     @type string $resource_type
     *           Required. The resource type to which the `BackupPlan` will be applied.
     *           Examples include, "compute.googleapis.com/Instance",
     *           "sqladmin.googleapis.com/Instance", "alloydb.googleapis.com/Cluster",
     *           "compute.googleapis.com/Disk".
     *     @type string $etag
     *           Optional. `etag` is returned from the service in the response. As a user of
     *           the service, you may provide an etag value in this field to prevent stale
     *           resources.
     *     @type string $backup_vault
     *           Required. Resource name of backup vault which will be used as storage
     *           location for backups. Format:
     *           projects/{project}/locations/{location}/backupVaults/{backupvault}
     *     @type string $backup_vault_service_account
     *           Output only. The Google Cloud Platform Service Account to be used by the
     *           BackupVault for taking backups. Specify the email address of the Backup
     *           Vault Service Account.
     *     @type int|string $log_retention_days
     *           Optional. Applicable only for CloudSQL and AlloyDB resource_type.
     *           Configures how long logs will be stored. It is defined in “days”. This
     *           value should be greater than or equal to minimum enforced log retention
     *           duration of the backup vault.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $supported_resource_types
     *           Output only. All resource types to which backupPlan can be applied.
     *     @type string $revision_id
     *           Output only. The user friendly revision ID of the `BackupPlanRevision`.
     *           Example: v0, v1, v2, etc.
     *     @type string $revision_name
     *           Output only. The resource id of the `BackupPlanRevision`.
     *           Format:
     *           `projects/{project}/locations/{location}/backupPlans/{backup_plan}/revisions/{revision_id}`
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Backupdr\V1\Backupplan::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Identifier. The resource name of the `BackupPlan`.
     * Format: `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Identifier. The resource name of the `BackupPlan`.
     * Format: `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. The description of the `BackupPlan` resource.
     * The description allows for additional details about `BackupPlan` and its
     * use cases to be provided. An example description is the following:  "This
     * is a backup plan that performs a daily backup at 6pm and retains data for 3
     * months". The description must be at most 2048 characters.
     *
     * Generated from protobuf field <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. The description of the `BackupPlan` resource.
     * The description allows for additional details about `BackupPlan` and its
     * use cases to be provided. An example description is the following:  "This
     * is a backup plan that performs a daily backup at 6pm and retains data for 3
     * months". The description must be at most 2048 characters.
     *
     * Generated from protobuf field <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. This collection of key/value pairs allows for custom labels to be
     * supplied by the user.  Example, {"tag": "Weekly"}.
     *
     * Generated from protobuf field <code>map<string, string> labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. This collection of key/value pairs allows for custom labels to be
     * supplied by the user.  Example, {"tag": "Weekly"}.
     *
     * Generated from protobuf field <code>map<string, string> labels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. When the `BackupPlan` was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. When the `BackupPlan` was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. When the `BackupPlan` was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. When the `BackupPlan` was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Required. The backup rules for this `BackupPlan`. There must be at least
     * one `BackupRule` message.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.BackupRule backup_rules = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBackupRules()
    {
        return $this->backup_rules;
    }

    /**
     * Required. The backup rules for this `BackupPlan`. There must be at least
     * one `BackupRule` message.
     *
     * Generated from protobuf field <code>repeated .google.cloud.backupdr.v1.BackupRule backup_rules = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\BackupDR\V1\BackupRule>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBackupRules($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\BackupDR\V1\BackupRule::class);
        $this->backup_rules = $arr;

        return $this;
    }

    /**
     * Output only. The `State` for the `BackupPlan`.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.BackupPlan.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The `State` for the `BackupPlan`.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.BackupPlan.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BackupDR\V1\BackupPlan\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Required. The resource type to which the `BackupPlan` will be applied.
     * Examples include, "compute.googleapis.com/Instance",
     * "sqladmin.googleapis.com/Instance", "alloydb.googleapis.com/Cluster",
     * "compute.googleapis.com/Disk".
     *
     * Generated from protobuf field <code>string resource_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getResourceType()
    {
        return $this->resource_type;
    }

    /**
     * Required. The resource type to which the `BackupPlan` will be applied.
     * Examples include, "compute.googleapis.com/Instance",
     * "sqladmin.googleapis.com/Instance", "alloydb.googleapis.com/Cluster",
     * "compute.googleapis.com/Disk".
     *
     * Generated from protobuf field <code>string resource_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setResourceType($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_type = $var;

        return $this;
    }

    /**
     * Optional. `etag` is returned from the service in the response. As a user of
     * the service, you may provide an etag value in this field to prevent stale
     * resources.
     *
     * Generated from protobuf field <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Optional. `etag` is returned from the service in the response. As a user of
     * the service, you may provide an etag value in this field to prevent stale
     * resources.
     *
     * Generated from protobuf field <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Required. Resource name of backup vault which will be used as storage
     * location for backups. Format:
     * projects/{project}/locations/{location}/backupVaults/{backupvault}
     *
     * Generated from protobuf field <code>string backup_vault = 10 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getBackupVault()
    {
        return $this->backup_vault;
    }

    /**
     * Required. Resource name of backup vault which will be used as storage
     * location for backups. Format:
     * projects/{project}/locations/{location}/backupVaults/{backupvault}
     *
     * Generated from protobuf field <code>string backup_vault = 10 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setBackupVault($var)
    {
        GPBUtil::checkString($var, True);
        $this->backup_vault = $var;

        return $this;
    }

    /**
     * Output only. The Google Cloud Platform Service Account to be used by the
     * BackupVault for taking backups. Specify the email address of the Backup
     * Vault Service Account.
     *
     * Generated from protobuf field <code>string backup_vault_service_account = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getBackupVaultServiceAccount()
    {
        return $this->backup_vault_service_account;
    }

    /**
     * Output only. The Google Cloud Platform Service Account to be used by the
     * BackupVault for taking backups. Specify the email address of the Backup
     * Vault Service Account.
     *
     * Generated from protobuf field <code>string backup_vault_service_account = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setBackupVaultServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->backup_vault_service_account = $var;

        return $this;
    }

    /**
     * Optional. Applicable only for CloudSQL and AlloyDB resource_type.
     * Configures how long logs will be stored. It is defined in “days”. This
     * value should be greater than or equal to minimum enforced log retention
     * duration of the backup vault.
     *
     * Generated from protobuf field <code>int64 log_retention_days = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getLogRetentionDays()
    {
        return $this->log_retention_days;
    }

    /**
     * Optional. Applicable only for CloudSQL and AlloyDB resource_type.
     * Configures how long logs will be stored. It is defined in “days”. This
     * value should be greater than or equal to minimum enforced log retention
     * duration of the backup vault.
     *
     * Generated from protobuf field <code>int64 log_retention_days = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setLogRetentionDays($var)
    {
        GPBUtil::checkInt64($var);
        $this->log_retention_days = $var;

        return $this;
    }

    /**
     * Output only. All resource types to which backupPlan can be applied.
     *
     * Generated from protobuf field <code>repeated string supported_resource_types = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSupportedResourceTypes()
    {
        return $this->supported_resource_types;
    }

    /**
     * Output only. All resource types to which backupPlan can be applied.
     *
     * Generated from protobuf field <code>repeated string supported_resource_types = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSupportedResourceTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->supported_resource_types = $arr;

        return $this;
    }

    /**
     * Output only. The user friendly revision ID of the `BackupPlanRevision`.
     * Example: v0, v1, v2, etc.
     *
     * Generated from protobuf field <code>string revision_id = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getRevisionId()
    {
        return $this->revision_id;
    }

    /**
     * Output only. The user friendly revision ID of the `BackupPlanRevision`.
     * Example: v0, v1, v2, etc.
     *
     * Generated from protobuf field <code>string revision_id = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setRevisionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->revision_id = $var;

        return $this;
    }

    /**
     * Output only. The resource id of the `BackupPlanRevision`.
     * Format:
     * `projects/{project}/locations/{location}/backupPlans/{backup_plan}/revisions/{revision_id}`
     *
     * Generated from protobuf field <code>string revision_name = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getRevisionName()
    {
        return $this->revision_name;
    }

    /**
     * Output only. The resource id of the `BackupPlanRevision`.
     * Format:
     * `projects/{project}/locations/{location}/backupPlans/{backup_plan}/revisions/{revision_id}`
     *
     * Generated from protobuf field <code>string revision_name = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setRevisionName($var)
    {
        GPBUtil::checkString($var, True);
        $this->revision_name = $var;

        return $this;
    }

}

